/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.one.util.streamex;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.kotlin.one.util.streamex.AbstractStreamEx;
import org.jetbrains.kotlin.one.util.streamex.StreamContext;

public class EntryStream<K, V>
extends AbstractStreamEx<Map.Entry<K, V>, EntryStream<K, V>> {
    EntryStream(Stream<? extends Map.Entry<K, V>> stream, StreamContext context2) {
        super(stream, context2);
    }

    @Override
    EntryStream<K, V> supply(Stream<Map.Entry<K, V>> stream) {
        return new EntryStream<K, V>(stream, this.context);
    }

    static <K, V, M extends Map<K, V>> Consumer<? super Map.Entry<K, V>> toMapConsumer(M map) {
        return entry -> EntryStream.addToMap(map, entry.getKey(), Objects.requireNonNull(entry.getValue()));
    }

    public EntryStream<K, V> nonNullKeys() {
        return (EntryStream)this.filter((T e2) -> e2.getKey() != null);
    }

    public Map<K, V> toMap() {
        AbstractMap map = this.isParallel() ? new ConcurrentHashMap() : new HashMap();
        this.forEach(EntryStream.toMapConsumer(map));
        return map;
    }

    public Map<K, V> toImmutableMap() {
        Map<K, V> map = this.toMap();
        return map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
    }
}

