/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.Allocable;
import mpi.AllocablePool;
import mpi.Status;

public class Request
implements Allocable {
    private long handle;

    public long getHandle() {
        return this.handle;
    }

    void setHandle(long l) {
        this.handle = l;
    }

    public Request() {
        this.init();
        AllocablePool.add(this);
    }

    public Request(long l) {
        this.init_with_handle(l);
        AllocablePool.add(this);
    }

    private native void init();

    private native void init_with_handle(long var1);

    @Override
    public void free() {
        AllocablePool.remove(this);
        this.free(this.handle);
    }

    private native void free(long var1);

    public Status Wait() {
        Status status = new Status();
        this.MPI_Wait(status.getHandle());
        return status;
    }

    private native void MPI_Wait(long var1);

    public static Status[] waitAll(int n, Request[] requestArray) {
        long[] lArray = new long[requestArray.length];
        for (int i = 0; i < requestArray.length; ++i) {
            lArray[i] = requestArray[i].getHandle();
        }
        Status[] statusArray = new Status[requestArray.length];
        for (int i = 0; i < statusArray.length; ++i) {
            statusArray[i] = new Status();
        }
        long[] lArray2 = new long[statusArray.length];
        for (int i = 0; i < statusArray.length; ++i) {
            lArray2[i] = statusArray[i].getHandle();
        }
        Request.MPI_Waitall(n, lArray, lArray2);
        return statusArray;
    }

    private static native void MPI_Waitall(int var0, long[] var1, long[] var2);

    public static Status waitAny(int n, Request[] requestArray, int[] nArray) {
        Status status = new Status();
        long[] lArray = new long[requestArray.length];
        for (int i = 0; i < requestArray.length; ++i) {
            lArray[i] = requestArray[i].getHandle();
        }
        Request.MPI_Waitany(n, lArray, nArray, status.getHandle());
        return status;
    }

    private static native void MPI_Waitany(int var0, long[] var1, int[] var2, long var3);

    public static Status[] waitSome(int n, Request[] requestArray, int[] nArray, int[] nArray2) {
        long[] lArray = new long[requestArray.length];
        for (int i = 0; i < requestArray.length; ++i) {
            lArray[i] = requestArray[i].getHandle();
        }
        Status[] statusArray = new Status[requestArray.length];
        for (int i = 0; i < statusArray.length; ++i) {
            statusArray[i] = new Status();
        }
        long[] lArray2 = new long[statusArray.length];
        for (int i = 0; i < requestArray.length; ++i) {
            lArray2[i] = statusArray[i].getHandle();
        }
        Request.MPI_Waitsome(n, lArray, nArray, nArray2, lArray2);
        return statusArray;
    }

    private static native void MPI_Waitsome(int var0, long[] var1, int[] var2, int[] var3, long[] var4);

    public boolean test(Status status) {
        return this.MPI_Test(status.getHandle());
    }

    private native boolean MPI_Test(long var1);
}

