/****
    Copyright (C) 2019 Intel Corporation.  All Rights Reserved.

    This file is part of SEP Development Kit.

    SEP Development Kit is free software; you can redistribute it
    and/or modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    SEP Development Kit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SEP Development Kit; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    As a special exception, you may use this file as part of a free software
    library without restriction.  Specifically, if other files instantiate
    templates or use macros or inline functions from this file, or you compile
    this file and link it with other files to produce an executable, this
    file does not by itself cause the resulting executable to be covered by
    the GNU General Public License.  This exception does not however
    invalidate any other reasons why the executable file might be covered by
    the GNU General Public License.
****/





#ifndef _PMU_INFO_MSR_H_INC_
#define _PMU_INFO_MSR_H_INC_

static PMU_MSR_INFO_NODE perfmon_v4_architectural[] = {
	{ 0x1D9 }, { 0x3F1 },         { 0x345, 0, 0 }, { 0x38D, 0, 0 },
	{ 0x38E }, { 0x38F },         { 0x390 },       { 0x600 },
	{ 0x1A0 }, { 0x186, 0, 0x7 }, { 0x8b },        { 0x392 },
	{ 0x0 }
};

static PMU_MSR_INFO_NODE perfmon_v5_architectural[] = {
	{ 0x1D9 }, { 0x3F1 },         { 0x345, 0, 0 }, { 0x38D, 0, 0 },
	{ 0x38E }, { 0x38F },         { 0x390 },       { 0x600 },
	{ 0x1A0 }, { 0x186, 0, 0x7 }, { 0x8b },        { 0x392 },
	{ 0x3F2 }, { 0x0 }
};

static PMU_MSR_INFO_NODE core_1[] = {
	{ 0x1D9 }, { 0x3F1 }, { 0x345, 0, 0 }, { 0x38D, 0, 0 },
	{ 0x38E }, { 0x38F }, { 0x390 },       { 0x1C8 },
	{ 0x3F7 }, { 0x600 }, { 0x1A0 },       { 0x186, 0, 0x3 },
	{ 0x1C9 }, { 0xCE },  { 0x1A4 },       { 0x1A6 },
	{ 0x1A7 }, { 0x34 },  { 0x606 },	   { 0x0 }
};

static PMU_MSR_INFO_NODE core_2[] = {
	{ 0xC5, 0, 0 }, { 0xC6, 0, 0 }, { 0xC7, 0, 0 },
	{ 0xC8, 0, 0 }, { 0x3F6 },      { 0x18A, 0, 0x3 },
	{ 0x1AD },      { 0x1AE },      { 0x0 }
};

static PMU_MSR_INFO_NODE core_3[] = {
	{ 0x680, 0, 0xF }, { 0x6C0, 0, 0xF }, { 0x1B }, { 0x0 }
};

static PMU_MSR_INFO_NODE core_4[] = {
	{ 0x3F2 }, { 0x30C }, { 0x329, 0, 0 }, { 0x0 }
};

static PMU_MSR_INFO_NODE core_5[] = {
	{ 0x40, 0, 0x7 }, { 0x60, 0, 0x7 }, { 0xCD }, { 0x0 }
};

static PMU_MSR_INFO_NODE core_6[] = { { 0xDC0, 0, 0x1F }, { 0x0 } };

static PMU_MSR_INFO_NODE core_7[] = {
	{ 0x690, 0, 0xF }, { 0x6D0, 0, 0xF }, { 0x0 }
};

static PMU_MSR_INFO_NODE core_8[] = { { 0x1AF }, { 0x0 } };

static PMU_MSR_INFO_NODE core_9[] = {
	{ 0x1500, 0, 0x1F }, { 0x1600, 0, 0x1F }, { 0x1200, 0, 0x1F },
	{ 0x14CE },          { 0x14CF },          { 0x1DD },
	{ 0x1DE },           { 0x1E0 },           { 0x0 }
};

static PMU_MSR_INFO_NODE core_10[] = {
	{ 0xC5 }, { 0xC6 }, { 0x18A }, { 0x18B }, { 0x0 }
};

static PMU_MSR_INFO_NODE core_11[]  = { { 0x392 }, { 0x0 } };

static PMU_MSR_INFO_NODE core_12[] = {
	{ 0x18C }, { 0x18D }, { 0x18E }, { 0x18F },
	{ 0xC7  }, { 0xC8  }, { 0xC9  }, { 0x0CA },
	{ 0x30D }, { 0x30E }, { 0x30F }, { 0x0   }
};

static PMU_MSR_INFO_NODE core_13[] = {
	 { 0x3F4 }, { 0x3F5 }, { 0x1903 }, { 0x1907 },
	 { 0x190B }, { 0x190F }, { 0x1913 }, { 0x1917 },
	 { 0x191B }, { 0x191F }, { 0x1923 }, { 0x1927 },
	 { 0x1983 }, { 0x1987 }, { 0x198B }, { 0x198F },
	 { 0x1993 }, { 0x1997 }, { 0x199B }
};

static PMU_MSR_INFO_NODE uncore_2[] = { { 0x700 }, { 0x702 }, { 0x0 } };

static PMU_MSR_INFO_NODE uncore_3[] = { { 0x1F80 }, { 0x1F82 }, { 0x0 } };

static PMU_MSR_INFO_NODE uncore_4[] = { { 0xE01, 0, 0x1 }, { 0x0 } };

static PMU_MSR_INFO_NODE uncore_5[] = { { 0x391, 0, 0x1 }, { 0x0 } };

static PMU_MSR_INFO_NODE uncore_6[] = { { 0x2FF0 }, { 0x2FFE }, { 0x0 } };

static PMU_MSR_INFO_NODE uncore_7[] = { { 0x2FF0 }, { 0x2FF2 }, { 0x0 } };

static PMU_MSR_INFO_NODE uncore_8[] = { { 0x2FF0 }, { 0x700 }, { 0x3FED }, { 0x0 } };

static PMU_MSR_INFO_NODE uncore_9[] = { { 0x200E }, { 0x240E }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu1_1[] = { { 0x396 }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu1_2[] = {
	{ 0xE00, 0, 0x6 }, { 0xE08, 0, 0x4 }, { 0xE10, 0, 0xB },
	{ 0xE20, 0, 0xB }, { 0xE30, 0, 0xB }, { 0xE40, 0, 0xB },
	{ 0xE50, 0, 0xB }, { 0xE60, 0, 0xB }, { 0xE70, 0, 0xB },
	{ 0xE80, 0, 0xB }, { 0xE90, 0, 0xB }, { 0xEA0, 0, 0xB },
	{ 0xEB0, 0, 0xB }, { 0xEC0, 0, 0xB }, { 0xED0, 0, 0xB },
	{ 0xEE0, 0, 0xB }, { 0xEF0, 0, 0xB }, { 0xF00, 0, 0xB },
	{ 0xF10, 0, 0xB }, { 0xF20, 0, 0xB }, { 0xF30, 0, 0xB },
	{ 0xF40, 0, 0xB }, { 0xF50, 0, 0xB }, { 0xF60, 0, 0xB },
	{ 0xF70, 0, 0xB }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu1_6[] = {
	{ 0x700, 0, 0x4 }, { 0x708, 0, 0x4 }, { 0x710, 0, 0x4 },
	{ 0x718, 0, 0x4 }, { 0x720, 0, 0x4 }, { 0x728, 0, 0x4 },
	{ 0x730, 0, 0x4 }, { 0x738, 0, 0x4 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu1_7[] = {
	{ 0x700, 0, 0x69 }, { 0xF70, 0, 0x29 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu1_8[] = { { 0x700, 0, 0x49 }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu1_9[] = { { 0x2000, 0, 0, 1, 0x396, 0x1F, 8, 3 }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu1_10[] = { { 0x2442, 0, 0, 1, 0x396, 0x1F, 16, 7 },
									   { 0x2042, 0, 0x17 }, {0x0} };

static PMU_MSR_INFO_NODE pmu2_1[] = { { 0xE00, 0, 0x1BB }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu2_2[] = { { 0xE00, 0, 0x1C8 }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu2_3[] = {
	{ 0xE00, 0, 0x1E7 }, { 0xB60, 0, 0x6D }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu2_4[] = { { 0x1C00, 0, 0x5B }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu2_5[] = { { 0x2000, 0, 0x7FF }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu2_6[] = { { 0x2800, 0, 0x3F }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu2_7[] = { { 0x2000, 0, 0x6E }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu2_8[] = { { 0x2000, 0, 0x57E }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu3_1[] = { { 0x2800, 0, 0x7BF }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu3_2[] = { { 0x2F00, 0, 0x4FB }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu3_3[] = { { 0x2F00, 0, 0x31B }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu4_1[] = {
	{ 0xA40, 0, 0x5 }, { 0xA47, 0, 0x4 }, { 0xB00, 0, 0xF },
	{ 0xA60, 0, 0x5 }, { 0xA67, 0, 0x4 }, { 0xB10, 0, 0xF },
	{ 0xA80, 0, 0x5 }, { 0xA87, 0, 0x4 }, { 0xB20, 0, 0xF },
	{ 0xAA0, 0, 0x5 }, { 0xAA7, 0, 0x4 }, { 0xB30, 0, 0xF },
	{ 0xAC0, 0, 0x5 }, { 0xAC7, 0, 0x4 }, { 0xB40, 0, 0xF },
	{ 0x0 }
};

static PMU_MSR_INFO_NODE pmu4_2[] = {
	{ 0xA50, 0, 0x5 }, { 0xA57, 0, 0x4 }, { 0xAA0, 0, 0xF },
	{ 0xA70, 0, 0x5 }, { 0xA77, 0, 0x4 }, { 0xAB0, 0, 0xF },
	{ 0xA90, 0, 0x5 }, { 0xA97, 0, 0x4 }, { 0xAC0, 0, 0xF },
	{ 0xAE0, 0, 0x5 }, { 0xAE7, 0, 0x4 }, { 0xB30, 0, 0xF },
	{ 0xB00, 0, 0x5 }, { 0xB07, 0, 0x4 }, { 0xB40, 0, 0xF },
	{ 0xB20, 0, 0x5 }, { 0xB27, 0, 0x4 }, { 0xB50, 0, 0xF },
	{ 0x0 }
};

static PMU_MSR_INFO_NODE pmu4_3[] = {
	{ 0x1E00, 0, 0x4 }, { 0x1E07, 0, 0x4 }, { 0x1F00, 0, 0xF },
	{ 0x1E10, 0, 0x4 }, { 0x1E17, 0, 0x4 }, { 0x1F10, 0, 0xF },
	{ 0x1E20, 0, 0x4 }, { 0x1E27, 0, 0x4 }, { 0x1F20, 0, 0xF },
	{ 0x1E30, 0, 0x4 }, { 0x1E37, 0, 0x4 }, { 0x1F30, 0, 0xF },
	{ 0x1E40, 0, 0x4 }, { 0x1E47, 0, 0x4 }, { 0x1F40, 0, 0xF },
	{ 0x1EAC },         { 0x1EBC },         { 0x1ECC },
	{ 0x1EDC },         { 0x1EDC },         { 0x1EEC },
	{ 0x0 }
};

static PMU_MSR_INFO_NODE pmu4_4[] = {
	{ 0x3000, 0, 0x1FF }, { 0x3800, 0, 0x1FF }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu4_5[] = {
	{0x2900, 0, 0xE}, {0x2910, 0, 0xE}, {0x2920, 0, 0xE}, {0x2930, 0, 0xE}, {0x2940, 0, 0xE},
	{0x2950, 0, 0xE}, {0x2960, 0, 0xE}, {0x2970, 0, 0xE}, {0x2980, 0, 0xE}, {0x2990, 0, 0xE},
	{0x29A0, 0, 0xE}, {0x29B0, 0, 0xE}, {0x29C0, 0, 0xE}, {0x29D0, 0, 0xE}, {0x29E0, 0, 0xE},
	{0x29F0, 0, 0xE},
	{0x2E0E, 0, 0xFF0}, {0x0}
};

static PMU_MSR_INFO_NODE pmu4_6[] = {
	{0x2900, 0, 0xE}, {0x2910, 0, 0xE}, {0x2920, 0, 0xE},
	{0x2E0E, 0, 0x170}, {0x360E, 0, 0x170}, {0x0}
};

static PMU_MSR_INFO_NODE pmu4_7[] = {
	{0x2900, 0, 0xE}, {0x2910, 0, 0xE}, {0x2920, 0, 0xE}, {0x2930, 0, 0xE}, {0x2940, 0, 0xE},
	{0x2950, 0, 0xE}, {0x2960, 0, 0xE}, {0x2E0E, 0, 0xB70}, {0x0}
};

static PMU_MSR_INFO_NODE pmu5_msr_reg_list1[] = { { 0x300, 0, 0 }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu5_msr_reg_list2[] = {
	{ 0xA09, 0, 0 }, { 0xA0A, 0, 0 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu6_1[] = {
	{ 0xA58 }, { 0xA78 }, { 0xA98 }, { 0xAB8 }, { 0xAD8 }, { 0xA5B },
	{ 0xA5C }, { 0xA7B }, { 0xA7C }, { 0xA9B }, { 0xA9C }, { 0xABB },
	{ 0xABC }, { 0xADB }, { 0xADC }, { 0xA5F }, { 0xA7F }, { 0xA9F },
	{ 0xABF }, { 0xADF }, { 0xA59 }, { 0xA5A }, { 0xA79 }, { 0xA7A },
	{ 0xA99 }, { 0xA9A }, { 0xAB9 }, { 0xABA }, { 0xAD9 }, { 0xADA },
	{ 0x0 }
};

static PMU_MSR_INFO_NODE pmu6_2[] = {
	{ 0xA4A }, { 0xA6A }, { 0xA8A }, { 0xADA }, { 0xAFA }, { 0xB1A },
	{ 0xA4F }, { 0xA6F }, { 0xA8F }, { 0xADF }, { 0xAFF }, { 0xB1F },
	{ 0xA4D }, { 0xA6D }, { 0xA8D }, { 0xADD }, { 0xAFD }, { 0xB1D },
	{ 0xA4E }, { 0xA6E }, { 0xA8E }, { 0xADE }, { 0xAFE }, { 0xB1E },
	{ 0xA4B }, { 0xA6B }, { 0xA8B }, { 0xADB }, { 0xAFB }, { 0xB1B },
	{ 0xA4C }, { 0xA6C }, { 0xA8C }, { 0xADC }, { 0xAFC }, { 0xB1C },
	{ 0x0 }
};

static PMU_MSR_INFO_NODE pmu6_3[] = {
	{ 0x1EA0 }, { 0x1EB0 }, { 0x1EC0 }, { 0x1ED0 }, { 0x1EE0 }, { 0x1EA8 },
	{ 0x1EA9 }, { 0x1EB8 }, { 0x1EB9 }, { 0x1EC8 }, { 0x1EC9 }, { 0x1ED8 },
	{ 0x1ED9 }, { 0x1EE8 }, { 0x1EE9 }, { 0x1EA7 }, { 0x1EB7 }, { 0x1EC7 },
	{ 0x1ED7 }, { 0x1EE7 }, { 0x1EA1 }, { 0x1EA2 }, { 0x1EB1 }, { 0x1EB2 },
	{ 0x1EC1 }, { 0x1EC2 }, { 0x1ED1 }, { 0x1ED2 }, { 0x1EE1 }, { 0x1EE2 },
	{ 0x0 }
};

static PMU_MSR_INFO_NODE pmu6_4[] = { { 0x3400, 0, 0x1FF }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu6_5[] = { { 0x2A00, 0, 0xFB }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu6_6[] = { { 0x2A00, 0, 0x31}, { 0x0 } };

static PMU_MSR_INFO_NODE pmu6_7[] = { { 0x2A00, 0, 0x6B }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu7_1[] = {
	{ 0x394 }, { 0x395 }, { 0x396 }, { 0x3B0, 0, 0x3 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu7_2[] = { { 0x3B8, 0, 0x3 }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu7_3[] = {
	{ 0x2FD0, 0, 0x6 }, { 0x2FD8, 0, 0x6 }, { 0x2FDE }, { 0x2FDF }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu7_4[] = {
	{ 0x2002, 0, 0x6 }, { 0x2402, 0, 0x6 }, { 0x2412, 0, 0x17 }, { 0x2012, 0, 0x17 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu8_1[] = {
	{ 0x715 }, { 0x717, 0, 4 }, { 0x711, 0, 4 }, { 0x710 }, { 0x100 },
	{ 0x0 }
};

static PMU_MSR_INFO_NODE pmu8_2[] = { { 0x3FD }, { 0x3FC }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu8_3[] = { { 0x3F9 }, { 0x3F8 }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu8_5[] = {
	{ 0x1EF5 }, { 0x1EF8, 0, 4 }, { 0x1EF1, 0, 4 }, { 0x1EF0 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu8_6[] = { { 0x2FC0, 0, 0xF }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu8_7[] = { { 0x3F80, 0, 0x4E }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu9_1[] = {
	{ 0x198 }, { 0x19C }, { 0x1A2 }, { 0x1B0 }, { 0x3F8 }, { 0x3F9 },
	{ 0x3FA }, { 0x3FC }, { 0x3FD }, { 0x60D }, { 0x611 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu9_2[] = { { 0x639 }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu9_3[] = {
	{ 0x3FE }, { 0x614 }, { 0x619 }, { 0x621 }, { 0x61D },
	{ 0x0 }
};

static PMU_MSR_INFO_NODE pmu9_4[] = {
	{ 0x199 }, { 0x771 }, { 0x774 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu9_5[] = { { 0x660, 0, 0x5 }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu9_6[] = {
	{ 0x611 }, { 0x639 }, { 0x641 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu9_7[] = {
	{ 0x60D }, { 0x3F8 }, { 0x3F9 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu9_8[] = {
	{ 0x3FA }, { 0x3FC }, { 0x3FD }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu9_9[] = {
	{ 0x1A2 }, { 0x198 }, { 0x19C }, { 0x611 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu9_11[] = {
	{ 0x19C }, { 0x1B1 }, { 0x619 }, { 0x3FE }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu9_12[] = {
	{ 0x19C }, { 0x1B1 }, { 0x630 }, { 0x631 }, { 0x632 }, { 0x619 },
	{ 0x3FE }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu9_13[] = {
	{ 0x630 }, { 0x631 }, { 0x632 }, { 0x619 }, { 0x3FE }, { 0x653 },
	{ 0x61D }, { 0x655 }, { 0x656 }, { 0x19C }, { 0x1A2 }, { 0x1B1 },
	{ 0x0 }
};

static PMU_MSR_INFO_NODE pmu9_15[] = {
	{ 0x660 }, { 0x1B0 }, { 0x639 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu9_16[] = { { 0x661, 0, 0x4 }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu9_18[] = {
	{ 0x1B0 }, { 0x614 }, { 0x619 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu9_19[] = { { 0x17D2 }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu9_20[] = {
	{ 0x64F }, { 0x1B0 }, { 0x1B1 }, { 0x613 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu10_1[] = {
	{ 0xA40, 0, 0x9 }, { 0xA60, 0, 0x9 }, { 0xA80, 0, 0x9 },
	{ 0xAD0, 0, 0x9 }, { 0xAF0, 0, 0x9 }, { 0xB10, 0, 0x9 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu10_2[] = {
	{ 0x1E50, 0, 0x4 }, { 0x1E60, 0, 0x4 }, { 0x1E70, 0, 0x4 },
	{ 0x1E80, 0, 0x4 }, { 0x1E90, 0, 0x4 }, { 0x1E57, 0, 0x4 },
	{ 0x1E67, 0, 0x4 }, { 0x1E77, 0, 0x4 }, { 0x1E87, 0, 0x4 },
	{ 0x1E97, 0, 0x4 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu10_3[] = { { 0x3200, 0, 0x1FF }, { 0x0 } };

static PMU_MSR_INFO_NODE pmu11_1[] = {
	{ 0x720 },         { 0x72A },         { 0x734 },
	{ 0x73E },         { 0x721, 0, 0x3 }, { 0x72B, 0, 0x3 },
	{ 0x735, 0, 0x3 }, { 0x73F, 0, 0x3 }, { 0x726, 0, 0x3 },
	{ 0x730, 0, 0x3 }, { 0x73A, 0, 0x3 }, { 0x744, 0, 0x3 },
	{ 0x0 }
};

static PMU_MSR_INFO_NODE pmu12_1[] = {
	{ 0xC14 }, { 0x620 }, { 0x703, 0, 0x7 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu12_2[] = {
	{ 0xC14 }, { 0x620 }, { 0x1F91, 0, 0x3 }, { 0x1F98, 0, 0x1 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu12_4[] = {
	{ 0x620 },        { 0x2FD0 }, { 0x2FDE, 0, 0x2 }, { 0x2FD2, 0, 2 },
	{ 0x2FD8, 0, 2 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu12_5[] = {
	{ 0x620 },        { 0x3FF0 }, { 0x3FFD, 0, 0x2 }, { 0x3FF2, 0, 2 },
	{ 0x3FF8, 0, 2 }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu13[] = {
	{ 0xC8D }, { 0xC8E }, { 0xC8F }, { 0xD10 }, { 0xD11 }, { 0xD12 },
	{ 0xD13 }, { 0xC90 }, { 0xC91 }, { 0xC92 }, { 0xC93 },
	{ 0xC81, 0, 0x3 }, { 0xD50, 0, 0xF }, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu14[] = {
	{ 0x3400 }, { 0x340B }, { 0x340A }, { 0x3409 }, { 0x3408 }, { 0x3405 }, { 0x3404 }, { 0x3403 }, { 0x3402 },
	{ 0x3410 }, { 0x341B }, { 0x341A }, { 0x3419 }, { 0x3418 }, { 0x3415 }, { 0x3414 }, { 0x3413 }, { 0x3412 },
	{ 0x3420 }, { 0x342B }, { 0x342A }, { 0x3429 }, { 0x3428 }, { 0x3425 }, { 0x3424 }, { 0x3423 }, { 0x3422 },
	{ 0x3430 }, { 0x343B }, { 0x343A }, { 0x3439 }, { 0x3438 }, { 0x3435 }, { 0x3434 }, { 0x3433 }, { 0x3432 },
	{ 0x3440 }, { 0x344B }, { 0x344A }, { 0x3449 }, { 0x3448 }, { 0x3445 }, { 0x3444 }, { 0x3443 }, { 0x3442 },
	{ 0x3450 }, { 0x345B }, { 0x345A }, { 0x3459 }, { 0x3458 }, { 0x3455 }, { 0x3454 }, { 0x3453 }, { 0x3452 },
	{ 0x3460 }, { 0x346B }, { 0x346A }, { 0x3469 }, { 0x3468 }, { 0x3465 }, { 0x3464 }, { 0x3463 }, { 0x3462 },
	{ 0x3470 }, { 0x347B }, { 0x347A }, { 0x3479 }, { 0x3478 }, { 0x3475 }, { 0x3474 }, { 0x3473 }, { 0x3472 },
	{ 0x3480 }, { 0x348B }, { 0x348A }, { 0x3489 }, { 0x3488 }, { 0x3485 }, { 0x3484 }, { 0x3483 }, { 0x3482 },
	{ 0x3490 }, { 0x349B }, { 0x349A }, { 0x3499 }, { 0x3498 }, { 0x3495 }, { 0x3494 }, { 0x3493 }, { 0x3492 },
	{ 0x34A0 }, { 0x34AB }, { 0x34AA }, { 0x34A9 }, { 0x34A8 }, { 0x34A5 }, { 0x34A4 }, { 0x34A3 }, { 0x34A2 },
	{ 0x34B0 }, { 0x34BB }, { 0x34BA }, { 0x34B9 }, { 0x34B8 }, { 0x34B5 }, { 0x34B4 }, { 0x34B3 }, { 0x34B2 },
	{ 0x34C0 }, { 0x34CB }, { 0x34CA }, { 0x34C9 }, { 0x34C8 }, { 0x34C5 }, { 0x34C4 }, { 0x34C3 }, { 0x34C2 },
	{ 0x34D0 }, { 0x34DB }, { 0x34DA }, { 0x34D9 }, { 0x34D8 }, { 0x34D5 }, { 0x34D4 }, { 0x34D3 }, { 0x34D2 },
	{ 0x34E0 }, { 0x34EB }, { 0x34EA }, { 0x34E9 }, { 0x34E8 }, { 0x34E5 }, { 0x34E4 }, { 0x34E3 }, { 0x34E2 },
	{ 0x34F0 }, { 0x34FB }, { 0x34FA }, { 0x34F9 }, { 0x34F8 }, { 0x34F5 }, { 0x34F4 }, { 0x34F3 }, { 0x34F2 },
	{ 0x3500 }, { 0x350B }, { 0x350A }, { 0x3509 }, { 0x3508 }, { 0x3505 }, { 0x3504 }, { 0x3503 }, { 0x3502 },
	{ 0x3510 }, { 0x351B }, { 0x351A }, { 0x3519 }, { 0x3518 }, { 0x3515 }, { 0x3514 }, { 0x3513 }, { 0x3512 },
	{ 0x3520 }, { 0x352B }, { 0x352A }, { 0x3529 }, { 0x3528 }, { 0x3525 }, { 0x3524 }, { 0x3523 }, { 0x3522 },
	{ 0x3530 }, { 0x353B }, { 0x353A }, { 0x3539 }, { 0x3538 }, { 0x3535 }, { 0x3534 }, { 0x3533 }, { 0x3532 },
	{ 0x3540 }, { 0x354B }, { 0x354A }, { 0x3549 }, { 0x3548 }, { 0x3545 }, { 0x3544 }, { 0x3543 }, { 0x3542 },
	{ 0x3550 }, { 0x355B }, { 0x355A }, { 0x3559 }, { 0x3558 }, { 0x3555 }, { 0x3554 }, { 0x3553 }, { 0x3552 },
	{ 0x3560 }, { 0x356B }, { 0x356A }, { 0x3569 }, { 0x3568 }, { 0x3565 }, { 0x3564 }, { 0x3563 }, { 0x3562 },
	{ 0x3570 }, { 0x357B }, { 0x357A }, { 0x3579 }, { 0x3578 }, { 0x3575 }, { 0x3574 }, { 0x3573 }, { 0x3572 },
	{ 0x3580 }, { 0x358B }, { 0x358A }, { 0x3589 }, { 0x3588 }, { 0x3585 }, { 0x3584 }, { 0x3583 }, { 0x3582 },
	{ 0x3590 }, { 0x359B }, { 0x359A }, { 0x3599 }, { 0x3598 }, { 0x3595 }, { 0x3594 }, { 0x3593 }, { 0x3592 },
	{ 0x35A0 }, { 0x35AB }, { 0x35AA }, { 0x35A9 }, { 0x35A8 }, { 0x35A5 }, { 0x35A4 }, { 0x35A3 }, { 0x35A2 },
	{ 0x35B0 }, { 0x35BB }, { 0x35BA }, { 0x35B9 }, { 0x35B8 }, { 0x35B5 }, { 0x35B4 }, { 0x35B3 }, { 0x35B2 },
	{ 0x35C0 }, { 0x35CB }, { 0x35CA }, { 0x35C9 }, { 0x35C8 }, { 0x35C5 }, { 0x35C4 }, { 0x35C3 }, { 0x35C2 },
	{ 0x35D0 }, { 0x35DB }, { 0x35DA }, { 0x35D9 }, { 0x35D8 }, { 0x35D5 }, { 0x35D4 }, { 0x35D3 }, { 0x35D2 },
	{ 0x35E0 }, { 0x35EB }, { 0x35EA }, { 0x35E9 }, { 0x35E8 }, { 0x35E5 }, { 0x35E4 }, { 0x35E3 }, { 0x35E2 },
	{ 0x35F0 }, { 0x35FB }, { 0x35FA }, { 0x35F9 }, { 0x35F8 }, { 0x35F5 }, { 0x35F4 }, { 0x35F3 }, { 0x35F2 },
	{ 0x3600 }, { 0x360B }, { 0x360A }, { 0x3609 }, { 0x3608 }, { 0x3605 }, { 0x3604 }, { 0x3603 }, { 0x3602 },
	{ 0x3610 }, { 0x361B }, { 0x361A }, { 0x3619 }, { 0x3618 }, { 0x3615 }, { 0x3614 }, { 0x3613 }, { 0x3612 },
	{ 0x3620 }, { 0x362B }, { 0x362A }, { 0x3629 }, { 0x3628 }, { 0x3625 }, { 0x3624 }, { 0x3623 }, { 0x3622 },
	{ 0x3630 }, { 0x363B }, { 0x363A }, { 0x3639 }, { 0x3638 }, { 0x3635 }, { 0x3634 }, { 0x3633 }, { 0x3632 },
	{ 0x3640 }, { 0x364B }, { 0x364A }, { 0x3649 }, { 0x3648 }, { 0x3645 }, { 0x3644 }, { 0x3643 }, { 0x3642 },
	{ 0x3650 }, { 0x365B }, { 0x365A }, { 0x3659 }, { 0x3658 }, { 0x3655 }, { 0x3654 }, { 0x3653 }, { 0x3652 },
	{ 0x3660 }, { 0x366B }, { 0x366A }, { 0x3669 }, { 0x3668 }, { 0x3665 }, { 0x3664 }, { 0x3663 }, { 0x3662 },
	{ 0x3670 }, { 0x367B }, { 0x367A }, { 0x3679 }, { 0x3678 }, { 0x3675 }, { 0x3674 }, { 0x3673 }, { 0x3672 },
	{ 0x3680 }, { 0x368B }, { 0x368A }, { 0x3689 }, { 0x3688 }, { 0x3685 }, { 0x3684 }, { 0x3683 }, { 0x3682 },
	{ 0x3690 }, { 0x369B }, { 0x369A }, { 0x3699 }, { 0x3698 }, { 0x3695 }, { 0x3694 }, { 0x3693 }, { 0x3692 },
	{ 0x36A0 }, { 0x36AB }, { 0x36AA }, { 0x36A9 }, { 0x36A8 }, { 0x36A5 }, { 0x36A4 }, { 0x36A3 }, { 0x36A2 },
	{ 0x36B0 }, { 0x36BB }, { 0x36BA }, { 0x36B9 }, { 0x36B8 }, { 0x36B5 }, { 0x36B4 }, { 0x36B3 }, { 0x36B2 },
	{ 0x36C0 }, { 0x36CB }, { 0x36CA }, { 0x36C9 }, { 0x36C8 }, { 0x36C5 }, { 0x36C4 }, { 0x36C3 }, { 0x36C2 },
	{ 0x36D0 }, { 0x36DB }, { 0x36DA }, { 0x36D9 }, { 0x36D8 }, { 0x36D5 }, { 0x36D4 }, { 0x36D3 }, { 0x36D2 },
	{ 0x36E0 }, { 0x36EB }, { 0x36EA }, { 0x36E9 }, { 0x36E8 }, { 0x36E5 }, { 0x36E4 }, { 0x36E3 }, { 0x36E2 },
	{ 0x36F0 }, { 0x36FB }, { 0x36FA }, { 0x36F9 }, { 0x36F8 }, { 0x36F5 }, { 0x36F4 }, { 0x36F3 }, { 0x36F2 },
	{ 0x3700 }, { 0x370B }, { 0x370A }, { 0x3709 }, { 0x3708 }, { 0x3705 }, { 0x3704 }, { 0x3703 }, { 0x3702 },
	{ 0x3710 }, { 0x371B }, { 0x371A }, { 0x3719 }, { 0x3718 }, { 0x3715 }, { 0x3714 }, { 0x3713 }, { 0x3712 },
	{ 0x3720 }, { 0x372B }, { 0x372A }, { 0x3729 }, { 0x3728 }, { 0x3725 }, { 0x3724 }, { 0x3723 }, { 0x3722 },
	{ 0x3730 }, { 0x373B }, { 0x373A }, { 0x3739 }, { 0x3738 }, { 0x3735 }, { 0x3734 }, { 0x3733 }, { 0x3732 },
	{ 0x3740 }, { 0x374B }, { 0x374A }, { 0x3749 }, { 0x3748 }, { 0x3745 }, { 0x3744 }, { 0x3743 }, { 0x3742 },
	{ 0x3750 }, { 0x375B }, { 0x375A }, { 0x3759 }, { 0x3758 }, { 0x3755 }, { 0x3754 }, { 0x3753 }, { 0x3752 },
	{ 0x3760 }, { 0x376B }, { 0x376A }, { 0x3769 }, { 0x3768 }, { 0x3765 }, { 0x3764 }, { 0x3763 }, { 0x3762 },
	{ 0x3770 }, { 0x377B }, { 0x377A }, { 0x3779 }, { 0x3778 }, { 0x3775 }, { 0x3774 }, { 0x3773 }, { 0x3772 },
	{ 0x3780 }, { 0x378B }, { 0x378A }, { 0x3789 }, { 0x3788 }, { 0x3785 }, { 0x3784 }, { 0x3783 }, { 0x3782 },
	{ 0x3790 }, { 0x379B }, { 0x379A }, { 0x3799 }, { 0x3798 }, { 0x3795 }, { 0x3794 }, { 0x3793 }, { 0x3792 },
	{ 0x37A0 }, { 0x37AB }, { 0x37AA }, { 0x37A9 }, { 0x37A8 }, { 0x37A5 }, { 0x37A4 }, { 0x37A3 }, { 0x37A2 },
	{ 0x37B0 }, { 0x37BB }, { 0x37BA }, { 0x37B9 }, { 0x37B8 }, { 0x37B5 }, { 0x37B4 }, { 0x37B3 }, { 0x37B2 },
	{ 0x37C0 }, { 0x37CB }, { 0x37CA }, { 0x37C9 }, { 0x37C8 }, { 0x37C5 }, { 0x37C4 }, { 0x37C3 }, { 0x37C2 },
	{ 0x37D0 }, { 0x37DB }, { 0x37DA }, { 0x37D9 }, { 0x37D8 }, { 0x37D5 }, { 0x37D4 }, { 0x37D3 }, { 0x37D2 },
	{ 0x37E0 }, { 0x37EB }, { 0x37EA }, { 0x37E9 }, { 0x37E8 }, { 0x37E5 }, { 0x37E4 }, { 0x37E3 }, { 0x37E2 },
	{ 0x37F0 }, { 0x37FB }, { 0x37FA }, { 0x37F9 }, { 0x37F8 }, { 0x37F5 }, { 0x37F4 }, { 0x37F3 }, { 0x37F2 },
	{ 0x3800 }, { 0x380B }, { 0x380A }, { 0x3809 }, { 0x3808 }, { 0x3805 }, { 0x3804 }, { 0x3803 }, { 0x3802 },
	{ 0x3810 }, { 0x381B }, { 0x381A }, { 0x3819 }, { 0x3818 }, { 0x3815 }, { 0x3814 }, { 0x3813 }, { 0x3812 },
	{ 0x3820 }, { 0x382B }, { 0x382A }, { 0x3829 }, { 0x3828 }, { 0x3825 }, { 0x3824 }, { 0x3823 }, { 0x3822 },
	{ 0x3830 }, { 0x383B }, { 0x383A }, { 0x3839 }, { 0x3838 }, { 0x3835 }, { 0x3834 }, { 0x3833 }, { 0x3832 },
	{ 0x3840 }, { 0x384B }, { 0x384A }, { 0x3849 }, { 0x3848 }, { 0x3845 }, { 0x3844 }, { 0x3843 }, { 0x3842 },
	{ 0x3850 }, { 0x385B }, { 0x385A }, { 0x3859 }, { 0x3858 }, { 0x3855 }, { 0x3854 }, { 0x3853 }, { 0x3852 },
	{ 0x3860 }, { 0x386B }, { 0x386A }, { 0x3869 }, { 0x3868 }, { 0x3865 }, { 0x3864 }, { 0x3863 }, { 0x3862 },
	{ 0x3870 }, { 0x387B }, { 0x387A }, { 0x3879 }, { 0x3878 }, { 0x3875 }, { 0x3874 }, { 0x3873 }, { 0x3872 },
	{ 0x3880 }, { 0x388B }, { 0x388A }, { 0x3889 }, { 0x3888 }, { 0x3885 }, { 0x3884 }, { 0x3883 }, { 0x3882 },
	{ 0x3890 }, { 0x389B }, { 0x389A }, { 0x3899 }, { 0x3898 }, { 0x3895 }, { 0x3894 }, { 0x3893 }, { 0x3892 },
	{ 0x38A0 }, { 0x38AB }, { 0x38AA }, { 0x38A9 }, { 0x38A8 }, { 0x38A5 }, { 0x38A4 }, { 0x38A3 }, { 0x38A2 },
	{ 0x38B0 }, { 0x38BB }, { 0x38BA }, { 0x38B9 }, { 0x38B8 }, { 0x38B5 }, { 0x38B4 }, { 0x38B3 }, { 0x38B2 },
	{ 0x38C0 }, { 0x38CB }, { 0x38CA }, { 0x38C9 }, { 0x38C8 }, { 0x38C5 }, { 0x38C4 }, { 0x38C3 }, { 0x38C2 },
	{ 0x38D0 }, { 0x38DB }, { 0x38DA }, { 0x38D9 }, { 0x38D8 }, { 0x38D5 }, { 0x38D4 }, { 0x38D3 }, { 0x38D2 },
	{ 0x38E0 }, { 0x38EB }, { 0x38EA }, { 0x38E9 }, { 0x38E8 }, { 0x38E5 }, { 0x38E4 }, { 0x38E3 }, { 0x38E2 },
	{ 0x38F0 }, { 0x38FB }, { 0x38FA }, { 0x38F9 }, { 0x38F8 }, { 0x38F5 }, { 0x38F4 }, { 0x38F3 }, { 0x38F2 },
	{ 0x3900 }, { 0x390B }, { 0x390A }, { 0x3909 }, { 0x3908 }, { 0x3905 }, { 0x3904 }, { 0x3903 }, { 0x3902 },
	{ 0x3910 }, { 0x391B }, { 0x391A }, { 0x3919 }, { 0x3918 }, { 0x3915 }, { 0x3914 }, { 0x3913 }, { 0x3912 },
	{ 0x3920 }, { 0x392B }, { 0x392A }, { 0x3929 }, { 0x3928 }, { 0x3925 }, { 0x3924 }, { 0x3923 }, { 0x3922 },
	{ 0x3930 }, { 0x393B }, { 0x393A }, { 0x3939 }, { 0x3938 }, { 0x3935 }, { 0x3934 }, { 0x3933 }, { 0x3932 },
	{ 0x3940 }, { 0x394B }, { 0x394A }, { 0x3949 }, { 0x3948 }, { 0x3945 }, { 0x3944 }, { 0x3943 }, { 0x3942 },
	{ 0x3950 }, { 0x395B }, { 0x395A }, { 0x3959 }, { 0x3958 }, { 0x3955 }, { 0x3954 }, { 0x3953 }, { 0x3952 },
	{ 0x3960 }, { 0x396B }, { 0x396A }, { 0x3969 }, { 0x3968 }, { 0x3965 }, { 0x3964 }, { 0x3963 }, { 0x3962 },
	{ 0x3970 }, { 0x397B }, { 0x397A }, { 0x3979 }, { 0x3978 }, { 0x3975 }, { 0x3974 }, { 0x3973 }, { 0x3972 },
	{ 0x3980 }, { 0x398B }, { 0x398A }, { 0x3989 }, { 0x3988 }, { 0x3985 }, { 0x3984 }, { 0x3983 }, { 0x3982 },
	{ 0x3990 }, { 0x399B }, { 0x399A }, { 0x3999 }, { 0x3998 }, { 0x3995 }, { 0x3994 }, { 0x3993 }, { 0x3992 },
	{ 0x39A0 }, { 0x39AB }, { 0x39AA }, { 0x39A9 }, { 0x39A8 }, { 0x39A5 }, { 0x39A4 }, { 0x39A3 }, { 0x39A2 },
	{ 0x39B0 }, { 0x39BB }, { 0x39BA }, { 0x39B9 }, { 0x39B8 }, { 0x39B5 }, { 0x39B4 }, { 0x39B3 }, { 0x39B2 },
	{ 0x39C0 }, { 0x39CB }, { 0x39CA }, { 0x39C9 }, { 0x39C8 }, { 0x39C5 }, { 0x39C4 }, { 0x39C3 }, { 0x39C2 },
	{ 0x39D0 }, { 0x39DB }, { 0x39DA }, { 0x39D9 }, { 0x39D8 }, { 0x39D5 }, { 0x39D4 }, { 0x39D3 }, { 0x39D2 },
	{ 0x39E0 }, { 0x39EB }, { 0x39EA }, { 0x39E9 }, { 0x39E8 }, { 0x39E5 }, { 0x39E4 }, { 0x39E3 }, { 0x39E2 },
	{ 0x39F0 }, { 0x39FB }, { 0x39FA }, { 0x39F9 }, { 0x39F8 }, { 0x39F5 }, { 0x39F4 }, { 0x39F3 }, { 0x39F2 },
	{ 0x3A00 }, { 0x3A0B }, { 0x3A0A }, { 0x3A09 }, { 0x3A08 }, { 0x3A05 }, { 0x3A04 }, { 0x3A03 }, { 0x3A02 },
	{ 0x3A10 }, { 0x3A1B }, { 0x3A1A }, { 0x3A19 }, { 0x3A18 }, { 0x3A15 }, { 0x3A14 }, { 0x3A13 }, { 0x3A12 },
	{ 0x3A20 }, { 0x3A2B }, { 0x3A2A }, { 0x3A29 }, { 0x3A28 }, { 0x3A25 }, { 0x3A24 }, { 0x3A23 }, { 0x3A22 },
	{ 0x3A30 }, { 0x3A3B }, { 0x3A3A }, { 0x3A39 }, { 0x3A38 }, { 0x3A35 }, { 0x3A34 }, { 0x3A33 }, { 0x3A32 },
	{ 0x3A40 }, { 0x3A4B }, { 0x3A4A }, { 0x3A49 }, { 0x3A48 }, { 0x3A45 }, { 0x3A44 }, { 0x3A43 }, { 0x3A42 },
	{ 0x3A50 }, { 0x3A5B }, { 0x3A5A }, { 0x3A59 }, { 0x3A58 }, { 0x3A55 }, { 0x3A54 }, { 0x3A53 }, { 0x3A52 },
	{ 0x3A60 }, { 0x3A6B }, { 0x3A6A }, { 0x3A69 }, { 0x3A68 }, { 0x3A65 }, { 0x3A64 }, { 0x3A63 }, { 0x3A62 },
	{ 0x3A70 }, { 0x3A7B }, { 0x3A7A }, { 0x3A79 }, { 0x3A78 }, { 0x3A75 }, { 0x3A74 }, { 0x3A73 }, { 0x3A72 },
	{ 0x3A80 }, { 0x3A8B }, { 0x3A8A }, { 0x3A89 }, { 0x3A88 }, { 0x3A85 }, { 0x3A84 }, { 0x3A83 }, { 0x3A82 },
	{ 0x3A90 }, { 0x3A9B }, { 0x3A9A }, { 0x3A99 }, { 0x3A98 }, { 0x3A95 }, { 0x3A94 }, { 0x3A93 }, { 0x3A92 },
	{ 0x3AA0 }, { 0x3AAB }, { 0x3AAA }, { 0x3AA9 }, { 0x3AA8 }, { 0x3AA5 }, { 0x3AA4 }, { 0x3AA3 }, { 0x3AA2 },
	{ 0x3AB0 }, { 0x3ABB }, { 0x3ABA }, { 0x3AB9 }, { 0x3AB8 }, { 0x3AB5 }, { 0x3AB4 }, { 0x3AB3 }, { 0x3AB2 },
	{ 0x3AC0 }, { 0x3ACB }, { 0x3ACA }, { 0x3AC9 }, { 0x3AC8 }, { 0x3AC5 }, { 0x3AC4 }, { 0x3AC3 }, { 0x3AC2 },
	{ 0x3AD0 }, { 0x3ADB }, { 0x3ADA }, { 0x3AD9 }, { 0x3AD8 }, { 0x3AD5 }, { 0x3AD4 }, { 0x3AD3 }, { 0x3AD2 },
	{ 0x3AE0 }, { 0x3AEB }, { 0x3AEA }, { 0x3AE9 }, { 0x3AE8 }, { 0x3AE5 }, { 0x3AE4 }, { 0x3AE3 }, { 0x3AE2 },
	{ 0x3AF0 }, { 0x3AFB }, { 0x3AFA }, { 0x3AF9 }, { 0x3AF8 }, { 0x3AF5 }, { 0x3AF4 }, { 0x3AF3 }, { 0x3AF2 },
	{ 0x3B00 }, { 0x3B0B }, { 0x3B0A }, { 0x3B09 }, { 0x3B08 }, { 0x3B05 }, { 0x3B04 }, { 0x3B03 }, { 0x3B02 },
	{ 0x3B10 }, { 0x3B1B }, { 0x3B1A }, { 0x3B19 }, { 0x3B18 }, { 0x3B15 }, { 0x3B14 }, { 0x3B13 }, { 0x3B12 },
	{ 0x3B20 }, { 0x3B2B }, { 0x3B2A }, { 0x3B29 }, { 0x3B28 }, { 0x3B25 }, { 0x3B24 }, { 0x3B23 }, { 0x3B22 },
	{ 0x3B30 }, { 0x3B3B }, { 0x3B3A }, { 0x3B39 }, { 0x3B38 }, { 0x3B35 }, { 0x3B34 }, { 0x3B33 }, { 0x3B32 },
	{ 0x3B40 }, { 0x3B4B }, { 0x3B4A }, { 0x3B49 }, { 0x3B48 }, { 0x3B45 }, { 0x3B44 }, { 0x3B43 }, { 0x3B42 },
	{ 0x3B50 }, { 0x3B5B }, { 0x3B5A }, { 0x3B59 }, { 0x3B58 }, { 0x3B55 }, { 0x3B54 }, { 0x3B53 }, { 0x3B52 },
	{ 0x3B60 }, { 0x3B6B }, { 0x3B6A }, { 0x3B69 }, { 0x3B68 }, { 0x3B65 }, { 0x3B64 }, { 0x3B63 }, { 0x3B62 },
	{ 0x3B70 }, { 0x3B7B }, { 0x3B7A }, { 0x3B79 }, { 0x3B78 }, { 0x3B75 }, { 0x3B74 }, { 0x3B73 }, { 0x3B72 },
	{ 0x3B80 }, { 0x3B8B }, { 0x3B8A }, { 0x3B89 }, { 0x3B88 }, { 0x3B85 }, { 0x3B84 }, { 0x3B83 }, { 0x3B82 },
	{ 0x3B90 }, { 0x3B9B }, { 0x3B9A }, { 0x3B99 }, { 0x3B98 }, { 0x3B95 }, { 0x3B94 }, { 0x3B93 }, { 0x3B92 },
	{ 0x3BA0 }, { 0x3BAB }, { 0x3BAA }, { 0x3BA9 }, { 0x3BA8 }, { 0x3BA5 }, { 0x3BA4 }, { 0x3BA3 }, { 0x3BA2 },
	{ 0x3BB0 }, { 0x3BBB }, { 0x3BBA }, { 0x3BB9 }, { 0x3BB8 }, { 0x3BB5 }, { 0x3BB4 }, { 0x3BB3 }, { 0x3BB2 },
	{ 0x3BC0 }, { 0x3BCB }, { 0x3BCA }, { 0x3BC9 }, { 0x3BC8 }, { 0x3BC5 }, { 0x3BC4 }, { 0x3BC3 }, { 0x3BC2 },
	{ 0x3BD0 }, { 0x3BDB }, { 0x3BDA }, { 0x3BD9 }, { 0x3BD8 }, { 0x3BD5 }, { 0x3BD4 }, { 0x3BD3 }, { 0x3BD2 },
	{ 0x3BE0 }, { 0x3BEB }, { 0x3BEA }, { 0x3BE9 }, { 0x3BE8 }, { 0x3BE5 }, { 0x3BE4 }, { 0x3BE3 }, { 0x3BE2 },
	{ 0x3BF0 }, { 0x3BFB }, { 0x3BFA }, { 0x3BF9 }, { 0x3BF8 }, { 0x3BF5 }, { 0x3BF4 }, { 0x3BF3 }, { 0x3BF2 },
	{ 0x3C00 }, { 0x3C0B }, { 0x3C0A }, { 0x3C09 }, { 0x3C08 }, { 0x3C05 }, { 0x3C04 }, { 0x3C03 }, { 0x3C02 },
	{ 0x3C10 }, { 0x3C1B }, { 0x3C1A }, { 0x3C19 }, { 0x3C18 }, { 0x3C15 }, { 0x3C14 }, { 0x3C13 }, { 0x3C12 },
	{ 0x3C20 }, { 0x3C2B }, { 0x3C2A }, { 0x3C29 }, { 0x3C28 }, { 0x3C25 }, { 0x3C24 }, { 0x3C23 }, { 0x3C22 },
	{ 0x3C30 }, { 0x3C3B }, { 0x3C3A }, { 0x3C39 }, { 0x3C38 }, { 0x3C35 }, { 0x3C34 }, { 0x3C33 }, { 0x3C32 },
	{ 0x0 }
};

static PMU_MSR_INFO_NODE pmu14_2[] = {
	{ 0x3400 }, { 0x340B }, { 0x340A }, { 0x3409 }, { 0x3408 }, { 0x3405 }, { 0x3404 }, { 0x3403 }, { 0x3402 },
	{ 0x3410 }, { 0x341B }, { 0x341A }, { 0x3419 }, { 0x3418 }, { 0x3415 }, { 0x3414 }, { 0x3413 }, { 0x3412 },
	{ 0x3420 }, { 0x342B }, { 0x342A }, { 0x3429 }, { 0x3428 }, { 0x3425 }, { 0x3424 }, { 0x3423 }, { 0x3422 },
	{ 0x3430 }, { 0x343B }, { 0x343A }, { 0x3439 }, { 0x3438 }, { 0x3435 }, { 0x3434 }, { 0x3433 }, { 0x3432 },
	{ 0x3440 }, { 0x344B }, { 0x344A }, { 0x3449 }, { 0x3448 }, { 0x3445 }, { 0x3444 }, { 0x3443 }, { 0x3442 },
	{ 0x3450 }, { 0x345B }, { 0x345A }, { 0x3459 }, { 0x3458 }, { 0x3455 }, { 0x3454 }, { 0x3453 }, { 0x3452 },
	{ 0x3460 }, { 0x346B }, { 0x346A }, { 0x3469 }, { 0x3468 }, { 0x3465 }, { 0x3464 }, { 0x3463 }, { 0x3462 },
	{ 0x0 }
};

static PMU_MSR_INFO_NODE pmu14_3[] = {
	{ 0x3400 }, { 0x340B }, { 0x340A }, { 0x3409 }, { 0x3408 }, { 0x3405 }, { 0x3404 }, { 0x3403 }, { 0x3402 },
	{ 0x3410 }, { 0x341B }, { 0x341A }, { 0x3419 }, { 0x3418 }, { 0x3415 }, { 0x3414 }, { 0x3413 }, { 0x3412 },
	{ 0x3420 }, { 0x342B }, { 0x342A }, { 0x3429 }, { 0x3428 }, { 0x3425 }, { 0x3424 }, { 0x3423 }, { 0x3422 },
	{ 0x3430 }, { 0x343B }, { 0x343A }, { 0x3439 }, { 0x3438 }, { 0x3435 }, { 0x3434 }, { 0x3433 }, { 0x3432 },
	{ 0x3440 }, { 0x344B }, { 0x344A }, { 0x3449 }, { 0x3448 }, { 0x3445 }, { 0x3444 }, { 0x3443 }, { 0x3442 },
	{ 0x3450 }, { 0x345B }, { 0x345A }, { 0x3459 }, { 0x3458 }, { 0x3455 }, { 0x3454 }, { 0x3453 }, { 0x3452 },
	{ 0x3460 }, { 0x346B }, { 0x346A }, { 0x3469 }, { 0x3468 }, { 0x3465 }, { 0x3464 }, { 0x3463 }, { 0x3462 },
	{ 0x3470 }, { 0x347B }, { 0x347A }, { 0x3479 }, { 0x3478 }, { 0x3475 }, { 0x3474 }, { 0x3473 }, { 0x3472 },
	{ 0x3480 }, { 0x348B }, { 0x348A }, { 0x3489 }, { 0x3488 }, { 0x3485 }, { 0x3484 }, { 0x3483 }, { 0x3482 },
	{ 0x3490 }, { 0x349B }, { 0x349A }, { 0x3499 }, { 0x3498 }, { 0x3495 }, { 0x3494 }, { 0x3493 }, { 0x3492 },
	{ 0x34A0 }, { 0x34AB }, { 0x34AA }, { 0x34A9 }, { 0x34A8 }, { 0x34A5 }, { 0x34A4 }, { 0x34A3 }, { 0x34A2 },
	{ 0x34B0 }, { 0x34BB }, { 0x34BA }, { 0x34B9 }, { 0x34B8 }, { 0x34B5 }, { 0x34B4 }, { 0x34B3 }, { 0x34B2 },
	{ 0x34C0 }, { 0x34CB }, { 0x34CA }, { 0x34C9 }, { 0x34C8 }, { 0x34C5 }, { 0x34C4 }, { 0x34C3 }, { 0x34C2 },
	{ 0x34D0 }, { 0x34DB }, { 0x34DA }, { 0x34D9 }, { 0x34D8 }, { 0x34D5 }, { 0x34D4 }, { 0x34D3 }, { 0x34D2 },
	{ 0x34E0 }, { 0x34EB }, { 0x34EA }, { 0x34E9 }, { 0x34E8 }, { 0x34E5 }, { 0x34E4 }, { 0x34E3 }, { 0x34E2 },
	{ 0x34F0 }, { 0x34FB }, { 0x34FA }, { 0x34F9 }, { 0x34F8 }, { 0x34F5 }, { 0x34F4 }, { 0x34F3 }, { 0x34F2 },
	{ 0x3500 }, { 0x350B }, { 0x350A }, { 0x3509 }, { 0x3508 }, { 0x3505 }, { 0x3504 }, { 0x3503 }, { 0x3502 },
	{ 0x3510 }, { 0x351B }, { 0x351A }, { 0x3519 }, { 0x3518 }, { 0x3515 }, { 0x3514 }, { 0x3513 }, { 0x3512 },
	{ 0x3520 }, { 0x352B }, { 0x352A }, { 0x3529 }, { 0x3528 }, { 0x3525 }, { 0x3524 }, { 0x3523 }, { 0x3522 },
	{ 0x3530 }, { 0x353B }, { 0x353A }, { 0x3539 }, { 0x3538 }, { 0x3535 }, { 0x3534 }, { 0x3533 }, { 0x3532 },
	{ 0x3540 }, { 0x354B }, { 0x354A }, { 0x3549 }, { 0x3548 }, { 0x3545 }, { 0x3544 }, { 0x3543 }, { 0x3542 },
	{ 0x3550 }, { 0x355B }, { 0x355A }, { 0x3559 }, { 0x3558 }, { 0x3555 }, { 0x3554 }, { 0x3553 }, { 0x3552 },
	{ 0x3560 }, { 0x356B }, { 0x356A }, { 0x3569 }, { 0x3568 }, { 0x3565 }, { 0x3564 }, { 0x3563 }, { 0x3562 },
	{ 0x3570 }, { 0x357B }, { 0x357A }, { 0x3579 }, { 0x3578 }, { 0x3575 }, { 0x3574 }, { 0x3573 }, { 0x3572 },
	{ 0x3580 }, { 0x358B }, { 0x358A }, { 0x3589 }, { 0x3588 }, { 0x3585 }, { 0x3584 }, { 0x3583 }, { 0x3582 },
	{ 0x3590 }, { 0x359B }, { 0x359A }, { 0x3599 }, { 0x3598 }, { 0x3595 }, { 0x3594 }, { 0x3593 }, { 0x3592 },
	{ 0x35A0 }, { 0x35AB }, { 0x35AA }, { 0x35A9 }, { 0x35A8 }, { 0x35A5 }, { 0x35A4 }, { 0x35A3 }, { 0x35A2 },
	{ 0x35B0 }, { 0x35BB }, { 0x35BA }, { 0x35B9 }, { 0x35B8 }, { 0x35B5 }, { 0x35B4 }, { 0x35B3 }, { 0x35B2 },
	{ 0x35C0 }, { 0x35CB }, { 0x35CA }, { 0x35C9 }, { 0x35C8 }, { 0x35C5 }, { 0x35C4 }, { 0x35C3 }, { 0x35C2 },
	{ 0x35D0 }, { 0x35DB }, { 0x35DA }, { 0x35D9 }, { 0x35D8 }, { 0x35D5 }, { 0x35D4 }, { 0x35D3 }, { 0x35D2 },
	{ 0x35E0 }, { 0x35EB }, { 0x35EA }, { 0x35E9 }, { 0x35E8 }, { 0x35E5 }, { 0x35E4 }, { 0x35E3 }, { 0x35E2 },
	{ 0x35F0 }, { 0x35FB }, { 0x35FA }, { 0x35F9 }, { 0x35F8 }, { 0x35F5 }, { 0x35F4 }, { 0x35F3 }, { 0x35F2 },
	{ 0x3600 }, { 0x360B }, { 0x360A }, { 0x3609 }, { 0x3608 }, { 0x3605 }, { 0x3604 }, { 0x3603 }, { 0x3602 },
	{ 0x3610 }, { 0x361B }, { 0x361A }, { 0x3619 }, { 0x3618 }, { 0x3615 }, { 0x3614 }, { 0x3613 }, { 0x3612 },
	{ 0x3620 }, { 0x362B }, { 0x362A }, { 0x3629 }, { 0x3628 }, { 0x3625 }, { 0x3624 }, { 0x3623 }, { 0x3622 },
	{ 0x3630 }, { 0x363B }, { 0x363A }, { 0x3639 }, { 0x3638 }, { 0x3635 }, { 0x3634 }, { 0x3633 }, { 0x3632 },
	{ 0x3640 }, { 0x364B }, { 0x364A }, { 0x3649 }, { 0x3648 }, { 0x3645 }, { 0x3644 }, { 0x3643 }, { 0x3642 },
	{ 0x3650 }, { 0x365B }, { 0x365A }, { 0x3659 }, { 0x3658 }, { 0x3655 }, { 0x3654 }, { 0x3653 }, { 0x3652 },
	{ 0x3660 }, { 0x366B }, { 0x366A }, { 0x3669 }, { 0x3668 }, { 0x3665 }, { 0x3664 }, { 0x3663 }, { 0x3662 },
	{ 0x3670 }, { 0x367B }, { 0x367A }, { 0x3679 }, { 0x3678 }, { 0x3675 }, { 0x3674 }, { 0x3673 }, { 0x3672 },
	{ 0x3680 }, { 0x368B }, { 0x368A }, { 0x3689 }, { 0x3688 }, { 0x3685 }, { 0x3684 }, { 0x3683 }, { 0x3682 },
	{ 0x3690 }, { 0x369B }, { 0x369A }, { 0x3699 }, { 0x3698 }, { 0x3695 }, { 0x3694 }, { 0x3693 }, { 0x3692 },
	{ 0x36A0 }, { 0x36AB }, { 0x36AA }, { 0x36A9 }, { 0x36A8 }, { 0x36A5 }, { 0x36A4 }, { 0x36A3 }, { 0x36A2 },
	{ 0x36B0 }, { 0x36BB }, { 0x36BA }, { 0x36B9 }, { 0x36B8 }, { 0x36B5 }, { 0x36B4 }, { 0x36B3 }, { 0x36B2 },
	{ 0x36C0 }, { 0x36CB }, { 0x36CA }, { 0x36C9 }, { 0x36C8 }, { 0x36C5 }, { 0x36C4 }, { 0x36C3 }, { 0x36C2 },
	{ 0x36D0 }, { 0x36DB }, { 0x36DA }, { 0x36D9 }, { 0x36D8 }, { 0x36D5 }, { 0x36D4 }, { 0x36D3 }, { 0x36D2 },
	{ 0x36E0 }, { 0x36EB }, { 0x36EA }, { 0x36E9 }, { 0x36E8 }, { 0x36E5 }, { 0x36E4 }, { 0x36E3 }, { 0x36E2 },
	{ 0x36F0 }, { 0x36FB }, { 0x36FA }, { 0x36F9 }, { 0x36F8 }, { 0x36F5 }, { 0x36F4 }, { 0x36F3 }, { 0x36F2 },
	{ 0x3700 }, { 0x370B }, { 0x370A }, { 0x3709 }, { 0x3708 }, { 0x3705 }, { 0x3704 }, { 0x3703 }, { 0x3702 },
	{ 0x3710 }, { 0x371B }, { 0x371A }, { 0x3719 }, { 0x3718 }, { 0x3715 }, { 0x3714 }, { 0x3713 }, { 0x3712 },
	{ 0x3720 }, { 0x372B }, { 0x372A }, { 0x3729 }, { 0x3728 }, { 0x3725 }, { 0x3724 }, { 0x3723 }, { 0x3722 },
	{ 0x3730 }, { 0x373B }, { 0x373A }, { 0x3739 }, { 0x3738 }, { 0x3735 }, { 0x3734 }, { 0x3733 }, { 0x3732 },
	{ 0x3740 }, { 0x374B }, { 0x374A }, { 0x3749 }, { 0x3748 }, { 0x3745 }, { 0x3744 }, { 0x3743 }, { 0x3742 },
	{ 0x3750 }, { 0x375B }, { 0x375A }, { 0x3759 }, { 0x3758 }, { 0x3755 }, { 0x3754 }, { 0x3753 }, { 0x3752 },
	{ 0x3760 }, { 0x376B }, { 0x376A }, { 0x3769 }, { 0x3768 }, { 0x3765 }, { 0x3764 }, { 0x3763 }, { 0x3762 },
	{ 0x3770 }, { 0x377B }, { 0x377A }, { 0x3779 }, { 0x3778 }, { 0x3775 }, { 0x3774 }, { 0x3773 }, { 0x3772 },
	{ 0x3780 }, { 0x378B }, { 0x378A }, { 0x3789 }, { 0x3788 }, { 0x3785 }, { 0x3784 }, { 0x3783 }, { 0x3782 },
	{ 0x3790 }, { 0x379B }, { 0x379A }, { 0x3799 }, { 0x3798 }, { 0x3795 }, { 0x3794 }, { 0x3793 }, { 0x3792 },
	{ 0x37A0 }, { 0x37AB }, { 0x37AA }, { 0x37A9 }, { 0x37A8 }, { 0x37A5 }, { 0x37A4 }, { 0x37A3 }, { 0x37A2 },
	{ 0x37B0 }, { 0x37BB }, { 0x37BA }, { 0x37B9 }, { 0x37B8 }, { 0x37B5 }, { 0x37B4 }, { 0x37B3 }, { 0x37B2 },
	{ 0x37C0 }, { 0x37CB }, { 0x37CA }, { 0x37C9 }, { 0x37C8 }, { 0x37C5 }, { 0x37C4 }, { 0x37C3 }, { 0x37C2 },
	{ 0x37D0 }, { 0x37DB }, { 0x37DA }, { 0x37D9 }, { 0x37D8 }, { 0x37D5 }, { 0x37D4 }, { 0x37D3 }, { 0x37D2 },
	{ 0x37E0 }, { 0x37EB }, { 0x37EA }, { 0x37E9 }, { 0x37E8 }, { 0x37E5 }, { 0x37E4 }, { 0x37E3 }, { 0x37E2 },
	{ 0x37F0 }, { 0x37FB }, { 0x37FA }, { 0x37F9 }, { 0x37F8 }, { 0x37F5 }, { 0x37F4 }, { 0x37F3 }, { 0x37F2 },
	{ 0x3800 }, { 0x380B }, { 0x380A }, { 0x3809 }, { 0x3808 }, { 0x3805 }, { 0x3804 }, { 0x3803 }, { 0x3802 },
	{ 0x3810 }, { 0x381B }, { 0x381A }, { 0x3819 }, { 0x3818 }, { 0x3815 }, { 0x3814 }, { 0x3813 }, { 0x3812 },
	{ 0x3820 }, { 0x382B }, { 0x382A }, { 0x3829 }, { 0x3828 }, { 0x3825 }, { 0x3824 }, { 0x3823 }, { 0x3822 },
	{ 0x3830 }, { 0x383B }, { 0x383A }, { 0x3839 }, { 0x3838 }, { 0x3835 }, { 0x3834 }, { 0x3833 }, { 0x3832 },
	{ 0x3840 }, { 0x384B }, { 0x384A }, { 0x3849 }, { 0x3848 }, { 0x3845 }, { 0x3844 }, { 0x3843 }, { 0x3842 },
	{ 0x3850 }, { 0x385B }, { 0x385A }, { 0x3859 }, { 0x3858 }, { 0x3855 }, { 0x3854 }, { 0x3853 }, { 0x3852 },
	{ 0x3860 }, { 0x386B }, { 0x386A }, { 0x3869 }, { 0x3868 }, { 0x3865 }, { 0x3864 }, { 0x3863 }, { 0x3862 },
	{ 0x3870 }, { 0x387B }, { 0x387A }, { 0x3879 }, { 0x3878 }, { 0x3875 }, { 0x3874 }, { 0x3873 }, { 0x3872 },
	{ 0x3880 }, { 0x388B }, { 0x388A }, { 0x3889 }, { 0x3888 }, { 0x3885 }, { 0x3884 }, { 0x3883 }, { 0x3882 },
	{ 0x3890 }, { 0x389B }, { 0x389A }, { 0x3899 }, { 0x3898 }, { 0x3895 }, { 0x3894 }, { 0x3893 }, { 0x3892 },
	{ 0x38A0 }, { 0x38AB }, { 0x38AA }, { 0x38A9 }, { 0x38A8 }, { 0x38A5 }, { 0x38A4 }, { 0x38A3 }, { 0x38A2 },
	{ 0x38B0 }, { 0x38BB }, { 0x38BA }, { 0x38B9 }, { 0x38B8 }, { 0x38B5 }, { 0x38B4 }, { 0x38B3 }, { 0x38B2 },
	{ 0x38C0 }, { 0x38CB }, { 0x38CA }, { 0x38C9 }, { 0x38C8 }, { 0x38C5 }, { 0x38C4 }, { 0x38C3 }, { 0x38C2 },
	{ 0x38D0 }, { 0x38DB }, { 0x38DA }, { 0x38D9 }, { 0x38D8 }, { 0x38D5 }, { 0x38D4 }, { 0x38D3 }, { 0x38D2 },
	{ 0x38E0 }, { 0x38EB }, { 0x38EA }, { 0x38E9 }, { 0x38E8 }, { 0x38E5 }, { 0x38E4 }, { 0x38E3 }, { 0x38E2 },
	{ 0x38F0 }, { 0x38FB }, { 0x38FA }, { 0x38F9 }, { 0x38F8 }, { 0x38F5 }, { 0x38F4 }, { 0x38F3 }, { 0x38F2 },
	{ 0x3900 }, { 0x390B }, { 0x390A }, { 0x3909 }, { 0x3908 }, { 0x3905 }, { 0x3904 }, { 0x3903 }, { 0x3902 },
	{ 0x3910 }, { 0x391B }, { 0x391A }, { 0x3919 }, { 0x3918 }, { 0x3915 }, { 0x3914 }, { 0x3913 }, { 0x3912 },
	{ 0x3920 }, { 0x392B }, { 0x392A }, { 0x3929 }, { 0x3928 }, { 0x3925 }, { 0x3924 }, { 0x3923 }, { 0x3922 },
	{ 0x3930 }, { 0x393B }, { 0x393A }, { 0x3939 }, { 0x3938 }, { 0x3935 }, { 0x3934 }, { 0x3933 }, { 0x3932 },
	{ 0x3940 }, { 0x394B }, { 0x394A }, { 0x3949 }, { 0x3948 }, { 0x3945 }, { 0x3944 }, { 0x3943 }, { 0x3942 },
	{ 0x3950 }, { 0x395B }, { 0x395A }, { 0x3959 }, { 0x3958 }, { 0x3955 }, { 0x3954 }, { 0x3953 }, { 0x3952 },
	{ 0x3960 }, { 0x396B }, { 0x396A }, { 0x3969 }, { 0x3968 }, { 0x3965 }, { 0x3964 }, { 0x3963 }, { 0x3962 },
	{ 0x3970 }, { 0x397B }, { 0x397A }, { 0x3979 }, { 0x3978 }, { 0x3975 }, { 0x3974 }, { 0x3973 }, { 0x3972 },
	{ 0x3980 }, { 0x398B }, { 0x398A }, { 0x3989 }, { 0x3988 }, { 0x3985 }, { 0x3984 }, { 0x3983 }, { 0x3982 },
	{ 0x3990 }, { 0x399B }, { 0x399A }, { 0x3999 }, { 0x3998 }, { 0x3995 }, { 0x3994 }, { 0x3993 }, { 0x3992 },
	{ 0x39A0 }, { 0x39AB }, { 0x39AA }, { 0x39A9 }, { 0x39A8 }, { 0x39A5 }, { 0x39A4 }, { 0x39A3 }, { 0x39A2 },
	{ 0x39B0 }, { 0x39BB }, { 0x39BA }, { 0x39B9 }, { 0x39B8 }, { 0x39B5 }, { 0x39B4 }, { 0x39B3 }, { 0x39B2 },
	{ 0x39C0 }, { 0x39CB }, { 0x39CA }, { 0x39C9 }, { 0x39C8 }, { 0x39C5 }, { 0x39C4 }, { 0x39C3 }, { 0x39C2 },
	{ 0x39D0 }, { 0x39DB }, { 0x39DA }, { 0x39D9 }, { 0x39D8 }, { 0x39D5 }, { 0x39D4 }, { 0x39D3 }, { 0x39D2 },
	{ 0x39E0 }, { 0x39EB }, { 0x39EA }, { 0x39E9 }, { 0x39E8 }, { 0x39E5 }, { 0x39E4 }, { 0x39E3 }, { 0x39E2 },
	{ 0x39F0 }, { 0x39FB }, { 0x39FA }, { 0x39F9 }, { 0x39F8 }, { 0x39F5 }, { 0x39F4 }, { 0x39F3 }, { 0x39F2 },
	{ 0x3A00 }, { 0x3A0B }, { 0x3A0A }, { 0x3A09 }, { 0x3A08 }, { 0x3A05 }, { 0x3A04 }, { 0x3A03 }, { 0x3A02 },
	{ 0x3A10 }, { 0x3A1B }, { 0x3A1A }, { 0x3A19 }, { 0x3A18 }, { 0x3A15 }, { 0x3A14 }, { 0x3A13 }, { 0x3A12 },
	{ 0x3A20 }, { 0x3A2B }, { 0x3A2A }, { 0x3A29 }, { 0x3A28 }, { 0x3A25 }, { 0x3A24 }, { 0x3A23 }, { 0x3A22 },
	{ 0x3A30 }, { 0x3A3B }, { 0x3A3A }, { 0x3A39 }, { 0x3A38 }, { 0x3A35 }, { 0x3A34 }, { 0x3A33 }, { 0x3A32 },
	{ 0x0 }
};

static PMU_MSR_INFO_NODE pmu16[] = {
	{0x2C00, 0, 0x13B}, { 0x0 }
};

static PMU_MSR_INFO_NODE pmu16_2[] = {
	{0x2C00, 0, 0x8B}, { 0x0 }
};

static PMU_MSR_INFO_NODE *perfmon_v4_msr_list[] = {
	perfmon_v4_architectural,  0
};

static PMU_MSR_INFO_NODE *perfmon_v5_msr_list[] = {
	perfmon_v5_architectural, 0
};

static PMU_MSR_INFO_NODE *bdx_msr_list[] = {
	core_1, core_2, core_3, core_8, pmu1_1, pmu1_2,  pmu1_8,  pmu8_1,
	pmu8_2, pmu9_1, pmu9_2, pmu9_3, pmu9_4, pmu11_1, pmu12_1, uncore_2,
	pmu13,  0
};

static PMU_MSR_INFO_NODE *skx_msr_list[] = {
	core_1, core_2, core_3,  core_6,   core_7,             core_11,
	pmu2_1, pmu4_1, pmu6_1,  pmu8_1,   pmu8_2,             pmu9_1,
	pmu9_2, pmu9_3, pmu12_1, uncore_2, pmu5_msr_reg_list1, 0
};

static PMU_MSR_INFO_NODE *skl_msr_list[] = {
	core_1, core_2, core_3, core_6, core_7,  core_11,  pmu1_1, pmu1_7,
	pmu7_1, pmu9_6, pmu9_7, pmu9_8, pmu9_13, uncore_4, 0
};

static PMU_MSR_INFO_NODE *clx_msr_list[] = {
	core_1,             core_2, core_3,  core_6,  core_7,   core_11,
	pmu2_1,             pmu4_1, pmu6_1,  pmu8_1,  pmu8_2,   pmu9_1,
	pmu9_2,             pmu9_3, pmu9_11, pmu12_1, uncore_2, pmu13,
	pmu5_msr_reg_list1, 0
};

static PMU_MSR_INFO_NODE *icx_r_msr_list[] = {
	core_1,   core_2,   core_3, core_4, core_6, core_7,  core_11,
	pmu2_3,   pmu4_2,   pmu6_2, pmu8_1, pmu8_3, pmu10_1, pmu12_1,
	uncore_2, uncore_5, pmu9_1, pmu9_2, pmu9_3, pmu13,   0
};

static PMU_MSR_INFO_NODE *hsw_msr_list[] = {
	core_1, core_2, core_3,  core_8,   pmu1_1, pmu1_8, pmu7_1, pmu9_6,
	pmu9_7, pmu9_8, pmu9_11, uncore_5, 0
};

static PMU_MSR_INFO_NODE *hsw_ult_msr_list[] = {
	core_1, core_2, core_3,  core_8,   pmu1_1,   pmu1_8, pmu7_1, pmu9_6,
	pmu9_7, pmu9_8, pmu9_12, uncore_5, 0
};

static PMU_MSR_INFO_NODE *slm_msr_list[] = {
	core_1, core_5, pmu9_8, pmu9_9, pmu9_15, 0
};

static PMU_MSR_INFO_NODE *avt_msr_list[] = {
	core_1, core_5, pmu9_1, pmu9_2, pmu9_5, 0
};

static PMU_MSR_INFO_NODE *and_msr_list[] = {
	core_1, core_5, pmu9_7, pmu9_8, pmu9_9, pmu9_15, pmu9_16, 0
};

static PMU_MSR_INFO_NODE *bxt_msr_list[] = {
	core_1, core_3, core_6, core_7, core_11, pmu9_8, pmu9_9, pmu9_15,
	pmu13,  0 };

static PMU_MSR_INFO_NODE *dnv_msr_list[] = {
	core_1, core_3, core_6, core_11, pmu9_1, pmu9_2, pmu9_5, 0
};

static PMU_MSR_INFO_NODE *gml_msr_list[] = {
	core_1, core_3, core_6, core_11, pmu9_2, pmu9_9, 0
};

static PMU_MSR_INFO_NODE *hsx_msr_list[] = {
	core_1, core_2, core_3, core_8, pmu1_1,  pmu1_2,  pmu1_8,   pmu8_1,
	pmu8_2, pmu9_1, pmu9_2, pmu9_3, pmu11_1, pmu12_1, uncore_2, 0
};

static PMU_MSR_INFO_NODE *icl_msr_list[] = {
	core_1, core_2, core_3,   core_4,   core_6, core_7, core_11, pmu1_1,
	pmu1_6, pmu7_1, uncore_4, uncore_5, pmu9_6, pmu9_7, pmu9_8,  pmu9_13,
	0
};

static PMU_MSR_INFO_NODE *snr_msr_list[] = {
	core_1, core_2, core_3, core_4, core_6,  core_7,  core_11,  pmu2_4,
	pmu4_3, pmu6_3, pmu8_2, pmu8_5, pmu10_2, pmu12_2, uncore_3, pmu9_1,
	pmu9_2, pmu9_3, 0
};

static PMU_MSR_INFO_NODE *knl_msr_list[] = {
	core_1,  core_2,  core_3,   pmu2_2, pmu9_2, pmu9_7, pmu9_8, pmu9_9,
	pmu9_18, pmu12_1, uncore_2, 0
};

static PMU_MSR_INFO_NODE *ehl_msr_list[] = {
	core_1, core_2, core_3,   core_4, core_6, core_7, core_11,  pmu1_1,
	pmu1_6, pmu7_1, uncore_4, pmu9_6, pmu9_7, pmu9_8, pmu9_13,  0
};

static PMU_MSR_INFO_NODE *tgl_msr_list[] = {
	core_1,  core_2, core_3, core_4,   core_6,   core_7, core_11, pmu1_1,
	pmu1_6,  pmu7_1, pmu7_2, uncore_5, uncore_4, pmu9_6, pmu9_7,  pmu9_8,
	pmu9_13, 0
};

static PMU_MSR_INFO_NODE *plat3_msr_list[] = {
	core_1, core_2, core_4, core_9, core_11, pmu2_5, pmu2_6, pmu3_2, pmu4_5,
	pmu6_5, pmu8_7, pmu9_1, pmu9_2, pmu9_3, pmu9_19, pmu9_20, pmu12_5, pmu13,
	pmu14, pmu16, uncore_8, pmu5_msr_reg_list2,
	0
};

static PMU_MSR_INFO_NODE *plat4_msr_list[] = {
	core_1, core_2, core_4, core_9,  core_11, pmu2_5,             pmu3_1,
	pmu4_4, pmu6_4, pmu8_6, pmu10_3, pmu12_4, uncore_5,           uncore_6,
	pmu9_1, pmu9_2, pmu9_3, pmu9_20, pmu13,   pmu5_msr_reg_list2, pmu9_19, 0
};

static PMU_MSR_INFO_NODE *plat5_msr_list[] = {
	core_1,  core_2,  core_3,  core_4, core_6,   core_7, core_9, core_10,
	core_11, pmu1_1,  pmu1_9,  pmu7_3, uncore_7, pmu9_6, pmu9_7, pmu9_8,
	pmu9_13, pmu9_19, 0
};

static PMU_MSR_INFO_NODE *plat6_msr_list[] = {
	core_1, core_2, core_3, core_4, core_6, core_7, core_9, core_10, core_11,
	pmu1_1, pmu1_10,
	pmu7_4,
	uncore_9,
	pmu9_6, pmu9_7, pmu9_8, pmu9_13, pmu9_19,
	0
};

static PMU_MSR_INFO_NODE *plat7_msr_list[] = {
	core_1,  core_2,   core_4,  core_9,  core_11,  pmu2_7,  pmu4_6,  pmu6_6,
	pmu8_7,  pmu9_1,   pmu9_2,  pmu9_3,  pmu9_19,  pmu9_20,  pmu12_5,
	pmu14_2, uncore_8, pmu5_msr_reg_list2, 0
};

static PMU_MSR_INFO_NODE *plat8_msr_list[] = {
	core_1, core_2, core_3, core_4, core_6, core_7, core_9, core_10, core_11,
	pmu2_5, pmu2_6, pmu3_2, pmu4_5, pmu6_5, pmu8_7, pmu9_1, pmu9_2, pmu9_3,
	pmu9_19, pmu9_20, pmu12_5, pmu14, pmu16, uncore_8,
	0
};

static PMU_MSR_INFO_NODE *plat9_msr_list[] = {
	core_1, core_2, core_3, core_4, core_6, core_7, core_9, core_10, core_11, core_12,
	pmu1_1, pmu1_10, uncore_9, pmu7_4,
	pmu9_6, pmu9_7, pmu9_8, pmu9_11, pmu9_13, pmu9_15, pmu9_19,
	0
};

static PMU_MSR_INFO_NODE *plat10_msr_list[] = {
	core_1, core_2, core_3, core_4, core_6, core_7, core_9, core_10, core_11, core_12,
	pmu1_1, pmu1_10,
	pmu7_4,
	uncore_9,
	pmu9_6, pmu9_7, pmu9_8, pmu9_13, pmu9_19,
	0
};

static PMU_MSR_INFO_NODE *plat11_msr_list[] = {
	core_1,  core_2,   core_4, core_9, core_11, pmu2_8, pmu3_3, pmu4_7,
	pmu6_7, pmu8_7, pmu9_1, pmu9_2, pmu9_3, pmu9_19, pmu9_20, pmu12_5, pmu13,
	pmu14_3, pmu16_2, uncore_8, pmu5_msr_reg_list2,
	0
};

static PMU_MSR_INFO_NODE *plat12_msr_list[] = {
	core_1, core_2, core_3, core_4, core_6, core_7, core_9, core_10, core_11, core_12,
	core_13, uncore_9, pmu9_6, pmu9_7, pmu9_8, pmu9_11, pmu9_13, pmu9_15, pmu9_19,
	0
};

static PMU_MSR_INFO_NODE *plat13_msr_list[] = {
	core_1, core_2, core_3, core_4, core_6, core_7, core_9, core_10, core_11, core_12,
	core_13, pmu1_1, pmu2_5, pmu2_6, pmu3_2, pmu4_5, pmu6_5, pmu8_7, pmu9_1, pmu9_2, pmu9_3,
	pmu9_19, pmu9_20, pmu12_5, pmu14, pmu16, uncore_8,
	0
};

#endif

