/*******************************************************************************
* Copyright (C) 2023 Intel Corporation
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

//@HEADER
// ***************************************************
//
// HPCG: High Performance Conjugate Gradient Benchmark
//
// Contact:
// Michael A. Heroux ( maherou@sandia.gov)
// Jack Dongarra     (dongarra@eecs.utk.edu)
// Piotr Luszczek    (luszczek@eecs.utk.edu)
//
// ***************************************************
//@HEADER


#include "CustomKernels.hpp"

namespace custom {

    // implementation of extracting info about device from queue
    // to set the deviceInfo data to
    void deviceInfo::init(sycl::queue &queue)
    {
        sycl::device dev = queue.get_device();

        // info related to cache sizes
        this->device_global_mem_cache_line_size =
            std::max<int>(64, dev.get_info<sycl::info::device::global_mem_cache_line_size>());
        this->device_global_mem_cache_size =
            dev.get_info<sycl::info::device::global_mem_cache_size>();

        // info related to memory allocations and alignment
        this->device_alignment = std::max<std::uint32_t>(this->device_global_mem_cache_line_size,
                                                         dev.get_info<sycl::info::device::mem_base_addr_align>());
        this->device_max_mem_alloc_size = dev.get_info<sycl::info::device::max_mem_alloc_size>();

        // info about threads on device
        uint32_t eu_count = 512; // true for PVC
        if (dev.has(sycl::aspect::ext_intel_gpu_eu_count))
            eu_count = dev.get_info<sycl::ext::intel::info::device::gpu_eu_count>();

        uint32_t hw_thread_per_eu = 8; // true for PVC
        if (dev.has(sycl::aspect::ext_intel_gpu_hw_threads_per_eu)) {
              hw_thread_per_eu = dev.get_info<sycl::ext::intel::info::device::gpu_hw_threads_per_eu>();
        }

        this->device_num_threads = hw_thread_per_eu * eu_count;

//        std::cout << "Device Info Cached:" << std::endl;
//        std::cout << "\t cache_line_size (B)  = " << this->device_global_mem_cache_line_size << std::endl;
//        std::cout << "\t cache_size (B)       = " << this->device_global_mem_cache_size << std::endl;
//        std::cout << "\t mem alignment (B)    = " << this->device_alignment << std::endl;
//        std::cout << "\t max alloc size (B)   = " << this->device_max_mem_alloc_size << std::endl;
//        std::cout << "\t eu count             = " << eu_count << std::endl;
//        std::cout << "\t hw_thread_per_eu     = " << hw_thread_per_eu << std::endl;
//        std::cout << "\t num_threads          = " << this->device_num_threads << std::endl;

        // deviceInfo is now initialized
        this->isInitialized = true;
    }

} // namespace custom
