<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009-2025 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="msxsl"
                xmlns:int="http://www.w3.org/2001/XMLSchema#int"
                xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean"
                xmlns:exsl="http://exslt.org/common"
                exsl:keep_exsl_namespace=""
                syntax="norules">
  <xsl:output indent="yes" method="xml"/>
  <xsl:decimal-format name="double-en" decimal-separator="." grouping-separator=""/>
  <xsl:template match="/">
    <common>
      <finalization>
        <clearParameters/>
        <loadParameters id="load">
          <boolean:loadOption option="EnableTasksRegionsLoading">true</boolean:loadOption>
          <boolean:loadOption option="OptionMultipleFrameDomains">true</boolean:loadOption>
          <loadOption option="OptionCpuTableName">cpu_data</loadOption>
          <loadOption option="OptionTaskTableName">task_data</loadOption>
          <loadOption option="OptionThreadMarkerTableName">marker_thread_data</loadOption>
          <int:loadOption option="MaxOmpRegionBinNum">20</int:loadOption>
          <int:loadOption option="HugeResultThresholdMb">100</int:loadOption>
          <xsl:if test="exsl:ctx('modules', '') != ''">
            <loadOption option="OptionModulesWhiteList">
              <xsl:if test="exsl:ctx('modules_switch') = 'knob.modules_switch.exclude'">
                <xsl:attribute name="option">OptionModulesBlackList</xsl:attribute>
              </xsl:if>
              <xsl:value-of select="exsl:ctx('modules')"/>
            </loadOption>
          </xsl:if>
        </loadParameters>
        <transformParameters id="transform">
          <xsl:if test="exsl:ctx('cpu_profiling', 0)">
            <transformation name="Add Fake Loop Data" boolean:deferred="true"/>
            <transformation name="Resolving Trip Counts/FLOPs" boolean:deferred="true"/>
            <xsl:if test="exsl:ctx('static_instruction_mix', 'false') = 'true'">
              <transformation name="Resolving Instruction Mix for Call-Stack" boolean:deferred="true"/>
            </xsl:if>
            <transformation name="Function Call Count" boolean:deferred="true"/>
            <transformation name="Light Instruction Mix" boolean:deferred="true">
              <xsl:if test="exsl:ctx('static_instruction_mix', 'false') = 'true'">
                <xsl:attribute name="name">BB Instruction Mix</xsl:attribute>
              </xsl:if>
              <boolean:transformOption option="EnableSpillAnalysis"><xsl:value-of select="exsl:ctx('spillAnalysis', 'false')"/></boolean:transformOption>
            </transformation>
          </xsl:if>
          <xsl:if test="exsl:ctx('gpu_profiling', 0)">
            <transformation name="Fill Elapsed Time" boolean:deferred="true"/>
            <transformation name="Attribute compute data transfers" boolean:deferred="false"/>
            <transformation name="Compute Total GPU Elapsed Time" boolean:deferred="false"/>
            <transformation name="Configure GPU groupers" boolean:deferred="true"/>
          </xsl:if>
        </transformParameters>
        <precomputeParameters/>
        <resolveParameters id="resolve">
          <resolutionType name="bottom_user"/>
          <resolutionType name="function"/>
          <resolutionType name="source_line"/>
          <resolutionType name="sync_object_name"/>
          <resolutionType name="thread_name"/>
          <resolutionType name="basic_block"/>
          <resolutionType name="system"/>
          <resolutionType name="call_target"/>
          <resolutionType name="inline"/>
          <resolutionType name="loop"/>
          <resolutionType name="optreport"/>
          <resolutionType name="optreport_loops"/>
          <resolutionType name="unrolled_loops"/>
          <xsl:if test="exsl:ctx('support_multi_isa_binaries', 'false')">
            <resolutionType name="all_optreport_loops"/>
          </xsl:if>
          <resolutionType name="stack_variables"/>
        </resolveParameters>
        <checkpointParameters>
          <boolean:checkpointOption option="DiscardRawData">false</boolean:checkpointOption>
          <boolean:checkpointOption option="DiscardInstanceData">false</boolean:checkpointOption>
        </checkpointParameters>
      </finalization>
    </common>
  </xsl:template>
</xsl:stylesheet>
