from.messages import Messages as Msg
class BoundedByInfo:
 MEM_BW_ID='_BW'
 DEP_ID='Dependency'
 TRC_ID='Trip_Count'
 DECOMPOSITION_ID='Kernel_Decomposition'
 DATA_TRANSFER_ID='Data_Transfer'
 COMPUTE_ID='Compute'
 INVOKE_TAX_ID='Invoke_Tax'
 TRANSFER_TAX_ID='Transfer_Tax'
 LAUNCH_TAX_ID='Launch_Tax'
 GLOBAL_ATOMIC_ID='Global_Atomic'
 LATENCIES_ID='Latencies'
 class MSG:
  def __init__(self,id,msg,type,checker):
   self.id=id
   self.msg=msg
   self.type=type
   self.checker=checker if checker is not None else lambda x:x==id
 def __init__(self):
  self._messages=[]
  self.add_msg(self.MEM_BW_ID,Msg.BoundedBy.MEMORY_BW,'memory',lambda x:self.MEM_BW_ID in x)
  self.add_msg(self.DEP_ID,Msg.BoundedBy.DEPENDENCY)
  self.add_msg(self.TRC_ID,Msg.BoundedBy.TRIP_COUNT)
  self.add_msg(self.DATA_TRANSFER_ID,Msg.BoundedBy.DATA_TRANSFER)
  self.add_msg(self.COMPUTE_ID,Msg.BoundedBy.COMPUTE)
  self.add_msg(self.INVOKE_TAX_ID,Msg.BoundedBy.INVOKE_TAX)
  self.add_msg(self.TRANSFER_TAX_ID,Msg.BoundedBy.TRANSFER_TAX)
  self.add_msg(self.LAUNCH_TAX_ID,Msg.BoundedBy.LAUNCH_TAX)
  self.add_msg(self.GLOBAL_ATOMIC_ID,Msg.BoundedBy.GLOBAL_ATOMIC)
  self.add_msg(self.LATENCIES_ID,Msg.BoundedBy.LATENCIES)
 def add_msg(self,id,msg,type=None,checker=None):
  self._messages[:0]=[BoundedByInfo.MSG(id,msg,type,checker)]
 def get_msg(self,id):
  bounded_by=[m for m in self._messages if m.checker(id)==True]
  if len(bounded_by)==0:
   return id
  val=bounded_by[0]
  if val.type=='memory':
   mem_type=id[:-len(val.id)].replace('_',' ')
   return val.msg.format(mem_type)
  return val.msg
