'''
This module contains memory and compute models of accelerators.
Interface contains methods:
    [static methods]
        add_arguments(parser)
            Add arguments specific to accelerator to command line parser
        validate_args(parser, args)
            Validate command line arguments
        check_compatibility(current_arg, args, advisor_version)
            Check compatibility for command line arguments
    [regular methods]
        __init__(cmdline_args, config)
            Create object with command line arguments and configuration
        update_args(parsed_args, config)
            Update arguments based on config and model-specific conditions
        get_per_region_option(option, region_type)
            Return option based on region type if no global option was specified.
        description
            Property describing the specific implementation. Will be shown
            at beginning of analysis.
        is_cache_enabled
            Property that is True if cache is enabled
        offload_tax_struct
            Property containing information about offload tax components,
            the amount of which is the total tax for offloading the region
        get_non_used_columns()
            Returns list with names of columns that are unused by configuration
        mark_row_selected(row)
            Mark `row` as selected to analyze and extend resources
        is_row_selected(row)
            Returns True is row was previously selected
        get_unrolls(top_row, unroll_functions, with_dependency_constraint, nest_level)
            Returns arrays that contain information about area-constrained
            unroll of loops and functions
        does_this_fit(row, enforce_offloads, relaxed=False)
            Returns True if specific `row` fits accelerator
        get_times(row, unrolls_dict, MDT)
            Return times that row executed on CPU and on ACC
        create_offload(row, is_too_small, **kwargs)
            Creates offload object for Offload Head
        fill_area_requirements(row, requirements, fmt='{:.0f}')
            Insert area requirements of `row` to dictionary `requirements`
        fill_cache_simulation_data(row, out_row, total_time)
            Insert total cache model parameters to dictionary `out_row`
        get_mem_stats_if_nonempty(offload):
            Returns memory stats for row `offload` of empty dictionary if
            mem stats not available
        update_whole_app_metrics_by_row(app_row, out_row, offload, offload_data, config)
            Updates whole application metrics at `app_row` with offloaded row
            data placed in `out_row`, `offload`, `offload_data`.
            `config` is global config dict.
        get_unroll_based_metrics(row, unrolls_dict, offload_bound)
            Updates Offload Head or Node metrics
        get_scalers_info()
            Returns dictionary with scalers description
        get_potential_offload_metrics(row, unroll_functions)
            Returns dictionary with metrics for non-offloaded rows
        get_reason_loop_bounded_by(row, bounded_by, *args)
            Returns the reason the loop is bounded, represented as String
'''
