#
# Copyright (C) 2017 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#

import re

class AssemblyLine(object):
    def __init__(self, line):
        self.line = line

    def __iter__(self):
        return self

    def next(self):
        return next(self.line)

    __next__ = next

    def __getitem__(self, key):
        item = self.line[key]
        if key == 'operands':
            return self.parse_operands(item)
        if (key == 'instruction_address' or key == 'rva'):
            return hex(int(item))
        return item

    def __str__(self):
        return str(self.line)

    def __repr__(self):
        return repr(self.line)

    def __len__(self):
        return len(self.line)

    def parse_operands(self, data):
        MAX = 5 # quantity of captions that every assembler command operand has
        out = re.findall(r'<(.*?):(.*?)>', data)
        result = []
        if len(out) % MAX == 0:
            for i in range(0,len(out)//MAX):
                result.append(dict((x[0], (x[1])) for x in out[i*MAX:(i+1)*MAX]))
        return result


class AssemblyIterator(object):
    def __init__(self, it):
        self.__it = it

    def next(self):
        return AssemblyLine(next(self.__it))

    __next__ = next

    def __iter__(self):
        return self

