#
# Copyright (C) 2019 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to obtain information on heap-allocated objects.
# Collect tripcounts with the -enable-data-transfer-analysis option also provide
# the -track-heap-objects option.
#
# The information is only available for loops in the bottomup table.
#
# A memory object contains the following fields:
#
# - allocation_id:      Identifier associated with the allocation of the memory
#                       object.
# - size:               Size of the memory object in bytes.
# - address:            Virtual allocation address of the memory object.
# - allocation_type:    Type of memory allocation, at the moment only objects
#                       allocated on heap are tracked.
# - source_location:    Allocation source location file and line number.
# - transfer_direction: Data transfer direction (Device To Host, Host To Device,
#                       Shared, Private)
# ------------------------------------------------------------------------------

import sys

try:

    import advisor

except ImportError:

    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

# Check command-line arguments.
if len(sys.argv) < 2:
    print('Usage: "python {} path_to_project_dir"'.format(__file__))
    sys.exit(2)

# Open the Advisor Project and load the data.
project = advisor.open_project(sys.argv[1])
data = project.load(advisor.ALL)

# Iterate over entires in the bottomup table and print the memory objects.
for row in data.bottomup:
    print(row["function_call_sites_and_loops"])
    for memory_object in row.memory_objects:
        print(memory_object)
