# Copyright (C) 2023 Intel Corporation
# SPDX-License-Identifier: MIT

import time
from contextlib import contextmanager


class Timer:
    def __init__(self):
        self.__start = time.perf_counter()
        self.__elapsed = 0

    @property
    def start_time(self):
        return self.__start

    @property
    def elapsed_time(self):
        return self.__elapsed if self.__elapsed else time.perf_counter() - self.__start

    def stop(self):
        self.__elapsed = time.perf_counter() - self.__start

    def __str__(self):
        return f'{self.elapsed_time:.2f} seconds'


@contextmanager
def timer():
    t = Timer()
    try:
        yield t
    finally:
        t.stop()
