# Copyright (C) 2023 Intel Corporation
# SPDX-License-Identifier: MIT

from abc import ABC, abstractmethod
from typing import Optional

import pandas as pd

from mpp.core.views import ViewAttributes


class OutputWriter(ABC):
    """
    Output writer abstract base class (ABC)
    """

    @abstractmethod
    def write(self, title: str, content: pd.DataFrame, attributes: Optional[ViewAttributes] = None) -> None:
        """
        Write DataFrame content. Output type is determined by subclasses.

        :param title: the title/name of the content
        :param content: the content to write, as a Pandas DataFrame
        :param attributes: view attributes (optional)
        """
        pass

    @abstractmethod
    def close(self):
        """
        Finalize and close the output writer
        """
        pass
