<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl" xmlns:exsl="http://exslt.org/common" exsl:keep_exsl_namespace=""
  xmlns:int="http://www.w3.org/2001/XMLSchema#int"
  xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean"
  xmlns:str="http://exslt.org/strings"
  syntax="norules">
  <xsl:output indent="yes" method="xml"/>
  <xsl:variable name="pmuConditions" select="document('config://include/pmu_variables.xsl')"/>
  <xsl:variable name="isEcoreServerPMU" select="$pmuConditions//variables/isEcoreServerPMU"/>
  <xsl:variable name="is4thGenPcoreXeonOrLater" select="$pmuConditions//variables/is4thGenPcoreXeonOrLater"/>
  <xsl:template match="/">
    <common>
      <FpgaBlueStreamEvents>
        <xsl:text/>
      </FpgaBlueStreamEvents>
      <uncacheableReadsEventNameOnly>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'icelake_server' or $is4thGenPcoreXeonOrLater = 'true'">
            <xsl:text>MEM_LOAD_MISC_RETIRED.UC</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text></xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </uncacheableReadsEventNameOnly>
      <uncacheableReadsEvent>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'icelake_server' or $is4thGenPcoreXeonOrLater = 'true'">
            <xsl:text>MEM_LOAD_MISC_RETIRED.UC:sa=1009,</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text></xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </uncacheableReadsEvent>
      <xsl:variable name='defaultParts'>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'icelake_server' or $isEcoreServerPMU = 'true' or $is4thGenPcoreXeonOrLater = 'true'">
            <xsl:text>0;1;2;3;4;5;6;7</xsl:text>
          </xsl:when>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name='parts'>
        <xsl:choose>
          <xsl:when test="exsl:ctx('restrictPCIeBandwidthByClass', 'None') != 'None' and exsl:ctx('pciClassParts','') != ''">
            <xsl:for-each select="str:tokenize(exsl:ctx('pciClassParts',''), ';')">
              <xsl:variable name='className' select="substring-before(.,':')"/>
              <xsl:variable name='classParts' select="substring-after(.,':')"/>
              <xsl:if test="exsl:ctx('restrictPCIeBandwidthByClass', '') = $className">
                <xsl:value-of select="str:replace($classParts, ',', ';')"/>
              </xsl:if>
            </xsl:for-each>
          </xsl:when>
          <xsl:when test="exsl:is_experimental('all-io-events') or (exsl:ctx('populatedIoParts', '') = '')">
            <xsl:value-of select="$defaultParts"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="exsl:ctx('populatedIoParts')"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <PCIeBandwidthEventsSpecifics>
        <xsl:variable name='collectAdvancedIo' select="exsl:ctx('restrictPCIeBandwidthByClass', 'None') = 'None'"/>
        <xsl:variable name='tids'>
          <xsl:choose>
            <xsl:when test="exsl:is_experimental('all-io-events')">
              <xsl:value-of select="exsl:ctx('tidValuesForIO','')"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="exsl:ctx('populatedTidValuesForIO','')"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="exsl:ctx('targetOS') = 'QNX'">
            <xsl:text></xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'snowridge'">
            <xsl:choose>
              <xsl:when test="exsl:is_experimental('snr-pcie-over-cha')">
                <xsl:choose>
                  <xsl:when test="$tids != ''">
                    <xsl:for-each select="str:tokenize($tids, ';')">
                      <xsl:value-of select="concat('UNC_CHA_TOR_INSERTS.IO_MISS_ITOM:tid=', ., ',')"/>
                      <xsl:value-of select="concat('UNC_CHA_TOR_INSERTS.IO_MISS_ITOMCACHENEAR:tid=', ., ',')"/>
                      <xsl:value-of select="concat('UNC_CHA_TOR_INSERTS.IO_MISS_PCIRDCUR:tid=', ., ',')"/>
                      <xsl:value-of select="concat('UNC_CHA_TOR_INSERTS.IO_ITOM:tid=', ., ',')"/>
                      <xsl:value-of select="concat('UNC_CHA_TOR_INSERTS.IO_ITOMCACHENEAR:tid=', ., ',')"/>
                      <xsl:value-of select="concat('UNC_CHA_TOR_INSERTS.IO_PCIRDCUR:tid=', ., ',')"/>
                    </xsl:for-each>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text>UNC_CHA_TOR_INSERTS.IO_MISS_ITOM,UNC_CHA_TOR_INSERTS.IO_MISS_ITOMCACHENEAR,UNC_CHA_TOR_INSERTS.IO_MISS_PCIRDCUR,UNC_CHA_TOR_INSERTS.IO_ITOM,UNC_CHA_TOR_INSERTS.IO_ITOMCACHENEAR,UNC_CHA_TOR_INSERTS.IO_PCIRDCUR,</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <xsl:otherwise>
                <xsl:for-each select="str:tokenize($parts, ';')">
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_OF_CPU.MEM_READ.PART', ., ',')"/>
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_OF_CPU.MEM_WRITE.PART', ., ',')"/>
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_OF_CPU.CMPD.PART', ., ',')"/>
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_BY_CPU.MEM_WRITE.PART', ., ',')"/>
                </xsl:for-each>
                <xsl:choose>
                  <xsl:when test="$tids != ''">
                    <xsl:for-each select="str:tokenize($tids, ';')">
                      <xsl:value-of select="concat('UNC_CHA_TOR_INSERTS.IO_MISS_ITOM:tid=', ., ',')"/>
                      <xsl:value-of select="concat('UNC_CHA_TOR_INSERTS.IO_MISS_ITOMCACHENEAR:tid=', ., ',')"/>
                      <xsl:value-of select="concat('UNC_CHA_TOR_INSERTS.IO_MISS_PCIRDCUR:tid=', ., ',')"/>
                    </xsl:for-each>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text>UNC_CHA_TOR_INSERTS.IO_MISS_ITOM,UNC_CHA_TOR_INSERTS.IO_MISS_ITOMCACHENEAR,UNC_CHA_TOR_INSERTS.IO_MISS_PCIRDCUR,</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:text>UNC_I_COHERENT_OPS.PCITOM,UNC_I_FAF_INSERTS,UNC_I_CACHE_TOTAL_OCCUPANCY.MEM,UNC_I_FAF_OCCUPANCY,UNC_I_TRANSACTIONS.WR_PREF,UNC_I_MISC1.LOST_FWD,UNC_I_CLOCKTICKS,</xsl:text>
                <xsl:if test="exsl:ctx('isSEPDriverAvailable', 0)">
                  <xsl:for-each select="str:tokenize($parts, ';')">
                    <xsl:value-of select="concat('UNC_IIO_COMP_BUF_OCCUPANCY.CMPD.PART', ., ',')"/>
                    <xsl:value-of select="concat('UNC_IIO_COMP_BUF_INSERTS.CMPD.PART', ., ',')"/>
                  </xsl:for-each>
                </xsl:if>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'icelake_server' or ($isEcoreServerPMU = 'true' and exsl:ctx('PMU') != 'snowridge') or $is4thGenPcoreXeonOrLater = 'true'">
            <xsl:choose>
              <xsl:when test="exsl:ctx('PMU') = 'icelake_server' or exsl:ctx('PMU') = 'sapphirerapids_server' or exsl:ctx('PMU') = 'emeraldrapids_server'">
                <xsl:for-each select="str:tokenize($parts, ';')">
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_OF_CPU.MEM_READ.PART', ., ',')"/>
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_OF_CPU.MEM_WRITE.PART', ., ',')"/>
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_OF_CPU.CMPD.PART', ., ',')"/>
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_BY_CPU.MEM_WRITE.PART', ., ',')"/>
                </xsl:for-each>
              </xsl:when>
              <xsl:otherwise>
                <xsl:for-each select="str:tokenize($parts, ';')">
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_OF_CPU.MEM_READ.PART', ., ',')"/>
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_OF_CPU.MEM_WRITE.PART', ., ',')"/>
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_BY_CPU.MEM_READ.PART', ., ',')"/>
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_BY_CPU.MEM_WRITE.PART', ., ',')"/>
                </xsl:for-each>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="$collectAdvancedIo">
              <xsl:choose>
                <xsl:when test="$tids != ''">
                  <xsl:for-each select="str:tokenize($tids, ';')">
                    <xsl:value-of select="concat('UNC_CHA_TOR_INSERTS.IO_MISS_ITOM:tid=', ., ',')"/>
                    <xsl:value-of select="concat('UNC_CHA_TOR_INSERTS.IO_MISS_ITOMCACHENEAR:tid=', ., ',')"/>
                    <xsl:value-of select="concat('UNC_CHA_TOR_INSERTS.IO_MISS_PCIRDCUR:tid=', ., ',')"/>
                  </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text>UNC_CHA_TOR_INSERTS.IO_MISS_ITOM,UNC_CHA_TOR_INSERTS.IO_MISS_ITOMCACHENEAR,UNC_CHA_TOR_INSERTS.IO_MISS_PCIRDCUR,</xsl:text>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:if test="exsl:ctx('PMU') = 'icelake_server'">
                <xsl:text>UNC_I_COHERENT_OPS.PCITOM,</xsl:text>
              </xsl:if>
              <xsl:text>UNC_I_FAF_INSERTS,UNC_I_CACHE_TOTAL_OCCUPANCY.MEM,UNC_I_FAF_OCCUPANCY,UNC_I_TRANSACTIONS.WR_PREF,UNC_I_MISC1.LOST_FWD,UNC_I_CLOCKTICKS,</xsl:text>
              <xsl:if test="exsl:ctx('isSEPDriverAvailable', 0)">
                <xsl:for-each select="str:tokenize($parts, ';')">
                  <xsl:value-of select="concat('UNC_IIO_COMP_BUF_OCCUPANCY.CMPD.PART', ., ',')"/>
                  <xsl:value-of select="concat('UNC_IIO_COMP_BUF_INSERTS.CMPD.PART', ., ',')"/>
                </xsl:for-each>
              </xsl:if>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text></xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </PCIeBandwidthEventsSpecifics>
      <IommuEvents>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'snowridge' or exsl:ctx('PMU') = 'icelake_server'">
            <xsl:text>UNC_IIO_IOMMU0.FIRST_LOOKUPS,UNC_IIO_IOMMU0.CTXT_CACHE_LOOKUPS,UNC_IIO_PWT_OCCUPANCY,UNC_IIO_TXN_REQ_OF_CPU.MEM_READ.IOMMU1,</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'sapphirerapids_server' or exsl:ctx('PMU') = 'emeraldrapids_server'">
            <xsl:text>UNC_IIO_IOMMU0.FIRST_LOOKUPS,UNC_IIO_IOMMU0.4K_HITS,UNC_IIO_IOMMU0.2M_HITS,UNC_IIO_IOMMU0.1G_HITS,UNC_IIO_IOMMU0.CTXT_CACHE_LOOKUPS,UNC_IIO_PWT_OCCUPANCY,UNC_IIO_IOMMU3.PWT_OCCUPANCY_MSB,UNC_IIO_IOMMU1.NUM_MEM_ACCESSES,</xsl:text>
          </xsl:when>
          <xsl:when test="($isEcoreServerPMU = 'true' and exsl:ctx('PMU') != 'snowridge') or exsl:ctx('PMU') = 'graniterapids_server'">
            <xsl:text>UNC_IIO_IOMMU0.FIRST_LOOKUPS,UNC_IIO_IOMMU0.4K_HITS,UNC_IIO_IOMMU0.2M_HITS,UNC_IIO_IOMMU0.1G_HITS,UNC_IIO_IOMMU0.CTXT_CACHE_LOOKUPS,UNC_IIO_PWT_OCCUPANCY,UNC_IIO_IOMMU1.NUM_MEM_ACCESSES,</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text></xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </IommuEvents>
      <IioClockticksEvent>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'icelake_server' or $isEcoreServerPMU = 'true' or $is4thGenPcoreXeonOrLater = 'true'">
            <xsl:text>UNC_IIO_CLOCKTICKS,</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text></xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </IioClockticksEvent>
      <HBMEvents>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'sapphirerapids_server' or exsl:ctx('PMU') = 'emeraldrapids_server'">
            <xsl:text>UNC_MCHBM_CAS_COUNT.RD,UNC_MCHBM_CAS_COUNT.WR,UNC_CHA_CLOCKTICKS</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text></xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </HBMEvents>
      <P2PEvents>
        <xsl:choose>
          <xsl:when test="exsl:is_experimental('p2p-traffic')">
            <xsl:choose>
              <xsl:when test="exsl:ctx('PMU') = 'snowridge' or exsl:ctx('PMU') = 'icelake_server'">
                <xsl:text>UNC_I_P2P_TRANSACTIONS.RD,UNC_I_P2P_TRANSACTIONS.REM,UNC_I_P2P_TRANSACTIONS.WR,UNC_I_P2P_TRANSACTIONS.REM_AND_TGT_MATCH,UNC_I_P2P_TRANSACTIONS.MSG,UNC_I_P2P_TRANSACTIONS.LOC,UNC_I_P2P_TRANSACTIONS.CMPL,UNC_I_P2P_TRANSACTIONS.LOC_AND_TGT_MATCH,UNC_I_P2P_INSERTS,UNC_I_P2P_OCCUPANCY,</xsl:text>
                <xsl:for-each select="str:tokenize($parts, ';')">
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART', ., ',')"/>
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART', ., ',')"/>
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.PART', ., ',')"/>
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART', ., ',')"/>
                </xsl:for-each>
              </xsl:when>
              <xsl:when test="exsl:ctx('PMU') = 'sapphirerapids_server' or exsl:ctx('PMU') = 'emeraldrapids_server'">
                <xsl:for-each select="str:tokenize($parts, ';')">
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART', ., ',')"/>
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART', ., ',')"/>
                  <xsl:value-of select="concat('UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART', ., ',')"/>
                </xsl:for-each>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text></xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text></xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </P2PEvents>
      <CXLEvents>
        <xsl:text></xsl:text>
      </CXLEvents>
    </common>
  </xsl:template>
</xsl:stylesheet>
