<?xml version='1.0' encoding='utf-8'?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet exclude-result-prefixes="msxsl" syntax="norules" version="1.0" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:exsl="http://exslt.org/common" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output indent="yes" method="xml" />
    <xsl:template match="/">
        <bag>
            <vectorQuery id="GETopDown_socsmall" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery id="RetiredPipelineSlotsGroup">
                    <queryInherit>/RetiredPipelineSlots_socsmall</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="RetiredPipelineSlotsGroupExpanded">
                            <derivedQuery id="ArithGroup">
                                <queryInherit>/Arith_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="ArithGroupExpanded">
                                        <queryRef>/Non-Div_socsmall</queryRef>
                                        <queryRef>/FPDIV_socsmall</queryRef>
                                        <queryRef>/IDIV_socsmall</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="MemGroup">
                                <queryInherit>/Mem_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="MemGroupExpanded">
                                        <queryRef>/Loads_socsmall</queryRef>
                                        <queryRef>/Stores_socsmall</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="FrontendBoundPipelineSlotsGroup">
                    <queryInherit>/FrontendBoundPipelineSlots_socsmall</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="FrontendBoundPipelineSlotsGroupExpanded">
                            <derivedQuery id="IFetch_LatencyGroup">
                                <queryInherit>/IFetch_Latency_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="IFetch_LatencyGroupExpanded">
                                        <queryRef>/ICacheMisses_socsmall</queryRef>
                                        <queryRef>/ITLBOverhead_socsmall</queryRef>
                                        <queryRef>/BACLEARS_socsmall</queryRef>
                                        <queryRef>/BranchResteers_socsmall</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="IFetch_BandwidthGroup">
                                <queryInherit>/IFetch_Bandwidth_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="IFetch_BandwidthGroupExpanded">
                                        <queryRef>/FEBandwidthCisc_socsmall</queryRef>
                                        <queryRef>/FEBandwidthDecode_socsmall</queryRef>
                                        <queryRef>/PreDecodeWrong_socsmall</queryRef>
                                        <queryRef>/FEOther_socsmall</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="CancelledPipelineSlotsGroup">
                    <queryInherit>/CancelledPipelineSlots_socsmall</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="CancelledPipelineSlotsGroupExpanded">
                            <derivedQuery id="BranchMispredictGroup">
                                <queryInherit>/BranchMispredict_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="BranchMispredictGroupExpanded">
                                        <queryRef>/LSD_Mispredict_socsmall</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="MachineClearsGroup">
                                <queryInherit>/MachineClears_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="MachineClearsGroupExpanded">
                                        <queryRef>/Ucode_Assist_socsmall</queryRef>
                                        <queryRef>/Machine_Restart_socsmall</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="BackendBoundGroup">
                    <queryInherit>/BackendBound_socsmall</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="BackendBoundGroupExpanded">
                            <derivedQuery id="Mem_Sub_Sys_BoundGroup">
                                <queryInherit>/Mem_Sub_Sys_Bound_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="Mem_Sub_Sys_BoundGroupExpanded">
                                        <queryRef>/L2Bound_socsmall</queryRef>
                                        <derivedQuery id="L2MissGroup">
                                            <queryInherit>/L2Miss_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="L2MissGroupExpanded">
                                                    <derivedQuery id="L3BoundGroup">
                                                        <queryInherit>/L3Bound_socsmall</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="L3BoundGroupExpanded">
                                                                <queryRef>/L3_Hit_Bound_socsmall</queryRef>
                                                                <queryRef>/FWD_Bound_socsmall</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/MemBound_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="CoreBoundGroup">
                                <queryInherit>/CoreBound_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="CoreBoundGroupExpanded">
                                        <derivedQuery id="Serializing_OperationGroup">
                                            <queryInherit>/Serializing_Operation_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="Serializing_OperationGroupExpanded">
                                                    <queryRef>/Pause_socsmall</queryRef>
                                                    <queryRef>/Tpause_socsmall</queryRef>
                                                    <queryRef>/Fence_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/L1Bound_socsmall</queryRef>
                                        <queryRef>/RB_Bound_socsmall</queryRef>
                                        <queryRef>/StoresBound_socsmall</queryRef>
                                        <derivedQuery id="Execution_BoundGroup">
                                            <queryInherit>/Execution_Bound_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="Execution_BoundGroupExpanded">
                                                    <derivedQuery id="Floating_Point_BoundGroup">
                                                        <queryInherit>/Floating_Point_Bound_socsmall</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="Floating_Point_BoundGroupExpanded">
                                                                <queryRef>/FP_Port0_socsmall</queryRef>
                                                                <queryRef>/FP_Port1_socsmall</queryRef>
                                                                <queryRef>/FP_Port2_socsmall</queryRef>
                                                                <queryRef>/FP_Port3_socsmall</queryRef>
                                                                <queryRef>/FP_STD_socsmall</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <derivedQuery id="Integer_BoundGroup">
                                                        <queryInherit>/Integer_Bound_socsmall</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="Integer_BoundGroupExpanded">
                                                                <queryRef>/Int_Load_Port_socsmall</queryRef>
                                                                <queryRef>/Int_STA_Port_socsmall</queryRef>
                                                                <queryRef>/Int_STD_JMP_Port_socsmall</queryRef>
                                                                <queryRef>/Int_Port0_socsmall</queryRef>
                                                                <queryRef>/Int_Port1_socsmall</queryRef>
                                                                <queryRef>/Int_Port2_socsmall</queryRef>
                                                                <queryRef>/Int_Port3_socsmall</queryRef>
                                                                <queryRef>/Int_Secondary_Ports_socsmall</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="Allocation_BoundGroup">
                                            <queryInherit>/Allocation_Bound_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="Allocation_BoundGroupExpanded">
                                                    <queryRef>/BEAllocRestriction_socsmall</queryRef>
                                                    <queryRef>/LSD_Entry_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery displayName="%InfoMetrics" id="InfoMetricsGroup">
                    <description>%InfoMetricsDescriptionAll</description>
                    <valueEval>""</valueEval>
                    <displayAttributes>
                        <boolean:expand>true</boolean:expand>
                        <boolean:allowCollapse>false</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="InfoMetricsExpanded">
                            <queryRef>/StoresBound_Info_socsmall</queryRef>
                            <queryRef>/LoadBound_Info_socsmall</queryRef>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <queryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="RetiredPipelineSlots_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/TOPDOWN_RETIRING_ALIAS_socsmall") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/RetiredPipelineSlots_socsmall") >0.75 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Arith" id="Arith_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%ArithDescriptionAll</description>
                    <helpKeyword>configs.arith_arithdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/RetiredPipelineSlots_socsmall") - query("/Mem_socsmall") ) if ( query("/RetiredPipelineSlots_socsmall") - query("/Mem_socsmall") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Arith_socsmall") >0.60 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/RetiredPipelineSlots_socsmall") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.60 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_socsmall") - query("/Mem_socsmall") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Non-Div" id="Non-Div_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Non-DivDescriptionAll</description>
                    <helpKeyword>configs.non_div_non_divdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Arith_socsmall") - ( query("/FPDIV_socsmall") + query("/IDIV_socsmall") ) ) ]]></valueEval>
                    <issueText>%Non-DivIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Non-Div_socsmall") >0.60 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Arith_socsmall") >0.60 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/RetiredPipelineSlots_socsmall") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.60 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_socsmall") - query("/Mem_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.IDIV]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FPDIV" id="FPDIV_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FPDIVDescriptionAll</description>
                    <helpKeyword>configs.fpdiv_fpdivdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%FPDIVIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FPDIV_socsmall") >0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Arith_socsmall") >0.60 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/RetiredPipelineSlots_socsmall") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IDIV" id="IDIV_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%IDIVDescriptionAll</description>
                    <helpKeyword>configs.idiv_idivdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_RETIRED.IDIV]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%IDIVIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/IDIV_socsmall") >0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Arith_socsmall") >0.60 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/RetiredPipelineSlots_socsmall") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.IDIV]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem" id="Mem_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MemDescriptionAll</description>
                    <helpKeyword>configs.mem_memdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_UOPS_RETIRED.ALL]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%MemIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Mem_socsmall") >0.30 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/RetiredPipelineSlots_socsmall") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.30 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Loads" id="Loads_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%LoadsDescriptionAll</description>
                    <helpKeyword>configs.loads_loadsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_UOPS_RETIRED.ALL_LOADS]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%LoadsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Loads_socsmall") >0.30 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Mem_socsmall") >0.30 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/RetiredPipelineSlots_socsmall") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.30 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL_LOADS]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Stores" id="Stores_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%StoresDescriptionAll</description>
                    <helpKeyword>configs.stores_storesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_UOPS_RETIRED.ALL_STORES]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%StoresIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Stores_socsmall") >0.30 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Mem_socsmall") >0.30 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/RetiredPipelineSlots_socsmall") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.30 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL_STORES]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="FrontendBoundPipelineSlots_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/TOPDOWN_FE_ALIAS_socsmall") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IFetch_Latency" id="IFetch_Latency_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%IFetch_LatencyDescriptionAll</description>
                    <helpKeyword>configs.ifetch_latency_ifetch_latencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%IFetch_LatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/IFetch_Latency_socsmall") >0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="ICacheMisses_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ICACHE]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%ICacheMissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/ICacheMisses_socsmall") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/IFetch_Latency_socsmall") >0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ICACHE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="ITLBOverhead_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ITLB_MISS]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/ITLBOverhead_socsmall") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/IFetch_Latency_socsmall") >0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ITLB_MISS]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BACLEARS" id="BACLEARS_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BACLEARSDescriptionAll</description>
                    <helpKeyword>configs.baclears_baclearsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_DETECT]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%BACLEARSIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/BACLEARS_socsmall") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/IFetch_Latency_socsmall") >0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_DETECT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="BranchResteers_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_RESTEER]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/BranchResteers_socsmall") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/IFetch_Latency_socsmall") >0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_RESTEER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IFetch_Bandwidth" id="IFetch_Bandwidth_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%IFetch_BandwidthDescriptionAll</description>
                    <helpKeyword>configs.ifetch_bandwidth_ifetch_bandwidthdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/FrontendBoundPipelineSlots_socsmall") - query("/IFetch_Latency_socsmall") ) if ( query("/FrontendBoundPipelineSlots_socsmall") - query("/IFetch_Latency_socsmall") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%IFetch_BandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/IFetch_Bandwidth_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/FrontendBoundPipelineSlots_socsmall") - query("/IFetch_Latency_socsmall") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthCisc" id="FEBandwidthCisc_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthCiscDescriptionAll</description>
                    <helpKeyword>configs.febandwidthcisc_febandwidthciscdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.CISC]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%FEBandwidthCiscIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FEBandwidthCisc_socsmall") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/IFetch_Bandwidth_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.CISC]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDecode" id="FEBandwidthDecode_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthDecodeDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdecode_febandwidthdecodedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.DECODE]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%FEBandwidthDecodeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FEBandwidthDecode_socsmall") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/IFetch_Bandwidth_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.DECODE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%PreDecodeWrong" id="PreDecodeWrong_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%PreDecodeWrongDescriptionAll</description>
                    <helpKeyword>configs.predecodewrong_predecodewrongdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.PREDECODE]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%PreDecodeWrongIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/PreDecodeWrong_socsmall") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/IFetch_Bandwidth_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.PREDECODE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEOther" id="FEOther_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEOtherDescriptionAll</description>
                    <helpKeyword>configs.feother_feotherdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.OTHER]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%FEOtherIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FEOther_socsmall") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/IFetch_Bandwidth_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.OTHER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="CancelledPipelineSlots_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/TOPDOWN_BAD_SPECULATION_ALIAS_socsmall") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/CancelledPipelineSlots_socsmall") >0.15 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="BranchMispredict_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/BranchMispredict_socsmall") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/CancelledPipelineSlots_socsmall") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LSD_Mispredict" id="LSD_Mispredict_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%LSD_MispredictDescriptionAll</description>
                    <helpKeyword>configs.lsd_mispredict_lsd_mispredictdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.LSD_MISPREDICT]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%LSD_MispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/LSD_Mispredict_socsmall") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/BranchMispredict_socsmall") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/CancelledPipelineSlots_socsmall") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.LSD_MISPREDICT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClearsNuke" id="MachineClears_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MachineClearsNukeDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/CancelledPipelineSlots_socsmall") - query("/BranchMispredict_socsmall") ) if ( query("/CancelledPipelineSlots_socsmall") - query("/BranchMispredict_socsmall") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%MachineClearsNukeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MachineClears_socsmall") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/CancelledPipelineSlots_socsmall") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots_socsmall") - query("/BranchMispredict_socsmall") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Ucode_Assist" id="Ucode_Assist_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Ucode_AssistDescriptionAll</description>
                    <helpKeyword>configs.ucode_assist_ucode_assistdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%Ucode_AssistIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Ucode_Assist_socsmall") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MachineClears_socsmall") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/CancelledPipelineSlots_socsmall") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Machine_Restart" id="Machine_Restart_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Machine_RestartDescriptionAll</description>
                    <helpKeyword>configs.machine_restart_machine_restartdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.FASTNUKE]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%Machine_RestartIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Machine_Restart_socsmall") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MachineClears_socsmall") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/CancelledPipelineSlots_socsmall") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.FASTNUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="BackendBound_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/TOPDOWN_BE_BOUND_ALIAS_socsmall") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/BackendBound_socsmall") >0.10 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Sub_Sys_Bound" id="Mem_Sub_Sys_Bound_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Mem_Sub_Sys_BoundDescriptionAll</description>
                    <helpKeyword>configs.mem_sub_sys_bound_mem_sub_sys_bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") / query("/DerivedClockticks_socsmall") < query("/BackendBound_socsmall") ? query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") / query("/DerivedClockticks_socsmall") : query("/BackendBound_socsmall") ) ) ]]></valueEval>
                    <issueText>%Mem_Sub_Sys_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Mem_Sub_Sys_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="L2Bound_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_Sub_Sys_Bound_socsmall") * query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                    <issueText>%L2BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L2Bound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Mem_Sub_Sys_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Miss" id="L2Miss_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L2MissDescriptionAll</description>
                    <helpKeyword>configs.l2miss_l2missdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_Sub_Sys_Bound_socsmall") * query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_MISS]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                    <issueText>%L2MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L2Miss_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Mem_Sub_Sys_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_MISS]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="L3Bound_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/L3_Hit_Bound_socsmall") + query("/FWD_Bound_socsmall") ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L3Bound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/L2Miss_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Mem_Sub_Sys_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS_OTHERMOD]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L3_Hit_Bound" id="L3_Hit_Bound_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L3_Hit_BoundDescriptionAll</description>
                    <helpKeyword>configs.l3_hit_bound_l3_hit_bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_Sub_Sys_Bound_socsmall") * query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                    <issueText>%L3_Hit_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L3_Hit_Bound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/L3Bound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/L2Miss_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Mem_Sub_Sys_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FWD_Bound" id="FWD_Bound_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%FWD_BoundDescriptionAll</description>
                    <helpKeyword>configs.fwd_bound_fwd_bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_Sub_Sys_Bound_socsmall") * query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS_OTHERMOD]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                    <issueText>%FWD_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FWD_Bound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/L3Bound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/L2Miss_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Mem_Sub_Sys_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS_OTHERMOD]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="MemBound_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_Sub_Sys_Bound_socsmall") * ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[LPE-Core]") - query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS_OTHERMOD]/PMUCoreType[LPE-Core]") ) / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MemBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/L2Miss_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Mem_Sub_Sys_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS_OTHERMOD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="CoreBound_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) if ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="Serializing_Operation_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") < query("/CoreBound_socsmall") ? query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") : query("/CoreBound_socsmall") ) ) ]]></valueEval>
                    <issueText>%Serializing_OperationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Serializing_Operation_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Pause" id="Pause_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%PauseDescriptionAll</description>
                    <helpKeyword>configs.pause_pausedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Serializing_Operation_socsmall") * query("/PMUEventCount/PMUEventType[SERIALIZATION.NON_C01_MS_SCB]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                    <issueText>%PauseIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Pause_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Serializing_Operation_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[SERIALIZATION.NON_C01_MS_SCB]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Tpause" id="Tpause_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%TpauseDescriptionAll</description>
                    <helpKeyword>configs.tpause_tpausedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Serializing_Operation_socsmall") * query("/PMUEventCount/PMUEventType[SERIALIZATION.C01_MS_SCB]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                    <issueText>%TpauseIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Tpause_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Serializing_Operation_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[SERIALIZATION.C01_MS_SCB]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Fence" id="Fence_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FenceDescriptionAll</description>
                    <helpKeyword>configs.fence_fencedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Serializing_Operation_socsmall") * query("/PMUEventCount/PMUEventType[SERIALIZATION.IQ_JEU_SCB]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                    <issueText>%FenceIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Fence_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Serializing_Operation_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[SERIALIZATION.IQ_JEU_SCB]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="L1Bound_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Core_Bound_Nonexec_socsmall") * ( query("/PMUEventCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") * query("/Pipeline_Width_socsmall") / query("/Core_Bound_Nonexec_Slots_socsmall") ) ) ]]></valueEval>
                    <issueText>%L1BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L1Bound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") >= 10 )  ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%RB_Bound" id="RB_Bound_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%RB_BoundDescriptionAll</description>
                    <helpKeyword>configs.rb_bound_rb_bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Core_Bound_Nonexec_socsmall") * ( query("/PMUEventCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") * query("/Pipeline_Width_socsmall") / query("/Core_Bound_Nonexec_Slots_socsmall") ) ) ]]></valueEval>
                    <issueText>%RB_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/RB_Bound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") >= 10 )  ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="StoresBound_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Core_Bound_Nonexec_socsmall") * ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") * ( query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) / query("/Core_Bound_Nonexec_Slots_socsmall") ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/StoresBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Execution_Bound" id="Execution_Bound_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Execution_BoundDescriptionAll</description>
                    <helpKeyword>configs.execution_bound_execution_bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/CoreBound_socsmall") - query("/Serializing_Operation_socsmall") - query("/Core_Bound_Nonexec_socsmall") ) ]]></valueEval>
                    <issueText>%Execution_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Execution_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Floating_Point_Bound" id="Floating_Point_Bound_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Floating_Point_BoundDescriptionAll</description>
                    <helpKeyword>configs.floating_point_bound_floating_point_bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Execution_Bound_socsmall") * ( query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") / ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") + query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") ) ) ) ]]></valueEval>
                    <issueText>%Floating_Point_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Floating_Point_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Execution_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Port0" id="FP_Port0_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FP_Port0DescriptionAll</description>
                    <helpKeyword>configs.fp_port0_fp_port0descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Floating_Point_Bound_socsmall") * ( query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P0]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%FP_Port0IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Port0_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Floating_Point_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P0]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Port1" id="FP_Port1_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FP_Port1DescriptionAll</description>
                    <helpKeyword>configs.fp_port1_fp_port1descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Floating_Point_Bound_socsmall") * ( query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P1]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%FP_Port1IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Port1_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Floating_Point_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P1]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Port2" id="FP_Port2_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FP_Port2DescriptionAll</description>
                    <helpKeyword>configs.fp_port2_fp_port2descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Floating_Point_Bound_socsmall") * ( query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P2]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%FP_Port2IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Port2_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Floating_Point_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P2]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Port3" id="FP_Port3_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FP_Port3DescriptionAll</description>
                    <helpKeyword>configs.fp_port3_fp_port3descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Floating_Point_Bound_socsmall") * ( query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P3]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%FP_Port3IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Port3_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Floating_Point_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P3]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_STD" id="FP_STD_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FP_STDDescriptionAll</description>
                    <helpKeyword>configs.fp_std_fp_stddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Floating_Point_Bound_socsmall") * ( query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.STD]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%FP_STDIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_STD_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Floating_Point_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.STD]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Integer_Bound" id="Integer_Bound_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Integer_BoundDescriptionAll</description>
                    <helpKeyword>configs.integer_bound_integer_bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Execution_Bound_socsmall") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") / ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") + query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") ) ) ) ]]></valueEval>
                    <issueText>%Integer_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Integer_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Execution_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Load_Port" id="Int_Load_Port_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Int_Load_PortDescriptionAll</description>
                    <helpKeyword>configs.int_load_port_int_load_portdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Integer_Bound_socsmall") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.LD]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%Int_Load_PortIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Load_Port_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Integer_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.LD]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_STA_Port" id="Int_STA_Port_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Int_STA_PortDescriptionAll</description>
                    <helpKeyword>configs.int_sta_port_int_sta_portdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Integer_Bound_socsmall") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.STA]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%Int_STA_PortIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_STA_Port_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Integer_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.STA]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_STD_JMP_Port" id="Int_STD_JMP_Port_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Int_STD_JMP_PortDescriptionAll</description>
                    <helpKeyword>configs.int_std_jmp_port_int_std_jmp_portdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Integer_Bound_socsmall") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.STD_JMP]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%Int_STD_JMP_PortIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_STD_JMP_Port_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Integer_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.STD_JMP]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Port0" id="Int_Port0_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Int_Port0DescriptionAll</description>
                    <helpKeyword>configs.int_port0_int_port0descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Integer_Bound_socsmall") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.P0]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%Int_Port0IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Port0_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Integer_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.P0]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Port1" id="Int_Port1_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Int_Port1DescriptionAll</description>
                    <helpKeyword>configs.int_port1_int_port1descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Integer_Bound_socsmall") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.P1]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%Int_Port1IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Port1_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Integer_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.P1]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Port2" id="Int_Port2_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Int_Port2DescriptionAll</description>
                    <helpKeyword>configs.int_port2_int_port2descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Integer_Bound_socsmall") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.P2]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%Int_Port2IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Port2_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Integer_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.P2]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Port3" id="Int_Port3_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Int_Port3DescriptionAll</description>
                    <helpKeyword>configs.int_port3_int_port3descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Integer_Bound_socsmall") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.P3]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%Int_Port3IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Port3_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Integer_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.P3]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Secondary_Ports" id="Int_Secondary_Ports_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Int_Secondary_PortsDescriptionAll</description>
                    <helpKeyword>configs.int_secondary_ports_int_secondary_portsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Integer_Bound_socsmall") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.2ND]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%Int_Secondary_PortsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Secondary_Ports_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Integer_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_socsmall") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.2ND]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Allocation_Bound" id="Allocation_Bound_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Allocation_BoundDescriptionAll</description>
                    <helpKeyword>configs.allocation_bound_allocation_bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Core_Bound_Nonexec_socsmall") * ( ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") + query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) / query("/Core_Bound_Nonexec_Slots_socsmall") ) ) ]]></valueEval>
                    <issueText>%Allocation_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Allocation_Bound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BEAllocRestriction" id="BEAllocRestriction_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BEAllocRestrictionDescriptionAll</description>
                    <helpKeyword>configs.beallocrestriction_beallocrestrictiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Core_Bound_Nonexec_socsmall") * ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") / query("/Core_Bound_Nonexec_Slots_socsmall") ) ) ]]></valueEval>
                    <issueText>%BEAllocRestrictionIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/BEAllocRestriction_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Allocation_Bound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LSD_Entry" id="LSD_Entry_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%LSD_EntryDescriptionAll</description>
                    <helpKeyword>configs.lsd_entry_lsd_entrydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Core_Bound_Nonexec_socsmall") * ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") / query("/Core_Bound_Nonexec_Slots_socsmall") ) ) ]]></valueEval>
                    <issueText>%LSD_EntryIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/LSD_Entry_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Allocation_Bound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_socsmall") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%SLOTS" id="SLOTS_socsmall">
                    <description>%SLOTSDescriptionAll</description>
                    <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Pipeline_Width_socsmall") * query("/DerivedClockticks_socsmall") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Instructions" id="Instructions_socsmall">
                    <description>%InstructionsDescriptionAll</description>
                    <helpKeyword>configs.instructions_instructionsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/DerivedInstructionsRetired_socsmall") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.ANY]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FLOPc" id="FLOPc_socsmall">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%FLOPcDescriptionAll</description>
                    <helpKeyword>configs.flopc_flopcdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FLOP_Count_socsmall") / query("/DerivedClockticks_socsmall") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[FP_FLOPS_RETIRED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IpFLOP" id="IpFLOP_socsmall">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%IpFLOPDescriptionAll</description>
                    <helpKeyword>configs.ipflop_ipflopdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Instructions_socsmall") / query("/FLOP_Count_socsmall") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.ANY]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_FLOPS_RETIRED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IpArith" id="IpArith_socsmall">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%IpArithDescriptionAll</description>
                    <helpKeyword>configs.iparith_iparithdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Instructions_socsmall") / query("/PMUEventCount/PMUEventType[FP_INST_RETIRED.ALL]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.ANY]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_INST_RETIRED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IpArith_Scalar_SP" id="IpArith_Scalar_SP_socsmall">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%IpArith_Scalar_SPDescriptionAll</description>
                    <helpKeyword>configs.iparith_scalar_sp_iparith_scalar_spdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Instructions_socsmall") / query("/PMUEventCount/PMUEventType[FP_INST_RETIRED.32B_SP]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.ANY]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_INST_RETIRED.32B_SP]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IpArith_Scalar_DP" id="IpArith_Scalar_DP_socsmall">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%IpArith_Scalar_DPDescriptionAll</description>
                    <helpKeyword>configs.iparith_scalar_dp_iparith_scalar_dpdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Instructions_socsmall") / query("/PMUEventCount/PMUEventType[FP_INST_RETIRED.64B_DP]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.ANY]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_INST_RETIRED.64B_DP]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IpArith_AVX128" id="IpArith_AVX128_socsmall">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%IpArith_AVX128DescriptionAll</description>
                    <helpKeyword>configs.iparith_avx128_iparith_avx128descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Instructions_socsmall") / ( query("/PMUEventCount/PMUEventType[FP_INST_RETIRED.128B_DP]/PMUCoreType[LPE-Core]") + query("/PMUEventCount/PMUEventType[FP_INST_RETIRED.128B_SP]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.ANY]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[FP_INST_RETIRED.128B_DP]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_INST_RETIRED.128B_SP]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IpArith_AVX256" id="IpArith_AVX256_socsmall">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%IpArith_AVX256DescriptionAll</description>
                    <helpKeyword>configs.iparith_avx256_iparith_avx256descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Instructions_socsmall") / ( query("/PMUEventCount/PMUEventType[FP_INST_RETIRED.256B_DP]/PMUCoreType[LPE-Core]") + query("/PMUEventCount/PMUEventType[FP_INST_RETIRED.256B_SP]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.ANY]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[FP_INST_RETIRED.256B_DP]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_INST_RETIRED.256B_SP]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="StoresBound_Info_socsmall">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%StoresBound_InfoDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) * ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LoadBound" id="LoadBound_Info_socsmall">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%LoadBound_InfoDescriptionAll</description>
                    <helpKeyword>configs.loadbound_loadbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") + query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) / query("/DerivedClockticks_socsmall") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%GFLOPs" id="GFLOPs_socsmall">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%GFLOPsDescriptionAll</description>
                    <helpKeyword>configs.gflops_gflopsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FLOP_Count_socsmall") / ( query("/Time_socsmall") * 1000000000 ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[FP_FLOPS_RETIRED.ALL]/PMUCoreType[LPE-Core]") >= 10 )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Time" id="Time_socsmall">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%TimeDescriptionAll</description>
                    <helpKeyword>configs.time_timedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/DurationTimeInMilliSeconds_socsmall") / 1000 ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  1000 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Pipeline_Width" id="Pipeline_Width_socsmall">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Pipeline_WidthDescriptionAll</description>
                    <helpKeyword>configs.pipeline_width_pipeline_widthdescriptionall</helpKeyword>
                    <valueEval>8</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%DurationTimeInMilliSeconds" id="DurationTimeInMilliSeconds_socsmall">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%DurationTimeInMilliSecondsDescriptionAll</description>
                    <helpKeyword>configs.durationtimeinmilliseconds_durationtimeinmillisecondsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( (query("/GlobalElapsedTimeQueryAll") * 1000) ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%FLOP_Count" id="FLOP_Count_socsmall">
                    <description>%FLOP_CountDescriptionAll</description>
                    <helpKeyword>configs.flop_count_flop_countdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[FP_FLOPS_RETIRED.ALL]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[FP_FLOPS_RETIRED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Core_Bound_Nonexec" id="Core_Bound_Nonexec_socsmall">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Core_Bound_NonexecDescriptionAll</description>
                    <helpKeyword>configs.core_bound_nonexec_core_bound_nonexecdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/CoreBound_socsmall") - query("/Serializing_Operation_socsmall") < query("/Core_Bound_Nonexec_Slots_socsmall") / query("/SLOTS_socsmall") ? query("/CoreBound_socsmall") - query("/Serializing_Operation_socsmall") : query("/Core_Bound_Nonexec_Slots_socsmall") / query("/SLOTS_socsmall") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Core_Bound_Nonexec_Slots" id="Core_Bound_Nonexec_Slots_socsmall">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Core_Bound_Nonexec_SlotsDescriptionAll</description>
                    <helpKeyword>configs.core_bound_nonexec_slots_core_bound_nonexec_slotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") + query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") + ( ( query("/PMUEventCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") + query("/PMUEventCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) * query("/Pipeline_Width_socsmall") ) + ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") * ( query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%TOPDOWN_FE_ALIAS" id="TOPDOWN_FE_ALIAS_socsmall">
                    <description>%TOPDOWN_FE_ALIASDescriptionAll</description>
                    <helpKeyword>configs.topdown_fe_alias_topdown_fe_aliasdescriptionall</helpKeyword>
                    <xsl:choose>
                        <xsl:when test="$isFixedTMASupported">
                            <valueEval>
                                <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                        </xsl:when>
                        <xsl:otherwise>
                            <valueEval>
                                <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                        </xsl:otherwise>
                    </xsl:choose>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%TOPDOWN_BAD_SPECULATION_ALIAS" id="TOPDOWN_BAD_SPECULATION_ALIAS_socsmall">
                    <description>%TOPDOWN_BAD_SPECULATION_ALIASDescriptionAll</description>
                    <helpKeyword>configs.topdown_bad_speculation_alias_topdown_bad_speculation_aliasdescriptionall</helpKeyword>
                    <xsl:choose>
                        <xsl:when test="$isFixedTMASupported">
                            <valueEval>
                                <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                        </xsl:when>
                        <xsl:otherwise>
                            <valueEval>
                                <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL_P]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                        </xsl:otherwise>
                    </xsl:choose>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%TOPDOWN_BE_BOUND_ALIAS" id="TOPDOWN_BE_BOUND_ALIAS_socsmall">
                    <description>%TOPDOWN_BE_BOUND_ALIASDescriptionAll</description>
                    <helpKeyword>configs.topdown_be_bound_alias_topdown_be_bound_aliasdescriptionall</helpKeyword>
                    <xsl:choose>
                        <xsl:when test="$isFixedTMASupported">
                            <valueEval>
                                <![CDATA[ ( query("/SLOTS_socsmall") - ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") + query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") + query("/PMUEventCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                        </xsl:when>
                        <xsl:otherwise>
                            <valueEval>
                                <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                        </xsl:otherwise>
                    </xsl:choose>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%TOPDOWN_RETIRING_ALIAS" id="TOPDOWN_RETIRING_ALIAS_socsmall">
                    <description>%TOPDOWN_RETIRING_ALIASDescriptionAll</description>
                    <helpKeyword>configs.topdown_retiring_alias_topdown_retiring_aliasdescriptionall</helpKeyword>
                    <xsl:choose>
                        <xsl:when test="$isFixedTMASupported">
                            <valueEval>
                                <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                        </xsl:when>
                        <xsl:otherwise>
                            <valueEval>
                                <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_RETIRING.ALL_P]/PMUCoreType[LPE-Core]") ) ]]></valueEval>
                        </xsl:otherwise>
                    </xsl:choose>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
            </queryLibrary>
            <vectorQuery id="locatorGETopDown_socsmall" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery displayName="Locators" id="LocatorsGridSection">
                    <valueEval>0</valueEval>
                    <valueType>double</valueType>
                    <displayAttributes>
                        <boolean:expand>true</boolean:expand>
                        <boolean:allowCollapse>false</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="LocatorsGridGroup">
                            <derivedQuery id="locatorRetiredPipelineSlotsGroup">
                                <queryInherit>/locatorRetiredPipelineSlots_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorRetiredPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorArithGroup">
                                            <queryInherit>/locatorArith_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorArithGroupExpanded">
                                                    <queryRef>/locatorNon-Div_socsmall</queryRef>
                                                    <queryRef>/locatorFPDIV_socsmall</queryRef>
                                                    <queryRef>/locatorIDIV_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorMemGroup">
                                            <queryInherit>/locatorMem_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMemGroupExpanded">
                                                    <queryRef>/locatorLoads_socsmall</queryRef>
                                                    <queryRef>/locatorStores_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorFrontendBoundPipelineSlotsGroup">
                                <queryInherit>/locatorFrontendBoundPipelineSlots_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorFrontendBoundPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorIFetch_LatencyGroup">
                                            <queryInherit>/locatorIFetch_Latency_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorIFetch_LatencyGroupExpanded">
                                                    <queryRef>/locatorICacheMisses_socsmall</queryRef>
                                                    <queryRef>/locatorITLBOverhead_socsmall</queryRef>
                                                    <queryRef>/locatorBACLEARS_socsmall</queryRef>
                                                    <queryRef>/locatorBranchResteers_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorIFetch_BandwidthGroup">
                                            <queryInherit>/locatorIFetch_Bandwidth_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorIFetch_BandwidthGroupExpanded">
                                                    <queryRef>/locatorFEBandwidthCisc_socsmall</queryRef>
                                                    <queryRef>/locatorFEBandwidthDecode_socsmall</queryRef>
                                                    <queryRef>/locatorPreDecodeWrong_socsmall</queryRef>
                                                    <queryRef>/locatorFEOther_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorCancelledPipelineSlotsGroup">
                                <queryInherit>/locatorCancelledPipelineSlots_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorCancelledPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorBranchMispredictGroup">
                                            <queryInherit>/locatorBranchMispredict_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorBranchMispredictGroupExpanded">
                                                    <queryRef>/locatorLSD_Mispredict_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorMachineClearsGroup">
                                            <queryInherit>/locatorMachineClears_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMachineClearsGroupExpanded">
                                                    <queryRef>/locatorUcode_Assist_socsmall</queryRef>
                                                    <queryRef>/locatorMachine_Restart_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorBackendBoundGroup">
                                <queryInherit>/locatorBackendBound_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorBackendBoundGroupExpanded">
                                        <derivedQuery id="locatorMem_Sub_Sys_BoundGroup">
                                            <queryInherit>/locatorMem_Sub_Sys_Bound_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMem_Sub_Sys_BoundGroupExpanded">
                                                    <queryRef>/locatorL2Bound_socsmall</queryRef>
                                                    <derivedQuery id="locatorL2MissGroup">
                                                        <queryInherit>/locatorL2Miss_socsmall</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorL2MissGroupExpanded">
                                                                <derivedQuery id="locatorL3BoundGroup">
                                                                    <queryInherit>/locatorL3Bound_socsmall</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorL3BoundGroupExpanded">
                                                                            <queryRef>/locatorL3_Hit_Bound_socsmall</queryRef>
                                                                            <queryRef>/locatorFWD_Bound_socsmall</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <queryRef>/locatorMemBound_socsmall</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorCoreBoundGroup">
                                            <queryInherit>/locatorCoreBound_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorCoreBoundGroupExpanded">
                                                    <derivedQuery id="locatorSerializing_OperationGroup">
                                                        <queryInherit>/locatorSerializing_Operation_socsmall</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorSerializing_OperationGroupExpanded">
                                                                <queryRef>/locatorPause_socsmall</queryRef>
                                                                <queryRef>/locatorTpause_socsmall</queryRef>
                                                                <queryRef>/locatorFence_socsmall</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorL1Bound_socsmall</queryRef>
                                                    <queryRef>/locatorRB_Bound_socsmall</queryRef>
                                                    <queryRef>/locatorStoresBound_socsmall</queryRef>
                                                    <derivedQuery id="locatorExecution_BoundGroup">
                                                        <queryInherit>/locatorExecution_Bound_socsmall</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorExecution_BoundGroupExpanded">
                                                                <derivedQuery id="locatorFloating_Point_BoundGroup">
                                                                    <queryInherit>/locatorFloating_Point_Bound_socsmall</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorFloating_Point_BoundGroupExpanded">
                                                                            <queryRef>/locatorFP_Port0_socsmall</queryRef>
                                                                            <queryRef>/locatorFP_Port1_socsmall</queryRef>
                                                                            <queryRef>/locatorFP_Port2_socsmall</queryRef>
                                                                            <queryRef>/locatorFP_Port3_socsmall</queryRef>
                                                                            <queryRef>/locatorFP_STD_socsmall</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <derivedQuery id="locatorInteger_BoundGroup">
                                                                    <queryInherit>/locatorInteger_Bound_socsmall</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorInteger_BoundGroupExpanded">
                                                                            <queryRef>/locatorInt_Load_Port_socsmall</queryRef>
                                                                            <queryRef>/locatorInt_STA_Port_socsmall</queryRef>
                                                                            <queryRef>/locatorInt_STD_JMP_Port_socsmall</queryRef>
                                                                            <queryRef>/locatorInt_Port0_socsmall</queryRef>
                                                                            <queryRef>/locatorInt_Port1_socsmall</queryRef>
                                                                            <queryRef>/locatorInt_Port2_socsmall</queryRef>
                                                                            <queryRef>/locatorInt_Port3_socsmall</queryRef>
                                                                            <queryRef>/locatorInt_Secondary_Ports_socsmall</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <derivedQuery id="locatorAllocation_BoundGroup">
                                                        <queryInherit>/locatorAllocation_Bound_socsmall</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorAllocation_BoundGroupExpanded">
                                                                <queryRef>/locatorBEAllocRestriction_socsmall</queryRef>
                                                                <queryRef>/locatorLSD_Entry_socsmall</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <locatorqueryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="locatorRetiredPipelineSlots_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/RetiredPipelineSlots_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorRetiredPipelineSlots") >0.75 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Arith" id="locatorArith_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ArithDescriptionAll</description>
                    <helpKeyword>configs.arith_arithdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_socsmall") - query("/Mem_socsmall") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Arith_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorArith") >0.60 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Non-Div" id="locatorNon-Div_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Non-DivDescriptionAll</description>
                    <helpKeyword>configs.non_div_non_divdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_socsmall") - query("/Mem_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.IDIV]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Non-Div_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%Non-DivIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorNon-Div") >0.60 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FPDIV" id="locatorFPDIV_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FPDIVDescriptionAll</description>
                    <helpKeyword>configs.fpdiv_fpdivdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FPDIV_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FPDIVIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFPDIV") >0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%IDIV" id="locatorIDIV_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%IDIVDescriptionAll</description>
                    <helpKeyword>configs.idiv_idivdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.IDIV]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/IDIV_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%IDIVIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorIDIV") >0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem" id="locatorMem_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MemDescriptionAll</description>
                    <helpKeyword>configs.mem_memdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Mem_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%MemIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMem") >0.30 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Loads" id="locatorLoads_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LoadsDescriptionAll</description>
                    <helpKeyword>configs.loads_loadsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL_LOADS]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Loads_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%LoadsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoads") >0.30 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Stores" id="locatorStores_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%StoresDescriptionAll</description>
                    <helpKeyword>configs.stores_storesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL_STORES]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Stores_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%StoresIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStores") >0.30 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="locatorFrontendBoundPipelineSlots_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FrontendBoundPipelineSlots_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFrontendBoundPipelineSlots") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%IFetch_Latency" id="locatorIFetch_Latency_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%IFetch_LatencyDescriptionAll</description>
                    <helpKeyword>configs.ifetch_latency_ifetch_latencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/IFetch_Latency_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%IFetch_LatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorIFetch_Latency") >0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="locatorICacheMisses_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ICACHE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/ICacheMisses_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%ICacheMissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorICacheMisses") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="locatorITLBOverhead_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ITLB_MISS]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/ITLBOverhead_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorITLBOverhead") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BACLEARS" id="locatorBACLEARS_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BACLEARSDescriptionAll</description>
                    <helpKeyword>configs.baclears_baclearsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_DETECT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BACLEARS_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%BACLEARSIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBACLEARS") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="locatorBranchResteers_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_RESTEER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BranchResteers_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchResteers") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%IFetch_Bandwidth" id="locatorIFetch_Bandwidth_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%IFetch_BandwidthDescriptionAll</description>
                    <helpKeyword>configs.ifetch_bandwidth_ifetch_bandwidthdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/FrontendBoundPipelineSlots_socsmall") - query("/IFetch_Latency_socsmall") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/IFetch_Bandwidth_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%IFetch_BandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorIFetch_Bandwidth") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthCisc" id="locatorFEBandwidthCisc_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthCiscDescriptionAll</description>
                    <helpKeyword>configs.febandwidthcisc_febandwidthciscdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.CISC]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidthCisc_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthCiscIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthCisc") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDecode" id="locatorFEBandwidthDecode_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthDecodeDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdecode_febandwidthdecodedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.DECODE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidthDecode_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthDecodeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthDecode") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%PreDecodeWrong" id="locatorPreDecodeWrong_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%PreDecodeWrongDescriptionAll</description>
                    <helpKeyword>configs.predecodewrong_predecodewrongdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.PREDECODE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PreDecodeWrong_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%PreDecodeWrongIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPreDecodeWrong") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEOther" id="locatorFEOther_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEOtherDescriptionAll</description>
                    <helpKeyword>configs.feother_feotherdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.OTHER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEOther_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FEOtherIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEOther") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="locatorCancelledPipelineSlots_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/CancelledPipelineSlots_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCancelledPipelineSlots") >0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="locatorBranchMispredict_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BranchMispredict_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchMispredict") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LSD_Mispredict" id="locatorLSD_Mispredict_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LSD_MispredictDescriptionAll</description>
                    <helpKeyword>configs.lsd_mispredict_lsd_mispredictdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.LSD_MISPREDICT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/LSD_Mispredict_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%LSD_MispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLSD_Mispredict") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClearsNuke" id="locatorMachineClears_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MachineClearsNukeDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots_socsmall") - query("/BranchMispredict_socsmall") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MachineClears_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%MachineClearsNukeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMachineClears") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Ucode_Assist" id="locatorUcode_Assist_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Ucode_AssistDescriptionAll</description>
                    <helpKeyword>configs.ucode_assist_ucode_assistdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Ucode_Assist_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%Ucode_AssistIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorUcode_Assist") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Machine_Restart" id="locatorMachine_Restart_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Machine_RestartDescriptionAll</description>
                    <helpKeyword>configs.machine_restart_machine_restartdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.FASTNUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Machine_Restart_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%Machine_RestartIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMachine_Restart") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="locatorBackendBound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BackendBound_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBackendBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Sub_Sys_Bound" id="locatorMem_Sub_Sys_Bound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mem_Sub_Sys_BoundDescriptionAll</description>
                    <helpKeyword>configs.mem_sub_sys_bound_mem_sub_sys_bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Mem_Sub_Sys_Bound_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%Mem_Sub_Sys_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMem_Sub_Sys_Bound") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="locatorL2Bound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L2Bound_socsmall") ) ]]></valueEval>
                    <issueText>%L2BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL2Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Miss" id="locatorL2Miss_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L2MissDescriptionAll</description>
                    <helpKeyword>configs.l2miss_l2missdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_MISS]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L2Miss_socsmall") ) ]]></valueEval>
                    <issueText>%L2MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL2Miss") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="locatorL3Bound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS_OTHERMOD]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L3Bound_socsmall") ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL3Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L3_Hit_Bound" id="locatorL3_Hit_Bound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L3_Hit_BoundDescriptionAll</description>
                    <helpKeyword>configs.l3_hit_bound_l3_hit_bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L3_Hit_Bound_socsmall") ) ]]></valueEval>
                    <issueText>%L3_Hit_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL3_Hit_Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FWD_Bound" id="locatorFWD_Bound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FWD_BoundDescriptionAll</description>
                    <helpKeyword>configs.fwd_bound_fwd_bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS_OTHERMOD]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/FWD_Bound_socsmall") ) ]]></valueEval>
                    <issueText>%FWD_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFWD_Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="locatorMemBound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS_OTHERMOD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/MemBound_socsmall") ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMemBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="locatorCoreBound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/CoreBound_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCoreBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="locatorSerializing_Operation_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Serializing_Operation_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%Serializing_OperationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSerializing_Operation") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Pause" id="locatorPause_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%PauseDescriptionAll</description>
                    <helpKeyword>configs.pause_pausedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[SERIALIZATION.NON_C01_MS_SCB]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Pause_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%PauseIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPause") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Tpause" id="locatorTpause_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%TpauseDescriptionAll</description>
                    <helpKeyword>configs.tpause_tpausedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[SERIALIZATION.C01_MS_SCB]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Tpause_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%TpauseIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorTpause") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Fence" id="locatorFence_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FenceDescriptionAll</description>
                    <helpKeyword>configs.fence_fencedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[SERIALIZATION.IQ_JEU_SCB]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Fence_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FenceIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFence") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="locatorL1Bound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") >= 10 )  ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L1Bound_socsmall") ) ]]></valueEval>
                    <issueText>%L1BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL1Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%RB_Bound" id="locatorRB_Bound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RB_BoundDescriptionAll</description>
                    <helpKeyword>configs.rb_bound_rb_bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") >= 10 )  ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/RB_Bound_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%RB_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorRB_Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="locatorStoresBound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/StoresBound_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStoresBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Execution_Bound" id="locatorExecution_Bound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Execution_BoundDescriptionAll</description>
                    <helpKeyword>configs.execution_bound_execution_bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Execution_Bound_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%Execution_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorExecution_Bound") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Floating_Point_Bound" id="locatorFloating_Point_Bound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Floating_Point_BoundDescriptionAll</description>
                    <helpKeyword>configs.floating_point_bound_floating_point_bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Floating_Point_Bound_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%Floating_Point_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFloating_Point_Bound") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Port0" id="locatorFP_Port0_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_Port0DescriptionAll</description>
                    <helpKeyword>configs.fp_port0_fp_port0descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P0]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Port0_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FP_Port0IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Port0") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Port1" id="locatorFP_Port1_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_Port1DescriptionAll</description>
                    <helpKeyword>configs.fp_port1_fp_port1descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P1]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Port1_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FP_Port1IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Port1") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Port2" id="locatorFP_Port2_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_Port2DescriptionAll</description>
                    <helpKeyword>configs.fp_port2_fp_port2descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P2]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Port2_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FP_Port2IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Port2") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Port3" id="locatorFP_Port3_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_Port3DescriptionAll</description>
                    <helpKeyword>configs.fp_port3_fp_port3descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P3]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Port3_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FP_Port3IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Port3") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_STD" id="locatorFP_STD_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_STDDescriptionAll</description>
                    <helpKeyword>configs.fp_std_fp_stddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.STD]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_STD_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FP_STDIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_STD") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Integer_Bound" id="locatorInteger_Bound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Integer_BoundDescriptionAll</description>
                    <helpKeyword>configs.integer_bound_integer_bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Integer_Bound_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%Integer_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorInteger_Bound") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Load_Port" id="locatorInt_Load_Port_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Int_Load_PortDescriptionAll</description>
                    <helpKeyword>configs.int_load_port_int_load_portdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.LD]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Int_Load_Port_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%Int_Load_PortIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorInt_Load_Port") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_STA_Port" id="locatorInt_STA_Port_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Int_STA_PortDescriptionAll</description>
                    <helpKeyword>configs.int_sta_port_int_sta_portdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.STA]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Int_STA_Port_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%Int_STA_PortIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorInt_STA_Port") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_STD_JMP_Port" id="locatorInt_STD_JMP_Port_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Int_STD_JMP_PortDescriptionAll</description>
                    <helpKeyword>configs.int_std_jmp_port_int_std_jmp_portdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[LPE-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[LPE-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.STD_JMP]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Int_STD_JMP_Port_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%Int_STD_JMP_PortIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorInt_STD_JMP_Port") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Port0" id="locatorInt_Port0_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Int_Port0DescriptionAll</description>
                    <helpKeyword>configs.int_port0_int_port0descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/Mem_Sub_Sys_Bound_socsmall") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[LPE-Core]")