<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:exsl="http://exslt.org/common">
  <xsl:output indent="yes" method="xml"/>
  <xsl:param name="grouping"></xsl:param>
  <xsl:param name="metric"></xsl:param>
  <xsl:param name="function"></xsl:param>
  <xsl:param name="module"></xsl:param>
  <xsl:param name="sourceFile"></xsl:param>
  <xsl:param name="functionType"></xsl:param>
  <xsl:param name="metrics"></xsl:param>
  <xsl:param name="metricNames"></xsl:param>
  <xsl:param name="minFrameSize">3</xsl:param>
  <xsl:template match="/">
    <html id="flameGraphPane" displayName="%FlameGraphWindow">
      <description>%FlameGraphWindowDescription</description>
      <helpKeywordF1>configs.flame_graph</helpKeywordF1>
      <icon file="client.dat#zip:images.xrc" image="tab_timeline"/>
      <additionalParams boolean:showInDiff="false"/>
      <application name="flameGraph"/>
      <filter handleList="global"/>
      <event handleList="KnobChangedEvent"/>
      <config>
        <grouping><xsl:value-of select="$grouping"/></grouping>
        <metric><xsl:value-of select="$metric"/></metric>
        <function><xsl:value-of select="$function"/></function>
        <module><xsl:value-of select="$module"/></module>
        <sourceFile><xsl:value-of select="$sourceFile"/></sourceFile>
        <functionType><xsl:value-of select="$functionType"/></functionType>
        <metrics><xsl:value-of select="$metrics"/></metrics>
        <metricNames><xsl:value-of select="$metricNames"/></metricNames>
        <int:minFrameSize><xsl:value-of select="$minFrameSize"/></int:minFrameSize>
        <functionTypeColors>
          <User label="%FlameUser" color="#6CB85D"/>
          <xsl:if test="contains(exsl:ctx('mrteType', ''), 'java')">
            <JavaDynamic type="User" label="%FlameJavaDynamic" color="#65F765" moduleRegex="\[Dynamic code\]"/>
          </xsl:if>
          <System label="%FlameSystem" color="#CDCD3D"/>
          <Synchronization label="%FlameSynchronization" color="#FE7E0B"/>
          <Overhead label="%FlameOverhead" color="#F7A00A"/>
          <Other label="%FlameOther" color="#8C8C8C"/>
        </functionTypeColors>
      </config>
    </html>
  </xsl:template>
</xsl:stylesheet>
