/*******************************************************************************
 * Copyright 2020 Intel Corporation.
 *
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them is governed by
 * the express license under which they were provided to you ('License'). Unless the License provides otherwise,
 * you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
 * documents without Intel's prior written permission.
 * This software and the related documents are provided as is, with no express or implied warranties, other than
 * those that are expressly stated in the License.
 *******************************************************************************/

#include "ippcv.h"
#include "ippcore_tl.h"
#include "ippcv_tl.h"
#include "owndefs_tl.h"
#include "owncv_tl.h"
#include "ownisplit_t.h"

typedef struct {
    IppiSize kernelSize;
} SeparableInfo;

#define TILE_S (maskSize.height)

typedef union {
    Ipp8u *borderValue_8u;
    Ipp16s *borderValue_16s;
    Ipp16u *borderValue_16u;
    Ipp32f *borderValue_32f;
} bValue;

typedef struct _ippiFilterSeparable_T_Str {
    Ipp8u *pSrc; // const
    int srcStep;
    Ipp8u *pDst;
    int dstStep;
    IppiBorderType borderType;
    bValue borderValue;
    IppiFilterSeparableSpec_T *pSpec; // const
    Ipp8u *pBuffer;
    int bufSize;
    int numChannels;
    IppiPoint splitImage;
    IppiSize pTileSize;
    IppiSize pLastSize;
} ippiFilterSeparable_T_Str;

static void fSeparableThreadingStructureEncode(Ipp8u *pSrc, int srcStep, Ipp8u *pDst, int dstStep, IppiBorderType borderType, bValue borderValue,
                                               IppiFilterSeparableSpec_T *pSpec, Ipp8u *pBuffer, int bufSize, int numChannels, IppiPoint splitImage,
                                               IppiSize pTileSize, IppiSize pLastSize, ippiFilterSeparable_T_Str *ts)
{
    ts->pSrc = pSrc;
    ts->srcStep = srcStep;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->borderType = borderType;
    ts->borderValue = borderValue;
    ts->pSpec = pSpec;
    ts->pBuffer = pBuffer;
    ts->bufSize = bufSize;
    ts->numChannels = numChannels;
    ts->splitImage = splitImage;
    ts->pTileSize = pTileSize;
    ts->pLastSize = pLastSize;
}
