/*******************************************************************************
 * Copyright 2018 Intel Corporation.
 *
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them is governed by
 * the express license under which they were provided to you ('License'). Unless the License provides otherwise,
 * you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
 * documents without Intel's prior written permission.
 * This software and the related documents are provided as is, with no express or implied warranties, other than
 * those that are expressly stated in the License.
 *
 *******************************************************************************/

#ifndef PIFILBILBRD_T_H__
#define PIFILBILBRD_T_H__

#include "ippcore.h"
#include "owndefs_tl.h"
#include "ippcore_tl.h"
#include "ipps.h"
#include "ippi.h"
#include "ippdefs.h"
#include "ownisplit_t.h"
#include "owni_tl.h"

#ifdef USE_OMP
  #include <omp.h>
#endif

#define D_ALIGN           32
#define ippBorderInMemAll ((int)(ippBorderInMemTop | ippBorderInMemBottom | ippBorderInMemLeft | ippBorderInMemRight))

typedef struct {
    IppiPoint split;
    IppiSize tileSize;
    IppiSize lastTile;
    IppDataType dataType;
    Ipp32u numChannels;
    int bufsize;
    int radius;
} BilateralInfo;

#define TYLE_S (maskSize.height + 1)

typedef struct _ippiFilterBilateral_T_Str {
    Ipp8u *pSrc; // const
    int srcStep;
    Ipp8u *pDst;
    int dstStep;
    IppiBorderType border;
    Ipp8u *borderValue;
    IppiFilterBilateralSpec_T *pSpec; // const
    Ipp8u *pBuffer;
    int bufSize;
    int numChannels;
    IppiPoint splitImage;
    IppiSize pTileSize;
    IppiSize pLastSize;
} ippiFilterBilateral_T_Str;
typedef struct _ippiFilterBilateral_P3_T_Str {
    Ipp8u *pSrc[3]; // const
    int srcStep[3];
    Ipp8u *pDst[3];
    int dstStep[3];
    IppiBorderType border;
    Ipp8u *borderValue;
    IppiFilterBilateralSpec_T *pSpec; // const
    Ipp8u *pBuffer;
    int bufSize;
    int numChannels;
    IppiPoint splitImage;
    IppiSize pTileSize;
    IppiSize pLastSize;
} ippiFilterBilateral_P3_T_Str;

static void fBilateralBrdThreadingStructureEncode(Ipp8u *pSrc, int srcStep, Ipp8u *pDst, int dstStep, IppiBorderType border, Ipp8u *borderValue,
                                                  IppiFilterBilateralSpec_T *pSpec, Ipp8u *pBuffer, int bufSize, int numChannels,
                                                  IppiPoint splitImage, IppiSize pTileSize, IppiSize pLastSize, ippiFilterBilateral_T_Str *ts)
{
    ts->pSrc = pSrc;
    ts->srcStep = srcStep;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->border = border;
    ts->borderValue = borderValue;
    ts->pSpec = pSpec;
    ts->pBuffer = pBuffer;
    ts->bufSize = bufSize;
    ts->numChannels = numChannels;
    ts->splitImage = splitImage;
    ts->pTileSize = pTileSize;
    ts->pLastSize = pLastSize;
}
static void fBilateralBrdThreadingStructureEncode_P3(Ipp8u *pSrc[3], int srcStep[3], Ipp8u *pDst[3], int dstStep[3], IppiBorderType border,
                                                     Ipp8u *borderValue, IppiFilterBilateralSpec_T *pSpec, Ipp8u *pBuffer, int bufSize,
                                                     int numChannels, IppiPoint splitImage, IppiSize pTileSize, IppiSize pLastSize,
                                                     ippiFilterBilateral_P3_T_Str *ts)
{
    int n;
    for (n = 0; n < 3; n++) {
        ts->pSrc[n] = pSrc[n];
        ts->srcStep[n] = srcStep[n];
        ts->pDst[n] = pDst[n];
        ts->dstStep[n] = dstStep[n];
    }
    ts->border = border;
    ts->borderValue = borderValue;
    ts->pSpec = pSpec;
    ts->pBuffer = pBuffer;
    ts->bufSize = bufSize;
    ts->numChannels = numChannels;
    ts->splitImage = splitImage;
    ts->pTileSize = pTileSize;
    ts->pLastSize = pLastSize;
}
#endif // PIFILBILBRD_T_H__
