/*******************************************************************************
 * Copyright 2021 Intel Corporation.
 *
 * This software and the related documents are Intel copyrighted  materials,  and
 * your use of  them is  governed by the  express license  under which  they were
 * provided to you (License).  Unless the License provides otherwise, you may not
 * use, modify, copy, publish, distribute,  disclose or transmit this software or
 * the related documents without Intel's prior written permission.
 *
 * This software and the related documents  are provided as  is,  with no express
 * or implied  warranties,  other  than those  that are  expressly stated  in the
 * License.
 *
 * License:
 * https://www.intel.com/content/dam/develop/external/us/en/documents/intel-sample-source-code-license-agreement-rev2-2.pdf
 *******************************************************************************/

#ifndef PRWARPAFFINE_T_H_
#define PRWARPAFFINE_T_H_

#include "ippcore.h"
#include "ipps.h"
#include "ippi.h"
#include "ipptypes.h"

#include "ippcore_tl.h"
#include "ippi_tl.h"
#include "owndefs_tl.h"

#define EPSD 1.0e-10

#ifdef USE_OMP
  #include <omp.h>
#endif

static const int WARPAFFINE_NEAREST_MIN_DEPTH_SIZE = 1;
static const int WARPAFFINE_LINEAR_MIN_DEPTH_SIZE = 8;
static const int WARPAFFINE_CUBIC_MIN_DEPTH_SIZE = 16;

typedef struct {
    const Ipp8u *const *pSrc;
    Ipp8u *const *pDst;
    IpprVolume srcVolume;
    IpprCuboid srcVOI;
    IpprCuboid dstVOI;
    int srcStep;
    int dstStep;
    const double (*coeffs)[4];
    int interpolation;
    Ipp8u *pBuffer;
    int numSlices;
    int sizeSlice;
    int lastSlice;
} WarpAffineThreadData_8u_PV;

typedef struct {
    const Ipp16u *const *pSrc;
    Ipp16u *const *pDst;
    IpprVolume srcVolume;
    IpprCuboid srcVOI;
    IpprCuboid dstVOI;
    int srcStep;
    int dstStep;
    const double (*coeffs)[4];
    int interpolation;
    Ipp8u *pBuffer;
    int numSlices;
    int sizeSlice;
    int lastSlice;
} WarpAffineThreadData_16u_PV;

typedef struct {
    const Ipp32f *const *pSrc;
    Ipp32f *const *pDst;
    IpprVolume srcVolume;
    IpprCuboid srcVOI;
    IpprCuboid dstVOI;
    int srcStep;
    int dstStep;
    const double (*coeffs)[4];
    int interpolation;
    Ipp8u *pBuffer;
    int numSlices;
    int sizeSlice;
    int lastSlice;
} WarpAffineThreadData_32f_PV;

typedef struct {
    const Ipp8u *pSrc;
    Ipp8u *pDst;
    IpprVolume srcVolume;
    IpprCuboid srcVOI;
    IpprCuboid dstVOI;
    int srcStep;
    int dstStep;
    int srcPlaneStep;
    int dstPlaneStep;
    const double (*coeffs)[4];
    int interpolation;
    Ipp8u *pBuffer;
    int numSlices;
    int sizeSlice;
    int lastSlice;
} WarpAffineThreadData_8u_V;

typedef struct {
    const Ipp16u *pSrc;
    Ipp16u *pDst;
    IpprVolume srcVolume;
    IpprCuboid srcVOI;
    IpprCuboid dstVOI;
    int srcStep;
    int dstStep;
    int srcPlaneStep;
    int dstPlaneStep;
    const double (*coeffs)[4];
    int interpolation;
    Ipp8u *pBuffer;
    int numSlices;
    int sizeSlice;
    int lastSlice;
} WarpAffineThreadData_16u_V;

typedef struct {
    const Ipp32f *pSrc;
    Ipp32f *pDst;
    IpprVolume srcVolume;
    IpprCuboid srcVOI;
    IpprCuboid dstVOI;
    int srcStep;
    int dstStep;
    int srcPlaneStep;
    int dstPlaneStep;
    const double (*coeffs)[4];
    int interpolation;
    Ipp8u *pBuffer;
    int numSlices;
    int sizeSlice;
    int lastSlice;
} WarpAffineThreadData_32f_V;

void setWarpAffineThreadData_8u_PV(const Ipp8u *const pSrc[], Ipp8u *const pDst[], IpprVolume srcVolume, IpprCuboid srcVOI, IpprCuboid dstVOI,
                                   int srcStep, int dstStep, const double coeffs[3][4], int interpolation, Ipp8u *pBuffer, int numSlices,
                                   int sizeSlice, int lastSlice, WarpAffineThreadData_8u_PV *tData)
{
    tData->pSrc = pSrc;
    tData->pDst = pDst;
    tData->srcVolume = srcVolume;
    tData->srcVOI = srcVOI;
    tData->dstVOI = dstVOI;
    tData->srcStep = srcStep;
    tData->dstStep = dstStep;
    tData->coeffs = coeffs;
    tData->interpolation = interpolation;
    tData->pBuffer = pBuffer;
    tData->numSlices = numSlices;
    tData->sizeSlice = sizeSlice;
    tData->lastSlice = lastSlice;
}

void setWarpAffineThreadData_16u_PV(const Ipp16u *const pSrc[], Ipp16u *const pDst[], IpprVolume srcVolume, IpprCuboid srcVOI, IpprCuboid dstVOI,
                                    int srcStep, int dstStep, const double coeffs[3][4], int interpolation, Ipp8u *pBuffer, int numSlices,
                                    int sizeSlice, int lastSlice, WarpAffineThreadData_16u_PV *tData)
{
    tData->pSrc = pSrc;
    tData->pDst = pDst;
    tData->srcVolume = srcVolume;
    tData->srcVOI = srcVOI;
    tData->dstVOI = dstVOI;
    tData->srcStep = srcStep;
    tData->dstStep = dstStep;
    tData->coeffs = coeffs;
    tData->interpolation = interpolation;
    tData->pBuffer = pBuffer;
    tData->numSlices = numSlices;
    tData->sizeSlice = sizeSlice;
    tData->lastSlice = lastSlice;
}

void setWarpAffineThreadData_32f_PV(const Ipp32f *const pSrc[], Ipp32f *const pDst[], IpprVolume srcVolume, IpprCuboid srcVOI, IpprCuboid dstVOI,
                                    int srcStep, int dstStep, const double coeffs[3][4], int interpolation, Ipp8u *pBuffer, int numSlices,
                                    int sizeSlice, int lastSlice, WarpAffineThreadData_32f_PV *tData)
{
    tData->pSrc = pSrc;
    tData->pDst = pDst;
    tData->srcVolume = srcVolume;
    tData->srcVOI = srcVOI;
    tData->dstVOI = dstVOI;
    tData->srcStep = srcStep;
    tData->dstStep = dstStep;
    tData->coeffs = coeffs;
    tData->interpolation = interpolation;
    tData->pBuffer = pBuffer;
    tData->numSlices = numSlices;
    tData->sizeSlice = sizeSlice;
    tData->lastSlice = lastSlice;
}

void setWarpAffineThreadData_8u_V(const Ipp8u *pSrc, Ipp8u *pDst, IpprVolume srcVolume, IpprCuboid srcVOI, IpprCuboid dstVOI, int srcStep,
                                  int dstStep, int srcPlaneStep, int dstPlaneStep, const double coeffs[3][4], int interpolation, Ipp8u *pBuffer,
                                  int numSlices, int sizeSlice, int lastSlice, WarpAffineThreadData_8u_V *tData)
{
    tData->pSrc = pSrc;
    tData->pDst = pDst;
    tData->srcVolume = srcVolume;
    tData->srcVOI = srcVOI;
    tData->dstVOI = dstVOI;
    tData->srcStep = srcStep;
    tData->dstStep = dstStep;
    tData->srcPlaneStep = srcPlaneStep;
    tData->dstPlaneStep = dstPlaneStep;
    tData->coeffs = coeffs;
    tData->interpolation = interpolation;
    tData->pBuffer = pBuffer;
    tData->numSlices = numSlices;
    tData->sizeSlice = sizeSlice;
    tData->lastSlice = lastSlice;
}

void setWarpAffineThreadData_16u_V(const Ipp16u *pSrc, Ipp16u *pDst, IpprVolume srcVolume, IpprCuboid srcVOI, IpprCuboid dstVOI, int srcStep,
                                   int dstStep, int srcPlaneStep, int dstPlaneStep, const double coeffs[3][4], int interpolation, Ipp8u *pBuffer,
                                   int numSlices, int sizeSlice, int lastSlice, WarpAffineThreadData_16u_V *tData)
{
    tData->pSrc = pSrc;
    tData->pDst = pDst;
    tData->srcVolume = srcVolume;
    tData->srcVOI = srcVOI;
    tData->dstVOI = dstVOI;
    tData->srcStep = srcStep;
    tData->dstStep = dstStep;
    tData->srcPlaneStep = srcPlaneStep;
    tData->dstPlaneStep = dstPlaneStep;
    tData->coeffs = coeffs;
    tData->interpolation = interpolation;
    tData->pBuffer = pBuffer;
    tData->numSlices = numSlices;
    tData->sizeSlice = sizeSlice;
    tData->lastSlice = lastSlice;
}

void setWarpAffineThreadData_32f_V(const Ipp32f *pSrc, Ipp32f *pDst, IpprVolume srcVolume, IpprCuboid srcVOI, IpprCuboid dstVOI, int srcStep,
                                   int dstStep, int srcPlaneStep, int dstPlaneStep, const double coeffs[3][4], int interpolation, Ipp8u *pBuffer,
                                   int numSlices, int sizeSlice, int lastSlice, WarpAffineThreadData_32f_V *tData)
{
    tData->pSrc = pSrc;
    tData->pDst = pDst;
    tData->srcVolume = srcVolume;
    tData->srcVOI = srcVOI;
    tData->dstVOI = dstVOI;
    tData->srcStep = srcStep;
    tData->dstStep = dstStep;
    tData->srcPlaneStep = srcPlaneStep;
    tData->dstPlaneStep = dstPlaneStep;
    tData->coeffs = coeffs;
    tData->interpolation = interpolation;
    tData->pBuffer = pBuffer;
    tData->numSlices = numSlices;
    tData->sizeSlice = sizeSlice;
    tData->lastSlice = lastSlice;
}

#endif // PRWARPAFFINE_T_H_
