/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeRouteStop;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;

public class TradeRoute
extends FreeColGameObject
implements Nameable,
Ownable {
    private static final Logger logger = Logger.getLogger(TradeRoute.class.getName());
    public static final String TAG = "tradeRoute";
    private String name;
    private Player owner;
    private final List<TradeRouteStop> stops = new ArrayList<TradeRouteStop>();
    private boolean silent = false;
    private static final String NAME_TAG = "name";
    private static final String OWNER_TAG = "owner";
    private static final String SILENT_TAG = "silent";

    public TradeRoute(Game game, String name, Player player) {
        super(game);
        this.name = name;
        this.owner = player;
        this.silent = false;
    }

    public TradeRoute(Game game, String id) {
        super(game, id);
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getStopCount() {
        List<TradeRouteStop> list = this.stops;
        synchronized (list) {
            return this.stops.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TradeRouteStop getStop(int index) {
        List<TradeRouteStop> list = this.stops;
        synchronized (list) {
            return index >= 0 && index < this.stops.size() ? this.stops.get(index) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<TradeRouteStop> getStopList() {
        List<TradeRouteStop> list = this.stops;
        synchronized (list) {
            return new ArrayList<TradeRouteStop>(this.stops);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TradeRouteStop> getStopSublist(TradeRouteStop start, TradeRouteStop end) {
        int i0 = this.getIndex(start);
        int in = this.getIndex(end);
        if (i0 < 0 || in < 0) {
            return null;
        }
        ArrayList<TradeRouteStop> result = new ArrayList<TradeRouteStop>();
        List<TradeRouteStop> list = this.stops;
        synchronized (list) {
            while (i0 != in) {
                result.add(this.stops.get(i0));
                if (++i0 < this.stops.size()) continue;
                i0 = 0;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStop(TradeRouteStop stop) {
        List<TradeRouteStop> list = this.stops;
        synchronized (list) {
            this.stops.add(stop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStop(TradeRouteStop stop) {
        List<TradeRouteStop> list = this.stops;
        synchronized (list) {
            this.stops.remove(stop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMatchingStops(Location loc) {
        List<TradeRouteStop> list = this.stops;
        synchronized (list) {
            return CollectionUtils.removeInPlace(this.stops, trs -> Map.isSameLocation(trs.getLocation(), loc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndex(TradeRouteStop stop) {
        List<TradeRouteStop> list = this.stops;
        synchronized (list) {
            int i = 0;
            for (TradeRouteStop trs : this.stops) {
                if (trs == stop) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStops() {
        List<TradeRouteStop> list = this.stops;
        synchronized (list) {
            this.stops.clear();
        }
    }

    public List<Unit> getAssignedUnits() {
        return CollectionUtils.transform(this.getOwner().getUnits(), CollectionUtils.matchKey(this, Unit::getTradeRoute));
    }

    public static boolean isStopValid(Unit unit, TradeRouteStop stop) {
        return TradeRoute.isStopValid(unit.getOwner(), stop);
    }

    public static boolean isStopValid(Player player, TradeRouteStop stop) {
        return stop == null ? false : stop.isValid(player);
    }

    public StringTemplate verifyUniqueName() {
        return this.getOwner().getTradeRouteByName(this.name, this) != null ? (StringTemplate)StringTemplate.template("model.tradeRoute.duplicateName").addName("%name%", this.name) : null;
    }

    public StringTemplate verify() {
        if (this.name == null) {
            return StringTemplate.template("model.tradeRoute.nullName");
        }
        if (this.owner == null) {
            return StringTemplate.template("model.tradeRoute.nullOwner");
        }
        if (this.getStopCount() < 2) {
            return StringTemplate.template("model.tradeRoute.notEnoughStops");
        }
        HashSet<GoodsType> always = new HashSet<GoodsType>(this.getStop(0).getCargo());
        boolean empty = true;
        int n = this.getStopCount();
        for (int i = 0; i < n; ++i) {
            TradeRouteStop stop = this.getStop(i);
            if (!TradeRoute.isStopValid(this.owner, stop)) {
                return stop.invalidStopLabel(this.owner);
            }
            if (!stop.getCargo().isEmpty()) {
                empty = false;
            }
            always.retainAll(stop.getCargo());
        }
        boolean enhancedTradeRoutes = this.getSpecification().getBoolean("model.option.enhancedTradeRoutes");
        return empty ? StringTemplate.template("model.tradeRoute.allEmpty") : (!enhancedTradeRoutes && !always.isEmpty() ? StringTemplate.template("model.tradeRoute.alwaysPresent").addNamed("%goodsType%", CollectionUtils.first(always)) : null);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String newName) {
        this.name = newName;
    }

    @Override
    public final Player getOwner() {
        return this.owner;
    }

    @Override
    public final void setOwner(Player newOwner) {
        this.owner = newOwner;
    }

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        StringTemplate ver = this.verify();
        if (ver != null) {
            lb.add("\n  In ", this.getId(), " ", Messages.message(ver));
            result = result.fail();
        }
        return result;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        TradeRoute o = this.copyInCast(other, TradeRoute.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.name = o.getName();
        this.owner = o.getOwner();
        this.clearStops();
        for (TradeRouteStop trs : o.getStopList()) {
            this.addStop(new TradeRouteStop(trs));
        }
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(NAME_TAG, this.getName());
        xw.writeAttribute(OWNER_TAG, this.getOwner());
        xw.writeAttribute(SILENT_TAG, this.isSilent());
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (TradeRouteStop stop : this.stops) {
            stop.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.name = xr.getAttribute(NAME_TAG, null);
        this.owner = xr.findFreeColGameObject(this.getGame(), OWNER_TAG, Player.class, null, true);
        this.silent = xr.getAttribute(SILENT_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.clearStops();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if ("tradeRouteStop".equals(tag)) {
            this.addStop(new TradeRouteStop(this.getGame(), xr));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[').append(this.getId()).append(" \"").append(this.name).append('\"');
        if (this.owner != null) {
            sb.append(" owner=").append(this.owner.getId());
        }
        sb.append(" silent=").append(Boolean.toString(this.silent));
        for (TradeRouteStop stop : this.getStopList()) {
            sb.append(' ').append(stop);
        }
        sb.append(']');
        return sb.toString();
    }
}

