/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import org.freeplane.api.LengthUnit;
import org.freeplane.api.NodeShape;
import org.freeplane.api.Quantity;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleShape;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.Proxy;

class NodeGeometryProxy
extends AbstractProxy<NodeModel>
implements Proxy.NodeGeometry {
    private static final NodeStyleShape[] SHAPES = NodeStyleShape.values();
    private static final NodeShape[] NODE_SHAPES = NodeShape.values();

    NodeGeometryProxy(NodeModel delegate, ScriptContext scriptContext) {
        super(delegate, scriptContext);
    }

    private MNodeStyleController getStyleController() {
        return (MNodeStyleController)NodeStyleController.getController();
    }

    public NodeShape getShape() {
        return NODE_SHAPES[this.getStyleController().getShape((NodeModel)this.getDelegate(), LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE).ordinal()];
    }

    public Quantity<LengthUnit> getHorizontalMargin() {
        return this.getStyleController().getShapeConfiguration((NodeModel)this.getDelegate(), LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE).getHorizontalMargin();
    }

    public Quantity<LengthUnit> getVerticalMargin() {
        return this.getStyleController().getShapeConfiguration((NodeModel)this.getDelegate(), LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE).getVerticalMargin();
    }

    public boolean getIsUniform() {
        return this.getStyleController().getShapeConfiguration((NodeModel)this.getDelegate(), LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE).isUniform();
    }

    public void setShape(NodeShape shape) {
        this.getStyleController().setShape((NodeModel)this.getDelegate(), SHAPES[shape.ordinal()]);
    }

    public void setHorizontalMargin(Quantity<LengthUnit> length) {
        this.getStyleController().setShapeHorizontalMargin((NodeModel)this.getDelegate(), length);
    }

    public void setVerticalMargin(Quantity<LengthUnit> length) {
        this.getStyleController().setShapeVerticalMargin((NodeModel)this.getDelegate(), length);
    }

    public void setIsUniform(boolean isUniform) {
        this.getStyleController().setUniformShape((NodeModel)this.getDelegate(), isUniform);
    }
}

