/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.security.AccessControlContext;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.permissions.ConditionalPermission;
import org.osgi.service.condpermadmin.Condition;

class PostponementCheck<T>
implements PrivilegedAction<T> {
    private final AccessControlContext acc;
    private final Permission perm;
    private ArrayList<Class<? extends Condition>> checkedClasses;
    private ArrayList<List<ConditionalPermission>> ppList = null;
    private Debug debug = null;

    PostponementCheck(AccessControlContext acc, Permission perm, PostponementCheck<?> previous) {
        this.acc = acc;
        this.perm = perm;
        this.checkedClasses = previous != null ? previous.getCheckedClasses() : null;
    }

    ArrayList<Class<? extends Condition>> getCheckedClasses() {
        if (this.checkedClasses != null) {
            ArrayList res = (ArrayList)this.checkedClasses.clone();
            return res;
        }
        return null;
    }

    public void savePostponement(List<ConditionalPermission> postponement, Object debug) {
        if (this.ppList == null) {
            this.ppList = new ArrayList(2);
            this.debug = (Debug)debug;
        }
        this.ppList.add(postponement);
    }

    @Override
    public T run() {
        this.acc.checkPermission(this.perm);
        this.checkPostponements();
        return null;
    }

    private void checkPostponements() {
        if (this.ppList != null) {
            HashMap<Class<? extends Condition>, Dictionary<Object, Object>> condDict = new HashMap<Class<? extends Condition>, Dictionary<Object, Object>>();
            if (this.checkedClasses == null) {
                this.checkedClasses = new ArrayList();
            }
            for (List<ConditionalPermission> list : this.ppList) {
                boolean deny = true;
                for (ConditionalPermission name : list) {
                    ConditionalPermission cp = name;
                    if (!cp.checkPostponedOk(condDict, this.checkedClasses)) continue;
                    if (cp.access != "allow") break;
                    deny = false;
                    break;
                }
                if (!deny) continue;
                if (this.debug.permissions) {
                    this.debug.println("CHECK_POSTPONE: postponement failed");
                }
                throw new SecurityException("Postponed conditions failed");
            }
            if (this.debug.permissions) {
                this.debug.println("CHECK_POSTPONE: postponement ok");
            }
        }
    }
}

