# SLA, chapter 2
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("sla02.tst");

# doc/manual.xml:93-98
gap> R:= RootSystem("F",4);;
gap> ExtendedCartanMatrix(R);
rec( ECM := [ [ 2, -1, 0, 0, 0 ], [ -1, 2, -1, 0, 0 ], [ 0, -1, 2, -2, 0 ], 
      [ 0, 0, -1, 2, -1 ], [ 0, 0, 0, -1, 2 ] ], labels := [ 1, 2, 3, 4, 2 ] )

# doc/manual.xml:117-123
gap> C:= [[2,0,-3,0],[0,2,0,-1],[-1,0,2,0],[0,-1,0,2]];
[ [ 2, 0, -3, 0 ], [ 0, 2, 0, -1 ], [ -1, 0, 2, 0 ], [ 0, -1, 0, 2 ] ]
gap> CartanType(C);
rec( enumeration := [ [ 3, 1 ], [ 2, 4 ] ], 
  types := [ [ "G", 2 ], [ "A", 2 ] ] )

# doc/manual.xml:139-145
gap> C:=[[2,0,-1,0,0,0],[0,2,0,0,-3,0],[-1,0,2,0,0,-1],[0,0,0,2,0,-1],
> [0,-1,0,0,2,0],[0,0,-2,-1,0,2]];;
gap> DisplayDynkinDiagram(C); 
F4:  4---6=>=3---1
G2:  5#<#2

# doc/manual.xml:181-190
gap> R:= RootSystem("A",3);;
gap> WeylTransversal( R, [2,6] );
[ [  ], [ 1 ], [ 3 ], [ 1, 2 ], [ 1, 3 ], [ 3, 2 ] ]
gap> R:= RootSystem("E",8);;
gap> p:= PositiveRootsNF(R);;
gap> a:= WeylTransversal( R, [p[1],p[3],p[4],p[5],p[6],p[7],p[8],-p[120]] );;
gap> Length(a);
1920

# doc/manual.xml:209-217
gap> R:= RootSystem( SimpleLieAlgebra("E",6,Rationals) );;
gap> SizeOfWeylGroup(R);                
51840
gap> SizeOfWeylGroup( [["E",6]] );
51840
gap> SizeOfWeylGroup( "E", 6 );   
51840

# doc/manual.xml:253-260
gap> R:= RootSystem("E",6);
<root system of type E6>
gap> G:= WeylGroupAsPermGroup( R );
<permutation group with 6 generators>
gap> Size(G);
51840

# doc/manual.xml:277-284
gap> R:= RootSystem("D",4);;
gap> G:= WeylGroupAsPermGroup(R);
<permutation group with 4 generators>
gap> wt:= ApplyWeylPermToWeight( R, Random(G), [1,1,1,1] );;
gap> ConjugateDominantWeight( WeylGroup(R), wt );
[ 1, 1, 1, 1 ] 

# doc/manual.xml:301-305
gap> R:= RootSystem("D",4);;
gap> WeylWordAsPerm( R, [1,2,1,3,4,2,3,4,1] );
(1,23,12,17)(2,10,14,22)(3,19,16,6)(4,18,15,7)(5,13,11,24)(8,21)(9,20)

# doc/manual.xml:321-332
gap> R:= RootSystem("D",4);;
gap> rts:= [1,3,4,12,13,15,16,24];;
gap> G:= WeylGroupAsPermGroup(R);;
gap> S:= Stabilizer( G, rts, OnSets );
<permutation group of size 64 with 6 generators>
gap> Size(S);
64
gap> List( GeneratorsOfGroup(S), g -> PermAsWeylWord( R, g ) );
[ [ 3 ], [ 3, 4 ], [ 2, 1, 3, 2, 4, 2, 1, 3, 2, 4 ], [ 2, 1, 3, 2 ], 
  [ 2, 1, 4, 2 ], [ 1, 3 ] ]

#
gap> STOP_TEST("sla02.tst", 1);
