/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.text.Keymap;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class NotifyDescriptor {
    public static final String PROP_MESSAGE = "message";
    public static final String PROP_MESSAGE_TYPE = "messageType";
    public static final String PROP_OPTION_TYPE = "optionType";
    public static final String PROP_OPTIONS = "options";
    public static final String PROP_VALUE = "value";
    public static final String PROP_TITLE = "title";
    public static final String PROP_DETAIL = "detail";
    public static final String PROP_VALID = "valid";
    public static final String PROP_NO_DEFAULT_CLOSE = "noDefaultClose";
    public static final String PROP_ERROR_NOTIFICATION = "errorNotification";
    public static final String PROP_WARNING_NOTIFICATION = "warningNotification";
    public static final String PROP_INFO_NOTIFICATION = "infoNotification";
    public static final Object YES_OPTION = new Integer(0);
    public static final Object NO_OPTION = new Integer(1);
    public static final Object CANCEL_OPTION = new Integer(2);
    public static final Object OK_OPTION = new Integer(0);
    public static final Object CLOSED_OPTION = new Integer(-1);
    public static final int DEFAULT_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    private static final int MAXIMUM_TEXT_WIDTH = 100;
    private static final int SIZE_PREFERRED_WIDTH = 350;
    private static final int SIZE_PREFERRED_HEIGHT = 150;
    private Object message;
    private int messageType = -1;
    private int optionType;
    private Object[] options;
    private Object[] adOptions;
    private Object value;
    private Object defaultValue;
    private String title;
    private boolean valid = true;
    private NotificationLineSupport notificationLineSupport = null;
    private String infoMsg;
    private String warnMsg;
    private String errMsg;
    private PropertyChangeSupport changeSupport;
    private boolean noDefaultClose = false;

    public NotifyDescriptor(Object message, String title, int optionType, int messageType, Object[] options, Object initialValue) {
        this.checkMessageValidity(message);
        this.message = message;
        this.messageType = messageType;
        this.options = options;
        this.optionType = optionType;
        this.title = title;
        this.value = initialValue;
        this.defaultValue = initialValue;
    }

    protected void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void getterCalled() {
        boolean init = false;
        NotifyDescriptor notifyDescriptor = this;
        synchronized (notifyDescriptor) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
                init = true;
            }
        }
        if (init) {
            this.initialize();
        }
    }

    public final boolean isValid() {
        this.getterCalled();
        return this.valid;
    }

    public final void setValid(boolean newValid) {
        boolean oldValid = this.valid;
        this.valid = newValid;
        this.firePropertyChange(PROP_VALID, oldValid ? Boolean.TRUE : Boolean.FALSE, newValid ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setMessage(Object newMessage) {
        this.checkMessageValidity(newMessage);
        Object oldMessage = this.message;
        if (newMessage instanceof String) {
            JTextArea area = new JTextArea((String)newMessage);
            area.setBackground(UIManager.getColor("Label.background"));
            area.setBorder(BorderFactory.createEmptyBorder());
            area.setLineWrap(true);
            area.setWrapStyleWord(true);
            area.setEditable(false);
            area.setFocusable(true);
            area.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACN_NotifyDescriptor_MessageJTextArea"));
            area.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACD_NotifyDescriptor_MessageJTextArea"));
            JScrollPane sp = new JScrollPane(area);
            sp.setBorder(BorderFactory.createEmptyBorder());
            sp.setPreferredSize(new Dimension(350, 150));
            newMessage = sp;
        }
        this.message = newMessage;
        this.firePropertyChange(PROP_MESSAGE, oldMessage, newMessage);
    }

    private void checkMessageValidity(Object message) {
        if (message instanceof Window) {
            throw new IllegalArgumentException("The message must not be a window. message = " + message);
        }
    }

    public Object getMessage() {
        this.getterCalled();
        return this.message;
    }

    public void setMessageType(int newType) {
        if (newType != 0 && newType != 1 && newType != 2 && newType != 3 && newType != -1) {
            throw new IllegalArgumentException("Message type must be one of the following: ERROR_MESSAGE, INFORMATION_MESSAGE, WARNING_MESSAGE, QUESTION_MESSAGE or PLAIN_MESSAGE.");
        }
        int oldType = this.messageType;
        this.messageType = newType;
        this.firePropertyChange(PROP_MESSAGE_TYPE, new Integer(oldType), new Integer(this.messageType));
    }

    public int getMessageType() {
        this.getterCalled();
        return this.messageType;
    }

    public void setOptionType(int newType) {
        if (newType != -1 && newType != 0 && newType != 1 && newType != 2) {
            throw new IllegalArgumentException("Option type must be one of the following: DEFAULT_OPTION, YES_NO_OPTION, YES_NO_CANCEL_OPTION or OK_CANCEL_OPTION.");
        }
        int oldType = this.optionType;
        this.optionType = newType;
        this.firePropertyChange(PROP_OPTION_TYPE, new Integer(oldType), new Integer(this.optionType));
    }

    public int getOptionType() {
        this.getterCalled();
        return this.optionType;
    }

    public void setOptions(Object[] newOptions) {
        Object[] oldOptions = this.options;
        this.options = newOptions;
        this.firePropertyChange(PROP_OPTIONS, oldOptions, newOptions);
    }

    public Object[] getOptions() {
        this.getterCalled();
        if (this.options != null) {
            return (Object[])this.options.clone();
        }
        return this.options;
    }

    public void setAdditionalOptions(Object[] newOptions) {
        Object[] oldOptions = this.adOptions;
        this.adOptions = newOptions;
        this.firePropertyChange(PROP_OPTIONS, oldOptions, newOptions);
    }

    public Object[] getAdditionalOptions() {
        this.getterCalled();
        if (this.adOptions != null) {
            return (Object[])this.adOptions.clone();
        }
        return null;
    }

    void setValueWithoutPCH(Object newValue) {
        this.value = newValue;
    }

    public void setValue(Object newValue) {
        Object oldValue = this.value;
        this.setValueWithoutPCH(newValue);
        this.firePropertyChange(PROP_VALUE, oldValue, newValue);
    }

    public Object getValue() {
        this.getterCalled();
        return this.value;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setTitle(String newTitle) {
        String oldTitle = this.title;
        this.title = newTitle;
        this.firePropertyChange(PROP_TITLE, oldTitle, newTitle);
    }

    public String getTitle() {
        this.getterCalled();
        return this.title;
    }

    public final NotificationLineSupport createNotificationLineSupport() {
        this.notificationLineSupport = new NotificationLineSupport(this);
        return this.notificationLineSupport;
    }

    public final NotificationLineSupport getNotificationLineSupport() {
        return this.notificationLineSupport;
    }

    void setInformationMessage(String msg) {
        if (this.notificationLineSupport == null) {
            throw new IllegalStateException("NotificationLineSupport wasn't created yet.");
        }
        this.infoMsg = msg;
        this.warnMsg = null;
        this.errMsg = null;
        this.firePropertyChange(PROP_INFO_NOTIFICATION, null, msg);
    }

    void setWarningMessage(String msg) {
        if (this.notificationLineSupport == null) {
            throw new IllegalStateException("NotificationLineSupport wasn't created yet.");
        }
        this.infoMsg = null;
        this.warnMsg = msg;
        this.errMsg = null;
        this.firePropertyChange(PROP_WARNING_NOTIFICATION, null, msg);
    }

    void setErrorMessage(String msg) {
        if (this.notificationLineSupport == null) {
            throw new IllegalStateException("NotificationLineSupport wasn't created yet.");
        }
        this.infoMsg = null;
        this.warnMsg = null;
        this.errMsg = msg;
        this.firePropertyChange(PROP_ERROR_NOTIFICATION, null, msg);
    }

    String getInformationMessage() {
        if (this.notificationLineSupport == null) {
            throw new IllegalStateException("NotificationLineSupport wasn't created yet.");
        }
        return this.infoMsg;
    }

    String getWarningMessage() {
        if (this.notificationLineSupport == null) {
            throw new IllegalStateException("NotificationLineSupport wasn't created yet.");
        }
        return this.warnMsg;
    }

    String getErrorMessage() {
        if (this.notificationLineSupport == null) {
            throw new IllegalStateException("NotificationLineSupport wasn't created yet.");
        }
        return this.errMsg;
    }

    void clearMessages() {
        if (this.notificationLineSupport == null) {
            throw new IllegalStateException("NotificationLineSupport wasn't created yet.");
        }
        this.infoMsg = null;
        this.warnMsg = null;
        this.errMsg = null;
        this.firePropertyChange(PROP_INFO_NOTIFICATION, null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getterCalled();
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void setNoDefaultClose(boolean noDefaultClose) {
        boolean oldValue = this.noDefaultClose;
        this.noDefaultClose = noDefaultClose;
        this.firePropertyChange(PROP_NO_DEFAULT_CLOSE, oldValue, noDefaultClose);
    }

    public boolean isNoDefaultClose() {
        return this.noDefaultClose;
    }

    protected static String getTitleForType(int messageType) {
        switch (messageType) {
            case 0: {
                return NbBundle.getMessage(NotifyDescriptor.class, (String)"NTF_ErrorTitle");
            }
            case 2: {
                return NbBundle.getMessage(NotifyDescriptor.class, (String)"NTF_WarningTitle");
            }
            case 3: {
                return NbBundle.getMessage(NotifyDescriptor.class, (String)"NTF_QuestionTitle");
            }
            case 1: {
                return NbBundle.getMessage(NotifyDescriptor.class, (String)"NTF_InformationTitle");
            }
            case -1: {
                return NbBundle.getMessage(NotifyDescriptor.class, (String)"NTF_PlainTitle");
            }
        }
        return "";
    }

    public static final class ComposedInput
    extends NotifyDescriptor {
        public static final String PROP_ESTIMATED_NUMBER_OF_INPUTS = "estimatedNumberOfInputs";
        private final List<NotifyDescriptor> inputs = new ArrayList<NotifyDescriptor>();
        private final Callback callback;
        private int estimatedNumberOfInputs;

        public ComposedInput(String title, int estimatedNumberOfInputs, Callback callback) {
            super(null, title, 2, -1, null, null);
            this.callback = callback;
            this.estimatedNumberOfInputs = estimatedNumberOfInputs;
        }

        public int getEstimatedNumberOfInputs() {
            return this.estimatedNumberOfInputs;
        }

        public void setEstimatedNumberOfInputs(int estimatedNumberOfInputs) {
            int oldNumber = this.estimatedNumberOfInputs;
            this.estimatedNumberOfInputs = estimatedNumberOfInputs;
            this.firePropertyChange(PROP_ESTIMATED_NUMBER_OF_INPUTS, oldNumber, estimatedNumberOfInputs);
        }

        public NotifyDescriptor createInput(int number) {
            NotifyDescriptor step = this.callback.createInput(this, number);
            if (step != null) {
                if (number - 1 < this.inputs.size()) {
                    this.inputs.set(number - 1, step);
                } else if (number - 1 == this.inputs.size()) {
                    this.inputs.add(step);
                } else {
                    return null;
                }
                if (number >= this.estimatedNumberOfInputs) {
                    this.estimatedNumberOfInputs = number;
                }
            }
            return step;
        }

        public NotifyDescriptor[] getInputs() {
            return this.inputs.toArray(new NotifyDescriptor[0]);
        }

        @Override
        public Object getMessage() {
            NotifyDescriptor input;
            Object msg = super.getMessage();
            if (msg != null) {
                return msg;
            }
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            panel.setLayout(new GridBagLayout());
            int i = 0;
            GridBagConstraints gridBagConstraints = null;
            while ((input = this.createInput(++i)) != null) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = i - 1;
                gridBagConstraints.gridwidth = -1;
                gridBagConstraints.gridheight = -1;
                gridBagConstraints.anchor = 23;
                panel.add((Component)((JPanel)input.getMessage()), gridBagConstraints);
            }
            if (gridBagConstraints != null) {
                gridBagConstraints.weighty = 1.0;
            }
            this.setMessage(panel);
            return panel;
        }

        public static interface Callback {
            public NotifyDescriptor createInput(ComposedInput var1, int var2);
        }
    }

    public static final class QuickPick
    extends NotifyDescriptor {
        private final String text;
        private final List<Item> items;
        private final boolean multipleSelection;

        public QuickPick(String text, String title, List<Item> items, boolean multipleSelection) {
            super(null, title, 2, -1, null, null);
            this.text = text;
            this.items = items;
            this.multipleSelection = multipleSelection;
        }

        @Override
        public Object getMessage() {
            Object msg = super.getMessage();
            if (msg != null) {
                return msg;
            }
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            GroupLayout layout = new GroupLayout(panel);
            panel.setLayout(layout);
            JLabel label = new JLabel();
            Mnemonics.setLocalizedText((JLabel)label, (String)this.text);
            GroupLayout.ParallelGroup hGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(label);
            GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup().addContainerGap().addComponent(label);
            final LinkedHashMap<JToggleButton, Item> btn2items = new LinkedHashMap<JToggleButton, Item>();
            ItemListener listener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JToggleButton btn = (JToggleButton)e.getItemSelectable();
                    Item item = (Item)btn2items.get(btn);
                    if (item != null) {
                        item.setSelected(btn.isSelected());
                    }
                }
            };
            ButtonGroup buttonGroup = this.multipleSelection ? null : new ButtonGroup();
            for (Item item : this.items) {
                JToggleButton btn;
                if (buttonGroup != null) {
                    btn = new JRadioButton();
                    buttonGroup.add(btn);
                } else {
                    btn = new JCheckBox();
                }
                btn.setText(item.getLabel());
                btn.setToolTipText(item.getDescription());
                btn.setSelected(item.isSelected());
                hGroup.addComponent(btn);
                vGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btn);
                btn.addItemListener(listener);
                btn2items.put(btn, item);
            }
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(hGroup).addContainerGap()));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(vGroup.addContainerGap()));
            this.setMessage(panel);
            return panel;
        }

        public String getLabel() {
            return this.text;
        }

        public List<Item> getItems() {
            return Collections.unmodifiableList(this.items);
        }

        public boolean isMultipleSelection() {
            return this.multipleSelection;
        }

        public static final class Item {
            private final String label;
            private final String description;
            private boolean selected;

            public Item(String label, String description) {
                this.label = label;
                this.description = description;
            }

            public String getLabel() {
                return this.label;
            }

            public String getDescription() {
                return this.description;
            }

            public boolean isSelected() {
                return this.selected;
            }

            public void setSelected(boolean selected) {
                this.selected = selected;
            }
        }
    }

    public static class InputLine
    extends NotifyDescriptor {
        protected JTextField textField;

        public InputLine(String text, String title) {
            this(text, title, 2, -1);
        }

        public InputLine(String text, String title, int optionType, int messageType) {
            super(null, title, optionType, messageType, null, null);
            super.setMessage(this.createDesign(text));
        }

        public String getInputText() {
            return this.textField.getText();
        }

        public void setInputText(String text) {
            this.textField.setText(text);
            this.textField.selectAll();
        }

        protected Component createDesign(String text) {
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            JLabel textLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)textLabel, (String)text);
            boolean longText = text.length() > 80;
            this.textField = this.createTextField();
            textLabel.setLabelFor(this.textField);
            this.textField.requestFocus();
            GroupLayout layout = new GroupLayout(panel);
            panel.setLayout(layout);
            if (longText) {
                layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(textLabel, -1, -1, Short.MAX_VALUE).addGap(32, 32, 32)).addComponent(this.textField)).addContainerGap()));
            } else {
                layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(textLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textField, -1, 207, Short.MAX_VALUE).addContainerGap()));
            }
            if (longText) {
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(textLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
            } else {
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(textLabel).addComponent(this.textField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
            }
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            Keymap map = this.textField.getKeymap();
            map.removeKeyStrokeBinding(enter);
            panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputPanel"));
            this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputField"));
            return panel;
        }

        JTextField createTextField() {
            return new JTextField(25);
        }
    }

    public static final class PasswordLine
    extends InputLine {
        public PasswordLine(String text, String title) {
            super(text, title);
        }

        @Override
        JTextField createTextField() {
            return new JPasswordField(25);
        }
    }

    @Deprecated
    public static final class Exception
    extends Confirmation {
        static final long serialVersionUID = -3387516993124229948L;

        public Exception(Throwable detail) {
            this(detail, (Object)detail.getMessage());
            Object obj;
            if (detail instanceof InvocationTargetException) {
                Throwable target = ((InvocationTargetException)detail).getTargetException();
                this.setMessage(target);
                Object msgObj = this.getMessage();
                if (msgObj == null || "".equals(msgObj)) {
                    String msg = target.getMessage();
                    msg = Utilities.wrapString((String)msg, (int)100, (BreakIterator)BreakIterator.getCharacterInstance(), (boolean)false);
                    this.setMessage(msg);
                }
            }
            if ((obj = this.getMessage()) == null || "".equals(obj)) {
                this.setMessage(NbBundle.getMessage(NotifyDescriptor.class, (String)"NTF_ExceptionalException", (Object)detail.getClass().getName(), (Object)(System.getProperty("netbeans.user") + File.separator + "system")));
                this.setTitle(NbBundle.getMessage(NotifyDescriptor.class, (String)"NTF_ExceptionalExceptionTitle"));
            }
        }

        public Exception(Throwable detail, Object message) {
            super(message, -1, 0);
            this.setTitle(NbBundle.getMessage(NotifyDescriptor.class, (String)"NTF_ExceptionTitle"));
        }
    }

    public static class Confirmation
    extends NotifyDescriptor {
        public Confirmation(Object message) {
            this(message, 1);
        }

        public Confirmation(Object message, String title) {
            this(message, title, 1);
        }

        public Confirmation(Object message, int optionType) {
            this(message, optionType, 3);
        }

        public Confirmation(Object message, String title, int optionType) {
            this(message, title, optionType, 3);
        }

        public Confirmation(Object message, int optionType, int messageType) {
            Object[] objectArray;
            String string = NotifyDescriptor.getTitleForType(messageType);
            if (optionType == -1) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = OK_OPTION;
            } else {
                objectArray = null;
            }
            super(message, string, optionType, messageType, objectArray, OK_OPTION);
        }

        public Confirmation(Object message, String title, int optionType, int messageType) {
            Object[] objectArray;
            if (optionType == -1) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = OK_OPTION;
            } else {
                objectArray = null;
            }
            super(message, title, optionType, messageType, objectArray, OK_OPTION);
        }
    }

    public static class Message
    extends NotifyDescriptor {
        public Message(Object message) {
            this(message, 1);
        }

        public Message(Object message, int messageType) {
            super(message, NotifyDescriptor.getTitleForType(messageType), -1, messageType, new Object[]{OK_OPTION}, OK_OPTION);
        }
    }
}

