# Copyright (C) 2024 Intel Corporation
# SPDX-License-Identifier: MIT

from cli.timer import timer
from cli.writers.excel.excel_writer_base import BaseExcelWriter
from mpp import ViewCollection


class RustExcelWriter(BaseExcelWriter):

    def __init__(self, file_path: str, output_name: str, include_details=False, include_charts=False):
        super().__init__(file_path, output_name, include_details, include_charts)

    def write_csv_to_excel(self, view_collection: ViewCollection) -> None:
        import pyrust_xlsxwriter
        if not self.include_details:
            view_collection.remove_views('system_view_details')

        with timer() as number_of_seconds:
            sorted_sheets = self._get_sorted_sheet_list(view_collection.views)
            rust_sorted_sheets = \
                [pyrust_xlsxwriter.ExcelSheetInfo(sheet.file_path, sheet.name, sheet.tab_color)
                 for sheet in sorted_sheets]
            pyrust_xlsxwriter.csv_to_excel(rust_sorted_sheets, self.output_name)
        print(f'Excel file generated with Rust in {number_of_seconds}')
