# fabric profiler settings
export PATH=$ESP_ROOT/bin/collector:$PATH
if [ -z "$ESP_EXAMPLES" ]; then
  export ESP_EXAMPLES=$ESP_ROOT/examples
fi
if [ -z "$ESP_WORK" ]; then
  export ESP_WORK=$ESP_ROOT/results
fi
if [ -z "$ESP_LOG_PATH" ]; then
  export ESP_LOG_PATH=$ESP_WORK/logs
fi
export ESP_LIB=libesp.so
export ESP_SHMEM_LIB=libsma.so
export ESP_SHMEM_VERSION="sos1.4"
if [ -z "$ESP_VERBOSITY_LEVEL" ]; then
  export ESP_VERBOSITY_LEVEL=100
fi
if [ -z "$ESP_SAMPLE_RATE" ]; then
  export ESP_SAMPLE_RATE=100
fi
export ESP_TRACE_BUFFER_SIZE=4096
export ESP_TRACE_FILE_NAME="esptrace"
if [ -z "$ESP_TRACE_PATH" ]; then
  export ESP_TRACE_PATH=""
fi
export ESP_HFI_TRACE_BUFFER_SIZE=4096
export ESP_FUNCTION_TRACE_COUNT=5000000
# Borealis/Australis PAPI do not yet support these
##export ESP_PAPI_COUNTER_LIST="PAPI_TOT_CYC,PAPI_L1_TCM,PAPI_L2_TCM,PAPI_TLB_DM"
export ESP_PAPI_COUNTER_LIST=""
export ESP_FUNCTION_INST_MODE="selectiveDisable"
if [ "$ESP_FUNCTION_INST_MODE" == "selectiveDisable" ]; then
  export ESP_SELECTIVE_DISABLE
else
  export -n ESP_SELECTIVE_DISABLE
fi
export ESP_FUNCTION_INST_LIST="shmem_malloc"
export ESP_FUNCTION_INST_LIST=""
export ESP_SAMPLE_AFTER_DELAY=1
export ESP_CLOCK_SYNC_NUM_SAMPLES_PER_SYNC_EVENT=20
export ESP_CLOCK_SYNC_SAMPLE_INTERVAL=.001


########################################
# IGNORE FPRO_* IF NOT USING fpro script
########################################
# SHMEM job settings
export FPRO_NUM_NODES=1
export FPRO_NUM_PES_PER_NODE=2
export FPRO_SYMMETRIC_HEAP_SIZE_IN_MB=256
export FPRO_CPU_TYPE=""
# Select job manager, "pbs" or "slurm"
export FPRO_DEFAULT_JM="pbs"

# job status update period, in seconds 
export FPRO_WAIT_FOR_JOB_TO_COMPLETE_DELAY=2
# time (s) to wait for logs to sink after job completes
export FPRO_LOG_SINK_TIME=5

# location for fabric profiler temp files
export FPRO_TMP=$ESP_WORK/tmp 

##                  ##
## Cluster-Specific ##
##                  ##

# Perlmutter slurm and SHMEM exec settings
export FPRO_SHMEM_EXEC="srun"
export FPRO_SHMEM_EXEC_OPT_NUM_PE="--ntasks-per-node"
export FPRO_SLURM_QUEUE="debug"
export FPRO_SLURM_CPU_TYPE=""
export FPRO_SLURM_MAX_TIME="00:15:00"
export FPRO_SLURM_CONSTRAINT="cpu"
export FPRO_SLURM_LICENSE="SCRATCH"

#############################
#### Aurora: PBS SUPPORT ####
#############################
export FPRO_RESERVATION_ID="INVALID"
export FPRO_SHMEM_EXEC_PBS="oshrun"
export FPRO_SHMEM_EXEC_PBS_ISHM="mpiexec.hydra"
export FPRO_PBS_MAX_TIME="00:15:00"

