# BUILD and RUN
**Intel(R) VTune(TM) Fabric Profiler  
VERSION 2.0.0  
ONLY FOR EVALUATION USE**

0. Introduction
1. Mark up your source code to define Fabric Profiler regions of interest
2. Build a dynamically-linked application with Fabric Profiler instrumentation
3. Merge the trace files
4. View the traces in the analyzer
5. Quick Start Analyzers
6. Fabric Profiler configuration parameters

**0. Introduction**
This release of the Fabric Profiler tool is a binary release.  This document contains the details that we hope will allow you to successfully run Fabric Profiler-instrumented applications and view meaningful results with the included analyzers.

The Fabric Profiler data collector is implemented as a shared library that intercepts Intel® SHMEM v1.0.0 and Sandia OpenSHMEM calls. It is responsible for collecting runtime data about the SHMEM application and fabric response.

The analyzers are a collection of MATLAB applications that run with the freely available MATLAB runtime.  See README.OVERVIEW.md for an overview of the Fabric Profiler components.
Running the analyzers is simply a matter copying them from the release package to the Linux or Windows machine of your choice and installing the freely-available MATLAB Runtime.  See README.ANALYZER for more information on using the analyzer.

The rest of this file describes how to run applications with the Fabric Profiler data collector and generate traces that can be viewed with the analyzers.
We assume you've installed the Fabric Profiler using the instructions in the INSTALL.md file.

**1. Mark up your source code to define Fabric Profiler regions of interest** *(optional)*

Fabric Profiler regions are optional, but they can improve analysis and presentation of results by bookending critical sections of code. Regions are labeled and highlighted in the analyzer displays. To add Fabric Profiler regions to your code:

   a. Include the header file "esp.h" found in *$ESP_ROOT/include*.
   
   b. Bookend regions of interest with these statements:

     esp_enter("regionA");
     esp_exit("regionA");
   *NOTE: You must use the same name for enter and exit.

  c. Re-build your application.
	**Note**: Region markers should not be nested or interleaved.  Also, you should match the names used in the esp_enter() and esp_exit() calls as shown above.

**2. Build a dynamically-linked application with Fabric Profiler instrumentation**
You do not need to rebuild your application unless you've added Fabric Profiler regions to your source code.  The profiler is loaded dynamically with the help of the ***fpro*** helper script.  This script attempts to hide some of the gory details, but invariably you'll want to become familiar with it when things don't quite go to plan.

**3. Merge the trace files**
The Fabric Profiler completion banner displays the path to the trace files.  Sections below describes how the data collector chooses a trace path based on envt vars.

- To merge traces, run the following commands in-order:

		$ESP_ROOT/bin/collector/mergeFuncFile {path to traces} {path to parallel app}
		$ESP_ROOT/bin/collector/mergeProfileFile {path to traces}
		$ESP_ROOT/bin/collector/mergePutFile {path to traces} {path to parallel app}

**4. View the traces in the analyzer.**
Copy the trace files from the top-level of the traces directory at *$ESP_TRACE_PATH* (they have ".uc1" in their name) to the machine where you have copied the analyzers and view them there. (You will see subdirectories in the trace directory and you do not need those. Those contain per-PE files that were merged into single files in the traces directory.)
When you run any of the analyzers they will query you for the path to a particular trace file. Point it to the trace files you copied.

**5. Quick Start Analyzers:**

__ANALYZER REQUIREMENTS__

* [MATLAB Runtime R2021b (9.11)](https://www.mathworks.com/products/compiler/matlab-runtime.html) for Linux.

* Run your SHMEM application with Fabric Profiler's Collector to generate required trace files.

* Four Trace Files:

	  {trace-file-prefix}.uc1.put
	  {trace-file-prefix}.uc1.profile
	  {trace-file-prefix}.uc1.hfi
	  {trace-file-prefix}.uc1.func

	Traces are found under the $ESP_TRACE_PATH directory.

	When opening a trace in the analyzer(s) the directory must contain ALL FOUR traces.
	Feel free to move this directory to a more accessible location.

__RUN ANALYZER__

The Analyzer contains one binary for Linux. Located under: **$ESP_ROOT/bin/analyzer**

	Linux Binary Name:   "fpro_analyzer"
          
[Terminal Execution]
    
	> Open terminal
	> Navigate to $ESP_ROOT/bin/analyzer
	> Execute: ./fpro_analyzer

__ANALYZER DOCS__

For more information see:
    
    README.ANALYZER.md


**6. Fabric Profiler configuration parameters**
Please start with setMyVars.sh.  This BASH script can be sourced once edited to initialize the rather large set of required parameters.

**Ones that need to change**:
- ESP_ROOT - the basis of other paths, set it to the base directory where you decompressed the Fabris Profiler package. 
- ESP_TRACE_PATH - Define which *existing* directory the traces should be deposited into.  It is important to create this directory first.

**Some that you may want to change/investigate:**
 - ESP_WORK - By default, the data collector will write trace files to `$ESP_ROOT/results`
 - ESP_VERBOSITY_LEVEL - If set to 100 or greater, the data collector will write log files while the application is running.
 - ESP_LOG_PATH - Defaults to `$ESP_WORK/logs`
 - ESP_FUNCTION_TRACE_COUNT - Increase this if you run your instrumented app and get a message that you ran out of space for the function trace.  It is the maximum number of instrumented SHMEM calls by any process at run time.
 - ESP_TRACE_BUFFER_SIZE - Increase this if you get an error message that there was insufficient memory to store the "put" file traces.
 - ESP_HFI_TRACE_BUFFER_SIZE - This is for the HFI trace file size.
 - ESP_VERBOSITY_LEVEL - When set to 100 or greater, log files will be written by the data collector.  When the value is 1, Fabric Profiler start and end banners will be displayed in the application output.  When the value is 0, Fabric Profiler is quiet.  By default it is set to 100 so you can see what's going on.
 - ESP_SAMPLE_RATE - The frequency, in samples per second, at which the HFI data collector reads the network card counters. Note that at the time of release, CXI network counters are counting once a second - changing this value will not help (we're already oversampling with the default setting).  It is expected that a future driver update will adjust this behavior and more granular updates will be realized.

