/********************************************/
/* esp_region.h                             */
/*                                          */
/* implement region markers and user names  */
/* for process threads and SHMEM contexts   */
/*                                          */
/* 15-Nov-2017                              */
/*                                          */
/********************************************/

#ifndef ESP_REGION_H
#define ESP_REGION_H

#include "shmem.h"

static int ESP_START_REGION             =0x5a5a0f0f;
static int ESP_END_REGION               =0x5a5af0f0;
static int ESP_CONTEXT_NAME             =0xa5a50f0f;
static int ESP_THREAD_NAME              =0xa5a5f0f0;

// Call to mark the start of a source code region with a name
//
static inline void esp_enter(const char *name) {
  shmem_put8((void*)&ESP_START_REGION, name, 0, 0);
}
// Call to mark the end of the source code region with the identical name
// that was used in "esp_enter()".
//
static inline void esp_exit(const char *name) {
  shmem_put8((void*)&ESP_END_REGION, name, 0, 0);
}
// Call from a process thread to associate the provided name with the thread.
//
static inline void esp_set_thread_name(const char *name) {
  shmem_put8((void*)&ESP_THREAD_NAME, name, 0, 0);
}

// Call from user app to give a name to a context.  Cast the context
// as type size_t.  (We can not use shmem_ctx_t in a user header file
// because we can require them to use a SHMEM version supporting
// shmem_ctx_t.)
static inline void esp_set_context_name(const char *name, size_t ctx) {
  shmem_put8((void*)&ESP_CONTEXT_NAME, name, ctx, 0);
}

#endif /* ESP_REGION_H */
