/*
 * Copyright (C) 2013 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/

#ifndef _APIC_H_
#define _APIC_H_

typedef U64 *PHYSICAL_ADDRESS;
/**
// Data Types and Macros
*/
/*
// APIC registers and constants
*/
// APIC base MSR
#define DRV_APIC_BASE_MSR   0x001b

// APIC registers
#define DRV_APIC_LCL_ID     0x0020
#define DRV_APIC_LCL_TSKPRI 0x0080
#define DRV_APIC_LCL_PPR    0x00a0
#define DRV_APIC_LCL_EOI    0x00b0
#define DRV_APIC_LCL_LDEST  0x00d0
#define DRV_APIC_LCL_DSTFMT 0x00e0
#define DRV_APIC_LCL_SVR    0x00f0
#define DRV_APIC_LCL_ICR    0x0300
#define DRV_APIC_LVT_TIMER  0x0320
#define DRV_APIC_LVT_PMI    0x0340
#define DRV_APIC_LVT_LINT0  0x0350
#define DRV_APIC_LVT_LINT1  0x0360
#define DRV_APIC_LVT_ERROR  0x0370

#define DRV_APIC_LCL_ID_MSR     0x802
#define DRV_APIC_LCL_TSKPRI_MSR 0x808
#define DRV_APIC_LCL_PPR_MSR    0x80a
#define DRV_APIC_LCL_EOI_MSR    0x80b
#define DRV_APIC_LCL_LDEST_MSR  0x80d
#define DRV_APIC_LCL_DSTFMT_MSR 0x80e
#define DRV_APIC_LCL_SVR_MSR    0x80f
#define DRV_APIC_LCL_ICR_MSR    0x830
#define DRV_APIC_LVT_TIMER_MSR  0x832
#define DRV_APIC_LVT_PMI_MSR    0x834
#define DRV_APIC_LVT_LINT0_MSR  0x835
#define DRV_APIC_LVT_LINT1_MSR  0x836
#define DRV_APIC_LVT_ERROR_MSR  0x837

// masks for LVT
#define DRV_LVT_MASK        0x10000
#define DRV_LVT_EDGE        0x00000
#define DRV_LVT_LEVEL       0x08000
#define DRV_LVT_EXTINT      0x00700
#define DRV_LVT_NMI         0x00400

// task priorities
#define DRV_APIC_TSKPRI_LO  0x0000
#define DRV_APIC_TSKPRI_HI  0x00f0

#define DRV_X2APIC_ENABLED  0xc00LL

//// Interrupt vector for PMU overflow event
//
//     Choose the highest unused IDT vector possible so that our
//     callback routine runs at the highest priority allowed;
//     must avoid using pre-defined vectors in,
//              include/asm/irq.h
//              include/asm/hw_irq.h
//              include/asm/irq_vectors.h
//
#define CPU_PERF_VECTOR     (NRSVIDT + 1)

// Has the APIC Been enabled
#define DRV_APIC_BASE_GLOBAL_ENABLED(a)    ((a) & 1 << 11)
#define DRV_APIC_VIRTUAL_WIRE_ENABLED(a)   ((a) & 0x100)

extern U32 drv_x2apic_enabled;
/**
// Function Declarations
*/

/*
// APIC control functions
*/
extern VOID APIC_Disable_PMI(VOID);
extern VOID APIC_Deinit_Phase1(int cpu_idx);
extern VOID APIC_Ack_Eoi(VOID);
extern VOID APIC_Enable_Pmi(VOID);
extern VOID APIC_Init(PVOID param);
extern VOID APIC_Install_Interrupt_Handler(PVOID param);
extern VOID APIC_Unmap(PVOID addr);

#endif
