

package require -exact qsys 14.0

set_module_property NAME aoc_sim_stream_sink_dpi_bfm
set_module_property VERSION 1.0
set_module_property INTERNAL false
set_module_property GROUP Accelerators
set_module_property DISPLAY_NAME aoc_sim_stream_sink_dpi_bfm
set_module_property INSTANTIATE_IN_SYSTEM_MODULE true
set_module_property EDITABLE true

set_module_property ELABORATION_CALLBACK elaborate


# 
# file sets
# 
# only sim, no synth
add_fileset SIM_VERILOG SIM_VERILOG "" ""
set_fileset_property SIM_VERILOG TOP_LEVEL aoc_sim_stream_sink_dpi_bfm
set_fileset_property SIM_VERILOG ENABLE_RELATIVE_INCLUDE_PATHS false
add_fileset_file aoc_sim_stream_sink_dpi_bfm.sv SYSTEM_VERILOG PATH aoc_sim_stream_sink_dpi_bfm.sv


add_parameter COMPONENT_NAME STRING "dut" "The name of the component that contains the interface"
set_parameter_property COMPONENT_NAME DEFAULT_VALUE "dut"
set_parameter_property COMPONENT_NAME DISPLAY_NAME COMPONENT_NAME
set_parameter_property COMPONENT_NAME TYPE STRING
set_parameter_property COMPONENT_NAME UNITS None
set_parameter_property COMPONENT_NAME DESCRIPTION "The name of the component that contains the interface"
set_parameter_property COMPONENT_NAME HDL_PARAMETER true


add_parameter INTERFACE_NAME STRING "a" "The report name for the component's stream interface"
set_parameter_property INTERFACE_NAME DEFAULT_VALUE "a"
set_parameter_property INTERFACE_NAME DISPLAY_NAME INTERFACE_NAME
set_parameter_property INTERFACE_NAME TYPE STRING
set_parameter_property INTERFACE_NAME UNITS None
set_parameter_property INTERFACE_NAME DESCRIPTION "The report name for the component's stream interface"
set_parameter_property INTERFACE_NAME HDL_PARAMETER true


add_parameter INTERFACE_MANGLED_NAME STRING "" "The component's stream interface this dpi bfm connects to"
set_parameter_property INTERFACE_MANGLED_NAME DEFAULT_VALUE ""
set_parameter_property INTERFACE_MANGLED_NAME DISPLAY_NAME INTERFACE_MANGLED_NAME
set_parameter_property INTERFACE_MANGLED_NAME TYPE STRING
set_parameter_property INTERFACE_MANGLED_NAME UNITS None
set_parameter_property INTERFACE_MANGLED_NAME DESCRIPTION "The component's stream interface this dpi bfm connects to"
set_parameter_property INTERFACE_MANGLED_NAME HDL_PARAMETER true


add_parameter STREAM_DATAWIDTH INTEGER 1 "The datawidth of the component's stream interface"
set_parameter_property STREAM_DATAWIDTH DEFAULT_VALUE 1
set_parameter_property STREAM_DATAWIDTH DISPLAY_NAME STREAM_DATAWIDTH
set_parameter_property STREAM_DATAWIDTH TYPE INTEGER
set_parameter_property STREAM_DATAWIDTH UNITS None
set_parameter_property STREAM_DATAWIDTH DESCRIPTION "The datawidth of the component's stream interface"
set_parameter_property STREAM_DATAWIDTH HDL_PARAMETER true

add_parameter USE_AXI_INTERFACE INTEGER 0 "Use AXI-4 streaming interface instead of avalon interface"
set_parameter_property USE_AXI_INTERFACE DEFAULT_VALUE 0
set_parameter_property USE_AXI_INTERFACE DISPLAY_NAME USE_AXI_INTERFACE
set_parameter_property USE_AXI_INTERFACE TYPE INTEGER
set_parameter_property USE_AXI_INTERFACE UNITS None
set_parameter_property USE_AXI_INTERFACE DESCRIPTION "Use AXI-4 streaming interface instead of avalon interface"
set_parameter_property USE_AXI_INTERFACE HDL_PARAMETER false

add_parameter USE_DATA_PORT INTEGER 1 "Use the data port; otherwise just stall/valid"
set_parameter_property USE_DATA_PORT DEFAULT_VALUE 1
set_parameter_property USE_DATA_PORT DISPLAY_NAME USE_DATA_PORT
set_parameter_property USE_DATA_PORT TYPE INTEGER
set_parameter_property USE_DATA_PORT UNITS None
set_parameter_property USE_DATA_PORT DESCRIPTION "Use the data port; otherwise just stall/valid"
set_parameter_property USE_DATA_PORT HDL_PARAMETER false

add_parameter READY_LATENCY INTEGER 0 "The ready latency of the component's stream interface"
set_parameter_property READY_LATENCY DISPLAY_NAME READY_LATENCY
set_parameter_property READY_LATENCY UNITS None
set_parameter_property READY_LATENCY HDL_PARAMETER true

add_parameter STREAM_BITSPERSYMBOL INTEGER 1 "The symbol width in the component's stream data bus"
set_parameter_property STREAM_BITSPERSYMBOL DISPLAY_NAME STREAM_BITSPERSYMBOL
set_parameter_property STREAM_BITSPERSYMBOL UNITS None
set_parameter_property STREAM_BITSPERSYMBOL HDL_PARAMETER true

add_parameter USES_PACKETS INTEGER 0 "Uses startofpacket and endofpacket signals"
set_parameter_property USES_PACKETS DISPLAY_NAME USES_PACKETS
set_parameter_property USES_PACKETS UNITS None
set_parameter_property USES_PACKETS HDL_PARAMETER false

add_parameter EMPTY_WIDTH INTEGER 0 "The width of the empty signal"
set_parameter_property EMPTY_WIDTH DISPLAY_NAME EMPTY_WIDTH
set_parameter_property EMPTY_WIDTH UNITS None
set_parameter_property EMPTY_WIDTH HDL_PARAMETER true

add_parameter USER_WIDTH INTEGER 0 "The width of the AXI streaming USER signal"
set_parameter_property USER_WIDTH DISPLAY_NAME USER_WIDTH
set_parameter_property USER_WIDTH UNITS None
set_parameter_property USER_WIDTH HDL_PARAMETER true

add_parameter FIRST_SYMBOL_IN_HIGH_ORDER_BITS INTEGER 0 "First symbol in high order bits"
set_parameter_property FIRST_SYMBOL_IN_HIGH_ORDER_BITS DISPLAY_NAME FIRST_SYMBOL_IN_HIGH_ORDER_BITS
set_parameter_property FIRST_SYMBOL_IN_HIGH_ORDER_BITS UNITS None
set_parameter_property FIRST_SYMBOL_IN_HIGH_ORDER_BITS HDL_PARAMETER true

add_interface clock clock end
set_interface_property clock ENABLED true
add_interface_port clock clock clk Input 1

add_interface reset reset end
set_interface_property reset associatedClock clock
add_interface_port reset resetn reset_n Input 1

add_interface clock2x clock end
set_interface_property clock2x ENABLED true
add_interface_port clock2x clock2x clk Input 1

add_interface dpi_control_bind conduit end
set_interface_property dpi_control_bind ENABLED true
add_interface_port dpi_control_bind do_bind conduit Input 1

add_interface dpi_control_enable conduit end
set_interface_property dpi_control_enable ENABLED true
add_interface_port dpi_control_enable enable conduit Input 1

add_interface dpi_control_stream_active conduit start
set_interface_property dpi_control_stream_active ENABLED true
add_interface_port dpi_control_stream_active stream_active conduit Output 1

### Elaboration callback
proc elaborate {} {
  ### interface sink
  # case:298272 - restrictions on the maximum datawidth prevent us from going beyond 4k wide interfaces
  set data_width [ get_parameter_value STREAM_DATAWIDTH ]
  set ready_latency [ get_parameter_value READY_LATENCY ]
  set use_axi_interface [ get_parameter_value USE_AXI_INTERFACE ]
  set use_data_port [ get_parameter_value USE_DATA_PORT ]
  set bits_per_symbol [ get_parameter_value STREAM_BITSPERSYMBOL ]
  set uses_packets [ get_parameter_value USES_PACKETS]
  set empty_width [ get_parameter_value EMPTY_WIDTH ]
  set user_width [ get_parameter_value USER_WIDTH ]
  set first_symbol_in_high_order_bits [ get_parameter_value FIRST_SYMBOL_IN_HIGH_ORDER_BITS ]

  #setup interface, port, and port role names
  set data_intf sink
  set ready_intf sink
  set valid_intf sink
  set eop_intf sink
  if { $use_axi_interface == 1 } {
    set user_intf sink
  } else {
    set sop_intf sink
    set empty_intf sink
  }

  set data_port sink_data
  set ready_port sink_ready
  set valid_port sink_valid
  set eop_port sink_endofpacket
  if { $use_axi_interface == 1 } {
    set user_port sink_user
  } else {
    set sop_port sink_startofpacket
    set empty_port sink_empty
  }

  set data_port_role data
  set ready_port_role ready
  set valid_port_role valid
  set eop_port_role endofpacket
  if { $use_axi_interface == 1 } {
    set data_port_role tdata
    set ready_port_role tready
    set valid_port_role tvalid
    # Use eop port for tlast
    set eop_port_role tlast
    set user_port_role tuser
  } else {
    set sop_port_role startofpacket
    set empty_port_role empty
  }


  #setup interfaces
  if { $data_width > 8192 || $use_data_port == 0 } {
    # Avalon streaming interface data width is between 1 to 8192, update if the upper bound changed
    add_interface $data_intf conduit sink
    set_interface_property $data_intf associatedClock clock
    set_interface_property $data_intf associatedReset reset
  } elseif { $use_axi_interface == 1 } {
    add_interface $data_intf axi4stream sink
    set_interface_property $data_intf associatedClock clock
    set_interface_property $data_intf associatedReset reset
  } else {
    add_interface $data_intf avalon_streaming sink
    set_interface_property $data_intf associatedClock clock
    set_interface_property $data_intf associatedReset reset
    set_interface_property $data_intf maxChannel 0
    set_interface_property $data_intf readyLatency ${ready_latency}
    set_interface_property $data_intf dataBitsPerSymbol $bits_per_symbol
    set_interface_property $data_intf firstSymbolInHighOrderBits $first_symbol_in_high_order_bits
  }

  # add ports
  if { $use_data_port != 0 } {
    add_interface_port $data_intf $data_port $data_port_role Input $data_width
  }
  add_interface_port $ready_intf $ready_port $ready_port_role Output 1
  add_interface_port $valid_intf $valid_port $valid_port_role Input 1
  add_interface_port $eop_intf $eop_port $eop_port_role Input 1
  if { $use_axi_interface == 1 } {
    add_interface_port $user_intf $user_port $user_port_role Input [expr $user_width > 0 ? $user_width : 1]
  } else {
    add_interface_port $sop_intf $sop_port $sop_port_role Input 1
    add_interface_port $empty_intf $empty_port $empty_port_role Input [expr $empty_width > 0 ? $empty_width : 1]
  }

  if { $use_axi_interface == 0 } {
    if { $uses_packets == 0 } {
      set_port_property $sop_port TERMINATION 1
      set_port_property $sop_port TERMINATION_VALUE 0
    }
    if { $empty_width == 0 } {
      set_port_property $empty_port TERMINATION 1
      set_port_property $empty_port TERMINATION_VALUE 0
    }
  } else {
    if { $user_width == 0} {
      set_port_property $user_port TERMINATION 1
      set_port_property $user_port TERMINATION_VALUE 0
    }
  }

  if { $uses_packets == 0 } {
    set_port_property $eop_port TERMINATION 1
    set_port_property $eop_port TERMINATION_VALUE 0
  }
}
