#!/usr/bin/env python
from functools import reduce
import inspect
from operator import getitem
import os.path
import sys
from debug import myprint
from apm_helpers.messages import Messages as msg
APM_CONFIG_DIR=''
APM_CONFIG_NAME='apm_config'
def get_apm_root():
 return os.path.realpath(os.path.abspath(os.path.join(os.path.split(inspect.getfile(inspect.currentframe()))[0],'..',)))
class add_path():
 def __init__(self,path):
  self.path=path
 def __enter__(self):
  sys.path.insert(0,self.path)
 def __exit__(self,exc_type,exc_value,traceback):
  try:
   sys.path.remove(self.path)
  except ValueError:
   pass
def get_toml_dict_name(path):
 return path.replace('.toml','')
def get_from_obfuscated_config(config_path):
 with add_path(APM_CONFIG_DIR):
  from apm_config import config as obfuscated_config
  file_name=get_toml_dict_name(config_path)
  return obfuscated_config.get(file_name,{})
class ConfigurationFile:
 def __init__(self,path,target,obfuscated):
  self.path=path
  self.target=target
  self.obfuscated=obfuscated
 def __repr__(self):
  return "(ConfigurationFile) Path: {} | Target: {} | Obfuscated: {}".format(self.path,self.target,self.obfuscated)
 def __str__(self):
  return repr(self)
 def load(self,fail_during_exception):
  if not self.obfuscated:
   import toml
   try:
    return toml.load([self.path])
   except Exception as e:
    if fail_during_exception:
     myprint(msg.ERROR_INVALID_TOML.format(self.path,e),0,severity=4)
    else:
     return{}
  else:
   return get_from_obfuscated_config(self.path)
class ConfigurationLoader:
 def __init__(self,arch,pwd_path,enable_obfuscated=True,enable_search_in_cwd=True):
  self.arch=arch
  self.default_config_files=["default.toml"]
  self.possible_paths=[pwd_path]
  configs_path=os.path.join(pwd_path,'accelerators',self.arch,'configs')
  if os.path.exists(configs_path):
   self.possible_paths.append(configs_path)
  if enable_search_in_cwd:
   if not os.path.samefile(pwd_path,sys.path[0]):
    configs_path=os.path.join(sys.path[0],'accelerators',self.arch,'configs')
    if os.path.exists(configs_path):
     self.possible_paths.append(configs_path)
  if enable_obfuscated:
   from apm_helpers.compatibility import VERSIONED_MODULE_PATH,LIB_SUFFIX
   APM_ROOT=get_apm_root()
   APM_VERSIONED_ROOT=os.path.join(APM_ROOT,VERSIONED_MODULE_PATH)
   global APM_CONFIG_DIR
   APM_CONFIG_DIR=os.path.join(APM_ROOT,'accelerators',self.arch,'configs')
   obfuscated_config_path=os.path.join(APM_CONFIG_DIR,"{}".format(APM_CONFIG_NAME)+LIB_SUFFIX)
   if os.path.exists(obfuscated_config_path):
    self.obfuscated_config_exists=True
   else:
    APM_CONFIG_DIR=os.path.join(APM_VERSIONED_ROOT,'accelerators',self.arch,'configs')
    obfuscated_config_path=os.path.join(APM_CONFIG_DIR,"{}".format(APM_CONFIG_NAME)+LIB_SUFFIX)
    self.obfuscated_config_exists=os.path.exists(obfuscated_config_path)
  else:
   self.obfuscated_config_exists=False
 def find_file(self,name,fail_not_found=False):
  res=self.find_file_internal(name)
  if not res and not name.endswith('.toml'):
   res=self.find_file_internal(name+'.toml')
  if not res and fail_not_found:
   myprint(msg.ERROR_CONFIG_NOT_FOUND.format(name,"\n  > ".join(self.possible_paths)),severity=4)
  return res
 def find_file_internal(self,name):
  if name and os.path.exists(name):
   myprint(msg.INFO_CONFIG_FOUND.format(name))
   return name
  for path in self.possible_paths:
   candidate_file=os.path.join(path,name)
   if os.path.exists(candidate_file):
    myprint(msg.INFO_CONFIG_FOUND_AT.format(name,os.path.abspath(candidate_file)))
    return candidate_file
  return None
 def resolve_configuration_file(self,config_file_name,fail_not_found):
  config_file=self.find_file(config_file_name,fail_not_found=fail_not_found)
  if config_file:
   return ConfigurationFile(os.path.abspath(config_file),[],False)
  elif self.obfuscated_config_exists:
   return ConfigurationFile(config_file_name,[],True)
 def resolve_inclusions(self,configs_to_process):
  all_config_files=[]
  configs=[(cfg,[])for cfg in configs_to_process]
  configs.reverse()
  while configs:
   cfg_file,walk=configs.pop()
   config=cfg_file.load(fail_during_exception=True)
   if config and 'include' in config:
    myprint(msg.DEBUG_INCLUSIONS_FOUND.format(cfg_file.path.replace('.toml',''),config.get('short_description','N/A'),),)
    config['include'].reverse()
    for inclusion in config['include']:
     inclusion_file_name=inclusion['filename']
     inclusion_cfg_file=self.resolve_configuration_file(inclusion_file_name,not self.obfuscated_config_exists or not get_from_obfuscated_config(inclusion_file_name))
     if not inclusion_cfg_file.path in walk:
      if 'root' in inclusion:
       inclusion_cfg_file.target=inclusion['root']
      configs.append((inclusion_cfg_file,walk+[inclusion_cfg_file.path]))
      myprint(msg.DEBUG_INCLUDE_CONFIG_FILE.format(inclusion))
     else:
      myprint(msg.ERROR_DUPLICATE_CONFIGS.format(inclusion_cfg_file.path,),severity=4)
   all_config_files.append(cfg_file)
  return all_config_files
 def load_configuration(self,config_file_names):
  config_files=[self.resolve_configuration_file(f,not self.obfuscated_config_exists)for f in self.default_config_files]
  for config_file_name in config_file_names:
   config_files.append(self.resolve_configuration_file(config_file_name,not self.obfuscated_config_exists or not get_from_obfuscated_config(config_file_name)))
  config_files=self.resolve_inclusions(config_files)
  return self.load_aggregate_config(config_files)
 def load_aggregate_config(self,config_files):
  aggregate_config={}
  for config_file in config_files:
   config=config_file.load(fail_during_exception=True)
   if config_file.obfuscated:
    myprint(msg.INFO_FOUND_APM_LIBRARY_CONFIG.format(config_file.path),)
   if config_file.target:
    root=aggregate_config
    for x in config_file.target:
     root=root.setdefault(x,{})
    root.update(config)
   else:
    aggregate_config.update(config)
  return aggregate_config
def update_configuration(config,update_line):
 import toml
 decoder=toml.TomlDecoder()
 data={}
 leveltrace=[]
 decoder.load_line(update_line,data,{},{},leveltrace)
 root_config=config
 for key in leveltrace:
  data=data[key]
  try:
   root_config=root_config[key]
  except KeyError:
   root_config[key]={}
   root_config=root_config[key]
 root_config.update(data)
