import functools
import inspect
list_of_caches=[]
def cached(func):
 @functools.wraps(func)
 def wrapper_cached(*args,**kwargs):
  if wrapper_cached.cache is None:
   wrapper_cached.cache=func(*args,**kwargs)
  return wrapper_cached.cache
 wrapper_cached.cache=None
 return wrapper_cached
def cached_with_key(key_getter):
 def decorator_cached_with_key(func):
  func_id=func.__module__,func.__name__
  if func_id not in cached_with_key.cached_func_arg_spec:
   if not cached_with_key.unknown_func_handler or not cached_with_key.unknown_func_handler(func,func_id):
    @functools.wraps(func)
    def wrapper_cached_with_key(*args,**kwargs):
     return func(*args,**kwargs)
    return wrapper_cached_with_key
  @functools.wraps(func)
  def wrapper_cached_with_key(*args,**kwargs):
   fspec=wrapper_cached_with_key.func_spec
   all_args={}
   if fspec[1]:
    all_args.update({k:v for k,v in zip(reversed(fspec[0]),reversed(fspec[1]))})
   all_args.update({k:v for k,v in zip(fspec[0],args)})
   all_args.update(kwargs)
   key_args=[all_args[n]for n in wrapper_cached_with_key.positionals]
   key_kwargs={n:all_args[n]for n in wrapper_cached_with_key.kwargs}
   key=key_getter(*key_args,**key_kwargs)
   if key in wrapper_cached_with_key.cache:
    return wrapper_cached_with_key.cache[key]
   wrapper_cached_with_key.cache[key]=res=func(*args,**kwargs)
   return res
  wrapper_cached_with_key.cache={}
  list_of_caches.append(wrapper_cached_with_key.cache)
  wrapper_cached_with_key.func_spec=cached_with_key.cached_func_arg_spec[func_id]
  kg_argnames,_,_,kg_defaults=inspect.getargspec(key_getter)
  f_argnames=cached_with_key.cached_func_arg_spec[func_id][0]
  if not kg_defaults:
   pos_count=len(kg_argnames)
  else:
   pos_count=len(kg_argnames)-len(kg_defaults)
  wrapper_cached_with_key.positionals=f_argnames[:pos_count]
  wrapper_cached_with_key.kwargs=f_argnames[pos_count:]
  return wrapper_cached_with_key
 return decorator_cached_with_key
cached_with_key.unknown_func_handler=None
try:
 from apm_helpers.argspec import cached_func_arg_spec
 cached_with_key.cached_func_arg_spec=cached_func_arg_spec
except ImportError:
 cached_with_key.cached_func_arg_spec={}
 def add_func_arg_spec(func,func_id):
  args,_,_,defaults=inspect.getargspec(func)
  cached_with_key.cached_func_arg_spec[func_id]=(tuple(args),defaults or tuple())
  return True
 cached_with_key.unknown_func_handler=add_func_arg_spec
TURN_OFF_CACHE=False
if TURN_OFF_CACHE:
 def cached(func):
  print('Applied decorator "cached" to function "{}" in no-cache mode'.format(func.__name__))
  return func
 def cached_with_key(key_getter):
  def decorator(func):
   print('Applied decorator "cached_with_key" to function "{}" in no-cache mode'.format(func.__name__))
   return func
  return decorator
def cached_by_params(*names):
 def key_getter(**kwargs):
  return tuple(kwargs[n]for n in names)
 return cached_with_key(key_getter)
cached_cls_prop=cached_with_key(lambda this:this)
def cached_cls_prop_extra(*names):
 def key_getter(this,**kwargs):
  return(this,)+tuple(kwargs[n]for n in names)
 return cached_with_key(key_getter)
def row_by_key_column(this,row,**kwargs):
 if not row:
  return None
 return(row['key_column'],row.is_bottomup)
cached_cls_row_prop=cached_with_key(row_by_key_column)
def cached_cls_row_prop_extra(*names):
 def key_getter(this,row,**kwargs):
  if row is None:
   return None
  return(row['key_column'],row.is_bottomup,)+tuple(kwargs[n]for n in names)
 return cached_with_key(key_getter=key_getter)
def bu_row_by_unique_index(this,row,bu_row,**kwargs):
 if not bu_row:
  return None
 return(bu_row['unique_index'],bu_row.is_bottomup)
cached_cls_bu_row_prop=cached_with_key(bu_row_by_unique_index)
def static_row_by_key_column(row,**kwargs):
 if not row:
  return None
 return(row['key_column'],row.is_bottomup)
cached_by_key_column=cached_with_key(static_row_by_key_column)
def static_row_by_unique_index(row,**kwargs):
 if not row:
  return None
 return(row['unique_index'],row.is_bottomup)
cached_by_unique_index=cached_with_key(static_row_by_unique_index)
def cached_by_key_column_and_custom_fields(*names):
 def key_getter(row,**kwargs):
  if row is None:
   return None
  return(row['key_column'],row.is_bottomup,)+tuple(kwargs[n]for n in names)
 return cached_with_key(key_getter)
def clear_all_caches():
 for cache in list_of_caches:
  cache.clear()
