from apm_helpers.justifiedbool import JustifiedBool
from apm_helpers.convert import work_size_to_str
from apm_helpers.messages import Messages as msg
NonOffloadReasons=msg.NonOffload.Reasons
class Source:
 begin=0
 end=0
 content=[]
class Traffic:
 def __init__(self):
  self.by_level=[]
  self.carm=(0,0)
  self.footprint=(0,0)
 @property
 def has_cache_misses(self):
  return any(x for y in self.by_level for x in y)
 def copy(self):
  res=Traffic()
  res.by_level=self.by_level.copy()
  res.carm=self.carm
  res.footprint=self.footprint
  return res
class BaseRow(object):
 has_reuse_data=False
 def __init__(self,row,key_column,minor_rows):
  self._row=row
  self._key=self.get_key(row)
  self._all_rows=[row]+list(minor_rows)
  self._data={}
  self._diagnostics=[]
  self._is_bottomup=True
  self._children=[]
  self._parent=None
  self._basic_blocks=[]
  self._is_aggregated=False
  self._aggregated=None
  self._subitems=[]
  self._instruction_mix={}
  self._atomic_counts=[]
  self._source=Source()
  self._memory_objects=None
  self._data_transferred={'shared':0.0,'in':0.0,'out':0.0,'inout':0.0}
  self._total_strides=[]
  self._mem_stat=None
  self._memory_footprint=0
  self._code_size=0
  self._baseline_cache_sizes={}
  self._cacheconfig_target=None
  self._is_executed=False
  self._is_function=False
  self._is_user_function=False
  self._is_loop=False
  self._is_vector_loop=False
  self._is_offload_candidate=JustifiedBool(False,NonOffloadReasons.INTERNAL_ERROR)
  self._is_scalar=True
  self._callchain_weight=1.0
  self._module_type='USR'
  self._nesting_level=0
  self._data['dependency_type']=''
  self._data['dependency_key']=''
  self._data['has_dependency']=False
  self._data['dependent_iterations_distance']=float('inf')
  self._data['programming_model']=''
  self._data['baseline_device']=None
  self._data['vector_length']=1
  self._data['simd_width']=1
  self._data['global_atomic_accesses']=0
  self._data['local_atomic_accesses']=0
  self._data['barrier_accesses']=0
  self._overriden_metrics={}
  for x in('total_time_in_mpi','total_time_in_system_modules','total_time_in_ignored','source_execution_count','source_iterations','instance_count','execution_count',):
   self._data[x]=0.0
  self._data['global_size']=None
  self._data['local_size']=None
  self._traffic={}
  self._ins_mix={}
  self._lazy_items={}
  self._is_marked_up=False
  self._is_selected=False
  self._selected_by=None
  self._tostring={'global_size':work_size_to_str,'local_size':work_size_to_str,}
 def __repr__(self):
  return '{}({}, index={})'.format(type(self).__name__,self._data['function_call_sites_and_loops'],self._data['key_column'])
 def set_base_memory_config(self,baseline_cache_config):
  for mem_type,cache_sizes in baseline_cache_config.items():
   if cache_sizes:
    res=[cache_sizes[0]]
    for x in cache_sizes[1:]:
     res.append(res[-1]+x)
    self._baseline_cache_sizes[mem_type]=res
  if not self._baseline_cache_sizes and not self._cacheconfig_target:
   self._diagnostics.append('Can\'t load baseline cache configuration')
 def __hash__(self):
  return hash(self._key)
 def __eq__(self,other):
  if isinstance(other,BaseRow):
   return type(self)==type(other)and self._key==other._key
  return NotImplemented
 def str(self,key):
  value=self._data[key]
  try:
   return self._tostring[key](value)
  except KeyError:
   return str(value)
 def get(self,key,default=None):
  return self._data.get(key,default)
 def get_overriden_metrics(self):
  yield from((k,v[0],v[1],self._data[k])for k,v in self._overriden_metrics.items())
 @property
 def is_bottomup(self):
  return self._is_bottomup
 @property
 def is_aggregated(self):
  return self._is_aggregated
 @property
 def aggregated(self):
  return self._aggregated
 def __getitem__(self,key):
  if key in self._overriden_metrics:
   return self._overriden_metrics[key][0]
  if key in self._lazy_items:
   self._gather_lazy_item(key)
  return self._data[key]
 def __contains__(self,key):
  return key in self._data
 @property
 def traffic(self):
  return self._traffic
 @property
 def has_traffic(self):
  return any(x.has_cache_misses for x in self._traffic.values())
 @property
 def diagnostics(self):
  return self._diagnostics[:]
 @property
 def children(self):
  return self._children[:]
 @property
 def parent(self):
  return self._parent
 @property
 def basic_blocks(self):
  return[]
 @property
 def source(self):
  return self._source
 @property
 def has_dependency(self):
  return self['has_dependency']
 @property
 def memory_objects(self):
  if self._memory_objects is None:
   self._memory_objects=[]
   if self._row:
    try:
     self._memory_objects=prepare_memory_objects(self._row.memory_objects)
    except KeyError:
     self._diagnostics.append('Can\'t load memory objects')
  return self._memory_objects
 @property
 def data_transferred(self):
  return self._data_transferred
 @property
 def total_strides(self):
  return self._total_strides
 @property
 def mem_stat(self):
  return self._mem_stat
 @property
 def memory_footprint(self):
  return self._memory_footprint
 @property
 def code_size(self):
  return self._code_size
 @property
 def instruction_mix(self):
  return self._instruction_mix
 @property
 def atomic_counts(self):
  return self._atomic_counts
 @property
 def is_executed(self):
  return self._is_executed
 @property
 def is_function(self):
  return self._is_function
 @property
 def is_user_function(self):
  return self._is_user_function
 @property
 def is_loop(self):
  return self._is_loop
 @property
 def is_vector_loop(self):
  return self._is_vector_loop
 @property
 def is_scalar(self):
  return self._is_scalar
 @property
 def is_offload_candidate(self):
  return self._is_offload_candidate
 @property
 def not_offload_candidate_reasons(self):
  return self._is_offload_candidate.reasons
 @property
 def callchain_weight(self):
  return self._callchain_weight
 @property
 def module_type(self):
  return self._module_type
 @property
 def nesting_level(self):
  return self._nesting_level
 @property
 def use_barriers(self):
  return self._data['barrier_accesses']!=0
 def _fill_call_stack_based_metrics(self):
  pass
 @staticmethod
 def _get_extra_rows(row):
  return[]
 def _gather_lazy_item(self,key):
  info=self._lazy_items[key]
  res={k:v for k,v in info['getter']().items()if k in info['together']}
  self._data.update(res)
  for x in res:
   self._lazy_items.pop(x,None)
 @property
 def is_marked_up(self):
  return self._is_marked_up
 @property
 def is_selected(self):
  return self._is_selected
 @property
 def selected_by(self):
  if self._selected_by is None:
   rows=[self]
   while True:
    curr_row=rows[-1]
    if curr_row._selected_by is not None:
     for x in rows[:-1]:
      x._selected_by=curr_row._selected_by
     break
    if not curr_row._parent:
     break
    rows.append(curr_row._parent)
  return self._selected_by
 @staticmethod
 def filter_children(row):
  return[]
 def set_aggregated_subitems(self,subitems):
  self._is_aggregated=True
  self._is_offload_candidate=JustifiedBool(False,NonOffloadReasons.AGGREGATED)
  self._subitems=subitems
  for x in subitems:
   x._aggregated=self
def postprocess_memory_object(obj):
 for x in prepare_memory_objects.postprocess:
  x(obj)
 return obj
def set_loaded_n_stored_by_children(obj):
 if 'loaded_by_children' not in obj:
  obj['loaded_by_children']=False
 if 'stored_by_children' not in obj:
  obj['stored_by_children']=False
def check_data_reuse(obj):
 if obj['max_access_counter']!=0:
  BaseRow.has_reuse_data=True
def prepare_memory_objects(memory_objects):
 uniq_dict={}
 for obj in memory_objects:
  if not obj['allocation_id']in uniq_dict:
   uniq_dict[obj['allocation_id']]=obj
  else:
   max_access_counter=uniq_dict[obj['allocation_id']]['max_access_counter']if 'max_access_counter' in uniq_dict[obj['allocation_id']]else ''
   try:
    counter=int(max_access_counter)
   except ValueError:
    counter=0
   if counter==0:
    uniq_dict[obj['allocation_id']]=obj
 unique_objects=uniq_dict.values()
 return[postprocess_memory_object({k:int(x[k].strip()or 0)if k in prepare_memory_objects.numerical else x[k]for k in x})for x in unique_objects]
prepare_memory_objects.postprocess=[set_loaded_n_stored_by_children,check_data_reuse,]
prepare_memory_objects.numerical={'min_modification_counter','max_modification_counter','min_access_counter','max_access_counter','object_loads','object_stores',}
