#
# Copyright (C) 2017 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to obtain traits detected by the recommendation engine
# of Offload Advisor. Issues and traits detection requires loading ALL data
# models (survey, MAP, dependency) to take into account all the information.
#
# The script may be modified to look for traits of interest by ID. For example:
#
# - ID for system calls presence is SYSTEM_CALLS, for indirect calls
#   INDIRECT_CALLS
# ------------------------------------------------------------------------------

import sys

try:

    import advisor

except ImportError:

    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

# Check command-line arguments.
if len(sys.argv) < 2:
    print('Usage: "python {} path_to_project_dir"'.format(__file__))
    sys.exit(2)

# Open the Advisor Project and load the data.
project = advisor.open_project(sys.argv[1])
data = project.load(advisor.ALL)

for row in data.bottomup:
    # Print the function name.
    print(row["function_call_sites_and_loops"])
    # Print the traits.
    for trait in row.get_traits():
        print("    {}: {}".format(trait.id, trait.text))
    print("")
