/*
 * Copyright (C) 2020 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/

#pragma OPENCL EXTENSION cl_khr_fp64 : enable

// FmaD 0Gr:0d/0Gr:0d/0Gw:0d 53760000 0 1
__kernel void FmaD(__global double *pA, __global double *pB, __global double *pC)
{
    const int id = get_global_id(0);

    double a = pA[id];
    double b = pB[id];
    double c = 1.f;
    double d = 1.f;
    double e = 1.f;
    double f = 1.f;
    double g = 1.f;
    double h = 1.f;
    double i = 1.f;
    double j = 1.f;
    double k = 1.f;
    double l = 1.f;
    double m = 1.f;
    double n = 1.f;
    double o = 1.f;
    double p = 1.f;
    double q = 1.f;
    double r = 1.f;
    double s = 1.f;
    double t = 1.f;
    double u = 1.f;
    double v = 1.f;
    double w = 1.f;

    for (int count = 0; count < 640; count++)
    {
        c = mad(a, d, c);
        e = mad(b, f, e);
        g = mad(a, h, g);
        i = mad(b, j, i);
        k = mad(a, l, k);
        m = mad(b, n, m);
        o = mad(a, p, o);
        d = mad(b, e, d);
        f = mad(a, g, f);
        h = mad(b, i, h);
        j = mad(a, k, j);
        l = mad(b, m, l);
        n = mad(a, o, n);
        p = mad(b, d, p);
    }
    pC[id] = c;
    //    pC[id] = c + e + g + i + k + m + o + d + f + h + j + l + n + p;
}
