
=pod

=head1 COPYRIGHT

# (c) 1992-2024 Intel Corporation.                                              
# Intel, the Intel logo, Intel, MegaCore, NIOS II, Quartus and TalkBack         
# words and logos are trademarks of Intel Corporation or its                    
# subsidiaries in the U.S. and/or other countries. Other marks and              
# brands may be claimed as the property of others.                              
# See Trademarks on intel.com for full list of Intel trademarks or the          
# Trademarks & Brands Names Database (if Intel)                                 
# or See www.Intel.com/legal (if Altera)                                        
# Your use of Intel Corporation's design tools, logic functions and             
# other software and tools, and its AMPP partner logic functions, and           
# any output files any of the foregoing (including device programming           
# or simulation files), and any associated documentation or information         
# are expressly subject to the terms and conditions of the Altera               
# Program License Subscription Agreement, Intel MegaCore Function               
# License Agreement, or other applicable license agreement, including,          
# without limitation, that your use is for the sole purpose of                  
# programming logic devices manufactured by Intel and sold by Intel or          
# its authorized distributors.                                                  
# Please refer to the applicable agreement for further details.                 


=head1 NAME

acl::CommonData.pm - Data to be used in the compiler that may need to be updated outside of the logic

=head1 SYNOPSIS

Stores some data, such as supported version numbers and Quartus download links, that may change more often than the logic using it.

=cut

package acl::CommonData;
use strict;
use Exporter;

our @ISA = qw(Exporter);
our @EXPORT = qw( @supported_acds_list @internal_acds $latest_released_quartus $min_supported_quartus %quartus_download_links $download_center_link );

our @supported_acds_list = ('22.3', '22.4', '23.1', '23.2', '23.3', '23.4', '24.1', '24.2');
our @internal_acds = ('24.3', '24.4', '25.1');
our $latest_released_quartus = q{24.2};
our $min_supported_quartus = q{22.3};
our %quartus_download_links = (
	'stdlin'	=> 'https://www.intel.com/content/www/us/en/software-kit/825312/questa-intel-fpgas-standard-edition-software-version-23-1-1.html',
	'stdwin'	=> 'https://www.intel.com/content/www/us/en/software-kit/825312/questa-intel-fpgas-standard-edition-software-version-23-1-1.html',
	'22.3lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/746666/intel-quartus-prime-pro-edition-design-software-version-22-3-for-linux.html',
	'22.3win'	=> 'https://www.intel.com/content/www/us/en/software-kit/746667/intel-quartus-prime-pro-edition-design-software-version-22-3-for-windows.html',
	'22.4lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/764010/intel-quartus-prime-pro-edition-design-software-version-22-4-for-linux.html',
	'22.4win'	=> 'https://www.intel.com/content/www/us/en/software-kit/764011/intel-quartus-prime-pro-edition-design-software-version-22-4-for-windows.html',
	'23.1lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/776241/intel-quartus-prime-pro-edition-design-software-version-23-1-for-linux.html',
	'23.1win'	=> 'https://www.intel.com/content/www/us/en/software-kit/776242/intel-quartus-prime-pro-edition-design-software-version-23-1-for-windows.html',
	'23.2lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/782411/intel-quartus-prime-pro-edition-design-software-version-23-2-for-linux.html',
	'23.2win'	=> 'https://www.intel.com/content/www/us/en/software-kit/782412/intel-quartus-prime-pro-edition-design-software-version-23-2-for-windows.html',
	'23.3lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/790039/intel-quartus-prime-pro-edition-design-software-version-23-3-for-linux.html',
	'23.3win'	=> 'https://www.intel.com/content/www/us/en/software-kit/790040/intel-quartus-prime-pro-edition-design-software-version-23-3-for-windows.html',
	'23.4lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/794624/intel-quartus-prime-pro-edition-design-software-version-23-4-for-linux.html',
	'23.4win'	=> 'https://www.intel.com/content/www/us/en/software-kit/794625/intel-quartus-prime-pro-edition-design-software-version-23-4-for-windows.html',
	'24.1lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/819137/intel-quartus-prime-pro-edition-design-software-version-24-1-b115-for-linux.html',
	'24.1win'	=> 'https://www.intel.com/content/www/us/en/software-kit/819138/intel-quartus-prime-pro-edition-design-software-version-24-1-b115-for-windows.html',
	'24.2lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/826843/intel-quartus-prime-pro-edition-design-software-version-24-2-for-linux.html',
	'24.2win'	=> 'https://www.intel.com/content/www/us/en/software-kit/826844/intel-quartus-prime-pro-edition-design-software-version-24-2-for-windows.html',
);
our $download_center_link = 'https://www.intel.com/content/www/us/en/collections/products/fpga/software/downloads.html?edition=pro&s=Newest';

1;
