/*
    Copyright Intel Corporation.
    
    This software and the related documents are Intel copyrighted materials, and
    your use of them is governed by the express license under which they were
    provided to you (License). Unless the License provides otherwise, you may
    not use, modify, copy, publish, distribute, disclose or transmit this
    software or the related documents without Intel's prior written permission.
    
    This software and the related documents are provided as is, with no express
    or implied warranties, other than those that are expressly stated in the
    License.
*/
package mpi.test;
import mpi.*;

public class Test {
    static public void main(String[] args) throws MPIException {
        MPI.Init(args);
        
        int[] size = new int[]{Comm.WORLD.getSize()};
        int[] rank = new int[]{Comm.WORLD.getRank()};
        String processorName = MPI.getProcessorName();
        int[] length = new int[]{processorName.length()};
        char[] nameToSend = processorName.toCharArray();

        if (rank[0] == 0) {
            for (int i = 1; i < size[0]; i++) {
                PTP.recv (rank, 1, Datatype.INT, i, 1, Comm.WORLD);
                PTP.recv (size, 1, Datatype.INT, i, 1, Comm.WORLD);
                PTP.recv (length, 1, Datatype.INT, i, 1, Comm.WORLD);
                char[] name = new char[length[0]];
                PTP.recv (name, length[0]*Character.SIZE / Byte.SIZE, Datatype.CHAR, i, 1, Comm.WORLD);
                MPI.println("Hello world: rank " + rank[0] + " of " + size[0] + " running on " + new String(name));
            }
        } else {
            PTP.send (rank, 1, Datatype.INT, 0, 1, Comm.WORLD);
            PTP.send (size, 1, Datatype.INT, 0, 1, Comm.WORLD);
            PTP.send (length, 1, Datatype.INT, 0, 1, Comm.WORLD);
            PTP.send (nameToSend, (length[0])*Character.SIZE / Byte.SIZE, Datatype.CHAR, 0, 1, Comm.WORLD);
        }
        MPI.Finalize();
    }
}
