<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl" xmlns:exsl="http://exslt.org/common" exsl:keep_exsl_namespace=""
    xmlns:str="http://exslt.org/strings" syntax="norules">
  <xsl:output indent="yes" method="xml"/>
  <xsl:param name="referenceFrequency">
    <xsl:value-of select="exsl:ctx('referenceFrequency', 1)"/>
  </xsl:param>
  <xsl:variable name="specifics" select="document('config://include/pmu_common_specifics.xsl')"/>
  <xsl:variable name="pmuConditions" select="document('config://include/pmu_variables.xsl')"/>
  <xsl:variable name="isHybridPMU" select="$pmuConditions//variables/isHybridPMU"/>
  <xsl:variable name="isPerfmetricsSupported" select="$pmuConditions//variables/isPerfmetricsSupported"/>
  <xsl:variable name="isEcorePMU" select="$pmuConditions//variables/isEcorePMU"/>
  <xsl:variable name="isEcoreServerPMU" select="$pmuConditions//variables/isEcoreServerPMU"/>
  <xsl:variable name="is12thGenClientOrLater" select="$pmuConditions//variables/is12thGenClientOrLater"/>
  <xsl:template match="/">
    <variables>
      <xsl:variable name="isVisaAvailable">
        <xsl:for-each select="str:tokenize(exsl:ctx('availablePmuTypes',''), ',')">
          <xsl:if test=".='sa' ">
             <xsl:text>true</xsl:text>
          </xsl:if>
        </xsl:for-each>
      </xsl:variable>
      <visaAvailable>
        <xsl:value-of select="$isVisaAvailable"/>
      </visaAvailable>
      <forceIMCBandwidthOnAtom>
        <xsl:choose>
          <xsl:when test="(exsl:ctx('PMU') = 'goldmont' or exsl:ctx('PMU') = 'goldmont_plus') and
               (exsl:is_experimental('force_imc_bandwidth') or $isVisaAvailable != 'true')">
            <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </forceIMCBandwidthOnAtom>
      <clockticksEvent>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'lwt-simics'">
            <xsl:text>totalCycles</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('clockticksEventName', '')">
            <xsl:copy-of select="exsl:ctx('clockticksEventName')"/>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'silvermont' or exsl:ctx('PMU') = 'airmont' or exsl:ctx('PMU') = 'goldmont' or exsl:ctx('PMU') = 'goldmont_plus' or exsl:ctx('PMU') = 'snowridge' or exsl:ctx('PMU') = 'elkhartlake'">
            <xsl:text>CPU_CLK_UNHALTED.CORE</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'sniper'">
            <xsl:text>CPU_CLK_UNHALTED.REF</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'na'">
            <xsl:text>Cycle Count Register</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('collectFullProcTrace', 0)">
            <xsl:text>PT_CLOCKTICKS</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="exsl:ctx('PerfmonVersion', '4') = '1'">
                <xsl:text>CPU_CLK_UNHALTED.THREAD_P_ANY</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>CPU_CLK_UNHALTED.THREAD</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </clockticksEvent>
      <clockticksEventBig>
        <xsl:text>CPU_CLK_UNHALTED.THREAD</xsl:text>
      </clockticksEventBig>
      <clockticksEventSmall>
        <xsl:text>CPU_CLK_UNHALTED.THREAD</xsl:text>
      </clockticksEventSmall>
      <clockticksEventProgrammable>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'silvermont' or exsl:ctx('PMU') = 'airmont' or exsl:ctx('PMU') = 'goldmont' or exsl:ctx('PMU') = 'goldmont_plus' or exsl:ctx('PMU') = 'snowridge' or exsl:ctx('PMU') = 'elkhartlake'">
            <xsl:text>CPU_CLK_UNHALTED.CORE_P</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>CPU_CLK_UNHALTED.THREAD_P</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </clockticksEventProgrammable>
      <clockticksEventProgrammableBig>
        <xsl:text>CPU_CLK_UNHALTED.THREAD_P</xsl:text>
      </clockticksEventProgrammableBig>
      <clockticksEventProgrammableSmall>
        <xsl:text>CPU_CLK_UNHALTED.THREAD_P</xsl:text>
      </clockticksEventProgrammableSmall>
      <refClockticksEvent>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'lwt-simics'">
            <xsl:text>totalCycles</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('clockticksEventName', '')">
            <xsl:copy-of select="exsl:ctx('clockticksEventName')"/>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'sniper'">
            <xsl:text>CPU_CLK_UNHALTED.REF</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'na'">
            <xsl:text>Cycle Count Register</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('collectFullProcTrace', 0)">
            <xsl:text>PT_CLOCKTICKS</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="exsl:ctx('PerfmonVersion', '4') = '1'">
                <xsl:text>CPU_CLK_UNHALTED.THREAD_P_ANY</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>CPU_CLK_UNHALTED.REF_TSC</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </refClockticksEvent>
      <factorFromRefClkToTsc>
        <xsl:choose>
          <xsl:when test="(exsl:ctx('PMU') = 'silvermont' or exsl:ctx('PMU') = 'airmont' or exsl:ctx('PMU') = 'goldmont') and exsl:ctx('cpuFamily') = 6 and exsl:ctx('cpuModel') = 93">
            <xsl:text>9360000000</xsl:text>
          </xsl:when>
          <xsl:when test="(exsl:ctx('PMU') = 'silvermont' or exsl:ctx('PMU') = 'airmont' or exsl:ctx('PMU') = 'goldmont') and exsl:ctx('cpuFamily') = 6 and exsl:ctx('cpuModel') = 101">
            <xsl:text>3744000000</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="format-number($referenceFrequency, '#')"/>
          </xsl:otherwise>
        </xsl:choose>
      </factorFromRefClkToTsc>
      <instructionsEvent>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'lwt-simics'">
            <xsl:text>totalInstructions</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'na'">
            <xsl:text>Instruction Count</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('collectFullProcTrace', 0)">
            <xsl:text>PT_INSTRUCTIONS</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="exsl:ctx('PerfmonVersion', '4') = '1'">
                <xsl:text>INST_RETIRED.ANY_P</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>INST_RETIRED.ANY</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </instructionsEvent>
      <xsl:variable name="programmableClockticksEvent">
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'silvermont' or
                          exsl:ctx('PMU') = 'airmont' or
                          exsl:ctx('PMU') = 'goldmont' or
                          exsl:ctx('PMU') = 'goldmont_plus' or
                          exsl:ctx('PMU') = 'snowridge' or
                          exsl:ctx('PMU') = 'elkhartlake'">
            <xsl:text>CPU_CLK_UNHALTED.CORE_P</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>CPU_CLK_UNHALTED.THREAD_P</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <programmableClockticksEvent>
        <xsl:value-of select="$programmableClockticksEvent"/>
      </programmableClockticksEvent>
      <ring123Event>
        <xsl:value-of select="concat($programmableClockticksEvent, ':sample:sa=1:cmask=1:e=yes:os=no:usr=yes:ctxsw:mg')"/>
      </ring123Event>
      <callCountQueryEvent>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'silvermont' or exsl:ctx('PMU') = 'airmont'">
            <xsl:text>BR_INST_RETIRED.CALL_PS</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>CALL_COUNT</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </callCountQueryEvent>
      <memBandwidthEvents>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'silvermont' or exsl:ctx('PMU') = 'airmont'">
            <xsl:text>UNC_SOC_Memory_DDR_BW</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'goldmont' or exsl:ctx('PMU') = 'goldmont_plus'">
            <xsl:choose>
              <xsl:when test="exsl:is_experimental('force_imc_bandwidth') or $isVisaAvailable != 'true'">
                <xsl:text>UNC_IMC_DRAM_RW_SLICE0,UNC_IMC_DRAM_RW_SLICE1</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>UNC_SOC_All_BW</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'haswell' or exsl:ctx('PMU') = 'crystalwell' or exsl:ctx('PMU') = 'broadwell' or (exsl:ctx('PMU') = 'skylake' and exsl:ctx('targetOS', '') != 'MacOSX') or exsl:ctx('PMU') = 'icelake' or exsl:ctx('PMU') = 'elkhartlake'">
            <xsl:text>UNC_IMC_DRAM_DATA_READS,UNC_IMC_DRAM_DATA_WRITES</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'tigerlake'">
            <xsl:text>UNC_MC0_RDCAS_COUNT_FREERUN,UNC_MC0_WRCAS_COUNT_FREERUN,UNC_MC1_RDCAS_COUNT_FREERUN,UNC_MC1_WRCAS_COUNT_FREERUN</xsl:text>
          </xsl:when>
          <xsl:when test="$is12thGenClientOrLater = 'true'">
            <xsl:text>UNC_M_CAS_COUNT_RD,UNC_M_CAS_COUNT_WR</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'skylake' and exsl:ctx('targetOS', '') = 'MacOSX'">
            <xsl:text>UNC_IMC_DRAM_GT_REQUESTS,UNC_IMC_DRAM_IA_REQUESTS,UNC_IMC_DRAM_IO_REQUESTS,UNC_IMC_DRAM_DATA_READS,UNC_IMC_DRAM_DATA_WRITES,UNC_EDRAM_RD_HIT:filter0=0x7,UNC_EDRAM_RD_MISS,UNC_EDRAM_PTLWR_HIT,UNC_EDRAM_PTLWR_MISS,UNC_EDRAM_WR_HIT,UNC_EDRAM_WR_MISS</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'haswell_server' or exsl:ctx('PMU') = 'broadwell_de' or exsl:ctx('PMU') = 'broadwell_server'">
            <xsl:text>UNC_M_CAS_COUNT.RD,UNC_M_CAS_COUNT.WR</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'skylake_server'">
            <xsl:text>UNC_M_CAS_COUNT.RD,UNC_M_CAS_COUNT.WR</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'cascadelake_server'">
            <xsl:text>UNC_M_CAS_COUNT.RD,UNC_M_CAS_COUNT.WR,UNC_M_TAGCHK.MISS_CLEAN,UNC_M_TAGCHK.MISS_DIRTY,UNC_M2M_IMC_READS.TO_PMM,UNC_M2M_IMC_WRITES.TO_PMM,UNC_M2M_TAG_HIT.NM_RD_HIT_CLEAN,UNC_M2M_TAG_HIT.NM_RD_HIT_DIRTY</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'icelake_server' or exsl:ctx('PMU') = 'sapphirerapids_server'">
            <xsl:text>UNC_M_CAS_COUNT.RD,UNC_M_CAS_COUNT.WR,UNC_M_PMM_RPQ_INSERTS,UNC_M_PMM_WPQ_INSERTS,UNC_M2M_TAG_HIT.NM_RD_HIT_CLEAN,UNC_M2M_TAG_HIT.NM_RD_HIT_DIRTY</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'emeraldrapids_server'">
            <xsl:text>UNC_M_CAS_COUNT.RD,UNC_M_CAS_COUNT.WR,UNC_M2M_TAG_HIT.NM_RD_HIT_CLEAN,UNC_M2M_TAG_HIT.NM_RD_HIT_DIRTY</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'snowridge'">
            <xsl:text>UNC_M_CAS_COUNT.RD,UNC_M_CAS_COUNT.WR</xsl:text>
          </xsl:when>
          <xsl:when test="($isEcoreServerPMU = 'true' and exsl:ctx('PMU') != 'snowridge') or exsl:ctx('PMU') = 'graniterapids_server'">
            <xsl:text>UNC_M_CAS_COUNT_SCH0.RD,UNC_M_CAS_COUNT_SCH1.RD,UNC_M_CAS_COUNT_SCH0.WR,UNC_M_CAS_COUNT_SCH1.WR</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'knl'">
            <xsl:text>UNC_M_CAS_COUNT.RD,UNC_M_CAS_COUNT.WR,UNC_E_RPQ_INSERTS,UNC_E_WPQ_INSERTS,UNC_E_EDC_ACCESS.HIT_CLEAN,UNC_E_EDC_ACCESS.HIT_DIRTY,UNC_E_EDC_ACCESS.MISS_CLEAN,UNC_E_EDC_ACCESS.MISS_DIRTY</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text></xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </memBandwidthEvents>
      <qpiBandwidthEvents>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'haswell_server' or exsl:ctx('PMU') = 'broadwell_de' or exsl:ctx('PMU') = 'broadwell_server'">
            <xsl:text>UNC_Q_TxL_FLITS_G0.DATA,UNC_Q_TxL_FLITS_G0.NON_DATA,UNC_Q_RxL_FLITS_G1.DRS_DATA,UNC_Q_RxL_FLITS_G2.NCB_DATA</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'skylake_server' or exsl:ctx('PMU') = 'cascadelake_server' or exsl:ctx('PMU') = 'icelake_server' or exsl:ctx('PMU') = 'sapphirerapids_server' or exsl:ctx('PMU') = 'emeraldrapids_server' or exsl:ctx('PMU') = 'sierraforest_server' or exsl:ctx('PMU') = 'graniterapids_server'">
            <xsl:text>UNC_UPI_TxL_FLITS.ALL_DATA,UNC_UPI_TxL_FLITS.NON_DATA,UNC_UPI_CLOCKTICKS,UNC_UPI_L1_POWER_CYCLES</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text></xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </qpiBandwidthEvents>
      <cpuGPUBandwidthEvents>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'icelake_server' or exsl:ctx('PMU') = 'sapphirerapids_server' or exsl:ctx('PMU') = 'emeraldrapids_server' or exsl:ctx('PMU') = 'graniterapids_server' or ($isEcoreServerPMU = 'true' and exsl:ctx('PMU') != 'snowridge')">
            <xsl:text>UNC_I_FAF_INSERTS,UNC_I_TRANSACTIONS.WR_PREF</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text></xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </cpuGPUBandwidthEvents>
      <isPeciseClockticksAvailable>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'haswell'
              or exsl:ctx('PMU') = 'haswell_server'
              or exsl:ctx('PMU') = 'crystalwell'
              or exsl:ctx('PMU') = 'broadwell'
              or exsl:ctx('PMU') = 'broadwell_de'
              or exsl:ctx('PMU') = 'broadwell_server'
              or exsl:ctx('PMU') = 'skylake'
              or exsl:ctx('PMU') = 'skylake_server'
              or exsl:ctx('PMU') = 'cascadelake_server'">
            <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isPeciseClockticksAvailable>
      <peciseClockticksEvent>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'skylake' or exsl:ctx('PMU') = 'skylake_server' or exsl:ctx('PMU') = 'cascadelake_server'">
            <xsl:text>INST_RETIRED.TOTAL_CYCLES_PS</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>INST_RETIRED.PREC_DIST:cmask=10:inv=yes</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </peciseClockticksEvent>
      <peciseClockticksEventNameOnly>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'skylake' or exsl:ctx('PMU') = 'skylake_server' or exsl:ctx('PMU') = 'cascadelake_server'">
            <xsl:text>INST_RETIRED.TOTAL_CYCLES_PS</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>INST_RETIRED.PREC_DIST</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </peciseClockticksEventNameOnly>
      <isPTAvailable>
        <xsl:choose>
          <xsl:when test="exsl:ctx('isPTAvailable', 0)">
            <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isPTAvailable>
      <isTripCountsAvailable>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'silvermont' or exsl:ctx('PMU') = 'airmont' or exsl:ctx('PMU') = 'knl'">
            <xsl:text>false</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>true</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isTripCountsAvailable>
      <callCountsEvents>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'silvermont' or exsl:ctx('PMU') = 'airmont'">
            <xsl:text>BR_INST_RETIRED.CALL_PS</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'goldmont'">
            <xsl:text>BR_INST_RETIRED.ALL_TAKEN_BRANCHES:sa=200003:usr=yes:os=no</xsl:text>
          </xsl:when>
          <xsl:when test="$isEcoreServerPMU = 'true'">
            <xsl:text>BR_INST_RETIRED.ALL_BRANCHES:sa=200003:usr=yes:os=no</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>BR_INST_RETIRED.NEAR_TAKEN:sa=200003:usr=yes:os=no</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </callCountsEvents>
      <takenBranchesEvent>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'silvermont' or exsl:ctx('PMU') = 'airmont' or exsl:ctx('PMU') = 'goldmont'">
            <name>BR_INST_RETIRED.ALL_TAKEN_BRANCHES</name>
            <modifiers></modifiers>
          </xsl:when>
          <xsl:otherwise>
            <name>BR_INST_RETIRED.NEAR_TAKEN</name>
            <modifiers>:sa=49999:usr=yes:os=no</modifiers>
          </xsl:otherwise>
        </xsl:choose>
      </takenBranchesEvent>
      <isPerfBWAvailable>
        <xsl:choose>
          <xsl:when test="(exsl:ctx('LinuxPerfCredentials', 'NotAvailable')!='NotAvailable' and exsl:ctx('LinuxPerfCredentials', 'NotAvailable')!='Kernel' and exsl:ctx('LinuxPerfCredentials', 'NotAvailable')!='User' and contains(exsl:ctx('LinuxPerfCapabilities', ''), 'format') and contains(exsl:ctx('LinuxPerfCapabilities', 'NotAvailable'), 'uncore_imc')) and not((exsl:ctx('PMU')='haswell' or exsl:ctx('PMU') = 'broadwell') and
                                  contains(exsl:ctx('LinuxRelease', ''), '3.10.0-327.el7.'))">
            <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isPerfBWAvailable>
      <xsl:variable name="kernelVersion" select="string(exsl:ctx('LinuxRelease', ''))"/>
      <xsl:variable name="currentKernelVersions" select="str:tokenize($kernelVersion, '.-')"/>
      <xsl:variable name="isLinuxKernel5p17OrGreater" select="(number($currentKernelVersions[1]) &gt; number(5)) or
            (number($currentKernelVersions[1]) = number(5) and (number($currentKernelVersions[2]) &gt;= number(17)))"/>
      <isDRAMBWAvailable>
        <xsl:choose>
          <xsl:when test="exsl:ctx('isSEPDriverAvailable', 0) or (exsl:ctx('LinuxPerfCredentials', 'NotAvailable')!='NotAvailable' and exsl:ctx('LinuxPerfCredentials', 'NotAvailable')!='Kernel' and exsl:ctx('LinuxPerfCredentials', 'NotAvailable')!='User' and contains(exsl:ctx('LinuxPerfCapabilities', ''), 'format') and contains(exsl:ctx('LinuxPerfCapabilities', 'NotAvailable'), 'uncore_imc') and (not(exsl:ctx('PMU') = 'alderlake') or (exsl:ctx('PMU') = 'alderlake' and $isLinuxKernel5p17OrGreater))) and not(exsl:ctx('PMU') = 'tigerlake') and not((exsl:ctx('PMU')='haswell' or exsl:ctx('PMU') = 'broadwell') and
                                  contains(exsl:ctx('LinuxRelease', ''), '3.10.0-327.el7.'))">
            <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isDRAMBWAvailable>
      <isInterSocketBWAvailable>
        <xsl:choose>
          <xsl:when test="exsl:ctx('isSEPDriverAvailable', 0) or (contains(exsl:ctx('LinuxPerfCapabilities', 'NotAvailable'), 'uncore_qpi') or contains(exsl:ctx('LinuxPerfCapabilities', 'NotAvailable'), 'uncore_upi'))">
            <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isInterSocketBWAvailable>
      <xsl:variable name="detectHBM" select="(exsl:ctx('isSEPDriverAvailable', 0) and contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'mchbm')) or contains(exsl:ctx('LinuxPerfCapabilities', 'NotAvailable'), 'uncore_hbm')"/>
      <isHBMBWAvailable>
        <xsl:choose>
          <xsl:when test="$detectHBM">
            <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isHBMBWAvailable>
      <isCXLBWAvailable>
        <xsl:choose>
          <xsl:when test="(exsl:ctx('isSEPDriverAvailable', 0) and contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'cxlcm'))">
            <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isCXLBWAvailable>
      <isPerfIOBWAvailable>
        <xsl:choose>
          <xsl:when test="exsl:ctx('LinuxPerfCredentials', 'NotAvailable')!='NotAvailable' and exsl:ctx('LinuxPerfCredentials', 'NotAvailable')!='Kernel' and exsl:ctx('LinuxPerfCredentials', 'NotAvailable')!='User' and contains(exsl:ctx('LinuxPerfCapabilities', ''), 'format') and ((contains(exsl:ctx('LinuxPerfCapabilities', 'NotAvailable'), 'uncore_cha') and contains(exsl:ctx('LinuxPerfCapabilities', 'NotAvailable'), 'uncore_iio')) or contains(exsl:ctx('LinuxPerfCapabilities', 'NotAvailable'), 'uncore_cbox'))">
            <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isPerfIOBWAvailable>
      <xsl:variable name='allStoresPreciseEvent'>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'haswell_server' or exsl:ctx('PMU') = 'broadwell_server'">
            <xsl:text>MEM_UOPS_RETIRED.ALL_STORES_PS:sa=100003,</xsl:text>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'skylake_server' or exsl:ctx('PMU') = 'cascadelake_server'">
            <xsl:text>MEM_INST_RETIRED.ALL_STORES_PS:sa=100003,</xsl:text>
          </xsl:when>
          <xsl:when test="$isEcoreServerPMU = 'true'">
            <xsl:text>MEM_UOPS_RETIRED.ALL_STORES:sa=100003,</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>MEM_INST_RETIRED.ALL_STORES:sa=100003,</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="PCIeBandwidthEventsSpecifics" select="$specifics//common/PCIeBandwidthEventsSpecifics"/>
      <xsl:variable name="P2PEvents" select="$specifics//common/P2PEvents"/>
      <xsl:variable name="uncacheableReadsEvent" select="$specifics//common/uncacheableReadsEvent"/>
      <PCIeBandwidthEvents>
        <xsl:value-of select="$PCIeBandwidthEventsSpecifics"/>
      </PCIeBandwidthEvents>
      <PCIeP2PEvents>
        <xsl:value-of select="$P2PEvents"/>
      </PCIeP2PEvents>
      <MmioAccessEvents>
        <xsl:value-of select="$uncacheableReadsEvent"/>
        <xsl:value-of select="$allStoresPreciseEvent"/>
      </MmioAccessEvents>
      <xsl:copy-of select="$specifics//common/uncacheableReadsEventNameOnly"/>
      <xsl:copy-of select="$specifics//common/IommuEvents"/>
      <xsl:copy-of select="$specifics//common/IioClockticksEvent"/>
      <ShowInboundPCIeRequestsWarning>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'skylake_server' or exsl:ctx('PMU') = 'cascadelake_server'">
            <xsl:choose>
              <xsl:when test="exsl:ctx('restrictPCIeBandwidthByClass', 'None') != 'None' and exsl:ctx('pciClassParts','') != ''">
                <xsl:text>false</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test="exsl:ctx('isSEPDriverAvailable', 0)">
                    <xsl:text>false</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text>true</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'icelake_server' or exsl:ctx('PMU') = 'snowridge'">
            <xsl:choose>
              <xsl:when test="exsl:ctx('isSEPDriverAvailable', 0)">
                <xsl:text>false</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>true</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </ShowInboundPCIeRequestsWarning>
      <ShowPerfPCIeDeviceMappingWarning>
        <xsl:choose>
          <xsl:when test="not(exsl:ctx('RootPrivileges', 0)) and not(exsl:ctx('isSEPDriverAvailable', 0)) and not(exsl:ctx('PMU') = 'haswell_server' or exsl:ctx('PMU') = 'broadwell_server')">
            <xsl:choose>
              <xsl:when test="not(exsl:ctx('isPerfPCIeMappingAvailable', 0))">
                <xsl:text>true</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>false</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </ShowPerfPCIeDeviceMappingWarning>
      <xsl:copy-of select="$specifics//common/FpgaBlueStreamEvents"/>
      <latencyEvents>
        <xsl:choose>
          <xsl:when test="$isHybridPMU = 'true'">
            <xsl:text>MEM_TRANS_RETIRED.LOAD_LATENCY_GT_4,MEM_UOPS_RETIRED.LOAD_LATENCY_GT_4</xsl:text>
          </xsl:when>
          <xsl:when test="isEcorePMU = 'true'">
            <xsl:text>MEM_UOPS_RETIRED.LOAD_LATENCY_GT_4</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>MEM_TRANS_RETIRED.LOAD_LATENCY_GT_4</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </latencyEvents>
      <perfMetricsPossible>
        <xsl:choose>
          <xsl:when test="$isPerfmetricsSupported = 'true' and exsl:ctx('isSEPDriverAvailable', 0) and
                          ($isHybridPMU = 'false' or exsl:ctx('Hypervisor', 'None') = 'None')">
            <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </perfMetricsPossible>
      <xsl:variable name="tmamEventsFileVar">
        <xsl:text>config://analysis_type/include/tmam/</xsl:text>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'skylake' and (contains(exsl:ctx('CPU_NAME',''),'Coffeelake') or contains(exsl:ctx('CPU_NAME',''),'Cometlake'))">
            <xsl:text>coffeelake</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="$detectHBM">
                <xsl:value-of select="concat(exsl:ctx('PMU', 'empty'), '_hbm')"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="exsl:ctx('PMU', 'empty')"></xsl:value-of>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>.xsl</xsl:text>
      </xsl:variable>
      <isTmamAvailable>
        <xsl:choose>
          <xsl:when test="exsl:is_file_exist(string($tmamEventsFileVar))">
            <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isTmamAvailable>
      <tmamEventsFile>
        <xsl:choose>
          <xsl:when test="exsl:is_file_exist(string($tmamEventsFileVar))">
            <xsl:value-of select="$tmamEventsFileVar"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>config://analysis_type/include/tmam/empty.xsl</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </tmamEventsFile>
      <xsl:variable name="tmamEventsFileVarPM">
        <xsl:text>config://analysis_type/include/tmam/</xsl:text>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'skylake' and (contains(exsl:ctx('CPU_NAME',''),'Coffeelake') or contains(exsl:ctx('CPU_NAME',''),'Cometlake'))">
            <xsl:text>coffeelake</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="$detectHBM">
                <xsl:value-of select="concat(exsl:ctx('PMU', 'empty'), '_hbm')"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="exsl:ctx('PMU', 'empty')"></xsl:value-of>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="(exsl:ctx('isSEPDriverAvailable', 0) and exsl:ctx('Hypervisor', 'None') = 'None'
                      and $isPerfmetricsSupported = 'true')">
          <xsl:text>_pmetrics</xsl:text>
        </xsl:if>
        <xsl:text>.xsl</xsl:text>
      </xsl:variable>
      <tmamEventsFilePM>
        <xsl:choose>
          <xsl:when test="exsl:is_file_exist(string($tmamEventsFileVarPM))">
            <xsl:value-of select="$tmamEventsFileVarPM"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>config://analysis_type/include/tmam/empty.xsl</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </tmamEventsFilePM>
      <xsl:variable name="tmamFile">
        <xsl:text>config://include/queries_tmam_</xsl:text>
        <xsl:choose>
          <xsl:when test="exsl:ctx('tmamVersion', '') = ''">
            <xsl:text>3_1</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="exsl:ctx('tmamVersion', '3_1')"></xsl:value-of>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>/</xsl:text>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'skylake' and (contains(exsl:ctx('CPU_NAME',''),'Coffeelake') or contains(exsl:ctx('CPU_NAME',''),'Cometlake'))">
            <xsl:text>coffeelake</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="$detectHBM">
                <xsl:value-of select="concat(exsl:ctx('PMU', 'empty'), '_hbm')"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="exsl:ctx('PMU', 'empty')"></xsl:value-of>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="exsl:ctx('usePerfMetrics', 0) and (exsl:ctx('isSEPDriverAvailable', 0) and exsl:ctx('Hypervisor', 'None') = 'None' and $isPerfmetricsSupported = 'true')">
          <xsl:text>_pmetrics</xsl:text>
        </xsl:if>
        <xsl:text>.xsl</xsl:text>
      </xsl:variable>
      <tmamQueryFile>
        <xsl:choose>
          <xsl:when test="exsl:is_file_exist(string($tmamFile))">
            <xsl:value-of select="$tmamFile"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>config://include/queries_tmam_3_1/empty.xsl</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </tmamQueryFile>
      <xsl:variable name="fpuMetricsFile">
        <xsl:text>config://include/queries_fpu_</xsl:text>
        <xsl:value-of select="exsl:ctx('fpuVersion', '1_0')"></xsl:value-of>
        <xsl:text>/</xsl:text>
        <xsl:value-of select="exsl:ctx('PMU', 'empty')"></xsl:value-of>
        <xsl:text>.xsl</xsl:text>
      </xsl:variable>
      <fpuQueryFile>
        <xsl:choose>
          <xsl:when test="exsl:is_file_exist(string($fpuMetricsFile))">
            <xsl:value-of select="$fpuMetricsFile"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>config://include/queries_fpu_1_0/empty.xsl</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </fpuQueryFile>
      <isTmamSmtAware>
        <xsl:choose>
          <xsl:when test="not(exsl:ctx('PMU')='knl' or not(exsl:ctx('isHTEnabled', 1)) or exsl:ctx('tmamVersion', '3_21') = '3_2' or exsl:ctx('tmamVersion', '3_21') = '3_14' or exsl:ctx('tmamVersion', '3_21') = '3_11' or exsl:ctx('tmamVersion', '3_21') = '3_1' or exsl:ctx('tmamVersion', '3_21') = '3_02')">
            <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isTmamSmtAware>
      <muxRatioFixedEvent>
        <xsl:choose>
          <xsl:when test="exsl:ctx('targetOS')='Linux' and contains(exsl:ctx('Hypervisor', 'None'),'KVM')">
            <name>INST_RETIRED.ANY</name>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="(exsl:ctx('PMU') = 'airmont')  or (exsl:ctx('PMU') = 'goldmont') or (exsl:ctx('PMU') = 'silvermont')">
                <name>CPU_CLK_UNHALTED.CORE</name>
              </xsl:when>
              <xsl:otherwise>
                <name>CPU_CLK_UNHALTED.THREAD</name>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </muxRatioFixedEvent>
      <muxRatioProgrEvent>
        <xsl:choose>
          <xsl:when test="exsl:ctx('targetOS')='Linux' and contains(exsl:ctx('Hypervisor', 'None'),'KVM')">
            <name>INST_RETIRED.ANY_P</name>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="(exsl:ctx('PMU') = 'airmont')  or (exsl:ctx('PMU') = 'goldmont') or (exsl:ctx('PMU') = 'silvermont')">
                <name>CPU_CLK_UNHALTED.CORE_P</name>
              </xsl:when>
              <xsl:otherwise>
                <name>CPU_CLK_UNHALTED.THREAD_P</name>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </muxRatioProgrEvent>
      <isPTBasedCallCounts>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'haswell'
                      or exsl:ctx('PMU') = 'haswell_server'
                      or exsl:ctx('PMU') = 'silvermont'
                      or exsl:ctx('PMU') = 'airmont'
                      or exsl:ctx('PMU') = 'crystalwell'
                      or exsl:ctx('PMU') = 'airmont'
                      or exsl:ctx('PMU') = 'broadwell'
                      or exsl:ctx('PMU') = 'broadwell_de'
                      or exsl:ctx('PMU') = 'broadwell_server'
                      or exsl:ctx('PMU') = 'knl'
                      or exsl:ctx('PMU') = 'goldmont'
                      or exsl:ctx('PMU') = 'goldmont_plus'">
            <xsl:text>false</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>true</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isPTBasedCallCounts>
      <cacheOccupancyEvents>
        <xsl:choose>
          <xsl:when test="exsl:ctx('isL3CacheOccupancyAvailable', '')='true'">
              <xsl:text>UNC_CMT_L3_CACHE_OCCUPANCY:intread,</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text></xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </cacheOccupancyEvents>
      <cacheUsageEvents>
        <xsl:choose>
          <xsl:when test="exsl:ctx('isCATSupportedByCPU', '')='true'">
            <xsl:if test="exsl:ctx('isL2CATAvailable', '')='true'">
              <xsl:text>UNC_CAT_L2_MASK:intread,</xsl:text>
            </xsl:if>
            <xsl:if test="exsl:ctx('isL3CATAvailable', '')='true'">
              <xsl:text>UNC_CAT_L3_MASK:intread,</xsl:text>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text></xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </cacheUsageEvents>
      <L3CATSegments>
        <xsl:choose>
          <xsl:when test="exsl:ctx('isL3CATAvailable', '')='true'">
            <xsl:for-each select="str:tokenize(exsl:ctx('L3CATDetails',''), ';')">
              <xsl:if test="contains(.,'ways=')">
                <xsl:value-of select="str:replace(., 'ways=', '')"/>
              </xsl:if>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>1</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </L3CATSegments>
      <L2CATSegments>
        <xsl:choose>
          <xsl:when test="exsl:ctx('isL2CATAvailable', '')='true'">
            <xsl:for-each select="str:tokenize(exsl:ctx('L2CATDetails',''), ';')">
              <xsl:if test="contains(.,'ways=')">
                <xsl:value-of select="str:replace(., 'ways=', '')"/>
              </xsl:if>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>1</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </L2CATSegments>
      <l3ExternalBWEvents>
        <xsl:choose>
          <xsl:when test="exsl:ctx('isL3LocalBWAvailable', 0)">
            <xsl:text>UNC_MBM_LOCAL_EXTERNAL_BW:intread,</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text></xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </l3ExternalBWEvents>
      <xsl:copy-of select="$specifics//common/HBMEvents"/>
      <xsl:copy-of select="$specifics//common/CXLEvents"/>
    </variables>
  </xsl:template>
</xsl:stylesheet>
