# Copyright (C) 2023 Intel Corporation
# SPDX-License-Identifier: MIT

from cli.args import parse_args
from mpp.core.input import Mpp
from cli.console_output import ConsoleOutput


def main(dry_run=False):
    ConsoleOutput.show_banner()
    args = parse_args()
    ConsoleOutput.initialize_logging(args.verbose)

    try:
        if not dry_run:
            run(args)
    except Exception as e:
        ConsoleOutput.show_error('Error running Metric post processor', exception=e)


def run(cli_args):
    from cli.mpp_cli import MppCli
    mpp_cli = MppCli(cli_args)
    mpp_cli.initialize()
    mpp = Mpp(mpp_cli.get_api_args())
    mpp.initialize()

    ConsoleOutput.show_run_information(mpp.ref_tsc)

    mpp.process_data(mpp_cli.parser.event_reader, mpp_cli.partitions, cli_args.parallel_cores, cli_args.no_detail_views)
    mpp.generate_summary_views(mpp_cli.first_sample, mpp_cli.last_sample)
    mpp_cli.generate_tps_views(mpp.view_writer, mpp.summary_views)
    ConsoleOutput.show_sample_count(mpp_cli.first_sample, mpp_cli.last_sample, mpp_cli.num_unique_events, mpp.total_metrics_derived)
    mpp_cli.write_excel_output(mpp.view_collection)
