/*******************************************************************************
* Copyright 2016 Intel Corporation.
*
*
* This software and the related documents are Intel copyrighted materials, and your use of them is governed by
* the express license under which they were provided to you ('License'). Unless the License provides otherwise,
* you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
* documents without Intel's prior written permission.
* This software and the related documents are provided as is, with no express or implied warranties, other than
* those that are expressly stated in the License.
*******************************************************************************/

#include "pifsobel_t.h"

/* /////////////////////////////////////////////////////////////////////////////
//  Name:               ownGetSobelSliceSize
//
//  Purpose:            Splits image to equal slices depending on ROI size and number of threads.
//                      Last slice can be slightly bigger than others.
//
//  Parameters:
//   roiSize            Size of destination ROI in pixels.
//   maskId             Predefined mask of IppiMaskSize type.
//   pTileSize          Size of single slice
//   lastTileSize       Size of last slice
//   splitImage         Amount of splits in x- and y- directions
//
//  Return Values:
//   void
*/
void ownGetSobelSliceSize(IppiSize roiSize, IppiMaskSize maskId, IppiSize* pTileSize, IppiSize* lastTileSize,
                          IppiPoint* splitImage)
{
    IppiSize sliceSize = { 0, 0 };
    (*splitImage).x = (*splitImage).y = 1;

    sliceSize.height = IPP_MIN(SLICE_MIN_HEIGHT(maskId), roiSize.height);
    sliceSize.width  = roiSize.width;

    /* split the image to tiles */
    ippiSplitToTiles_T(roiSize, sliceSize, splitImage, pTileSize, lastTileSize);
}
