/*******************************************************************************
* Copyright 2015 Intel Corporation.
*
*
* This software and the related documents are Intel copyrighted materials, and your use of them is governed by
* the express license under which they were provided to you ('License'). Unless the License provides otherwise,
* you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
* documents without Intel's prior written permission.
* This software and the related documents are provided as is, with no express or implied warranties, other than
* those that are expressly stated in the License.
*******************************************************************************/

/*
//   Description:
//       Intel(R) Integrated Performance Primitives (Intel(R) IPP) Resize Functions Wrappers for Threading Layer redefinitions:
//       functions with _L API call their _LT versions
//
//   Content:
//       ippiResizeAntialiasingLinearInit_C4R_LT
//       ippiResizeAntialiasingCubicInit_C4R_LT
//       ippiResizeAntialiasingLanczosInit_C4R_LT
//       ippiResizeAntialiasing_8u_C1R_LT_Proxy
//       ippiResizeAntialiasing_8u_C3R_LT_Proxy
//       ippiResizeAntialiasing_8u_C4R_LT_Proxy
//       ippiResizeAntialiasing_16u_C1R_LT_Proxy
//       ippiResizeAntialiasing_16u_C3R_LT_Proxy
//       ippiResizeAntialiasing_16u_C4R_LT_Proxy
//       ippiResizeAntialiasing_16s_C1R_LT_Proxy
//       ippiResizeAntialiasing_16s_C3R_LT_Proxy
//       ippiResizeAntialiasing_16s_C4R_LT_Proxy
//       ippiResizeAntialiasing_32f_C1R_LT_Proxy
//       ippiResizeAntialiasing_32f_C3R_LT_Proxy
//       ippiResizeAntialiasing_32f_C4R_LT_Proxy
//
*/

#if defined( IPP_ENABLED_THREADING_LAYER_REDEFINITIONS )
    #error "This file is not intended to be compiled with -DIPP_ENABLED_THREADING_LAYER_REDEFINITIONS option. Use this option in your application instead."
#endif

#include "owndefs_tl.h"
#include "ippi_tl.h"

/* //////////////////////////////////////////////////////////// */

IPPFUN(IppStatus, ippiResizeAntialiasingLinearInit_C4R_LT, (IppiSizeL srcSize, IppiSizeL dstSize, IppDataType dataType, IppiResizeSpec_LT* pSpec, Ipp8u* pInitBuf))
{
    return ippiResizeAntialiasingLinearInit_LT(srcSize, dstSize, dataType, 4, pSpec, pInitBuf);
}
IPPFUN(IppStatus, ippiResizeAntialiasingCubicInit_C4R_LT, (IppiSizeL srcSize, IppiSizeL dstSize, IppDataType dataType, Ipp32f valueB, Ipp32f valueC, IppiResizeSpec_LT* pSpec, Ipp8u* pInitBuf))
{
    return ippiResizeAntialiasingCubicInit_LT(srcSize, dstSize, dataType, 4, valueB, valueC, pSpec, pInitBuf);
}
IPPFUN(IppStatus, ippiResizeAntialiasingLanczosInit_C4R_LT, (IppiSizeL srcSize, IppiSizeL dstSize, IppDataType dataType, Ipp32u numLobes, IppiResizeSpec_LT* pSpec, Ipp8u* pInitBuf))
{
    return ippiResizeAntialiasingLanczosInit_LT(srcSize, dstSize, dataType, 4, numLobes, pSpec, pInitBuf);
}

/* //////////////////////////////////////////////////////////// */

#define ippiResizeBorder_LT_Proxy(ftype, type, depth, chan)                                                                 \
IPPFUN(IppStatus, ippiResize##ftype##_##depth##_C##chan##R_LT_Proxy, (                                                      \
    const type* pSrc,                                                                                                       \
    IppSizeL srcStep,                                                                                                       \
    type* pDst,                                                                                                             \
    IppSizeL dstStep,                                                                                                       \
    IppiPointL dstOffset,                                                                                                   \
    IppiSizeL dstSize,                              /* shall be set in init */                                              \
    IppiBorderType border,                                                                                                  \
    const type* pBorderValue,                                                                                               \
    const IppiResizeSpec_LT* pSpec,                                                                                         \
    Ipp8u* pBuffer))                                                                                                        \
{                                                                                                                           \
    return ippiResize##ftype##_##depth##_C##chan##R_LT(pSrc, srcStep, pDst, dstStep, border, pBorderValue, pSpec, pBuffer); \
}

ippiResizeBorder_LT_Proxy(Antialiasing, Ipp8u, 8u, 1)
ippiResizeBorder_LT_Proxy(Antialiasing, Ipp8u, 8u, 3)
ippiResizeBorder_LT_Proxy(Antialiasing, Ipp8u, 8u, 4)
ippiResizeBorder_LT_Proxy(Antialiasing, Ipp16u, 16u, 1)
ippiResizeBorder_LT_Proxy(Antialiasing, Ipp16u, 16u, 3)
ippiResizeBorder_LT_Proxy(Antialiasing, Ipp16u, 16u, 4)
ippiResizeBorder_LT_Proxy(Antialiasing, Ipp16s, 16s, 1)
ippiResizeBorder_LT_Proxy(Antialiasing, Ipp16s, 16s, 3)
ippiResizeBorder_LT_Proxy(Antialiasing, Ipp16s, 16s, 4)
ippiResizeBorder_LT_Proxy(Antialiasing, Ipp32f, 32f, 1)
ippiResizeBorder_LT_Proxy(Antialiasing, Ipp32f, 32f, 3)
ippiResizeBorder_LT_Proxy(Antialiasing, Ipp32f, 32f, 4)

/* //////////////////////////////////////////////////////////// */
