<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:exsl="http://exslt.org/common"
                xmlns:dyn="http://exslt.org/dynamic"
                xmlns:str="http://exslt.org/strings"
                xmlns:func="http://exslt.org/functions"
                extension-element-prefixes="func"
                xmlns:fnc="urn:functions">
  <func:function name="fnc:is_multi_gpu_adapter_system">
    <func:result select="count(str:split(exsl:ctx('gpuAdapterNameList', ''), ';')) > 1"/>
  </func:function>
  <func:function name="fnc:get_multi_adapter_grouping">
    <xsl:choose>
      <xsl:when test="fnc:is_multi_gpu_adapter_system()">
        <func:result select="string('/GPUAdapterAlias')"/>
      </xsl:when>
      <xsl:otherwise>
        <func:result select="string()"/>
      </xsl:otherwise>
    </xsl:choose>
  </func:function>
  <func:function name="fnc:is_multi_gpu_tile_system">
    <xsl:variable name="result">
      <xsl:for-each select="str:split(exsl:ctx('gpuAdapterTileNameList', ''), ';')">
        <xsl:variable name="info" select="str:split(., '|')"/>
        <xsl:variable name="bdf" select="string($info[1])"/>
        <xsl:variable name="name" select="string($info[2])"/>
        <xsl:variable name="tiles" select="string($info[3])"/>
        <xsl:value-of select="count(str:split($tiles, ',')) > 1"/>
      </xsl:for-each>
    </xsl:variable>
    <func:result select="contains($result, 'true')"/>
  </func:function>
  <func:function name="fnc:get_multi_tile_grouping">
    <xsl:choose>
      <xsl:when test="fnc:is_multi_gpu_tile_system()">
        <func:result select="string('/GPUTileName')"/>
      </xsl:when>
      <xsl:otherwise>
        <func:result select="string()"/>
      </xsl:otherwise>
    </xsl:choose>
  </func:function>
  <func:function name="fnc:get_multi_gpu_grouping">
    <func:result select="concat(fnc:get_multi_adapter_grouping(), fnc:get_multi_tile_grouping())"/>
  </func:function>
  <func:function name="fnc:is_universal_collector_in_multirun_mode">
    <func:result select="(string(exsl:ctx('isGpuMultiRunRequired', 'false')) != 'false') or contains(string(exsl:ctx('gpuCounters', '')), 'full-compute')"/>
  </func:function>
  <func:function name="fnc:node_join">
    <xsl:param name="node_set"/>
    <xsl:param name="node_path" select="'value'"/>
    <xsl:param name="separator" select="','"/>
    <xsl:variable name="result">
      <xsl:for-each select="dyn:evaluate(concat('exsl:node-set($node_set)/', $node_path))">
        <xsl:value-of select="."/><xsl:if test="not(position()=last())"><xsl:value-of select="$separator"/></xsl:if>
      </xsl:for-each>
    </xsl:variable>
    <func:result select="string($result)"/>
  </func:function>
  <func:function name="fnc:has_value_for_adapter">
    <xsl:param name="option_value"/>
    <xsl:param name="bdf"/>
    <xsl:param name="value"/>
    <xsl:param name="value_separator" select="string(',')"/>
    <xsl:param name="bdf_separator" select="string('|')"/>
    <xsl:variable name="result">
      <xsl:for-each select="str:split($option_value, $value_separator)">
      <xsl:variable name="adapter_option" select="str:split(., $bdf_separator)"/>
      <xsl:if test="($bdf = $adapter_option[1]) and ($adapter_option[2] = $value)">
          <xsl:text>.</xsl:text>
      </xsl:if>
      </xsl:for-each>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="string($result)">
        <func:result select="true()"/>
      </xsl:when>
      <xsl:otherwise>
        <func:result select="false()"/>
      </xsl:otherwise>
    </xsl:choose>
  </func:function>
  <func:function name="fnc:has_value">
    <xsl:param name="option_value"/>
    <xsl:param name="value"/>
    <xsl:param name="value_separator" select="string(',')"/>
    <xsl:param name="bdf_separator" select="string('|')"/>
    <xsl:variable name="result">
      <xsl:for-each select="str:split($option_value, $value_separator)">
      <xsl:variable name="adapter_option" select="str:split(., $bdf_separator)"/>
      <xsl:if test="$adapter_option[2] = $value">
          <xsl:text>.</xsl:text>
      </xsl:if>
      </xsl:for-each>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="string($result)">
        <func:result select="true()"/>
      </xsl:when>
      <xsl:otherwise>
        <func:result select="false()"/>
      </xsl:otherwise>
    </xsl:choose>
  </func:function>
  <func:function name="fnc:is_collection_enabled">
    <xsl:param name="option_value"/>
    <xsl:param name="bdf"/>
    <xsl:param name="value_separator" select="string(',')"/>
    <xsl:param name="bdf_separator" select="string('|')"/>
    <func:result select="fnc:has_value_for_adapter($option_value, $bdf, 'true', $value_separator, $bdf_separator)"/>
  </func:function>
  <func:function name="fnc:is_hw_sampling_enabled">
    <xsl:param name="bdf"/>
    <func:result select="fnc:is_collection_enabled(exsl:ctx('gpuHWProfiling', ''), $bdf)"/>
  </func:function>
  <func:function name="fnc:is_opencl_tracing_enabled">
    <xsl:param name="bdf"/>
    <func:result select="fnc:is_collection_enabled(exsl:ctx('collectGpuOpenCl', ''), $bdf)"/>
  </func:function>
  <func:function name="fnc:is_gpu_hw_stall_reason_collection_available">
    <xsl:param name="bdf" select="string()"/>
    <xsl:param name="value_separator" select="string(';')"/>
    <xsl:param name="bdf_separator" select="string('|')"/>
    <xsl:variable name="gpu_hw_stall_reason_collection_available_context_value" select="exsl:ctx('isGpuHwStallReasonCollectionAvailableList', '')"/>
    <xsl:choose>
      <xsl:when test="string($bdf)">
        <func:result select="fnc:has_value_for_adapter($gpu_hw_stall_reason_collection_available_context_value, $bdf, 'true', $value_separator, $bdf_separator)"/>
      </xsl:when>
      <xsl:otherwise>
        <func:result select="fnc:has_value($gpu_hw_stall_reason_collection_available_context_value, 'true', $value_separator, $bdf_separator)"/>
      </xsl:otherwise>
    </xsl:choose>
  </func:function>
  <func:function name="fnc:has_gpu_in_platform_index_list" as="booolean">
    <xsl:param name="gpu_cond_func" select="string()"/>
    <xsl:param name="gpu_platform_index_list" select="exsl:ctx('gpuPlatformIndexList', string())"/>
    <xsl:variable name="result">
      <xsl:choose>
        <xsl:when test="$gpu_cond_func">
          <xsl:for-each select="str:split($gpu_platform_index_list, ';')">
            <xsl:variable name="gpu_info" select="str:split(., '|')"/>
            <xsl:variable name="gpu_platform_index" select="number($gpu_info[2])"/>
            <xsl:value-of select="dyn:evaluate(concat($gpu_cond_func, '($gpu_platform_index)'))"/>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="$gpu_platform_index_list">
            <xsl:text>true</xsl:text>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <func:result select="contains(string($result), 'true')"/>
  </func:function>
  <func:function name="fnc:filter_target_gpus">
    <xsl:param name="gpu_cond_func" select="string()"/>
    <xsl:variable name="gpu_platform_index_list" select="exsl:ctx('gpuPlatformIndexList', string())"/>
    <xsl:variable name="target_gpus" select="exsl:ctx('targetGPUAtk', string())"/>
    <xsl:variable name="result">
    <xsl:for-each select="str:split($gpu_platform_index_list, ';')">
      <xsl:variable name="gpu_info" select="str:split(., '|')"/>
      <xsl:variable name="gpu_platform_index" select="number($gpu_info[2])"/>
      <xsl:if test="contains($target_gpus, $gpu_info[1]) or not($target_gpus)">
      <xsl:choose>
        <xsl:when test="$gpu_cond_func">
          <xsl:if test="dyn:evaluate(concat($gpu_cond_func, '($gpu_platform_index)'))">
            <value><xsl:value-of select="$gpu_info[1]"/></value>
          </xsl:if>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="$gpu_platform_index_list">
            <value><xsl:value-of select="$gpu_info[1]"/></value>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
    </xsl:for-each>
    </xsl:variable>
    <func:result select="fnc:node_join($result)"/>
  </func:function>
  <func:function name="fnc:has_gpu_on_board" as="booolean">
    <xsl:param name="gpu_cond_func" select="string()"/>
    <func:result select="fnc:has_gpu_in_platform_index_list($gpu_cond_func)"/>
  </func:function>
  <func:function name="fnc:get_collected_platform_indices">
    <xsl:variable name="gpu_platform_index_list" select="exsl:ctx('gpuPlatformIndexList', string())"/>
    <xsl:variable name="target_gpus" select="exsl:ctx('targetGPUAtk', string())"/>
    <xsl:variable name="gpu_selected_metrics" select="exsl:ctx('gpuMetricsSelected', string())"/>
    <xsl:variable name="gpu_counters" select="exsl:ctx('gpuCounters', string())"/>
    <xsl:variable name="result">
      <xsl:for-each select="str:split($gpu_platform_index_list, ';')">
        <xsl:variable name="gpu_info" select="str:split(., '|')"/>
        <xsl:variable name="gpu_platform_index" select="number($gpu_info[2])"/>
        <xsl:if test="contains($target_gpus, $gpu_info[1]) or contains($gpu_selected_metrics, $gpu_info[1]) or contains($gpu_counters, $gpu_info[1])">
        <value>
          <xsl:value-of select="."/>
        </value>
        </xsl:if>
      </xsl:for-each>
    </xsl:variable>
    <func:result select="fnc:node_join($result, 'value', ';')"/>
  </func:function>
  <func:function name="fnc:has_gpu_in_collected" as="booolean">
    <xsl:param name="gpu_cond_func" select="string()"/>
    <func:result select="fnc:has_gpu_in_platform_index_list($gpu_cond_func, fnc:get_collected_platform_indices())"/>
  </func:function>
  <func:function name="fnc:is_lnl">
    <xsl:param name="platformIndex"/>
    <func:result select="$platformIndex = 31"/>
  </func:function>
  <func:function name="fnc:is_bmg">
    <xsl:param name="platformIndex"/>
    <func:result select="$platformIndex = 28"/>
  </func:function>
  <func:function name="fnc:is_not_lnl_and_bmg">
    <xsl:param name="platformIndex"/>
    <func:result select="not(fnc:is_lnl($platformIndex)) and not(fnc:is_bmg($platformIndex))"/>
  </func:function>
  <func:function name="fnc:is_lnl_or_bmg">
    <xsl:param name="platformIndex"/>
    <func:result select="fnc:is_lnl($platformIndex) or fnc:is_bmg($platformIndex)"/>
  </func:function>
  <func:function name="fnc:is_mtl">
    <xsl:param name="platformIndex"/>
    <func:result select="$platformIndex = 27"/>
  </func:function>
  <func:function name="fnc:is_arl">
    <xsl:param name="platformIndex"/>
    <func:result select="$platformIndex = 34"/>
  </func:function>
  <func:function name="fnc:is_not_mtl_and_arl">
    <xsl:param name="platformIndex"/>
    <func:result select="not(fnc:is_mtl($platformIndex)) and not(fnc:is_arl($platformIndex))"/>
  </func:function>
  <func:function name="fnc:is_mtl_or_arl">
    <xsl:param name="platformIndex"/>
    <func:result select="fnc:is_mtl($platformIndex) or fnc:is_arl($platformIndex)"/>
  </func:function>
  <func:function name="fnc:is_pvc">
    <xsl:param name="platformIndex"/>
    <func:result select="$platformIndex = 25"/>
  </func:function>
  <func:function name="fnc:is_dg2">
    <xsl:param name="platformIndex"/>
    <func:result select="$platformIndex = 24"/>
  </func:function>
  <func:function name="fnc:is_not_dg2">
    <xsl:param name="platformIndex"/>
    <func:result select="not(fnc:is_dg2($platformIndex))"/>
  </func:function>
  <func:function name="fnc:is_dg2_or_pvc">
    <xsl:param name="platformIndex"/>
    <func:result select="fnc:is_dg2($platformIndex) or fnc:is_pvc($platformIndex)"/>
  </func:function>
  <func:function name="fnc:is_not_dg2_and_pvc">
    <xsl:param name="platformIndex"/>
    <func:result select="not(fnc:is_dg2($platformIndex)) and not(fnc:is_pvc($platformIndex))"/>
  </func:function>
   <func:function name="fnc:is_tgl">
    <xsl:param name="platformIndex"/>
    <func:result select="$platformIndex = 17"/>
  </func:function>
  <func:function name="fnc:is_dg1">
    <xsl:param name="platformIndex"/>
    <func:result select="$platformIndex = 21"/>
  </func:function>
  <func:function name="fnc:is_ats">
    <xsl:param name="platformIndex"/>
    <func:result select="$platformIndex = 22"/>
  </func:function>
  <func:function name="fnc:is_adl">
    <xsl:param name="platformIndex"/>
    <func:result select="($platformIndex = 26) or ($platformIndex = 30)"/>
  </func:function>
  <func:function name="fnc:is_rpl">
    <xsl:param name="platformIndex"/>
    <func:result select="$platformIndex = 29"/>
  </func:function>
  <func:function name="fnc:is_gen12">
    <xsl:param name="platformIndex"/>
    <func:result select="fnc:is_dg2_or_pvc($platformIndex) or fnc:is_tgl($platformIndex) or fnc:is_ats($platformIndex) or fnc:is_dg1($platformIndex) or fnc:is_mtl($platformIndex) or fnc:is_arl($platformIndex) or fnc:is_rpl($platformIndex) or fnc:is_adl($platformIndex)"/>
  </func:function>
  <func:function name="fnc:is_not_gen12">
    <xsl:param name="platformIndex"/>
    <func:result select="not(fnc:is_dg2_or_pvc($platformIndex)) and not(fnc:is_tgl($platformIndex)) and not(fnc:is_ats($platformIndex)) and not(fnc:is_dg1($platformIndex)) and not(fnc:is_mtl($platformIndex)) and not(fnc:is_arl($platformIndex)) and not(fnc:is_adl($platformIndex)) and not(fnc:is_rpl($platformIndex))"/>
  </func:function>
  <func:function name="fnc:is_not_dg2_pvc_mtl_arl">
    <xsl:param name="platformIndex"/>
    <func:result select="not(fnc:is_dg2_or_pvc($platformIndex)) and not(fnc:is_mtl($platformIndex)) and not(fnc:is_arl($platformIndex))"/>
  </func:function>
  <func:function name="fnc:is_not_dg2_mtl_arl">
    <xsl:param name="platformIndex"/>
    <func:result select="not(fnc:is_dg2($platformIndex)) and not(fnc:is_mtl($platformIndex)) and not(fnc:is_arl($platformIndex))"/>
  </func:function>
  <func:function name="fnc:get_alu2_name">
    <xsl:choose>
      <xsl:when test="fnc:has_gpu_in_collected('fnc:is_pvc')">
        <func:result select="string('Sys')"/>
      </xsl:when>
      <xsl:otherwise>
        <func:result select="string('XMX')"/>
      </xsl:otherwise>
    </xsl:choose>
  </func:function>
  <func:function name="fnc:is_media_metrics_supported">
    <xsl:param name="platformIndex"/>
    <func:result select="fnc:is_mtl($platformIndex) or fnc:is_arl($platformIndex) or fnc:is_lnl($platformIndex) or fnc:is_bmg($platformIndex)"/>
  </func:function>
  <func:function name="fnc:is_media_metrics_not_supported">
    <xsl:param name="platformIndex"/>
    <func:result select="not(fnc:is_media_metrics_supported($platformIndex))"/>
  </func:function>
</xsl:stylesheet>
