/*
 * Copyright (C) 2013 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/

#ifndef _PERFVER4_H_
#define _PERFVER4_H_

#include "msrdefs.h"

extern DISPATCH_NODE  perfver4_dispatch;
extern DISPATCH_NODE  perfver4_dispatch_htoff_mode;
extern DISPATCH_NODE  perfver4_dispatch_nonht_mode;

#define PERFVER4_UNC_BLBYPASS_BITMASK      0x00000001
#define PERFVER4_UNC_DISABLE_BL_BYPASS_MSR 0x39C

#if defined(DRV_IA32)
#define PERFVER4_LBR_DATA_BITS             32
#else
#define PERFVER4_LBR_DATA_BITS             57
#endif

#define PERFVER4_LBR_BITMASK               ((1ULL << PERFVER4_LBR_DATA_BITS) -1)

#define PERFVER4_FROZEN_BIT_MASK           0xc00000000000000ULL
#define PERFVER4_OVERFLOW_BIT_MASK_HT_ON   0x600000070000000FULL
#define PERFVER4_OVERFLOW_BIT_MASK_HT_OFF  0x60000007000000FFULL
#define PERFVER4_OVERFLOW_BIT_MASK_NON_HT  0x6000007F000003FFULL

#endif
