/*******************************************************************************
* Copyright 2018 Intel Corporation.
*
*
* This software and the related documents are Intel copyrighted materials, and your use of them is governed by
* the express license under which they were provided to you ('License'). Unless the License provides otherwise,
* you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
* documents without Intel's prior written permission.
* This software and the related documents are provided as is, with no express or implied warranties, other than
* those that are expressly stated in the License.
*
*******************************************************************************/

#ifndef PIRGBTOLAB_T_H__
#define PIRGBTOLAB_T_H__

#include "ippcore.h"
#include "owndefs_tl.h"
#include "ippcore_tl.h"
#include "ippi_tl.h"
#include "ipps.h"
#include "ippi.h"
#include "ippcc.h"
#include "ippdefs.h"
#include "ownisplit_t.h"
#include "owni_tl.h"


#ifdef USE_OMP
#include <omp.h>
#endif

#ifdef USE_OMP
/* minimal number of addition operations for threading */
#define IPP64_MIN_RGBLAB_2D        128*128
#elif defined(USE_TBB)
/* minimal number of addition operations for threading */
#define IPP64_MIN_RGBLAB_2D        128*128
#else
/* threading is not applied */
#define IPP64_MIN_RGBLAB_2D        IPP_MAX_32S
#endif


typedef struct _ippiRGBLab_32f_LT_Str
{
    Ipp32f* pSrc[3]; // const
    int srcStep[3];
    Ipp32f* pDst[3];
    int dstStep[3];
    IppiSize roiSize;
    IppiPoint splitImage;
    IppiSize  tileSize;
    IppiSize tailSize;
} ippiRGBLab_32f_T_Str;
typedef struct _ippiRGBLab_64f_T_Str
{
    Ipp64f* pSrc[3]; // const
    int srcStep[3];
    Ipp64f* pDst[3];
    int dstStep[3];
    IppiSize roiSize;
    IppiPoint splitImage;
    IppiSize  tileSize;
    IppiSize tailSize;
} ippiRGBLab_64f_T_Str;

static void RGBLabThreadingStructureEncode_32f_T (
    const Ipp32f* pSrc[3],
    int srcStep[3],
    Ipp32f* pDst[3],
    int dstStep[3],
    IppiSize roiSize,
    IppiPoint splitImage,
    IppiSize  tileSize,
    IppiSize tailSize,
    ippiRGBLab_32f_T_Str * ts
)
{
    ts->pSrc[0] = (Ipp32f*)pSrc[0];
    ts->pSrc[1] = (Ipp32f*)pSrc[1];
    ts->pSrc[2] = (Ipp32f*)pSrc[2];
    ts->srcStep[0] = srcStep[0];
    ts->srcStep[1] = srcStep[1];
    ts->srcStep[2] = srcStep[2];
    ts->pDst[0] = pDst[0];
    ts->pDst[1] = pDst[1];
    ts->pDst[2] = pDst[2];
    ts->dstStep[0] = dstStep[0];
    ts->dstStep[1] = dstStep[1];
    ts->dstStep[2] = dstStep[2];
    ts->roiSize = roiSize;
    ts->splitImage = splitImage;
    ts->tileSize = tileSize;
    ts->tailSize = tailSize;
}
static void RGBLabThreadingStructureEncode_64f_T(
    const Ipp64f* pSrc[3],
    int srcStep[3],
    Ipp64f* pDst[3],
    int dstStep[3],
    IppiSize roiSize,
    IppiPoint splitImage,
    IppiSize  tileSize,
    IppiSize tailSize,
    ippiRGBLab_64f_T_Str * ts
)
{
    ts->pSrc[0] = (Ipp64f*)pSrc[0];
    ts->pSrc[1] = (Ipp64f*)pSrc[1];
    ts->pSrc[2] = (Ipp64f*)pSrc[2];
    ts->srcStep[0] = srcStep[0];
    ts->srcStep[1] = srcStep[1];
    ts->srcStep[2] = srcStep[2];
    ts->pDst[0] = pDst[0];
    ts->pDst[1] = pDst[1];
    ts->pDst[2] = pDst[2];
    ts->dstStep[0] = dstStep[0];
    ts->dstStep[1] = dstStep[1];
    ts->dstStep[2] = dstStep[2];
    ts->roiSize = roiSize;
    ts->splitImage = splitImage;
    ts->tileSize = tileSize;
    ts->tailSize = tailSize;
}
#endif // PIRGBTOLAB_T_H__
