/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.archive.internal.StandardArchiveDescriptorFactory;
import org.hibernate.boot.archive.internal.UrlInputStreamAccess;
import org.hibernate.boot.archive.scan.internal.DisabledScanner;
import org.hibernate.boot.archive.scan.internal.ScannerLogger;
import org.hibernate.boot.archive.scan.internal.StandardScanParameters;
import org.hibernate.boot.archive.scan.spi.ClassDescriptor;
import org.hibernate.boot.archive.scan.spi.MappingFileDescriptor;
import org.hibernate.boot.archive.scan.spi.PackageDescriptor;
import org.hibernate.boot.archive.scan.spi.ScanEnvironment;
import org.hibernate.boot.archive.scan.spi.ScanResult;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.boot.archive.scan.spi.ScannerFactory;
import org.hibernate.boot.archive.spi.ArchiveDescriptorFactory;
import org.hibernate.boot.internal.ClassLoaderAccessImpl;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.model.convert.internal.ConverterDescriptors;
import org.hibernate.boot.model.process.internal.ManagedResourcesImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.XmlMappingBinderAccess;

public class ScanningCoordinator {
    public static final ScanningCoordinator INSTANCE = new ScanningCoordinator();

    private ScanningCoordinator() {
    }

    public void coordinateScan(ManagedResourcesImpl managedResources, BootstrapContext bootstrapContext, XmlMappingBinderAccess xmlMappingBinderAccess) {
        if (bootstrapContext.getScanEnvironment() != null) {
            Scanner scanner = ScanningCoordinator.buildScanner(bootstrapContext);
            ScanResult scanResult = scanner.scan(bootstrapContext.getScanEnvironment(), bootstrapContext.getScanOptions(), StandardScanParameters.INSTANCE);
            this.applyScanResultsToManagedResources(managedResources, scanResult, bootstrapContext, xmlMappingBinderAccess);
        }
    }

    private static Scanner buildScanner(BootstrapContext bootstrapContext) {
        Object scannerSetting = bootstrapContext.getScanner();
        ArchiveDescriptorFactory archiveDescriptorFactory = bootstrapContext.getArchiveDescriptorFactory();
        if (scannerSetting == null) {
            return ScanningCoordinator.getStandardScanner(bootstrapContext, archiveDescriptorFactory);
        }
        if (scannerSetting instanceof Scanner) {
            Scanner scanner = (Scanner)scannerSetting;
            if (archiveDescriptorFactory != null) {
                throw new IllegalStateException("A Scanner instance and an ArchiveDescriptorFactory were both specified; please specify one or the other, or if you need to supply both, Scanner class to use (assuming it has a constructor accepting a ArchiveDescriptorFactory).  Alternatively, just pass the ArchiveDescriptorFactory during your own Scanner constructor assuming it is statically known.");
            }
            return scanner;
        }
        return ScanningCoordinator.createScanner(archiveDescriptorFactory, ScanningCoordinator.scannerClass(bootstrapContext, scannerSetting));
    }

    private static Class<? extends Scanner> scannerClass(BootstrapContext bootstrapContext, Object scannerSetting) {
        if (scannerSetting instanceof Class) {
            Class scannerSettingClass = (Class)scannerSetting;
            if (!Scanner.class.isAssignableFrom(scannerSettingClass)) {
                throw new IllegalArgumentException("Configuration provided a custom scanner class '" + scannerSettingClass.getName() + "' which does not implement 'Scanner'");
            }
            return scannerSettingClass.asSubclass(Scanner.class);
        }
        ClassLoaderAccessImpl classLoaderAccess = new ClassLoaderAccessImpl(bootstrapContext.getJpaTempClassLoader(), bootstrapContext.getClassLoaderService());
        return classLoaderAccess.classForName(scannerSetting.toString());
    }

    private static Scanner createScanner(ArchiveDescriptorFactory archiveDescriptorFactory, Class<? extends Scanner> scannerImplClass) {
        Class[] SINGLE_ARG = new Class[]{ArchiveDescriptorFactory.class};
        if (archiveDescriptorFactory != null) {
            try {
                Constructor<? extends Scanner> constructor = scannerImplClass.getConstructor(SINGLE_ARG);
                try {
                    return constructor.newInstance(archiveDescriptorFactory);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error instantiating custom scanner class '" + scannerImplClass.getName() + "'", e);
                }
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Configuration specified a custom scanner class and a custom ArchiveDescriptorFactory, but Scanner implementation does not have a constructor accepting ArchiveDescriptorFactory");
            }
        }
        try {
            Constructor<? extends Scanner> constructor = scannerImplClass.getConstructor(SINGLE_ARG);
            try {
                return constructor.newInstance(StandardArchiveDescriptorFactory.INSTANCE);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error instantiating custom scanner class '" + scannerImplClass.getName() + "'", e);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<? extends Scanner> constructor = scannerImplClass.getConstructor(new Class[0]);
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e2) {
                    throw new IllegalStateException("Error instantiating custom scanner class '" + scannerImplClass.getName() + "'", e2);
                }
            }
            catch (NoSuchMethodException ignore) {
                throw new IllegalArgumentException("Configuration specified a custom scanner class with no appropriate constructor");
            }
        }
    }

    private static Scanner getStandardScanner(BootstrapContext bootstrapContext, ArchiveDescriptorFactory archiveDescriptorFactory) {
        Collection<ScannerFactory> scannerFactories = bootstrapContext.getClassLoaderService().loadJavaServices(ScannerFactory.class);
        Iterator<ScannerFactory> iterator = scannerFactories.iterator();
        if (iterator.hasNext()) {
            ScannerFactory scannerFactory = iterator.next();
            Scanner scanner = scannerFactory.getScanner(archiveDescriptorFactory);
            if (scannerFactories.size() > 1) {
                ScannerLogger.SCANNER_LOGGER.multipleScannerFactoriesAvailable(scanner.getClass().getName());
            }
            return scanner;
        }
        ScannerLogger.SCANNER_LOGGER.noScannerFactoryAvailable();
        return new DisabledScanner();
    }

    public void applyScanResultsToManagedResources(ManagedResourcesImpl managedResources, ScanResult scanResult, BootstrapContext bootstrapContext, XmlMappingBinderAccess xmlMappingBinderAccess) {
        List<String> explicitlyListedClassNames;
        ScanEnvironment scanEnvironment = bootstrapContext.getScanEnvironment();
        ClassLoaderService classLoaderService = bootstrapContext.getClassLoaderService();
        HashSet<String> nonLocatedMappingFileNames = new HashSet<String>();
        List<String> explicitMappingFileNames = scanEnvironment.getExplicitlyListedMappingFiles();
        if (explicitMappingFileNames != null) {
            nonLocatedMappingFileNames.addAll(explicitMappingFileNames);
        }
        if (xmlMappingBinderAccess != null) {
            for (MappingFileDescriptor mappingFileDescriptor : scanResult.getLocatedMappingFiles()) {
                managedResources.addXmlBinding(xmlMappingBinderAccess.bind(mappingFileDescriptor.getStreamAccess()));
                nonLocatedMappingFileNames.remove(mappingFileDescriptor.getName());
            }
            for (String name : nonLocatedMappingFileNames) {
                URL url = classLoaderService.locateResource(name);
                if (url == null) {
                    throw new MappingException("Unable to resolve explicitly named mapping file: " + name, new Origin(SourceType.RESOURCE, name));
                }
                managedResources.addXmlBinding(xmlMappingBinderAccess.bind(new UrlInputStreamAccess(url)));
            }
        }
        ArrayList unresolvedListedClassNames = (explicitlyListedClassNames = scanEnvironment.getExplicitlyListedClassNames()) == null ? new ArrayList() : new ArrayList<String>(explicitlyListedClassNames);
        for (ClassDescriptor classDescriptor : scanResult.getLocatedClasses()) {
            if (classDescriptor.getCategorization() == ClassDescriptor.Categorization.CONVERTER) {
                managedResources.addAttributeConverterDefinition(ConverterDescriptors.of(classLoaderService.classForName(classDescriptor.getName()), bootstrapContext.getClassmateContext()));
            } else if (classDescriptor.getCategorization() == ClassDescriptor.Categorization.MODEL) {
                managedResources.addAnnotatedClassName(classDescriptor.getName());
            }
            unresolvedListedClassNames.remove(classDescriptor.getName());
        }
        for (PackageDescriptor packageDescriptor : scanResult.getLocatedPackages()) {
            managedResources.addAnnotatedPackageName(packageDescriptor.getName());
            unresolvedListedClassNames.remove(packageDescriptor.getName());
        }
        for (String unresolvedListedClassName : unresolvedListedClassNames) {
            URL classFileUrl = classLoaderService.locateResource(ScanningCoordinator.classFileName(unresolvedListedClassName));
            if (classFileUrl != null) {
                managedResources.addAnnotatedClassName(unresolvedListedClassName);
                continue;
            }
            URL packageInfoFileUrl = classLoaderService.locateResource(ScanningCoordinator.packageInfoFileName(unresolvedListedClassName));
            if (packageInfoFileUrl != null) {
                managedResources.addAnnotatedPackageName(unresolvedListedClassName);
                continue;
            }
            try {
                Class clazz = classLoaderService.classForName(unresolvedListedClassName);
                managedResources.addAnnotatedClassReference(clazz);
            }
            catch (ClassLoadingException ignore) {
                ScannerLogger.SCANNER_LOGGER.unableToResolveClass(unresolvedListedClassName, scanEnvironment.getRootUrl());
            }
        }
    }

    private static String packageInfoFileName(String unresolvedListedClassName) {
        return unresolvedListedClassName.replace('.', '/') + "/package-info.class";
    }

    private static String classFileName(String unresolvedListedClassName) {
        return unresolvedListedClassName.replace('.', '/') + ".class";
    }
}

