\name{VectorConfidenceConnectedImageFilter}
\alias{VectorConfidenceConnectedImageFilter}
\title{VectorConfidenceConnectedImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Segment pixels with similar statistics using connectivity.
VectorConfidenceConnectedImageFilter}
\details{
This filter extracts a connected set of pixels whose pixel intensities
are consistent with the pixel statistics of a seed point. The mean and
variance across a neighborhood (8-connected, 26-connected, etc.) are
calculated for a seed point. Then pixels connected to this seed point
whose values are within the confidence interval for the seed point are
grouped. The width of the confidence interval is controlled by the
"Multiplier" variable (the confidence interval is the mean plus or
minus the "Multiplier" times the standard deviation). If the
intensity variations across a segment were gaussian, a "Multiplier"
setting of 2.5 would define a confidence interval wide enough to
capture 99\% of samples in the segment.
After this initial segmentation is calculated, the mean and variance
are re-calculated. All the pixels in the previous segmentation are
used to calculate the mean the standard deviation (as opposed to using
the pixels in the neighborhood of the seed point). The segmentation is
then recalculated using these refined estimates for the mean and
variance of the pixel values. This process is repeated for the
specified number of iterations. Setting the "NumberOfIterations" to
zero stops the algorithm after the initial segmentation from the seed
point.
NOTE: the lower and upper threshold are restricted to lie within the
valid numeric limits of the input data pixel type. Also, the limits
may be adjusted to contain the seed point's intensity.
See:
VectorConfidenceConnected for the procedural interface
itk::VectorConfidenceConnectedImageFilter for the Doxygen on the original ITK class.
VectorConfidenceConnectedImageFilter}
%C++ includes: sitkVectorConfidenceConnectedImageFilter.h
\section{Methods}{
\describe{
\item{Self AddSeed(std::vector< unsigned int > point):}{
Add SeedList point.
}
\item{Self ClearSeeds():}{
Remove all SeedList points.
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::vector< double > GetCovariance() const:}{
Get the Covariance matrix computed during the segmentation
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{unsigned int GetInitialNeighborhoodRadius() const:}{
Get/Set the radius of the neighborhood over which the statistics are
evaluated
}
\item{std::vector< double > GetMean() const:}{
Get the Mean Vector computed during the segmentation
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetMultiplier() const:}{
Set/Get the multiplier to define the confidence interval. Multiplier
can be anything greater than zero. A typical value is 2.5
}
\item{std::string GetName() const:}{
Name of this class
}
\item{unsigned int GetNumberOfIterations() const:}{
Set/Get the number of iterations
}
\item{uint8_t GetReplaceValue() const:}{
Set/Get value to replace thresholded pixels
}
\item{std::vector< std::vector< unsigned int > > GetSeedList() const:}{
Get list of seeds.
}
\item{Self SetInitialNeighborhoodRadius(unsigned int InitialNeighborhoodRadius):}{
Get/Set the radius of the neighborhood over which the statistics are
evaluated
}
\item{Self SetMultiplier(double Multiplier):}{
Set/Get the multiplier to define the confidence interval. Multiplier
can be anything greater than zero. A typical value is 2.5
}
\item{Self SetNumberOfIterations(unsigned int NumberOfIterations):}{
Set/Get the number of iterations
}
\item{Self SetReplaceValue(uint8_t ReplaceValue):}{
Set/Get value to replace thresholded pixels
}
\item{Self SetSeedList(std::vector< std::vector< unsigned int > > SeedList):}{
Set list of image indexes for seeds.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ VectorConfidenceConnectedImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{ ~VectorConfidenceConnectedImageFilter():}{
Destructor
}
}
}
