/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.cli.HealthcheckTool;
import org.apache.solr.cli.ReplicaHealth;
import org.apache.solr.common.cloud.Replica;
import org.noggit.CharArr;
import org.noggit.JSONWriter;

class ShardHealth {
    String shard;
    List<ReplicaHealth> replicas;

    ShardHealth(String shard, List<ReplicaHealth> replicas) {
        this.shard = shard;
        this.replicas = replicas;
    }

    public HealthcheckTool.ShardState getShardState() {
        boolean healthy = true;
        boolean hasLeader = false;
        boolean atLeastOneActive = false;
        for (ReplicaHealth replicaHealth : this.replicas) {
            if (replicaHealth.isLeader) {
                hasLeader = true;
            }
            if (!Replica.State.ACTIVE.toString().equals(replicaHealth.status)) {
                healthy = false;
                continue;
            }
            atLeastOneActive = true;
        }
        if (!hasLeader) {
            return HealthcheckTool.ShardState.no_leader;
        }
        return healthy ? HealthcheckTool.ShardState.healthy : (atLeastOneActive ? HealthcheckTool.ShardState.degraded : HealthcheckTool.ShardState.down);
    }

    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("shard", this.shard);
        map.put("status", this.getShardState().toString());
        ArrayList<Map<String, Object>> replicaList = new ArrayList<Map<String, Object>>();
        for (ReplicaHealth replica : this.replicas) {
            replicaList.add(replica.asMap());
        }
        map.put("replicas", replicaList);
        return map;
    }

    public String toString() {
        CharArr arr = new CharArr();
        new JSONWriter(arr, 2).write(this.asMap());
        return arr.toString();
    }
}

