/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.google.common.annotations.VisibleForTesting;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QueryLimit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemAllowedLimit
implements QueryLimit {
    private static final Logger log;
    private static final double MEBI = 1048576.0;
    private static final ThreadMXBean threadBean;
    private static final Method GET_BYTES_METHOD;
    private static final boolean supported;
    private static final ThreadLocal<AtomicLong> threadLocalMem;
    private long limitBytes;
    private final AtomicLong accumulatedMem = new AtomicLong();
    private long exitedAt = 0L;

    public MemAllowedLimit(SolrQueryRequest req) {
        if (!supported) {
            throw new IllegalArgumentException("Per-thread memory allocation monitoring not available in this JVM.");
        }
        float reqMemLimit = req.getParams().getFloat("memAllowed", -1.0f);
        if (reqMemLimit <= 0.0f) {
            throw new IllegalArgumentException("Check for limit with hasMemLimit(req) before creating a MemAllowedLimit!");
        }
        this.limitBytes = Math.round((double)reqMemLimit * 1048576.0);
        this.init();
    }

    @VisibleForTesting
    MemAllowedLimit(float memLimit) {
        if (!supported) {
            throw new IllegalArgumentException("Per-thread memory allocation monitoring not available in this JVM.");
        }
        this.limitBytes = Math.round((double)memLimit * 1048576.0);
        this.init();
    }

    private final void init() {
        long currentAllocatedBytes;
        try {
            currentAllocatedBytes = (Long)GET_BYTES_METHOD.invoke((Object)threadBean, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unexpected error checking thread allocation!", e);
        }
        AtomicLong threadMem = threadLocalMem.get();
        threadMem.compareAndSet(-1L, currentAllocatedBytes);
    }

    private long getCurrentAllocatedBytes() {
        try {
            return (Long)GET_BYTES_METHOD.invoke((Object)threadBean, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unexpected error checking thread allocation!", e);
        }
    }

    @VisibleForTesting
    static boolean isSupported() {
        return supported;
    }

    static boolean hasMemLimit(SolrQueryRequest req) {
        return req.getParams().getFloat("memAllowed", -1.0f) > 0.0f;
    }

    public boolean shouldExit() {
        if (this.exitedAt > 0L) {
            return true;
        }
        try {
            long currentAllocatedBytes = this.getCurrentAllocatedBytes();
            AtomicLong threadMem = threadLocalMem.get();
            long lastAllocatedBytes = threadMem.get();
            this.accumulatedMem.addAndGet(currentAllocatedBytes - lastAllocatedBytes);
            threadMem.set(currentAllocatedBytes);
            if (log.isDebugEnabled()) {
                log.debug("mem limit thread {} remaining delta {}", (Object)Thread.currentThread().getName(), (Object)(this.limitBytes - this.accumulatedMem.get()));
            }
            if (this.limitBytes < this.accumulatedMem.get()) {
                this.exitedAt = this.accumulatedMem.get();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unexpected error checking thread allocation!", e);
        }
    }

    @Override
    public Object currentValue() {
        return this.exitedAt > 0L ? this.exitedAt : this.accumulatedMem.get();
    }

    static {
        boolean testSupported;
        log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        threadBean = ManagementFactory.getThreadMXBean();
        Method getBytesMethod = null;
        try {
            Class<?> sunThreadBeanClz = Class.forName("com.sun.management.ThreadMXBean");
            if (sunThreadBeanClz.isAssignableFrom(threadBean.getClass())) {
                Method m = sunThreadBeanClz.getMethod("isThreadAllocatedMemorySupported", new Class[0]);
                Boolean supported = (Boolean)m.invoke((Object)threadBean, new Object[0]);
                if (supported.booleanValue()) {
                    m = sunThreadBeanClz.getMethod("setThreadAllocatedMemoryEnabled", Boolean.TYPE);
                    m.invoke((Object)threadBean, Boolean.TRUE);
                    testSupported = true;
                    getBytesMethod = sunThreadBeanClz.getMethod("getCurrentThreadAllocatedBytes", new Class[0]);
                } else {
                    testSupported = false;
                }
            } else {
                testSupported = false;
            }
        }
        catch (Exception e) {
            testSupported = false;
        }
        supported = testSupported;
        GET_BYTES_METHOD = getBytesMethod;
        threadLocalMem = ThreadLocal.withInitial(() -> new AtomicLong(-1L));
    }
}

