/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.swing;

import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;

public abstract class VisibilityHandler {
    private Component component;
    private boolean wasVisible;
    private HierarchyListener listener;

    public abstract void shown();

    public abstract void hidden();

    public final void handle(Component component) {
        if (component == null) {
            throw new NullPointerException("component cannot be null");
        }
        if (this.listener != null && component != null) {
            component.removeHierarchyListener(this.listener);
        }
        this.component = component;
        this.wasVisible = component.isVisible();
        if (this.listener == null) {
            this.listener = this.createListener();
        }
        component.addHierarchyListener(this.listener);
    }

    private HierarchyListener createListener() {
        return new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    boolean visible = VisibilityHandler.this.component.isShowing();
                    if (VisibilityHandler.this.wasVisible == visible) {
                        return;
                    }
                    VisibilityHandler.this.wasVisible = visible;
                    if (visible) {
                        VisibilityHandler.this.shown();
                    } else {
                        VisibilityHandler.this.hidden();
                    }
                }
            }
        };
    }
}

