#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 berru <berru@riseup.net>
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Invisible Inc expansions:
# - Contingency Plan
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251018.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='invisible-inc'
GAME_NAME='Invisible Inc.'

EXPANSION_ID_CONTINGENCY='contingency-plan'
EXPANSION_NAME_CONTINGENCY='Contigency Plan'

ARCHIVE_BASE_0_NAME='invisible_inc_contingency_plan_dlc_en_n_a_15873.sh'
ARCHIVE_BASE_0_MD5='adfe52f0e0c3400c3026fca66acf5acb'
ARCHIVE_BASE_0_SIZE='2700'
ARCHIVE_BASE_0_VERSION='1.0-gog15873'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/invisible_inc_contingency_plan'

CONTENT_GAME_MAIN_PATH='data/noarch/game'
## FIXME: An explicit list of files should be set.
CONTENT_GAME_MAIN_FILES='
*'

PKG_PARENT_ID="$GAME_ID"

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_PARENT'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_default

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
