//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatabox

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AccountCopyLogDetails.
func (a AccountCopyLogDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accountName", a.AccountName)
	objectMap["copyLogDetailsType"] = ClassDiscriminatorDataBox
	populate(objectMap, "copyLogLink", a.CopyLogLink)
	populate(objectMap, "copyVerboseLogLink", a.CopyVerboseLogLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountCopyLogDetails.
func (a *AccountCopyLogDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "copyLogDetailsType":
			err = unpopulate(val, "CopyLogDetailsType", &a.CopyLogDetailsType)
			delete(rawMsg, key)
		case "copyLogLink":
			err = unpopulate(val, "CopyLogLink", &a.CopyLogLink)
			delete(rawMsg, key)
		case "copyVerboseLogLink":
			err = unpopulate(val, "CopyVerboseLogLink", &a.CopyVerboseLogLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddressValidationProperties.
func (a *AddressValidationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alternateAddresses":
			err = unpopulate(val, "AlternateAddresses", &a.AlternateAddresses)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "validationStatus":
			err = unpopulate(val, "ValidationStatus", &a.ValidationStatus)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &a.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableSKURequest.
func (a AvailableSKURequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "country", a.Country)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "skuNames", a.SKUNames)
	populate(objectMap, "transferType", a.TransferType)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AzureFileFilterDetails.
func (a AzureFileFilterDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "filePathList", a.FilePathList)
	populate(objectMap, "filePrefixList", a.FilePrefixList)
	populate(objectMap, "fileShareList", a.FileShareList)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BlobFilterDetails.
func (b BlobFilterDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blobPathList", b.BlobPathList)
	populate(objectMap, "blobPrefixList", b.BlobPrefixList)
	populate(objectMap, "containerList", b.ContainerList)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CloudError.
func (c CloudError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalInfo", c.AdditionalInfo)
	populate(objectMap, "code", c.Code)
	populate(objectMap, "details", c.Details)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "target", c.Target)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CommonJobDetails.
func (c CommonJobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", c.Actions)
	populate(objectMap, "chainOfCustodySasKey", c.ChainOfCustodySasKey)
	populate(objectMap, "contactDetails", c.ContactDetails)
	populate(objectMap, "copyLogDetails", c.CopyLogDetails)
	populate(objectMap, "dataCenterCode", c.DataCenterCode)
	populate(objectMap, "dataExportDetails", c.DataExportDetails)
	populate(objectMap, "dataImportDetails", c.DataImportDetails)
	populate(objectMap, "datacenterAddress", c.DatacenterAddress)
	populate(objectMap, "deliveryPackage", c.DeliveryPackage)
	populate(objectMap, "deviceErasureDetails", c.DeviceErasureDetails)
	populate(objectMap, "expectedDataSizeInTeraBytes", c.ExpectedDataSizeInTeraBytes)
	objectMap["jobDetailsType"] = c.JobDetailsType
	populate(objectMap, "jobStages", c.JobStages)
	populate(objectMap, "keyEncryptionKey", c.KeyEncryptionKey)
	populate(objectMap, "lastMitigationActionOnJob", c.LastMitigationActionOnJob)
	populate(objectMap, "preferences", c.Preferences)
	populate(objectMap, "returnPackage", c.ReturnPackage)
	populate(objectMap, "reverseShipmentLabelSasKey", c.ReverseShipmentLabelSasKey)
	populate(objectMap, "shippingAddress", c.ShippingAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonJobDetails.
func (c *CommonJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &c.Actions)
			delete(rawMsg, key)
		case "chainOfCustodySasKey":
			err = unpopulate(val, "ChainOfCustodySasKey", &c.ChainOfCustodySasKey)
			delete(rawMsg, key)
		case "contactDetails":
			err = unpopulate(val, "ContactDetails", &c.ContactDetails)
			delete(rawMsg, key)
		case "copyLogDetails":
			c.CopyLogDetails, err = unmarshalCopyLogDetailsClassificationArray(val)
			delete(rawMsg, key)
		case "dataCenterCode":
			err = unpopulate(val, "DataCenterCode", &c.DataCenterCode)
			delete(rawMsg, key)
		case "dataExportDetails":
			err = unpopulate(val, "DataExportDetails", &c.DataExportDetails)
			delete(rawMsg, key)
		case "dataImportDetails":
			err = unpopulate(val, "DataImportDetails", &c.DataImportDetails)
			delete(rawMsg, key)
		case "datacenterAddress":
			c.DatacenterAddress, err = unmarshalDatacenterAddressResponseClassification(val)
			delete(rawMsg, key)
		case "deliveryPackage":
			err = unpopulate(val, "DeliveryPackage", &c.DeliveryPackage)
			delete(rawMsg, key)
		case "deviceErasureDetails":
			err = unpopulate(val, "DeviceErasureDetails", &c.DeviceErasureDetails)
			delete(rawMsg, key)
		case "expectedDataSizeInTeraBytes":
			err = unpopulate(val, "ExpectedDataSizeInTeraBytes", &c.ExpectedDataSizeInTeraBytes)
			delete(rawMsg, key)
		case "jobDetailsType":
			err = unpopulate(val, "JobDetailsType", &c.JobDetailsType)
			delete(rawMsg, key)
		case "jobStages":
			err = unpopulate(val, "JobStages", &c.JobStages)
			delete(rawMsg, key)
		case "keyEncryptionKey":
			err = unpopulate(val, "KeyEncryptionKey", &c.KeyEncryptionKey)
			delete(rawMsg, key)
		case "lastMitigationActionOnJob":
			err = unpopulate(val, "LastMitigationActionOnJob", &c.LastMitigationActionOnJob)
			delete(rawMsg, key)
		case "preferences":
			err = unpopulate(val, "Preferences", &c.Preferences)
			delete(rawMsg, key)
		case "returnPackage":
			err = unpopulate(val, "ReturnPackage", &c.ReturnPackage)
			delete(rawMsg, key)
		case "reverseShipmentLabelSasKey":
			err = unpopulate(val, "ReverseShipmentLabelSasKey", &c.ReverseShipmentLabelSasKey)
			delete(rawMsg, key)
		case "shippingAddress":
			err = unpopulate(val, "ShippingAddress", &c.ShippingAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactDetails.
func (c ContactDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contactName", c.ContactName)
	populate(objectMap, "emailList", c.EmailList)
	populate(objectMap, "mobile", c.Mobile)
	populate(objectMap, "notificationPreference", c.NotificationPreference)
	populate(objectMap, "phone", c.Phone)
	populate(objectMap, "phoneExtension", c.PhoneExtension)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CreateJobValidations.
func (c CreateJobValidations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "individualRequestDetails", c.IndividualRequestDetails)
	objectMap["validationCategory"] = "JobCreationValidation"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateJobValidations.
func (c *CreateJobValidations) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "individualRequestDetails":
			c.IndividualRequestDetails, err = unmarshalValidationInputRequestClassificationArray(val)
			delete(rawMsg, key)
		case "validationCategory":
			err = unpopulate(val, "ValidationCategory", &c.ValidationCategory)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateOrderLimitForSubscriptionValidationRequest.
func (c CreateOrderLimitForSubscriptionValidationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deviceType", c.DeviceType)
	objectMap["validationType"] = ValidationInputDiscriminatorValidateCreateOrderLimit
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateOrderLimitForSubscriptionValidationRequest.
func (c *CreateOrderLimitForSubscriptionValidationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceType":
			err = unpopulate(val, "DeviceType", &c.DeviceType)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &c.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateOrderLimitForSubscriptionValidationResponseProperties.
func (c *CreateOrderLimitForSubscriptionValidationResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &c.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerDiskCopyLogDetails.
func (c CustomerDiskCopyLogDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["copyLogDetailsType"] = ClassDiscriminatorDataBoxCustomerDisk
	populate(objectMap, "errorLogLink", c.ErrorLogLink)
	populate(objectMap, "serialNumber", c.SerialNumber)
	populate(objectMap, "verboseLogLink", c.VerboseLogLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerDiskCopyLogDetails.
func (c *CustomerDiskCopyLogDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyLogDetailsType":
			err = unpopulate(val, "CopyLogDetailsType", &c.CopyLogDetailsType)
			delete(rawMsg, key)
		case "errorLogLink":
			err = unpopulate(val, "ErrorLogLink", &c.ErrorLogLink)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &c.SerialNumber)
			delete(rawMsg, key)
		case "verboseLogLink":
			err = unpopulate(val, "VerboseLogLink", &c.VerboseLogLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerDiskJobDetails.
func (c CustomerDiskJobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", c.Actions)
	populate(objectMap, "chainOfCustodySasKey", c.ChainOfCustodySasKey)
	populate(objectMap, "contactDetails", c.ContactDetails)
	populate(objectMap, "copyLogDetails", c.CopyLogDetails)
	populate(objectMap, "copyProgress", c.CopyProgress)
	populate(objectMap, "dataCenterCode", c.DataCenterCode)
	populate(objectMap, "dataExportDetails", c.DataExportDetails)
	populate(objectMap, "dataImportDetails", c.DataImportDetails)
	populate(objectMap, "datacenterAddress", c.DatacenterAddress)
	populate(objectMap, "deliverToDcPackageDetails", c.DeliverToDcPackageDetails)
	populate(objectMap, "deliveryPackage", c.DeliveryPackage)
	populate(objectMap, "deviceErasureDetails", c.DeviceErasureDetails)
	populate(objectMap, "enableManifestBackup", c.EnableManifestBackup)
	populate(objectMap, "expectedDataSizeInTeraBytes", c.ExpectedDataSizeInTeraBytes)
	populate(objectMap, "exportDiskDetailsCollection", c.ExportDiskDetailsCollection)
	populate(objectMap, "importDiskDetailsCollection", c.ImportDiskDetailsCollection)
	objectMap["jobDetailsType"] = ClassDiscriminatorDataBoxCustomerDisk
	populate(objectMap, "jobStages", c.JobStages)
	populate(objectMap, "keyEncryptionKey", c.KeyEncryptionKey)
	populate(objectMap, "lastMitigationActionOnJob", c.LastMitigationActionOnJob)
	populate(objectMap, "preferences", c.Preferences)
	populate(objectMap, "returnPackage", c.ReturnPackage)
	populate(objectMap, "returnToCustomerPackageDetails", c.ReturnToCustomerPackageDetails)
	populate(objectMap, "reverseShipmentLabelSasKey", c.ReverseShipmentLabelSasKey)
	populate(objectMap, "shippingAddress", c.ShippingAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerDiskJobDetails.
func (c *CustomerDiskJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &c.Actions)
			delete(rawMsg, key)
		case "chainOfCustodySasKey":
			err = unpopulate(val, "ChainOfCustodySasKey", &c.ChainOfCustodySasKey)
			delete(rawMsg, key)
		case "contactDetails":
			err = unpopulate(val, "ContactDetails", &c.ContactDetails)
			delete(rawMsg, key)
		case "copyLogDetails":
			c.CopyLogDetails, err = unmarshalCopyLogDetailsClassificationArray(val)
			delete(rawMsg, key)
		case "copyProgress":
			err = unpopulate(val, "CopyProgress", &c.CopyProgress)
			delete(rawMsg, key)
		case "dataCenterCode":
			err = unpopulate(val, "DataCenterCode", &c.DataCenterCode)
			delete(rawMsg, key)
		case "dataExportDetails":
			err = unpopulate(val, "DataExportDetails", &c.DataExportDetails)
			delete(rawMsg, key)
		case "dataImportDetails":
			err = unpopulate(val, "DataImportDetails", &c.DataImportDetails)
			delete(rawMsg, key)
		case "datacenterAddress":
			c.DatacenterAddress, err = unmarshalDatacenterAddressResponseClassification(val)
			delete(rawMsg, key)
		case "deliverToDcPackageDetails":
			err = unpopulate(val, "DeliverToDcPackageDetails", &c.DeliverToDcPackageDetails)
			delete(rawMsg, key)
		case "deliveryPackage":
			err = unpopulate(val, "DeliveryPackage", &c.DeliveryPackage)
			delete(rawMsg, key)
		case "deviceErasureDetails":
			err = unpopulate(val, "DeviceErasureDetails", &c.DeviceErasureDetails)
			delete(rawMsg, key)
		case "enableManifestBackup":
			err = unpopulate(val, "EnableManifestBackup", &c.EnableManifestBackup)
			delete(rawMsg, key)
		case "expectedDataSizeInTeraBytes":
			err = unpopulate(val, "ExpectedDataSizeInTeraBytes", &c.ExpectedDataSizeInTeraBytes)
			delete(rawMsg, key)
		case "exportDiskDetailsCollection":
			err = unpopulate(val, "ExportDiskDetailsCollection", &c.ExportDiskDetailsCollection)
			delete(rawMsg, key)
		case "importDiskDetailsCollection":
			err = unpopulate(val, "ImportDiskDetailsCollection", &c.ImportDiskDetailsCollection)
			delete(rawMsg, key)
		case "jobDetailsType":
			err = unpopulate(val, "JobDetailsType", &c.JobDetailsType)
			delete(rawMsg, key)
		case "jobStages":
			err = unpopulate(val, "JobStages", &c.JobStages)
			delete(rawMsg, key)
		case "keyEncryptionKey":
			err = unpopulate(val, "KeyEncryptionKey", &c.KeyEncryptionKey)
			delete(rawMsg, key)
		case "lastMitigationActionOnJob":
			err = unpopulate(val, "LastMitigationActionOnJob", &c.LastMitigationActionOnJob)
			delete(rawMsg, key)
		case "preferences":
			err = unpopulate(val, "Preferences", &c.Preferences)
			delete(rawMsg, key)
		case "returnPackage":
			err = unpopulate(val, "ReturnPackage", &c.ReturnPackage)
			delete(rawMsg, key)
		case "returnToCustomerPackageDetails":
			err = unpopulate(val, "ReturnToCustomerPackageDetails", &c.ReturnToCustomerPackageDetails)
			delete(rawMsg, key)
		case "reverseShipmentLabelSasKey":
			err = unpopulate(val, "ReverseShipmentLabelSasKey", &c.ReverseShipmentLabelSasKey)
			delete(rawMsg, key)
		case "shippingAddress":
			err = unpopulate(val, "ShippingAddress", &c.ShippingAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerDiskJobSecrets.
func (c *CustomerDiskJobSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "carrierAccountNumber":
			err = unpopulate(val, "CarrierAccountNumber", &c.CarrierAccountNumber)
			delete(rawMsg, key)
		case "dcAccessSecurityCode":
			err = unpopulate(val, "DcAccessSecurityCode", &c.DcAccessSecurityCode)
			delete(rawMsg, key)
		case "diskSecrets":
			err = unpopulate(val, "DiskSecrets", &c.DiskSecrets)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "jobSecretsType":
			err = unpopulate(val, "JobSecretsType", &c.JobSecretsType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataExportDetails.
func (d DataExportDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accountDetails", d.AccountDetails)
	populate(objectMap, "logCollectionLevel", d.LogCollectionLevel)
	populate(objectMap, "transferConfiguration", d.TransferConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataExportDetails.
func (d *DataExportDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountDetails":
			d.AccountDetails, err = unmarshalDataAccountDetailsClassification(val)
			delete(rawMsg, key)
		case "logCollectionLevel":
			err = unpopulate(val, "LogCollectionLevel", &d.LogCollectionLevel)
			delete(rawMsg, key)
		case "transferConfiguration":
			err = unpopulate(val, "TransferConfiguration", &d.TransferConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataImportDetails.
func (d DataImportDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accountDetails", d.AccountDetails)
	populate(objectMap, "logCollectionLevel", d.LogCollectionLevel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataImportDetails.
func (d *DataImportDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountDetails":
			d.AccountDetails, err = unmarshalDataAccountDetailsClassification(val)
			delete(rawMsg, key)
		case "logCollectionLevel":
			err = unpopulate(val, "LogCollectionLevel", &d.LogCollectionLevel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataTransferDetailsValidationRequest.
func (d DataTransferDetailsValidationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataExportDetails", d.DataExportDetails)
	populate(objectMap, "dataImportDetails", d.DataImportDetails)
	populate(objectMap, "deviceType", d.DeviceType)
	populate(objectMap, "transferType", d.TransferType)
	objectMap["validationType"] = ValidationInputDiscriminatorValidateDataTransferDetails
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataTransferDetailsValidationRequest.
func (d *DataTransferDetailsValidationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataExportDetails":
			err = unpopulate(val, "DataExportDetails", &d.DataExportDetails)
			delete(rawMsg, key)
		case "dataImportDetails":
			err = unpopulate(val, "DataImportDetails", &d.DataImportDetails)
			delete(rawMsg, key)
		case "deviceType":
			err = unpopulate(val, "DeviceType", &d.DeviceType)
			delete(rawMsg, key)
		case "transferType":
			err = unpopulate(val, "TransferType", &d.TransferType)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &d.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataTransferDetailsValidationResponseProperties.
func (d *DataTransferDetailsValidationResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &d.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &d.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatacenterAddressInstructionResponse.
func (d DatacenterAddressInstructionResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "communicationInstruction", d.CommunicationInstruction)
	populate(objectMap, "dataCenterAzureLocation", d.DataCenterAzureLocation)
	objectMap["datacenterAddressType"] = DatacenterAddressTypeDatacenterAddressInstruction
	populate(objectMap, "supportedCarriersForReturnShipment", d.SupportedCarriersForReturnShipment)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatacenterAddressInstructionResponse.
func (d *DatacenterAddressInstructionResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "communicationInstruction":
			err = unpopulate(val, "CommunicationInstruction", &d.CommunicationInstruction)
			delete(rawMsg, key)
		case "dataCenterAzureLocation":
			err = unpopulate(val, "DataCenterAzureLocation", &d.DataCenterAzureLocation)
			delete(rawMsg, key)
		case "datacenterAddressType":
			err = unpopulate(val, "DatacenterAddressType", &d.DatacenterAddressType)
			delete(rawMsg, key)
		case "supportedCarriersForReturnShipment":
			err = unpopulate(val, "SupportedCarriersForReturnShipment", &d.SupportedCarriersForReturnShipment)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatacenterAddressLocationResponse.
func (d DatacenterAddressLocationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalShippingInformation", d.AdditionalShippingInformation)
	populate(objectMap, "addressType", d.AddressType)
	populate(objectMap, "city", d.City)
	populate(objectMap, "company", d.Company)
	populate(objectMap, "contactPersonName", d.ContactPersonName)
	populate(objectMap, "country", d.Country)
	populate(objectMap, "dataCenterAzureLocation", d.DataCenterAzureLocation)
	objectMap["datacenterAddressType"] = DatacenterAddressTypeDatacenterAddressLocation
	populate(objectMap, "phone", d.Phone)
	populate(objectMap, "phoneExtension", d.PhoneExtension)
	populate(objectMap, "state", d.State)
	populate(objectMap, "street1", d.Street1)
	populate(objectMap, "street2", d.Street2)
	populate(objectMap, "street3", d.Street3)
	populate(objectMap, "supportedCarriersForReturnShipment", d.SupportedCarriersForReturnShipment)
	populate(objectMap, "zip", d.Zip)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatacenterAddressLocationResponse.
func (d *DatacenterAddressLocationResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalShippingInformation":
			err = unpopulate(val, "AdditionalShippingInformation", &d.AdditionalShippingInformation)
			delete(rawMsg, key)
		case "addressType":
			err = unpopulate(val, "AddressType", &d.AddressType)
			delete(rawMsg, key)
		case "city":
			err = unpopulate(val, "City", &d.City)
			delete(rawMsg, key)
		case "company":
			err = unpopulate(val, "Company", &d.Company)
			delete(rawMsg, key)
		case "contactPersonName":
			err = unpopulate(val, "ContactPersonName", &d.ContactPersonName)
			delete(rawMsg, key)
		case "country":
			err = unpopulate(val, "Country", &d.Country)
			delete(rawMsg, key)
		case "dataCenterAzureLocation":
			err = unpopulate(val, "DataCenterAzureLocation", &d.DataCenterAzureLocation)
			delete(rawMsg, key)
		case "datacenterAddressType":
			err = unpopulate(val, "DatacenterAddressType", &d.DatacenterAddressType)
			delete(rawMsg, key)
		case "phone":
			err = unpopulate(val, "Phone", &d.Phone)
			delete(rawMsg, key)
		case "phoneExtension":
			err = unpopulate(val, "PhoneExtension", &d.PhoneExtension)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &d.State)
			delete(rawMsg, key)
		case "street1":
			err = unpopulate(val, "Street1", &d.Street1)
			delete(rawMsg, key)
		case "street2":
			err = unpopulate(val, "Street2", &d.Street2)
			delete(rawMsg, key)
		case "street3":
			err = unpopulate(val, "Street3", &d.Street3)
			delete(rawMsg, key)
		case "supportedCarriersForReturnShipment":
			err = unpopulate(val, "SupportedCarriersForReturnShipment", &d.SupportedCarriersForReturnShipment)
			delete(rawMsg, key)
		case "zip":
			err = unpopulate(val, "Zip", &d.Zip)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatacenterAddressResponse.
func (d DatacenterAddressResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataCenterAzureLocation", d.DataCenterAzureLocation)
	objectMap["datacenterAddressType"] = d.DatacenterAddressType
	populate(objectMap, "supportedCarriersForReturnShipment", d.SupportedCarriersForReturnShipment)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DiskCopyLogDetails.
func (d DiskCopyLogDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["copyLogDetailsType"] = ClassDiscriminatorDataBoxDisk
	populate(objectMap, "diskSerialNumber", d.DiskSerialNumber)
	populate(objectMap, "errorLogLink", d.ErrorLogLink)
	populate(objectMap, "verboseLogLink", d.VerboseLogLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskCopyLogDetails.
func (d *DiskCopyLogDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyLogDetailsType":
			err = unpopulate(val, "CopyLogDetailsType", &d.CopyLogDetailsType)
			delete(rawMsg, key)
		case "diskSerialNumber":
			err = unpopulate(val, "DiskSerialNumber", &d.DiskSerialNumber)
			delete(rawMsg, key)
		case "errorLogLink":
			err = unpopulate(val, "ErrorLogLink", &d.ErrorLogLink)
			delete(rawMsg, key)
		case "verboseLogLink":
			err = unpopulate(val, "VerboseLogLink", &d.VerboseLogLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskGranularCopyLogDetails.
func (d *DiskGranularCopyLogDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &d.AccountName)
			delete(rawMsg, key)
		case "copyLogDetailsType":
			err = unpopulate(val, "CopyLogDetailsType", &d.CopyLogDetailsType)
			delete(rawMsg, key)
		case "errorLogLink":
			err = unpopulate(val, "ErrorLogLink", &d.ErrorLogLink)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &d.SerialNumber)
			delete(rawMsg, key)
		case "verboseLogLink":
			err = unpopulate(val, "VerboseLogLink", &d.VerboseLogLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskJobDetails.
func (d DiskJobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", d.Actions)
	populate(objectMap, "chainOfCustodySasKey", d.ChainOfCustodySasKey)
	populate(objectMap, "contactDetails", d.ContactDetails)
	populate(objectMap, "copyLogDetails", d.CopyLogDetails)
	populate(objectMap, "copyProgress", d.CopyProgress)
	populate(objectMap, "dataCenterCode", d.DataCenterCode)
	populate(objectMap, "dataExportDetails", d.DataExportDetails)
	populate(objectMap, "dataImportDetails", d.DataImportDetails)
	populate(objectMap, "datacenterAddress", d.DatacenterAddress)
	populate(objectMap, "deliveryPackage", d.DeliveryPackage)
	populate(objectMap, "deviceErasureDetails", d.DeviceErasureDetails)
	populate(objectMap, "disksAndSizeDetails", d.DisksAndSizeDetails)
	populate(objectMap, "expectedDataSizeInTeraBytes", d.ExpectedDataSizeInTeraBytes)
	populate(objectMap, "granularCopyProgress", d.GranularCopyProgress)
	objectMap["jobDetailsType"] = ClassDiscriminatorDataBoxDisk
	populate(objectMap, "jobStages", d.JobStages)
	populate(objectMap, "keyEncryptionKey", d.KeyEncryptionKey)
	populate(objectMap, "lastMitigationActionOnJob", d.LastMitigationActionOnJob)
	populate(objectMap, "passkey", d.Passkey)
	populate(objectMap, "preferences", d.Preferences)
	populate(objectMap, "preferredDisks", d.PreferredDisks)
	populate(objectMap, "returnPackage", d.ReturnPackage)
	populate(objectMap, "reverseShipmentLabelSasKey", d.ReverseShipmentLabelSasKey)
	populate(objectMap, "shippingAddress", d.ShippingAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskJobDetails.
func (d *DiskJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &d.Actions)
			delete(rawMsg, key)
		case "chainOfCustodySasKey":
			err = unpopulate(val, "ChainOfCustodySasKey", &d.ChainOfCustodySasKey)
			delete(rawMsg, key)
		case "contactDetails":
			err = unpopulate(val, "ContactDetails", &d.ContactDetails)
			delete(rawMsg, key)
		case "copyLogDetails":
			d.CopyLogDetails, err = unmarshalCopyLogDetailsClassificationArray(val)
			delete(rawMsg, key)
		case "copyProgress":
			err = unpopulate(val, "CopyProgress", &d.CopyProgress)
			delete(rawMsg, key)
		case "dataCenterCode":
			err = unpopulate(val, "DataCenterCode", &d.DataCenterCode)
			delete(rawMsg, key)
		case "dataExportDetails":
			err = unpopulate(val, "DataExportDetails", &d.DataExportDetails)
			delete(rawMsg, key)
		case "dataImportDetails":
			err = unpopulate(val, "DataImportDetails", &d.DataImportDetails)
			delete(rawMsg, key)
		case "datacenterAddress":
			d.DatacenterAddress, err = unmarshalDatacenterAddressResponseClassification(val)
			delete(rawMsg, key)
		case "deliveryPackage":
			err = unpopulate(val, "DeliveryPackage", &d.DeliveryPackage)
			delete(rawMsg, key)
		case "deviceErasureDetails":
			err = unpopulate(val, "DeviceErasureDetails", &d.DeviceErasureDetails)
			delete(rawMsg, key)
		case "disksAndSizeDetails":
			err = unpopulate(val, "DisksAndSizeDetails", &d.DisksAndSizeDetails)
			delete(rawMsg, key)
		case "expectedDataSizeInTeraBytes":
			err = unpopulate(val, "ExpectedDataSizeInTeraBytes", &d.ExpectedDataSizeInTeraBytes)
			delete(rawMsg, key)
		case "granularCopyProgress":
			err = unpopulate(val, "GranularCopyProgress", &d.GranularCopyProgress)
			delete(rawMsg, key)
		case "jobDetailsType":
			err = unpopulate(val, "JobDetailsType", &d.JobDetailsType)
			delete(rawMsg, key)
		case "jobStages":
			err = unpopulate(val, "JobStages", &d.JobStages)
			delete(rawMsg, key)
		case "keyEncryptionKey":
			err = unpopulate(val, "KeyEncryptionKey", &d.KeyEncryptionKey)
			delete(rawMsg, key)
		case "lastMitigationActionOnJob":
			err = unpopulate(val, "LastMitigationActionOnJob", &d.LastMitigationActionOnJob)
			delete(rawMsg, key)
		case "passkey":
			err = unpopulate(val, "Passkey", &d.Passkey)
			delete(rawMsg, key)
		case "preferences":
			err = unpopulate(val, "Preferences", &d.Preferences)
			delete(rawMsg, key)
		case "preferredDisks":
			err = unpopulate(val, "PreferredDisks", &d.PreferredDisks)
			delete(rawMsg, key)
		case "returnPackage":
			err = unpopulate(val, "ReturnPackage", &d.ReturnPackage)
			delete(rawMsg, key)
		case "reverseShipmentLabelSasKey":
			err = unpopulate(val, "ReverseShipmentLabelSasKey", &d.ReverseShipmentLabelSasKey)
			delete(rawMsg, key)
		case "shippingAddress":
			err = unpopulate(val, "ShippingAddress", &d.ShippingAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskJobSecrets.
func (d *DiskJobSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dcAccessSecurityCode":
			err = unpopulate(val, "DcAccessSecurityCode", &d.DcAccessSecurityCode)
			delete(rawMsg, key)
		case "diskSecrets":
			err = unpopulate(val, "DiskSecrets", &d.DiskSecrets)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &d.Error)
			delete(rawMsg, key)
		case "isPasskeyUserDefined":
			err = unpopulate(val, "IsPasskeyUserDefined", &d.IsPasskeyUserDefined)
			delete(rawMsg, key)
		case "jobSecretsType":
			err = unpopulate(val, "JobSecretsType", &d.JobSecretsType)
			delete(rawMsg, key)
		case "passKey":
			err = unpopulate(val, "PassKey", &d.PassKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskScheduleAvailabilityRequest.
func (d DiskScheduleAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "country", d.Country)
	populate(objectMap, "expectedDataSizeInTeraBytes", d.ExpectedDataSizeInTeraBytes)
	objectMap["skuName"] = SKUNameDataBoxDisk
	populate(objectMap, "storageLocation", d.StorageLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskScheduleAvailabilityRequest.
func (d *DiskScheduleAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "country":
			err = unpopulate(val, "Country", &d.Country)
			delete(rawMsg, key)
		case "expectedDataSizeInTeraBytes":
			err = unpopulate(val, "ExpectedDataSizeInTeraBytes", &d.ExpectedDataSizeInTeraBytes)
			delete(rawMsg, key)
		case "skuName":
			err = unpopulate(val, "SKUName", &d.SKUName)
			delete(rawMsg, key)
		case "storageLocation":
			err = unpopulate(val, "StorageLocation", &d.StorageLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HeavyAccountCopyLogDetails.
func (h HeavyAccountCopyLogDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accountName", h.AccountName)
	objectMap["copyLogDetailsType"] = ClassDiscriminatorDataBoxHeavy
	populate(objectMap, "copyLogLink", h.CopyLogLink)
	populate(objectMap, "copyVerboseLogLink", h.CopyVerboseLogLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HeavyAccountCopyLogDetails.
func (h *HeavyAccountCopyLogDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &h.AccountName)
			delete(rawMsg, key)
		case "copyLogDetailsType":
			err = unpopulate(val, "CopyLogDetailsType", &h.CopyLogDetailsType)
			delete(rawMsg, key)
		case "copyLogLink":
			err = unpopulate(val, "CopyLogLink", &h.CopyLogLink)
			delete(rawMsg, key)
		case "copyVerboseLogLink":
			err = unpopulate(val, "CopyVerboseLogLink", &h.CopyVerboseLogLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HeavyJobDetails.
func (h HeavyJobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", h.Actions)
	populate(objectMap, "chainOfCustodySasKey", h.ChainOfCustodySasKey)
	populate(objectMap, "contactDetails", h.ContactDetails)
	populate(objectMap, "copyLogDetails", h.CopyLogDetails)
	populate(objectMap, "copyProgress", h.CopyProgress)
	populate(objectMap, "dataCenterCode", h.DataCenterCode)
	populate(objectMap, "dataExportDetails", h.DataExportDetails)
	populate(objectMap, "dataImportDetails", h.DataImportDetails)
	populate(objectMap, "datacenterAddress", h.DatacenterAddress)
	populate(objectMap, "deliveryPackage", h.DeliveryPackage)
	populate(objectMap, "deviceErasureDetails", h.DeviceErasureDetails)
	populate(objectMap, "devicePassword", h.DevicePassword)
	populate(objectMap, "expectedDataSizeInTeraBytes", h.ExpectedDataSizeInTeraBytes)
	objectMap["jobDetailsType"] = ClassDiscriminatorDataBoxHeavy
	populate(objectMap, "jobStages", h.JobStages)
	populate(objectMap, "keyEncryptionKey", h.KeyEncryptionKey)
	populate(objectMap, "lastMitigationActionOnJob", h.LastMitigationActionOnJob)
	populate(objectMap, "preferences", h.Preferences)
	populate(objectMap, "returnPackage", h.ReturnPackage)
	populate(objectMap, "reverseShipmentLabelSasKey", h.ReverseShipmentLabelSasKey)
	populate(objectMap, "shippingAddress", h.ShippingAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HeavyJobDetails.
func (h *HeavyJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &h.Actions)
			delete(rawMsg, key)
		case "chainOfCustodySasKey":
			err = unpopulate(val, "ChainOfCustodySasKey", &h.ChainOfCustodySasKey)
			delete(rawMsg, key)
		case "contactDetails":
			err = unpopulate(val, "ContactDetails", &h.ContactDetails)
			delete(rawMsg, key)
		case "copyLogDetails":
			h.CopyLogDetails, err = unmarshalCopyLogDetailsClassificationArray(val)
			delete(rawMsg, key)
		case "copyProgress":
			err = unpopulate(val, "CopyProgress", &h.CopyProgress)
			delete(rawMsg, key)
		case "dataCenterCode":
			err = unpopulate(val, "DataCenterCode", &h.DataCenterCode)
			delete(rawMsg, key)
		case "dataExportDetails":
			err = unpopulate(val, "DataExportDetails", &h.DataExportDetails)
			delete(rawMsg, key)
		case "dataImportDetails":
			err = unpopulate(val, "DataImportDetails", &h.DataImportDetails)
			delete(rawMsg, key)
		case "datacenterAddress":
			h.DatacenterAddress, err = unmarshalDatacenterAddressResponseClassification(val)
			delete(rawMsg, key)
		case "deliveryPackage":
			err = unpopulate(val, "DeliveryPackage", &h.DeliveryPackage)
			delete(rawMsg, key)
		case "deviceErasureDetails":
			err = unpopulate(val, "DeviceErasureDetails", &h.DeviceErasureDetails)
			delete(rawMsg, key)
		case "devicePassword":
			err = unpopulate(val, "DevicePassword", &h.DevicePassword)
			delete(rawMsg, key)
		case "expectedDataSizeInTeraBytes":
			err = unpopulate(val, "ExpectedDataSizeInTeraBytes", &h.ExpectedDataSizeInTeraBytes)
			delete(rawMsg, key)
		case "jobDetailsType":
			err = unpopulate(val, "JobDetailsType", &h.JobDetailsType)
			delete(rawMsg, key)
		case "jobStages":
			err = unpopulate(val, "JobStages", &h.JobStages)
			delete(rawMsg, key)
		case "keyEncryptionKey":
			err = unpopulate(val, "KeyEncryptionKey", &h.KeyEncryptionKey)
			delete(rawMsg, key)
		case "lastMitigationActionOnJob":
			err = unpopulate(val, "LastMitigationActionOnJob", &h.LastMitigationActionOnJob)
			delete(rawMsg, key)
		case "preferences":
			err = unpopulate(val, "Preferences", &h.Preferences)
			delete(rawMsg, key)
		case "returnPackage":
			err = unpopulate(val, "ReturnPackage", &h.ReturnPackage)
			delete(rawMsg, key)
		case "reverseShipmentLabelSasKey":
			err = unpopulate(val, "ReverseShipmentLabelSasKey", &h.ReverseShipmentLabelSasKey)
			delete(rawMsg, key)
		case "shippingAddress":
			err = unpopulate(val, "ShippingAddress", &h.ShippingAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HeavyJobSecrets.
func (h *HeavyJobSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cabinetPodSecrets":
			err = unpopulate(val, "CabinetPodSecrets", &h.CabinetPodSecrets)
			delete(rawMsg, key)
		case "dcAccessSecurityCode":
			err = unpopulate(val, "DcAccessSecurityCode", &h.DcAccessSecurityCode)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &h.Error)
			delete(rawMsg, key)
		case "jobSecretsType":
			err = unpopulate(val, "JobSecretsType", &h.JobSecretsType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HeavyScheduleAvailabilityRequest.
func (h HeavyScheduleAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "country", h.Country)
	objectMap["skuName"] = SKUNameDataBoxHeavy
	populate(objectMap, "storageLocation", h.StorageLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HeavyScheduleAvailabilityRequest.
func (h *HeavyScheduleAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "country":
			err = unpopulate(val, "Country", &h.Country)
			delete(rawMsg, key)
		case "skuName":
			err = unpopulate(val, "SKUName", &h.SKUName)
			delete(rawMsg, key)
		case "storageLocation":
			err = unpopulate(val, "StorageLocation", &h.StorageLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobDeliveryInfo.
func (j JobDeliveryInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "scheduledDateTime", j.ScheduledDateTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobDeliveryInfo.
func (j *JobDeliveryInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scheduledDateTime":
			err = unpopulateTimeRFC3339(val, "ScheduledDateTime", &j.ScheduledDateTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobDetails.
func (j JobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", j.Actions)
	populate(objectMap, "chainOfCustodySasKey", j.ChainOfCustodySasKey)
	populate(objectMap, "contactDetails", j.ContactDetails)
	populate(objectMap, "copyLogDetails", j.CopyLogDetails)
	populate(objectMap, "copyProgress", j.CopyProgress)
	populate(objectMap, "dataCenterCode", j.DataCenterCode)
	populate(objectMap, "dataExportDetails", j.DataExportDetails)
	populate(objectMap, "dataImportDetails", j.DataImportDetails)
	populate(objectMap, "datacenterAddress", j.DatacenterAddress)
	populate(objectMap, "deliveryPackage", j.DeliveryPackage)
	populate(objectMap, "deviceErasureDetails", j.DeviceErasureDetails)
	populate(objectMap, "devicePassword", j.DevicePassword)
	populate(objectMap, "expectedDataSizeInTeraBytes", j.ExpectedDataSizeInTeraBytes)
	objectMap["jobDetailsType"] = ClassDiscriminatorDataBox
	populate(objectMap, "jobStages", j.JobStages)
	populate(objectMap, "keyEncryptionKey", j.KeyEncryptionKey)
	populate(objectMap, "lastMitigationActionOnJob", j.LastMitigationActionOnJob)
	populate(objectMap, "preferences", j.Preferences)
	populate(objectMap, "returnPackage", j.ReturnPackage)
	populate(objectMap, "reverseShipmentLabelSasKey", j.ReverseShipmentLabelSasKey)
	populate(objectMap, "shippingAddress", j.ShippingAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobDetails.
func (j *JobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &j.Actions)
			delete(rawMsg, key)
		case "chainOfCustodySasKey":
			err = unpopulate(val, "ChainOfCustodySasKey", &j.ChainOfCustodySasKey)
			delete(rawMsg, key)
		case "contactDetails":
			err = unpopulate(val, "ContactDetails", &j.ContactDetails)
			delete(rawMsg, key)
		case "copyLogDetails":
			j.CopyLogDetails, err = unmarshalCopyLogDetailsClassificationArray(val)
			delete(rawMsg, key)
		case "copyProgress":
			err = unpopulate(val, "CopyProgress", &j.CopyProgress)
			delete(rawMsg, key)
		case "dataCenterCode":
			err = unpopulate(val, "DataCenterCode", &j.DataCenterCode)
			delete(rawMsg, key)
		case "dataExportDetails":
			err = unpopulate(val, "DataExportDetails", &j.DataExportDetails)
			delete(rawMsg, key)
		case "dataImportDetails":
			err = unpopulate(val, "DataImportDetails", &j.DataImportDetails)
			delete(rawMsg, key)
		case "datacenterAddress":
			j.DatacenterAddress, err = unmarshalDatacenterAddressResponseClassification(val)
			delete(rawMsg, key)
		case "deliveryPackage":
			err = unpopulate(val, "DeliveryPackage", &j.DeliveryPackage)
			delete(rawMsg, key)
		case "deviceErasureDetails":
			err = unpopulate(val, "DeviceErasureDetails", &j.DeviceErasureDetails)
			delete(rawMsg, key)
		case "devicePassword":
			err = unpopulate(val, "DevicePassword", &j.DevicePassword)
			delete(rawMsg, key)
		case "expectedDataSizeInTeraBytes":
			err = unpopulate(val, "ExpectedDataSizeInTeraBytes", &j.ExpectedDataSizeInTeraBytes)
			delete(rawMsg, key)
		case "jobDetailsType":
			err = unpopulate(val, "JobDetailsType", &j.JobDetailsType)
			delete(rawMsg, key)
		case "jobStages":
			err = unpopulate(val, "JobStages", &j.JobStages)
			delete(rawMsg, key)
		case "keyEncryptionKey":
			err = unpopulate(val, "KeyEncryptionKey", &j.KeyEncryptionKey)
			delete(rawMsg, key)
		case "lastMitigationActionOnJob":
			err = unpopulate(val, "LastMitigationActionOnJob", &j.LastMitigationActionOnJob)
			delete(rawMsg, key)
		case "preferences":
			err = unpopulate(val, "Preferences", &j.Preferences)
			delete(rawMsg, key)
		case "returnPackage":
			err = unpopulate(val, "ReturnPackage", &j.ReturnPackage)
			delete(rawMsg, key)
		case "reverseShipmentLabelSasKey":
			err = unpopulate(val, "ReverseShipmentLabelSasKey", &j.ReverseShipmentLabelSasKey)
			delete(rawMsg, key)
		case "shippingAddress":
			err = unpopulate(val, "ShippingAddress", &j.ShippingAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobProperties.
func (j JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cancellationReason", j.CancellationReason)
	populate(objectMap, "deliveryInfo", j.DeliveryInfo)
	populate(objectMap, "deliveryType", j.DeliveryType)
	populate(objectMap, "details", j.Details)
	populate(objectMap, "error", j.Error)
	populate(objectMap, "isCancellable", j.IsCancellable)
	populate(objectMap, "isCancellableWithoutFee", j.IsCancellableWithoutFee)
	populate(objectMap, "isDeletable", j.IsDeletable)
	populate(objectMap, "isPrepareToShipEnabled", j.IsPrepareToShipEnabled)
	populate(objectMap, "isShippingAddressEditable", j.IsShippingAddressEditable)
	populateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "status", j.Status)
	populate(objectMap, "transferType", j.TransferType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobProperties.
func (j *JobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cancellationReason":
			err = unpopulate(val, "CancellationReason", &j.CancellationReason)
			delete(rawMsg, key)
		case "deliveryInfo":
			err = unpopulate(val, "DeliveryInfo", &j.DeliveryInfo)
			delete(rawMsg, key)
		case "deliveryType":
			err = unpopulate(val, "DeliveryType", &j.DeliveryType)
			delete(rawMsg, key)
		case "details":
			j.Details, err = unmarshalCommonJobDetailsClassification(val)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &j.Error)
			delete(rawMsg, key)
		case "isCancellable":
			err = unpopulate(val, "IsCancellable", &j.IsCancellable)
			delete(rawMsg, key)
		case "isCancellableWithoutFee":
			err = unpopulate(val, "IsCancellableWithoutFee", &j.IsCancellableWithoutFee)
			delete(rawMsg, key)
		case "isDeletable":
			err = unpopulate(val, "IsDeletable", &j.IsDeletable)
			delete(rawMsg, key)
		case "isPrepareToShipEnabled":
			err = unpopulate(val, "IsPrepareToShipEnabled", &j.IsPrepareToShipEnabled)
			delete(rawMsg, key)
		case "isShippingAddressEditable":
			err = unpopulate(val, "IsShippingAddressEditable", &j.IsShippingAddressEditable)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		case "transferType":
			err = unpopulate(val, "TransferType", &j.TransferType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobResource.
func (j JobResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", j.ID)
	populate(objectMap, "identity", j.Identity)
	populate(objectMap, "location", j.Location)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "sku", j.SKU)
	populate(objectMap, "systemData", j.SystemData)
	populate(objectMap, "tags", j.Tags)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type JobResourceUpdateParameter.
func (j JobResourceUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", j.Identity)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "tags", j.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobSecrets.
func (j *JobSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dcAccessSecurityCode":
			err = unpopulate(val, "DcAccessSecurityCode", &j.DcAccessSecurityCode)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &j.Error)
			delete(rawMsg, key)
		case "jobSecretsType":
			err = unpopulate(val, "JobSecretsType", &j.JobSecretsType)
			delete(rawMsg, key)
		case "podSecrets":
			err = unpopulate(val, "PodSecrets", &j.PodSecrets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobStages.
func (j JobStages) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "displayName", j.DisplayName)
	populate(objectMap, "jobStageDetails", &j.JobStageDetails)
	populate(objectMap, "stageName", j.StageName)
	populate(objectMap, "stageStatus", j.StageStatus)
	populateTimeRFC3339(objectMap, "stageTime", j.StageTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobStages.
func (j *JobStages) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &j.DisplayName)
			delete(rawMsg, key)
		case "jobStageDetails":
			err = unpopulate(val, "JobStageDetails", &j.JobStageDetails)
			delete(rawMsg, key)
		case "stageName":
			err = unpopulate(val, "StageName", &j.StageName)
			delete(rawMsg, key)
		case "stageStatus":
			err = unpopulate(val, "StageStatus", &j.StageStatus)
			delete(rawMsg, key)
		case "stageTime":
			err = unpopulateTimeRFC3339(val, "StageTime", &j.StageTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LastMitigationActionOnJob.
func (l LastMitigationActionOnJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "actionDateTimeInUtc", l.ActionDateTimeInUTC)
	populate(objectMap, "customerResolution", l.CustomerResolution)
	populate(objectMap, "isPerformedByCustomer", l.IsPerformedByCustomer)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LastMitigationActionOnJob.
func (l *LastMitigationActionOnJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionDateTimeInUtc":
			err = unpopulateTimeRFC3339(val, "ActionDateTimeInUTC", &l.ActionDateTimeInUTC)
			delete(rawMsg, key)
		case "customerResolution":
			err = unpopulate(val, "CustomerResolution", &l.CustomerResolution)
			delete(rawMsg, key)
		case "isPerformedByCustomer":
			err = unpopulate(val, "IsPerformedByCustomer", &l.IsPerformedByCustomer)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedDiskDetails.
func (m ManagedDiskDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["dataAccountType"] = DataAccountTypeManagedDisk
	populate(objectMap, "resourceGroupId", m.ResourceGroupID)
	populate(objectMap, "sharePassword", m.SharePassword)
	populate(objectMap, "stagingStorageAccountId", m.StagingStorageAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedDiskDetails.
func (m *ManagedDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataAccountType":
			err = unpopulate(val, "DataAccountType", &m.DataAccountType)
			delete(rawMsg, key)
		case "resourceGroupId":
			err = unpopulate(val, "ResourceGroupID", &m.ResourceGroupID)
			delete(rawMsg, key)
		case "sharePassword":
			err = unpopulate(val, "SharePassword", &m.SharePassword)
			delete(rawMsg, key)
		case "stagingStorageAccountId":
			err = unpopulate(val, "StagingStorageAccountID", &m.StagingStorageAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Preferences.
func (p Preferences) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "encryptionPreferences", p.EncryptionPreferences)
	populate(objectMap, "preferredDataCenterRegion", p.PreferredDataCenterRegion)
	populate(objectMap, "storageAccountAccessTierPreferences", p.StorageAccountAccessTierPreferences)
	populate(objectMap, "transportPreferences", p.TransportPreferences)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PreferencesValidationRequest.
func (p PreferencesValidationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deviceType", p.DeviceType)
	populate(objectMap, "preference", p.Preference)
	objectMap["validationType"] = ValidationInputDiscriminatorValidatePreferences
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PreferencesValidationRequest.
func (p *PreferencesValidationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceType":
			err = unpopulate(val, "DeviceType", &p.DeviceType)
			delete(rawMsg, key)
		case "preference":
			err = unpopulate(val, "Preference", &p.Preference)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &p.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PreferencesValidationResponseProperties.
func (p *PreferencesValidationResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &p.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &p.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegionConfigurationRequest.
func (r RegionConfigurationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "datacenterAddressRequest", r.DatacenterAddressRequest)
	populate(objectMap, "scheduleAvailabilityRequest", r.ScheduleAvailabilityRequest)
	populate(objectMap, "transportAvailabilityRequest", r.TransportAvailabilityRequest)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegionConfigurationRequest.
func (r *RegionConfigurationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datacenterAddressRequest":
			err = unpopulate(val, "DatacenterAddressRequest", &r.DatacenterAddressRequest)
			delete(rawMsg, key)
		case "scheduleAvailabilityRequest":
			r.ScheduleAvailabilityRequest, err = unmarshalCommonScheduleAvailabilityRequestClassification(val)
			delete(rawMsg, key)
		case "transportAvailabilityRequest":
			err = unpopulate(val, "TransportAvailabilityRequest", &r.TransportAvailabilityRequest)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegionConfigurationResponse.
func (r *RegionConfigurationResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datacenterAddressResponse":
			r.DatacenterAddressResponse, err = unmarshalDatacenterAddressResponseClassification(val)
			delete(rawMsg, key)
		case "scheduleAvailabilityResponse":
			err = unpopulate(val, "ScheduleAvailabilityResponse", &r.ScheduleAvailabilityResponse)
			delete(rawMsg, key)
		case "transportAvailabilityResponse":
			err = unpopulate(val, "TransportAvailabilityResponse", &r.TransportAvailabilityResponse)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", r.Identity)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ResourceIdentity.
func (r ResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "tenantId", r.TenantID)
	populate(objectMap, "type", r.Type)
	populate(objectMap, "userAssignedIdentities", r.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SKUAvailabilityValidationRequest.
func (s SKUAvailabilityValidationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "country", s.Country)
	populate(objectMap, "deviceType", s.DeviceType)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "transferType", s.TransferType)
	objectMap["validationType"] = ValidationInputDiscriminatorValidateSKUAvailability
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUAvailabilityValidationRequest.
func (s *SKUAvailabilityValidationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "country":
			err = unpopulate(val, "Country", &s.Country)
			delete(rawMsg, key)
		case "deviceType":
			err = unpopulate(val, "DeviceType", &s.DeviceType)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "transferType":
			err = unpopulate(val, "TransferType", &s.TransferType)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &s.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUAvailabilityValidationResponseProperties.
func (s *SKUAvailabilityValidationResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &s.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &s.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleAvailabilityRequest.
func (s ScheduleAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "country", s.Country)
	objectMap["skuName"] = SKUNameDataBox
	populate(objectMap, "storageLocation", s.StorageLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleAvailabilityRequest.
func (s *ScheduleAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "country":
			err = unpopulate(val, "Country", &s.Country)
			delete(rawMsg, key)
		case "skuName":
			err = unpopulate(val, "SKUName", &s.SKUName)
			delete(rawMsg, key)
		case "storageLocation":
			err = unpopulate(val, "StorageLocation", &s.StorageLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ShipmentPickUpRequest.
func (s ShipmentPickUpRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endTime", s.EndTime)
	populate(objectMap, "shipmentLocation", s.ShipmentLocation)
	populateTimeRFC3339(objectMap, "startTime", s.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ShipmentPickUpRequest.
func (s *ShipmentPickUpRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &s.EndTime)
			delete(rawMsg, key)
		case "shipmentLocation":
			err = unpopulate(val, "ShipmentLocation", &s.ShipmentLocation)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ShipmentPickUpResponse.
func (s *ShipmentPickUpResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "confirmationNumber":
			err = unpopulate(val, "ConfirmationNumber", &s.ConfirmationNumber)
			delete(rawMsg, key)
		case "readyByTime":
			err = unpopulateTimeRFC3339(val, "ReadyByTime", &s.ReadyByTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageAccountDetails.
func (s StorageAccountDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["dataAccountType"] = DataAccountTypeStorageAccount
	populate(objectMap, "sharePassword", s.SharePassword)
	populate(objectMap, "storageAccountId", s.StorageAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageAccountDetails.
func (s *StorageAccountDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataAccountType":
			err = unpopulate(val, "DataAccountType", &s.DataAccountType)
			delete(rawMsg, key)
		case "sharePassword":
			err = unpopulate(val, "SharePassword", &s.SharePassword)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &s.StorageAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionIsAllowedToCreateJobValidationRequest.
func (s SubscriptionIsAllowedToCreateJobValidationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["validationType"] = ValidationInputDiscriminatorValidateSubscriptionIsAllowedToCreateJob
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionIsAllowedToCreateJobValidationRequest.
func (s *SubscriptionIsAllowedToCreateJobValidationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "validationType":
			err = unpopulate(val, "ValidationType", &s.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (s *SubscriptionIsAllowedToCreateJobValidationResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &s.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &s.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransferFilterDetails.
func (t TransferFilterDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureFileFilterDetails", t.AzureFileFilterDetails)
	populate(objectMap, "blobFilterDetails", t.BlobFilterDetails)
	populate(objectMap, "dataAccountType", t.DataAccountType)
	populate(objectMap, "filterFileDetails", t.FilterFileDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UnencryptedCredentials.
func (u *UnencryptedCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobName":
			err = unpopulate(val, "JobName", &u.JobName)
			delete(rawMsg, key)
		case "jobSecrets":
			u.JobSecrets, err = unmarshalCommonJobSecretsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateAddress.
func (v ValidateAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deviceType", v.DeviceType)
	populate(objectMap, "shippingAddress", v.ShippingAddress)
	populate(objectMap, "transportPreferences", v.TransportPreferences)
	objectMap["validationType"] = ValidationInputDiscriminatorValidateAddress
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateAddress.
func (v *ValidateAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceType":
			err = unpopulate(val, "DeviceType", &v.DeviceType)
			delete(rawMsg, key)
		case "shippingAddress":
			err = unpopulate(val, "ShippingAddress", &v.ShippingAddress)
			delete(rawMsg, key)
		case "transportPreferences":
			err = unpopulate(val, "TransportPreferences", &v.TransportPreferences)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &v.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidationRequest.
func (v ValidationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "individualRequestDetails", v.IndividualRequestDetails)
	objectMap["validationCategory"] = v.ValidationCategory
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidationRequest.
func (v *ValidationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "individualRequestDetails":
			v.IndividualRequestDetails, err = unmarshalValidationInputRequestClassificationArray(val)
			delete(rawMsg, key)
		case "validationCategory":
			err = unpopulate(val, "ValidationCategory", &v.ValidationCategory)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidationResponseProperties.
func (v *ValidationResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "individualResponseDetails":
			v.IndividualResponseDetails, err = unmarshalValidationInputResponseClassificationArray(val)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
