//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armservicefabricmesh

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// CodePackageClient contains the methods for the CodePackage group.
// Don't use this type directly, use NewCodePackageClient() instead.
type CodePackageClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewCodePackageClient creates a new instance of CodePackageClient with the specified values.
// subscriptionID - The customer subscription identifier
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewCodePackageClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*CodePackageClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &CodePackageClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// GetContainerLogs - Gets the logs for the container of the specified code package of the service replica.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2018-09-01-preview
// resourceGroupName - Azure resource group name
// applicationResourceName - The identity of the application.
// serviceResourceName - The identity of the service.
// replicaName - Service Fabric replica name.
// codePackageName - The name of code package of the service.
// options - CodePackageClientGetContainerLogsOptions contains the optional parameters for the CodePackageClient.GetContainerLogs
// method.
func (client *CodePackageClient) GetContainerLogs(ctx context.Context, resourceGroupName string, applicationResourceName string, serviceResourceName string, replicaName string, codePackageName string, options *CodePackageClientGetContainerLogsOptions) (CodePackageClientGetContainerLogsResponse, error) {
	req, err := client.getContainerLogsCreateRequest(ctx, resourceGroupName, applicationResourceName, serviceResourceName, replicaName, codePackageName, options)
	if err != nil {
		return CodePackageClientGetContainerLogsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CodePackageClientGetContainerLogsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return CodePackageClientGetContainerLogsResponse{}, runtime.NewResponseError(resp)
	}
	return client.getContainerLogsHandleResponse(resp)
}

// getContainerLogsCreateRequest creates the GetContainerLogs request.
func (client *CodePackageClient) getContainerLogsCreateRequest(ctx context.Context, resourceGroupName string, applicationResourceName string, serviceResourceName string, replicaName string, codePackageName string, options *CodePackageClientGetContainerLogsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabricMesh/applications/{applicationResourceName}/services/{serviceResourceName}/replicas/{replicaName}/codePackages/{codePackageName}/logs"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	urlPath = strings.ReplaceAll(urlPath, "{applicationResourceName}", applicationResourceName)
	urlPath = strings.ReplaceAll(urlPath, "{serviceResourceName}", serviceResourceName)
	urlPath = strings.ReplaceAll(urlPath, "{replicaName}", replicaName)
	if codePackageName == "" {
		return nil, errors.New("parameter codePackageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{codePackageName}", url.PathEscape(codePackageName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-09-01-preview")
	if options != nil && options.Tail != nil {
		reqQP.Set("tail", strconv.FormatInt(int64(*options.Tail), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getContainerLogsHandleResponse handles the GetContainerLogs response.
func (client *CodePackageClient) getContainerLogsHandleResponse(resp *http.Response) (CodePackageClientGetContainerLogsResponse, error) {
	result := CodePackageClientGetContainerLogsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ContainerLogs); err != nil {
		return CodePackageClientGetContainerLogsResponse{}, err
	}
	return result, nil
}
